/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace Sludge {

static const SludgeGameDescription gameDescriptions[] = {
	{
		{
			"welcome",
			"",
			AD_ENTRY1s("Welcome.slg", "50445503761cf6684fe3270d0860a4c3", 51736),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"verbcoin",
			"",
			AD_ENTRY1s("Verb Coin.slg", "e39ec315dcbf3a1137481f0a5fe1617d", 980270),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"verbcoin",
			"",
			AD_ENTRY1s("Verb Coin.slg", "e39ec315dcbf3a1137481f0a5fe1617d", 980270),
			Common::DE_DEU,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		1
	},

	{
		{
			"robinsrescue",
			"",
			AD_ENTRY1s("robins_rescue.slg", "16cbf2bf916ed89f9c1b14fab133cf96", 14413769),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"robinsrescue",
			"v1.0",
			AD_ENTRY1s("Gamedata.slg", "16cbf2bf916ed89f9c1b14fab133cf96", 14413754),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"robinsrescue",
			"v1.0",
			AD_ENTRY1s("robins_rescue.slg", "16cbf2bf916ed89f9c1b14fab133cf96", 14413754),
			Common::EN_ANY,
			Common::kPlatformLinux,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"outoforder",
			"v1.0",
			AD_ENTRY2s("gamedata",         "4d72dbad0ff170169cd7e4e7e389a90d", 21122647,
					   "out-of-order.xpm", "407086751ac167884c6585c4cad5b664", 2601),
			Common::EN_ANY,
			Common::kPlatformLinux,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"outoforder",
			"v1.0",
			AD_ENTRY2s("gamedata",         "4d72dbad0ff170169cd7e4e7e389a90d", 21122647,
					   "Out Of Order.exe", "ebc386dd0cb77df68dd12d72742eb310", 68608),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"frasse",
			"v1.03",
			AD_ENTRY2s("gamedata",   "5a985d772f9909a8cc98e1e9edf0875d", 38186227,
					   "frasse.exe", "7016ef8ab67133a1d6fce20b8b70cd1d", 83968),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"frasse",
			"v1.04",
			AD_ENTRY2s("gamedata",   "13934872c16391de3ddd6644e3bfcd15", 38154596,
					   "frasse.exe", "7016ef8ab67133a1d6fce20b8b70cd1d", 83968),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"frasse",
			"v2.02",
			AD_ENTRY1s("Gamedata.slg", "25e4a63ae10f69f5032c58ad2fd51fac", 88582783),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"frasse",
			"v2.03",
			AD_ENTRY1s("Gamedata.slg", "e4eb4eca6117bb9b77870bb74af453b4", 88582819),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"interview",
			"",
			AD_ENTRY2s("gamedata",		"6ca8f6e44f30d09bd68e008be4c20e8d", 2570140,
					   "interview.exe", "7974f71566c423c3a344862dcbb827dd", 83968),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"life",
			"",
			AD_ENTRY1s("LifeFlashesBy.slg", "a471759e071e5d2c0e8e6887607df778", 163794266),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"life",
			"",
			AD_ENTRY2s("gamedata",   "a471759e071e5d2c0e8e6887607df778", 163794266,
					   "sludge.bmp", "69db99963fb7e93af6d48dfd7f4246ee", 13846),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"life",
			"",
			AD_ENTRY2s("gamedata",   		  "a471759e071e5d2c0e8e6887607df778", 163794266,
					   "Life Flashes By.exe", "d33c957eefa85defde8b8c29a0bb5a9b", 972800),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"tgttpoacs",
			"",
			AD_ENTRY2s("gamedata", "d5ec4d7d8440f7744335d25d25e1e943", 40368,
					   "gert.ico", "b76b5b38e8d5cd6843636085947bfd29", 3638),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"tgttpoacs",
			"",
			AD_ENTRY1s("tgttpoacs.dat", "e61d3d050793689d55487d3ad01b6693", 23817174),
			Common::EN_ANY,
			Common::kPlatformLinux,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"mandy",
			"v1.2",
			AD_ENTRY2s("data",      "df4a0c113b93b89ff2fe7991fb018bae", 7099447,
					   "Mandy.exe", "596478e1a7b4445fc0bd7f5ec2696125", 71168),
			Common::SK_SVK,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"mandy",
			"v1.2",
			AD_ENTRY2s("data",      "df4a0c113b93b89ff2fe7991fb018bae", 7099447,
					   "Mandy.exe", "596478e1a7b4445fc0bd7f5ec2696125", 71168),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		1
	},

	{
		{
			"mandy",
			"v1.3",
			AD_ENTRY2s("data",      "b732ffe04367c787c6ce70fbcb7aa6aa", 7100976,
					   "Mandy.exe", "596478e1a7b4445fc0bd7f5ec2696125", 71168),
			Common::SK_SVK,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"mandy",
			"v1.3",
			AD_ENTRY2s("data",      "b732ffe04367c787c6ce70fbcb7aa6aa", 7100976,
					   "Mandy.exe", "596478e1a7b4445fc0bd7f5ec2696125", 71168),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		1
	},

	{
		{
			"mandy",
			"v1.3",
			AD_ENTRY2s("data",      "b732ffe04367c787c6ce70fbcb7aa6aa", 7100976,
					   "Mandy.exe", "596478e1a7b4445fc0bd7f5ec2696125", 71168),
			Common::IT_ITA,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		2
	},

	{
		{
			"mandy",
			"v1.4",
			AD_ENTRY2s("data",      "705f6ca5f5da0c40c1f547231dd5139f", 7141292,
					   "Mandy.exe", "7016ef8ab67133a1d6fce20b8b70cd1d", 83968),
			Common::SK_SVK,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"mandy",
			"v1.4",
			AD_ENTRY2s("data",      "705f6ca5f5da0c40c1f547231dd5139f", 7141292,
					   "Mandy.exe", "7016ef8ab67133a1d6fce20b8b70cd1d", 83968),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		1
	},

	{
		{
			"mandy",
			"v1.4",
			AD_ENTRY2s("data",      "705f6ca5f5da0c40c1f547231dd5139f", 7141292,
					   "Mandy.exe", "7016ef8ab67133a1d6fce20b8b70cd1d", 83968),
			Common::IT_ITA,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		2
	},

	{
		{
			"mandy",
			"v1.4",
			AD_ENTRY2s("data",      "705f6ca5f5da0c40c1f547231dd5139f", 7141292,
					   "Mandy.exe", "7016ef8ab67133a1d6fce20b8b70cd1d", 83968),
			Common::PL_POL,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		3
	},

	{
		{
			"cubert",
			"",
			AD_ENTRY1s("cubert.dat", "e70050692a0ab96e8753109793157ccd", 19677815),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"cubert",
			"",
			AD_ENTRY1s("cubert.dat", "e70050692a0ab96e8753109793157ccd", 19677815),
			Common::IT_ITA,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		1
	},

	{
		{
			"cubert",
			"",
			AD_ENTRY1s("cubert.dat", "e70050692a0ab96e8753109793157ccd", 19677815),
			Common::SE_SWE,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		2
	},

	{
		{
			"cubert",
			"",
			AD_ENTRY1s("cubert.dat", "e70050692a0ab96e8753109793157ccd", 19677815),
			Common::DE_DEU,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		3
	},

	{
		{
			"cubert",
			"",
			AD_ENTRY1s("cubert.dat", "cabc424d4e39ecdba4b0afd4033b5ea8", 19696514),
			Common::DE_DEU,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		3
	},

	{
		{
			"nsc",
			"v1.03",
			AD_ENTRY1s("gamedata.slg", "57f318cc09e93a1e0685b790a956ebdc", 12733871),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"nsc",
			"v1.03",
			AD_ENTRY2s("gamedata", "57f318cc09e93a1e0685b790a956ebdc", 12733871,
					   "Nathan's Second Chance.exe", "9bb4492fc7f7fc38bc1772bb9f15f787", 71680),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"gjgagsas",
			"",
			AD_ENTRY1s("gamedata.slg", "f438946f2ee79d52918f44c4a67eb37b", 27527984),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"tsotc",
			"v6",
			AD_ENTRY1s("gamedata.slg", "7d677e79fb842df00c4602864da13829", 34740918),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"atw",
			"",
			AD_ENTRY1s("atw.slg", "41ae22ac9fa5051e0499468a9fbe600e", 27808575),
			Common::EN_ANY,
			Common::kPlatformUnknown,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"leptonsquest",
			"",
			AD_ENTRY1s("game.slg", "763d4020dcd55a4af4c01664f79584da", 71233234),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"leptonsquest",
			"",
			AD_ENTRY1s("Gamedata.slg", "763d4020dcd55a4af4c01664f79584da", 71233239),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{
		{
			"leptonsquest",
			"",
			AD_ENTRY1s("LeptonsQuest.slg", "763d4020dcd55a4af4c01664f79584da", 71233239),
			Common::EN_ANY,
			Common::kPlatformLinux,
			ADGF_UNSTABLE,
			GUIO1(GUIO_NOMIDI)
		},
		0
	},

	{ AD_TABLE_END_MARKER, 0 }
};

} // End of namespace Wage
