'\"
'\" Copyright (c) 1996-1997 University of Twente.
'\" Copyright (c) 1997-1998 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: TnmSnmp.n 1053 1998-03-04 16:44:11Z schoenw $
'\" 
.so man.macros
.TH TnmSnmp n "March 1998" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TnmSnmp \- A Tcl package of SNMP-based utility procedures.
.BE

.SH DESCRIPTION

The TnmSnmp package provides a set of Tcl command procedures to talk
to SNMP agents. Most of the commands work synchronously which means
that they might block the process for a while if there are
communication problems. The result of some of the procedures is
returned in a human readable format ready for displaying in a window
or printing to a file. The main purpose of these functions is
therefore to retrieve information that is displayed in a
user-interface and not further processed by software.

.SH USING THE PACKAGE

The TnmSnmp package is loaded into a Tcl interpreter by using the
following sequence of Tcl commands:

.CS
package require Tnm
.br
package require TnmSnmp $tnm(version)
.CE

All the TnmSnmp commands live in the TnmSnmp namespace. You can import
these commands into the current namespace by using the following Tcl
command:

.CS
namespace import TnmSnmp::*
.CE

It is however suggested to import commands explicitely or to use the
full name in scripts to avoid name clashes.

.SH COMMANDS

.TP
.B TnmSnmp::Walk \fIsession\fR \fIsubtree\fR

.TP
.B TnmSnmp::Scalars \fIsession\fR \fIscalars\fR \fIvarName\fR

.TP
.B TnmSnmp::ShowScalars \fIsession\fR \fIscalars\fR

.TP
.B TnmSnmp::Table \fIsession\fR \fItable\fR \fIvarName\fR

.TP
.B TnmSnmp::ShowTable \fIsession\fR \fItable\fR

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
