'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH http n "July 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
http \- Send and process HTTP requests.
.BE

.SH DESCRIPTION

The Hypertext Transfer Protocol (HTTP) (RFC 1945) is a client/server
protocol used to retrieve documents in the World Wide Web. Documents
are addressed using Uniform Resource Locators (URL) (RFC 1738). The
\fBhttp\fR command allows to implement HTTP clients and a simple HTTP
server.

.SH HTTP COMMAND
The following list of http commands is useful for HTTP clients:
.TP
.B http proxy \fR[\fIurl\fR]
The \fBhttp proxy\fR command allows to define a proxy HTTP server
which will be used in subsequent client commands. Using this command
without an \fIurl\fR argument will return the URL to the currently
used proxy or an empty string. Providing a \fIurl\fR argument sets the
proxy server.  Setting the proxy to an empty string turns the proxy
feature off.
.TP
.B http head \fIurl\fR
The \fBhttp head\fR command retrieves the HTTP header for the document
located at \fIurl\fR. The header is returned as a list of keys and
values which can be converted into a Tcl array using the array set
command.
.TP
.B http get \fIurl\fR \fIfileName\fR
The \fBhttp get\fR command retrieves the document located at
\fIurl\fR. The body of the document is written to the file named
\fIfileName\fR. The command returns the HTTP header as described for
the \fBhttp head\fR command above.
.TP
.B http post \fIurl\fR \fIdocFileName\fR \fIfileName\fR
The \fBhttp post\fR command posts the document in \fIdocFileName\fR to
the location \fIurl\fR. The body of the returned document is written
to the file named \fIfileName\fR. The command returns the HTTP header
as described for the \fBhttp head\fR command above.
.TP
.B http put \fIurl\fR \fIdocFileName\fR
The \fBhttp put\fR command puts the document in \fIdocFileName\fR to
the location \fIurl\fR. The command returns the HTTP header as
described for the \fBhttp head\fR command above.
.TP
.B http delete \fIurl\fR
The \fBhttp delete\fR command deletes the document at the location
defined by \fIurl\fR. The command returns HTTP status information.
.PP
The following set of http commands is useful for a simple HTTP server:
.TP
.B http server \fR[\fIport\fR]
The \fBhttp server\fR command starts a simple HTTP server listening on
port \fIport\fR. 
A previously started server is closed.
If called without a \fIport\fR argument, the
currently used port number or an empty string is returned. An empty
string indicates that no server is currently active.
.br
If called with an empty \fIport\fR argument, an active server is
closed; if no server is running this is a noop.
.TP
.B http mime \fItype\fR \fIextension\fR
The \fBhttp mime\fR command is used to add mime type definitions to
the internal table which maps file name extension to mime types. If
called without an argument, the list of all mime type mappings is
returned. A new mapping is created by supplying a mime \fItype\fR and
the file name \fIextension\fR.
.TP
.B http bind \fIpattern\fR \fImethod\fR \fR[\fIscript\fR]

The \fBhttp bind\fR command binds a Tcl script to the invocation of a
HTTP \fImethod\fR where the URL matches \fIpattern\fR. Whenever a HTTP
request of type \fImethod\fR is received that matches the pattern,
\fIscript\fR is evaluated. The return value of the script must be a
name of a file which will be send back to the client. Errors during
the evaluation of the \fIscript\fR will result in an HTTP error
response.

The following % sequences are substituted before a script bound
to a URL is evaluated:
.RS
.TP 6
.B %A
The network address of the client.
.TP
.B %P
The URL path requested by the client.
.TP
.B %S
The search path contained in the URL path.
.RE

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
