/*
 * tnmAsn1.h --
 *
 *	Definitions for the ASN.1/BER encoder/decoder for the SNMP
 *	protocol. This is only the subset of ASN.1/BER required by
 *	the SNMP protocol.
 *
 * Copyright (c) 1994-1996 Technical University of Braunschweig.
 * Copyright (c) 1996-1997 University of Twente. 
 * Copyright (c) 1997-1998 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNMASN1
#define _TNMASN1

/*
 *----------------------------------------------------------------
 * Definition of ASN.1 data types used by SNMP.
 *----------------------------------------------------------------
 */

#define ASN1_UNIVERSAL		( 0x00 )
#define ASN1_APPLICATION	( 0x40 )
#define ASN1_CONTEXT		( 0x80 )
#define ASN1_PRIVATE		( 0xc0 )

#define ASN1_PRIMITIVE		( 0x00 )
#define ASN1_CONSTRUCTED	( 0x20 )

#define	ASN1_OTHER		( ASN1_UNIVERSAL | ASN1_PRIMITIVE   | 0x00 )
#define ASN1_BOOLEAN		( ASN1_UNIVERSAL | ASN1_PRIMITIVE   | 0x01 )
#define	ASN1_INTEGER		( ASN1_UNIVERSAL | ASN1_PRIMITIVE   | 0x02 )
#define	ASN1_OCTET_STRING	( ASN1_UNIVERSAL | ASN1_PRIMITIVE   | 0x04 )
#define	ASN1_NULL		( ASN1_UNIVERSAL | ASN1_PRIMITIVE   | 0x05 )
#define ASN1_OBJECT_IDENTIFIER	( ASN1_UNIVERSAL | ASN1_PRIMITIVE   | 0x06 )
#define ASN1_SEQUENCE		( ASN1_UNIVERSAL | ASN1_CONSTRUCTED | 0x10 )
#define	ASN1_SEQUENCE_OF	( ASN1_UNIVERSAL | ASN1_CONSTRUCTED | 0x11 )

#define ASN1_IPADDRESS		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x00 )
#define ASN1_COUNTER32		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x01 )
#define ASN1_GAUGE32		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x02 )
#define ASN1_TIMETICKS		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x03 )
#define ASN1_OPAQUE		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x04 )
#define ASN1_COUNTER64		( ASN1_APPLICATION | ASN1_PRIMITIVE | 0x06 )

EXTERN TnmTable tnmSnmpTypeTable[];

/*
 *----------------------------------------------------------------
 * Exception codes used in SNMPv2 varbind lists (RFC 1905).
 *----------------------------------------------------------------
 */

#define ASN1_NO_SUCH_OBJECT	( ASN1_CONTEXT | ASN1_PRIMITIVE | 0x00 )
#define ASN1_NO_SUCH_INSTANCE	( ASN1_CONTEXT | ASN1_PRIMITIVE | 0x01 )
#define ASN1_END_OF_MIB_VIEW	( ASN1_CONTEXT | ASN1_PRIMITIVE | 0x02 )

EXTERN TnmTable tnmSnmpExceptionTable[];

/*
 *----------------------------------------------------------------
 * SNMP PDU types as defined in RFC 1157 and in RFC 1905.
 *----------------------------------------------------------------
 */

#define ASN1_SNMP_GET		( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x00 )
#define ASN1_SNMP_GETNEXT	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x01 )
#define ASN1_SNMP_RESPONSE	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x02 )
#define	ASN1_SNMP_SET		( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x03 )
#define ASN1_SNMPv1_TRAP	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x04 )
#define ASN1_SNMP_GETBULK	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x05 )
#define ASN1_SNMP_INFORM	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x06 )
#define ASN1_SNMPv2_TRAP	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x07 )
#define ASN1_SNMP_REPORT	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x08 )

#define ASN1_SNMP_GETRANGE	( ASN1_CONTEXT | ASN1_CONSTRUCTED | 0x0f )

EXTERN TnmTable tnmSnmpPDUTable[];

/*
 *----------------------------------------------------------------
 * Functions that manipulate object identifier. THIS IS OLD CODE
 * AND SHOULD NOT BE USED ANYMORE.
 *----------------------------------------------------------------
 */

typedef u_int Tnm_Oid;

EXTERN char*
TnmOidToStr		_ANSI_ARGS_((Tnm_Oid *oid, int len));

EXTERN Tnm_Oid*
TnmStrToOid		_ANSI_ARGS_((char *str, int *len));

/*
 *----------------------------------------------------------------
 * These functions get or set a static error string describing
 * the last error which incurred in the BER encoder/decoder.
 *----------------------------------------------------------------
 */

EXTERN char*
TnmBerGetError		_ANSI_ARGS_((void));

EXTERN void
TnmBerSetError		_ANSI_ARGS_((char *msg));

EXTERN void
TnmBerWrongValue	_ANSI_ARGS_((u_char tag, int offset));

EXTERN void
TnmBerWrongLength	_ANSI_ARGS_((u_char tag, int offset, int length));

EXTERN void
TnmBerWrongTag		_ANSI_ARGS_((u_char tag, int offset, u_char expected));

/*
 *----------------------------------------------------------------
 * BER functions visible for other modules (encoding/decoding):
 *----------------------------------------------------------------
 */

EXTERN u_char
TnmBerTag		_ANSI_ARGS_((u_char *packet, int *packetlen));

EXTERN u_char*
TnmBerEncLength		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char *len_fld, int length));
EXTERN u_char*
TnmBerDecLength		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     int *length));
EXTERN u_char*
TnmBerEncSequenceStart  _ANSI_ARGS_((u_char *packet, int *packetlen,
                                     u_char tag, u_char **token));
EXTERN u_char*
TnmBerEncSequenceEnd    _ANSI_ARGS_((u_char *packet, int *packetlen,
                                     u_char *token));
EXTERN u_char*
TnmBerDecSequenceStart  _ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char tag, u_char **token, int *length));
EXTERN u_char*
TnmBerDecSequenceEnd    _ANSI_ARGS_((u_char *packet, int *packetlen,
                                     u_char *token, int length));
EXTERN u_char*
TnmBerEncInt		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char tag, int value));
EXTERN u_char*
TnmBerDecInt		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char tag, int *value));
EXTERN u_char*
TnmBerEncCounter64	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     double value));
EXTERN u_char*
TnmBerDecCounter64	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_int *high, u_int *low));
EXTERN u_char*
TnmBerEncOID		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     Tnm_Oid *oid, int oidlen));
EXTERN u_char*
TnmBerDecOID		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     Tnm_Oid *oid, int *oidlen));
EXTERN u_char*
TnmBerEncOctetString	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char tag, char *octets, int len));
EXTERN u_char*
TnmBerDecOctetString	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char tag, char **octets, int *len));
EXTERN u_char*
TnmBerEncNull		_ANSI_ARGS_((u_char *packet, int *packetlen, 
				     u_char tag));
EXTERN u_char*
TnmBerDecNull		_ANSI_ARGS_((u_char *packet, int *packetlen, 
				     u_char tag));

#endif /* _TNMASN1 */
