'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH netdb n "July 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
netdb \- Access local network databases.
.BE

.SH DESCRIPTION
The \fBnetdb\fR command provides access to network information that is
stored in configuration files, the Network Information Service (NIS)
or in the Domain Name System (DNS). The results of the \fBnetdb\fR
command usually depend on the local configuration of your operating
system.

.SH NETDB COMMAND
.TP 
\fBnetdb hosts\fR
.ns
.TP 
\fBnetdb hosts name \fIaddress\fR
.ns
.TP
\fBnetdb hosts address \fIname\fR
.ns
.TP
\fBnetdb hosts aliases \fIaddress\fR
The first version of the \fBnetdb hosts\fR command returns a list of
all locally known hosts. Each element of this list contains a host
name and its IP address. The result is an empty list on many systems
that are configured to use the DNS for hostname lookups.  The second
version of the \fBnetdb hosts\fR command converts an IP \fIaddress\fR
into a host name and the third version of the \fBnetdb hosts\fR
command converts a host \fIname\fR into an IP address. The fourth
version of the \fBnetdb hosts\fR command returns a list of all 
known aliases for an IP \fIaddress\fR.
.TP 
\fBnetdb networks\fR
.ns
.TP 
\fBnetdb networks name \fIaddress\fR
.ns
.TP
\fBnetdb networks address \fIname\fR
.ns
.TP
\fBnetdb networks aliases \fIaddress\fR
The first version of the \fBnetdb networks\fR command returns a list
of all locally known networks. Each element of this list contains a
network name and the IP network address. The second version of the
\fBnetdb networks\fR command returns the network name that belongs to
the IP network \fIaddress\fR and the third version of the \fBnetdb
networks\fR command returns the network address that belongs to a
given network \fIname\fR. The fourth version of the \fBnetdb
networks\fR command returns a list of all known aliases for an IP
\fIaddress\fR.
.TP 
\fBnetdb protocols\fR
.ns
.TP 
\fBnetdb protocols name \fInumber\fR
.ns
.TP
\fBnetdb protocols number \fIname\fR
.ns
.TP
\fBnetdb protocols aliases \fInumber\fR
The first version of the \fBnetdb protocols\fR command returns a list
of all locally known Internet protocols. Each element of this list
contains a protocol name and its protocol number. The second version
of the \fBnetdb protocols\fR command returns the protocol name that
belongs to \fInumber\fR and the third version of the \fBnetdb
protocols\fR command returns the protocol number that belongs to a
protocol \fIname\fR. The fourth version of the \fBnetdb protocols\fR
command returns a list of all known aliases for a protocol \fInumber\fR.
.TP
\fBnetdb services\fR
.ns
.TP
\fBnetdb services name \fInumber\fR \fIprotocol\fR
.ns
.TP
\fBnetdb services number \fIname\fR \fIprotocol\fR
.ns
.TP
\fBnetdb services aliases \fInumber\fR \fIprotocol\fR 
The first version of the \fBnetdb services\fR command returns the list
of all locally known services. Each element of this list contains a
service name, the service number and the transport protocol. The
second version of the \fBnetdb services\fR command returns the service
name for the service described by \fInumber\fR and \fIprotocol\fR. The
third version of the \fBnetdb services\fR command returns the protocol
number for the service described by \fIname\fR and \fIprotocol\fR.
The fourth version of the \fBnetdb services\fR command returns a list
of all known aliases for a given service \fInumber\fR and
\fIprotocol\fR.
.TP 
\fBnetdb sunrpcs\fR
.ns
.TP 
\fBnetdb sunrpcs name \fInumber\fR
.ns
.TP
\fBnetdb sunrpcs number \fIname\fR
.ns
.TP 
\fBnetdb sunrpcs aliases \fInumber\fR
The first version of the \fBnetdb sunrpcs\fR command lists all locally
known Sun RPCs. Each element of this list contains a RPC name and its
registration number. The second version of the \fBnetdb sunrpcs\fR
command returns the RPC name for a given RPC \fInumber\fR and the
third version of the \fBnetdb sunrpcs\fR command returns the RPC
number for a given RPC \fIname\fR. The fourth version of the \fBnetdb
sunrpcs\fR command returns a list of all known aliases for a given RPC
\fInumber\fR.
.TP
\fBnetdb ip apply \fIaddress\fR \fImask\fR
.ns
.TP
\fBnetdb ip class \fIaddress\fR
.ns
.TP
\fBnetdb ip compare \fImask\fR \fImask\fR
.ns
.TP
\fBnetdb ip range \fIaddress mask\fR
The first version of the \fBnetdb ip\fR command applies the \fImask\fR
to the \fIaddress\fR and returns the resulting subnet. The \fBnetdb ip
class\fR command returns the IP class of the \fIaddress\fR
argument. The following classes are recognized: A, B, C, D and
loopback. The \fBnetdb ip compare\fR command compares two masks and
returns -1, 0 or 1, depending on whether the first mask is smaller,
equal or greater than the second mask. The \fBnetdb ip range\fR
command returns the list of IP addresses in the address range given by
\fIaddress\fR and \fImask\fR.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
