'\"
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: TnmMib.n 890 1997-12-04 12:35:12Z  $
'\" 
.so man.macros
.TH TnmMib n "September 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TnmMib \- A Tcl package of SNMP MIB utilities.
.BE

.SH DESCRIPTION

The TnmMib package provides a set of Tcl command procedures which are
useful utilities for implementing SNMP MIB browser type applications.

.SH USING THE PACKAGE

The TnmMib package is loaded into a Tcl interpreter by using the 
following sequence of Tcl commands:

.CS
package require Tnm
.br
package require TnmMib $tnm(version)
.CE

All the TnmMib commands live in the TnmMib namespace. You can import
these commands into the current namespace by using the following Tcl
command:

.CS
namespace import TnmMib::*
.CE

It is however suggested to import commands explicitely or to use the
full name in scripts to avoid name clashes.

.SH COMMANDS

.TP
.B TnmMib::DescribeNode \fInode\fR

The \fBTnmMib::DescribeNode\fR command returns a human readable
description of a MIB \fInode\fR. The exact format depends on the type
of the MIB \fInode\fR.

.TP
.B TnmMib::DescribeType \fItype\fR

The \fBTnmMib::DescribeType\fR command returns a human readable
description of a MIB \fItype\fR. The exact format depends on the 
type of the MIB \fItype\fR.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
