/*
 * tnmSmx.h --
 *
 *	Definitions for the SMX protocol implementation (RFC 2593).
 *
 * Copyright (c) 1998-1999 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * @(#) $Id: tnmUnixSmx.h 1403 1999-11-05 11:33:39Z schoenw $
 */

#ifndef _TNMSMX
#define _TNMSMX

#include "tnmInt.h"

#define TNM_SMX_VERSION	"1.0"

/*
 * The SMX command messages.
 */

#define TNM_SMX_CMD_HELLO	0x01
#define TNM_SMX_CMD_START	0x02
#define TNM_SMX_CMD_SUSPEND	0x03
#define TNM_SMX_CMD_RESUME	0x04
#define TNM_SMX_CMD_ABORT	0x05
#define TNM_SMX_CMD_STATUS	0x06

/*
 * The SMX reply codes.
 */

#define TNM_SMX_REPL_IDENT		211
#define TNM_SMX_REPL_STATUS		231
#define TNM_SMX_REPL_ABORT		232
#define TNM_SMX_REPL_SYNTAX_ERROR	401
#define TNM_SMX_REPL_UNKNOWN_CMD	402
#define TNM_SMX_REPL_UNKNOWN_FILE	421
#define TNM_SMX_REPL_UNKNOWN_ID		431
#define TNM_SMX_REPL_UNKNOWN_PROFILE	432
#define TNM_SMX_REPL_ILLEGAL_ARG	433
#define TNM_SMX_REPL_ILLEGAL_CHANGE	434
#define TNM_SMX_NTFY_MSG		511
#define TNM_SMX_NTFY_STATUS_CHANGE	531
#define TNM_SMX_NTFY_RESULT		532
#define TNM_SMX_NTFY_RESULT_TRAP	533
#define TNM_SMX_NTFY_TERMINATION	534
#define TNM_SMX_NTFY_ABORT		535

typedef struct TnmSmxThread {
    Tcl_Interp *interp;			/* Interpreter used by the thread.*/
    int id;				/* Identification of the thread. */
    int status;				/* Current status of the thread. */
    struct TnmSmxThread *nextPtr;	/* Next thread in thread list. */
} TnmSmxThread;

#endif /* _TNMSMX */
