'\"
'\" Copyright (c) 1998-1999 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: TnmDisman.n 1327 1999-06-21 13:59:46Z schoenw $
'\" 
.so man.macros
.TH TnmDisman n "February 1999" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TnmDisman \- A Tcl package of procedures for distributed SNMP management.
.BE

.SH DESCRIPTION

The TnmDisman package provides a set of Tcl command procedures that
interact with SNMP agents implementing MIBs developed by the
Distributed Management (DISMAN) working group of the IETF. Most of the
commands work synchronously which means that they might block the
process for a while if there are communication problems.

.SH USING THE PACKAGE

The TnmDisman package is loaded into a Tcl interpreter by using the
following sequence of Tcl commands:

.CS
package require Tnm
.br
package require TnmDisman $tnm(version)
.CE

All the TnmDisman commands live in the TnmDisman namespace. You can import
these commands into the current namespace by using the following Tcl
command:

.CS
namespace import TnmDisman::*
.CE

It is however suggested to import commands explicitely or to use the
full name in scripts to avoid name clashes.

.SH COMMANDS

.TP
.B TnmDisman::GetLanguages \fIsession\fR
The TnmDisman::GetLanguages procedure returns the list of languages
supported by an SNMP agent identified by the SNMP \fIsession\fR
handle. Each element in the result list contains the language index
(smLangIndex) and the language identification (smLangLanguage).

.TP
.B TnmDisman::GetExtensions \fIsession\fR \fIlanguage\fR
The TnmDisman::GetExtensions procedure returns the list of extensions
for a given language supported by an SNMP agent identified by the SNMP
\fIsession\fR handle. The \fIlanguage\fR parameter is the language
index (smLangIndex) which identfies a language within an agent. Each
element in the result list contains the extension index (smExtsnIndex)
and the extension identification (smExtsnExtension).


.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
