# Rolling releases by hand is getting a bit complicated and annoying. So
# without further ado...
#
#
# USAGE 1: gmake -f release.mk OLD=3.0.2 NEW=3.1
#
# This will drop sclj-3.0.2-3.1.diff.bz2 and sclj-3.1.tar.bz2 in OBJDIR, which
# defaults to .. (though as an absolute path instead of relative).
#
# USAGE 2: gmake -f release.mk OLD=3.0 NEW=3.1 diff bzip
#
# This will only create sclj-3.0-3.1.diff.bz2. Even if the previous example was
# run first, because the already-compressed sclj-3.1.tar.bz2 doesn't match
# sclj-3.1.tar.
#
# USAGE 3: gmake -f release.mk OLD=3.1 NEW=3.2 GTAR=gtar
#
# Some systems like Solaris have a silly tar that has no equivalent of
# '--exclude=CVS' as default. The GTAR variable points them in the right
# direction.

SRCDIR := $(shell pwd)
OBJDIR := $(shell dirname `pwd`)
BZIP2 := bzip2
COMP_FLAG := -9
GTAR := tar
TAG_FIXUP := | tr .- _
OLD_TAG := $(shell echo "PUBLIC_$(OLD)" $(TAG_FIXUP))
NEW_TAG := $(shell echo "PUBLIC_$(NEW)" $(TAG_FIXUP))
REL_DIFF := $(OBJDIR)/sclj-$(OLD)-$(NEW).diff
REL_TAR := $(OBJDIR)/sclj-$(NEW).tar
TAR_DIR := sclj-$(NEW)

.PHONY: release diff bzip all everything tag
all: release diff bzip

everything: tag all

bzip:
	test -e "$(REL_TAR)" && $(BZIP2) $(COMP_FLAG) "$(REL_TAR)"
	test -e "$(REL_DIFF)" && $(BZIP2) $(COMP_FLAG) "$(REL_DIFF)"

diff: $(REL_DIFF)

release: $(REL_TAR)

tag:
	cvs tag -c "$(NEW_TAG)"

$(REL_DIFF):
	-cvs diff -Nu "-r$(OLD_TAG)" "-r$(NEW_TAG)" >"$(REL_DIFF)"

$(REL_TAR):
	ln -sf "$(SRCDIR)" "$(OBJDIR)/$(TAR_DIR)"
	$(GTAR) c --exclude=CVS -h -C "$(OBJDIR)" -f "$(REL_TAR)" "$(TAR_DIR)"
	rm "$(OBJDIR)/$(TAR_DIR)"

