# What is SciDAVis?

SciDAVis is a free application for <i>Sci</i>entific <i>D</i>ata <i>A</i>nalysis and <i>Vis</i>ualization.

[![Build Status](https://travis-ci.org/highperformancecoder/scidavis.svg?branch=master)](https://travis-ci.org/highperformancecoder/scidavis)

# License

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or   
(at your option) any later version.                                 
                                                                    
This program is distributed in the hope that it will be useful,     
but WITHOUT ANY WARRANTY; without even the implied warranty of      
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       
GNU General Public License for more details.                        

A copy of this license is provided in the file gpl.txt.


# Platforms

SciDAVis runs on GNU/Linux, Windows and MacOS X; 
possibly also on other platforms like `*`BSD.


# Installation

See [INSTALL.md](INSTALL.md). 

Also consider using a prebuilt package, available for [PC and Mac](https://sourceforge.net/projects/scidavis/files/SciDAVis/) or [Linux](http://software.opensuse.org//download.html?project=home%3Ahpcoder1&package=scidavis).


# User Manual

[Manual](https://highperformancecoder.github.io/scidavis-handbook/)


# Web site

http://scidavis.sourceforge.net


# Credits

## Developers

The following people have written parts of the SciDAVis source code, ranging from a few lines to large chunks.
In alphabetical order.

Tilman Benkert[1], 
Knut Franke,
Miquel Garriga,
Arun Narayanankutty,
Russell Standish,

## Documentation

The following people have written parts of the manual and/or other documentation.
In alphabetical order :

Knut Franke, Roger Gadiou

## Translations

The following people have contributed translations or parts thereof.
In alphabetical order.

- Tilman Benkert[1],
- Markus Bongard,
- Tobias Burnus,
- Rémy Claverie,
- f0ma,
- Jose Antonio Lorenzo Fernandez,
- Pavel Fric,
- Jan Helebrant,
- Daniel Klaer,
- Peter Landgren,
- Fellype do Nascimento,
- Tomomasa Ohkubo,
- Mikhail Shevyakov,
- Mauricio Troviano

## Packagers

The following people have made installing SciDAVis easier by providing specialized binary packages.
In alphabetical order.

- Burkhard Bunk (Debian),
- Quentin Denis (SUSE),
- Yu-Hung Lien (Mac OS X),
- Eric Tanguy (Fedora),
- Mauricio Troviano (Windows installer)

## QtiPlot

SciDAVis uses code from QtiPlot, which consisted (at the time of the fork, i.e. QtiPlot 0.9-rc2) of code by the following people:

- Tilman Benkert[1],
- Shen Chen,
- Borries Demeler,
- José Antonio Lorenzo Fernández,
- Knut Franke,
- Vasileios Gkanis,
- Gudjon Gudjonsson,
- Alex Kargovsky,
- Michael Mac-Vicar,
- Tomomasa Ohkubo,
- Aaron Van Tassle,
- Branimir Vasilic,
- Ion Vasilief,
- Vincent Wagelaar

The SciDAVis manual is based on the QtiPlot manual, written by (in alphabetical order):

Knut Franke, Roger Gadiou, Ion Vasilief

footnotes:
[1] birth name: Tilman Hoener zu Siederdissen

## Special Thanks

We also want to acknowledge the people having helped us indirectly by contributing to the following
fine pieces of software. In no particular order.

- Qt (http://doc.trolltech.com/4.3/credits.html),
- Qwt (http://qwt.sourceforge.net/#credits),
- Qwtplot3D (http://qwtplot3d.sourceforge.net/),
- muParser (http://muparser.sourceforge.net/),
- Python (http://www.python.org/),
- liborigin (http://sourceforge.net/projects/liborigin/),
- Vim (http://www.vim.org/thanks.php/),
- webgen (http://webgen.rubyforge.org/),
- Doxygen (http://www.doxygen.org/),
- Subversion (http://subversion.tigris.org/),
- GSL (http://www.gnu.org/software/gsl/)

... and many more we just forgot to mention.
