<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:variable name="cr">
<xsl:text>
</xsl:text>
</xsl:variable>

<xsl:variable name="tab">
<xsl:text>      </xsl:text>
</xsl:variable>

<!-- Radio buttons are defined with several inputs with the same
     name. This function ensures that there is only one variable declared
     for each input and select name. -->
<xsl:template name="declare-vars">
	<xsl:variable name="unique-list" select=".//input[not(./@name=following::input/@name)]|.//select" />   
	<xsl:for-each select="$unique-list">
		<xsl:text>	char *</xsl:text>
		<xsl:call-template name="build-varname"/>
		<xsl:text> = NULL;</xsl:text>
	</xsl:for-each>
</xsl:template>

<!-- Radio buttons are defined with several inputs with the same
     name. This function ensures that there is only one print statement
     for each input and select name. -->
<xsl:template name="print-spool-values">
	<xsl:variable name="unique-list" select=".//input[not(./@name=following::input/@name)]|.//select" />   
	<xsl:for-each select="$unique-list">
		<xsl:text>fprintf (outfile, "%s ", </xsl:text>
		<xsl:call-template name="build-varname"/>
		<xsl:text>);
		</xsl:text>
	</xsl:for-each>
</xsl:template>

<!-- Radio buttons are defined with several inputs with the same
     name. This function ensures that there is only one print statement
     for each input and select name. -->
<xsl:template name="print-config-values">
	<xsl:variable name="unique-list" select=".//input[not(./@name=following::input/@name)]|.//select" />   
	<xsl:for-each select="$unique-list">
		<xsl:text>fprintf (outfile, "</xsl:text>
		<xsl:call-template name="build-varname"/>
		<xsl:text>=%s\n", </xsl:text>
		<xsl:call-template name="build-varname"/>
		<xsl:text>);
		</xsl:text>
	</xsl:for-each>
</xsl:template>

<xsl:template name="build-varname">
	<xsl:variable name="form-name" select="ancestor::form/@name"/>
	<xsl:variable name="input-name" select="@name"/>
	<xsl:variable name="input-value" select="@value"/>

	<xsl:value-of select="$form-name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="$input-name"/>
	<!--<xsl:if test="string-length($input-value) > 0">FIXME: REMOVE IF ALTERNATE WORKS
		<xsl:text>_</xsl:text>
		<xsl:value-of select="$input-value"/>
	</xsl:if>-->
</xsl:template>

<xsl:template name="_build-enabled-by">
	<xsl:param name="list"/>
	<xsl:variable name="token">
		<xsl:choose>
			<xsl:when test="contains($list, ',')">
				<xsl:value-of select="substring-before($list, ',')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$list"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:if test="contains($list, ',')">
		<xsl:call-template name="_build-enabled-by">
			<xsl:with-param name="list" select="substring-after($list, ',')"/>
		</xsl:call-template>
		<xsl:text> &amp;&amp; </xsl:text>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="contains($token, '[')">
			<xsl:variable name="index" select="substring-before(substring-after($token, '['), ']')"/>
			<!-- Find the name of the radio button that matches our index -->
			<xsl:variable name="name" select="//input[@type='radio' and @value=$index]/@name"/>

			<xsl:value-of select="substring-before($token, '[')"/>
			<xsl:text>[</xsl:text>
			<xsl:for-each select="//input[@type='radio' and @name=$name]">
				<xsl:if test="@value = $index">
					<xsl:value-of select="position() - 1"/>
				</xsl:if>
			</xsl:for-each>
			<xsl:text>]</xsl:text>
			<xsl:text>.checked == 1</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$token"/>
			<xsl:text>.checked == 1</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="build-enabled-by">

	<xsl:param name="type"/>
	<xsl:param name="enabled-by"/>

	<xsl:variable name="value" select="@value"/>

	<xsl:for-each select="//*[@enabled-by]">
		<xsl:if test="string-length(@enabled-by) > 0">
			<xsl:text>printf("&lt;script type=\"text/javascript\"&gt;</xsl:text>
			<xsl:text>function document_</xsl:text>
			<xsl:value-of select="ancestor::form/@name"/>
			<xsl:text>_</xsl:text>
			<xsl:value-of select="@name"/>	
			<xsl:text>_check_dependencies() {if (</xsl:text>
			<xsl:call-template name="_build-enabled-by">
				<xsl:with-param name="list" select="@enabled-by"/>
			</xsl:call-template>
			<xsl:text>) {</xsl:text>
			<xsl:text>document.</xsl:text>
			<xsl:value-of select="ancestor::form/@name"/>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="@name"/>
			<xsl:text>.disabled = false;} else {</xsl:text>
			<xsl:text>document.</xsl:text>
                        <xsl:value-of select="ancestor::form/@name"/>
                        <xsl:text>.</xsl:text>
                        <xsl:value-of select="@name"/>
                        <xsl:text>.disabled = true;}}</xsl:text>
			<xsl:text>&lt;/script&gt;");</xsl:text>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template name="build-input-tag">
	<xsl:text>input name=\"</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>\" type=\"</xsl:text>
	<xsl:value-of select="@type"/>
	<xsl:text>\" </xsl:text>
	<xsl:call-template name="build-onclick">
		<xsl:with-param name="onclick" select="@onclick"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="build-input">
	<xsl:param name="stored-value"/>
	<xsl:choose>
		<xsl:when test="@type='checkbox'">
		<!-- no value attribute, will be "on" or "off" -->
			<xsl:text>printf("&lt;</xsl:text>
			<xsl:call-template name="build-input-tag"/>
			<xsl:text> </xsl:text>
			<xsl:choose>
				<xsl:when test="$stored-value">
					<xsl:text> checked=\"%s\" /&gt;</xsl:text>
					<xsl:value-of select="@label"/>
					<xsl:text>", </xsl:text>
					<xsl:value-of select="$stored-value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>/&gt;</xsl:text>
					<xsl:value-of select="@label"/>
					<xsl:text>"</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>);</xsl:text>
		</xsl:when>
		<xsl:when test="@type='radio'">
			<xsl:text>printf("&lt;</xsl:text>
			<xsl:call-template name="build-input-tag"/>
			<xsl:text>value=\"</xsl:text>
			<xsl:value-of select="@value"/>
			<xsl:text>\" </xsl:text>
			<xsl:choose>
				<xsl:when test="$stored-value">
					<xsl:text> checked=\"%s\" /&gt;</xsl:text>
					<xsl:value-of select="@label"/>
					<xsl:text>", </xsl:text>
					<xsl:value-of select="$stored-value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>/&gt;</xsl:text>
					<xsl:value-of select="@label"/>
					<xsl:text>"</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>);</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>printf("</xsl:text>
			<xsl:value-of select="@label"/>
			<xsl:text>&lt;</xsl:text>
			<xsl:call-template name="build-input-tag"/>
			<xsl:text> </xsl:text>
			<xsl:choose>
				<xsl:when test="$stored-value">
					<xsl:text> value=\"%s\" /&gt;</xsl:text>
					<xsl:text>", </xsl:text>
					<xsl:value-of select="$stored-value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>/&gt;"</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>);</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="build-onclick">

        <xsl:param name="onclick"/>

	<xsl:variable name="name" select="@name"/>

	<xsl:text>onclick=\"</xsl:text>

	<xsl:for-each select="//*[@enabled-by]">
		<xsl:if test="contains(@enabled-by,$name)">
			<xsl:text>document_</xsl:text>
			<xsl:value-of select="ancestor::form/@name"/>
			<xsl:text>_</xsl:text>
			<xsl:value-of select="@name"/>	
			<xsl:text>_check_dependencies();</xsl:text>
		</xsl:if>
	</xsl:for-each>

        <xsl:if test="string-length($onclick) > 0">
                <xsl:value-of select="$onclick"/>
                <xsl:text>();</xsl:text>
        </xsl:if>

	<xsl:text>\"</xsl:text>
</xsl:template>

<xsl:template match="webapp">
	<xsl:text>/* WARNING: This C source code was generated from XML: DO NOT EDIT BY HAND! */</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:value-of select="$cr"/>
	<xsl:text>
#include &lt;stdio.h&gt;
#include &lt;stdio.h&gt;
#include &lt;string.h&gt;
#include &lt;stdlib.h&gt;
#include &lt;unistd.h&gt;
#include &lt;sys/types.h&gt;
#include &lt;sys/stat.h&gt;
#include &lt;glib.h&gt;
#include &lt;cgi.h&gt;
</xsl:text>
	<xsl:apply-templates select="(fieldset|form)" mode="pound-statements"/>
	<xsl:value-of select="$cr"/>
	<xsl:text>
void print_form (char *hostname, char *sidebar)
{
	struct stat buf;</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:call-template name="declare-vars"/>
	<xsl:text>printf("</xsl:text>
	<xsl:apply-templates select="top"/>
	<xsl:text>", hostname, sidebar);
</xsl:text>
	<xsl:call-template name="build-enabled-by"/>
	<xsl:apply-templates select="(fieldset|form)" mode="print-form"/>
	<xsl:text>printf("</xsl:text>
	<xsl:apply-templates select="bottom"/>
	<xsl:text>");
}

void save_data(s_cgi *cgi)
{
	FILE *outfile;
	struct stat buf;

	char *mode;
	</xsl:text>

	<xsl:call-template name="declare-vars"/>

	<xsl:text>
	if ((mode = cgiGetValue (cgi, "mode")) == NULL
            || *mode == 0x00) {
		cgiError ("Error: missing mode");
        }
	</xsl:text>
	<xsl:apply-templates select="(fieldset|form)" mode="save-input"/>
	<xsl:text>
}

char *get_post_mode(s_cgi *cgi)
{
        return cgiGetValue(cgi, "mode");
}</xsl:text>
</xsl:template>

<xsl:template match="fieldset" mode="pound-statements">
	<xsl:apply-templates select="form" mode="pound-statements"/>
</xsl:template>

<xsl:template match="legend" mode="print-form">
	<xsl:text>printf("&lt;legend&gt;");</xsl:text>
	<xsl:choose>
		<xsl:when test="count(child::*) > 0">
			<xsl:apply-templates select="*" mode="output-no-stored-settings"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>printf("</xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>");</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>printf("&lt;/legend&gt;");</xsl:text>
</xsl:template>

<xsl:template match="legend" mode="read-stored-settings">
	<xsl:apply-templates select="input|select" mode="read-stored-settings"/>
</xsl:template>

<xsl:template match="legend" mode="output-no-stored-settings">
	<xsl:text>printf("&lt;legend&gt;");</xsl:text>
	<xsl:choose>
		<xsl:when test="count(child::*) > 0">
			<xsl:apply-templates select="*" mode="output-no-stored-settings"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>printf("</xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>");</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>printf("&lt;/legend&gt;");</xsl:text>
</xsl:template>

<xsl:template match="legend" mode="output-stored-settings">
	<xsl:text>printf("&lt;legend&gt;");</xsl:text>
	<xsl:choose>
		<xsl:when test="count(child::*) > 0">
			<xsl:apply-templates select="*" mode="output-stored-settings"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>printf("</xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>");</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>printf("&lt;/legend&gt;");</xsl:text>
</xsl:template>

<xsl:template match="fieldset" mode="print-form">
	<!-- NOTE: this is if we are not yet inside a form, -->
        <!-- so we don't expect input, etc. -->
	<xsl:text>printf("&lt;fieldset&gt;");</xsl:text>
	<xsl:apply-templates select="legend" mode="print-form"/>
	<xsl:apply-templates select="form" mode="print-form"/>
	<xsl:text>printf("&lt;/fieldset&gt;");</xsl:text>
</xsl:template>

<xsl:template match="fieldset" mode="output-no-stored-settings">
	<xsl:text>printf("&lt;fieldset&gt;");</xsl:text>
	<xsl:apply-templates select="legend" mode="output-no-stored-settings"/>
	<xsl:apply-templates select="form|table|input|select|fieldset|call-print-input-fn|br" mode="output-no-stored-settings"/>
	<xsl:text>printf("&lt;/fieldset&gt;");</xsl:text>
</xsl:template>

<xsl:template match="fieldset" mode="output-stored-settings">
	<xsl:text>printf("&lt;fieldset&gt;");</xsl:text>
	<xsl:apply-templates select="legend" mode="output-stored-settings"/>
	<xsl:apply-templates select="form|table|input|select|fieldset|call-print-input-fn|br" mode="output-stored-settings"/>
	<xsl:text>printf("&lt;/fieldset&gt;");</xsl:text>
</xsl:template>

<xsl:template match="fieldset" mode="read-stored-settings">
	<xsl:apply-templates select="*" mode="read-stored-settings"/>
</xsl:template>

<xsl:template match="form" mode="pound-statements">
	<xsl:text>#define OUTFILE_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text> "</xsl:text>
	<xsl:value-of select="@save-to-dir"/>
	<xsl:value-of select="@name"/>
	<xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="form" mode="print-form">
	<xsl:text>
	printf("&lt;p&gt;&lt;form name=\"</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>\" action=\"</xsl:text>
	<xsl:value-of select="/webapp/@name"/>
	<xsl:text>\" method=\"post\"&gt;");
	if (stat (OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>, &amp;buf) == -1) {</xsl:text>
		<xsl:apply-templates select="*" mode="output-no-stored-settings"/>
	<xsl:text>
	} else { /* FIXME: need conf parser lib. Unfortunately, glib requires [GROUPS] */
		FILE *outfile;

		char buf[BUFSIZ];
		if ((outfile = fopen (OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>, "r")) == NULL) {
			cgiError ("Error opening " OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>);
		}

		while (fgets (buf, sizeof (buf), outfile) != NULL) {
			buf[strlen (buf) - 1] = 0x00; /* get rid of '\n' */

	</xsl:text>
	<xsl:apply-templates select="*" mode="read-stored-settings"/>
	<xsl:text>
		}
	</xsl:text>
	<xsl:apply-templates select="*" mode="output-stored-settings"/>
	<xsl:text>
		if (fclose (outfile) == EOF) {
			cgiError ("Error closing " OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>);
		}
	}
	</xsl:text>
	<xsl:apply-templates select="submit"/>
	<xsl:text>
	printf("&lt;input name=\"mode\" type=\"hidden\" value=\"</xsl:text><xsl:value-of select="@name"/><xsl:text>\"/&gt;\n");
	printf("&lt;/form&gt;&lt;p&gt;\n");
	</xsl:text>
</xsl:template>

<xsl:template match="form" mode="save-input">
	<xsl:text>

	if (g_ascii_strcasecmp(mode, "</xsl:text><xsl:value-of select="@name"/><xsl:text>") == 0) {
	if (stat (OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>, &amp;buf) == 0) {
		/* Deleted by appliance-configd after running all scripts */
		if (rename (OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>, OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text> ".old") == -1) {
			cgiError ("Error renaming old configuration");
		}
	}
	if ((outfile = fopen (OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>, "w")) == NULL) {
		cgiError ("Error opening " OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>);
	}
	</xsl:text>
	<xsl:choose>
		<xsl:when test="@save-data-as = 'config'"> 
			<xsl:text>
			fprintf (outfile, "# Created by appliance-config, do not edit by hand\n");
			fprintf (outfile, "\n");
			</xsl:text>
			<xsl:apply-templates select="(.//input|.//select|.//call-print-input-fn)" mode="save-input-to-config"/>
			<xsl:call-template name="print-config-values"/>
		</xsl:when>
		<xsl:when test="@save-data-as = 'spool'"> 
			<xsl:apply-templates select="(.//input|.//select|.//call-print-input-fn)" mode="save-input-to-spool"/>
			<xsl:call-template name="print-spool-values"/>
			<xsl:text>printf("\n");</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>cgiError ("Error: Invalid save-data-as value:</xsl:text><xsl:value-of select="@save-data-as"/><xsl:text>");</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>
	if (fclose (outfile) == EOF) {
		cgiError ("Error closing " OUTFILE_</xsl:text><xsl:value-of select="@name"/><xsl:text>);
	}
	}
	</xsl:text>
</xsl:template>

<xsl:template match="input|select" mode="save-input-to-config">
	<xsl:text>
	if ((</xsl:text>
	<xsl:call-template name="build-varname"/>
	<xsl:text> = cgiGetValue (cgi, "</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>")) == NULL || *</xsl:text>
	<xsl:call-template name="build-varname"/>
	<xsl:text> == 0x00) {
		</xsl:text>
	<xsl:call-template name="build-varname"/>
	<xsl:text> = "off";
	}</xsl:text>
</xsl:template>

<xsl:template match="fieldset" mode="save-input">
	<xsl:apply-templates select="form" mode="save-input"/>
</xsl:template>

<!-- TAKE OUT IF WORKS WITHOUT
<xsl:template match="legend" mode="save-input">
</xsl:template>

<xsl:template match="fieldset" mode="save-input-to-config">
	<xsl:apply-templates select="form|table" mode="save-input-to-config"/>
</xsl:template>

<xsl:template match="legend" mode="save-input-to-config">
</xsl:template>

<xsl:template match="table" mode="save-input-to-config">
	<xsl:apply-templates select="tr" mode="save-input-to-config"/>
</xsl:template>

<xsl:template match="tr" mode="save-input-to-config">
	<xsl:apply-templates select="td" mode="save-input-to-config"/>
</xsl:template>

<xsl:template match="td" mode="save-input-to-config">
	<xsl:if test="count(child::*) > 0">
		<xsl:apply-templates select="(input|select)" mode="save-input-to-config"/>
	</xsl:if>
</xsl:template>
-->

<xsl:template match="input|select" mode="save-input-to-spool">
	<xsl:text>
	if ((</xsl:text>
	<xsl:call-template name="build-varname"/>
	<xsl:text> = cgiGetValue (cgi, "</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>")) == NULL || *</xsl:text>
	<xsl:call-template name="build-varname"/>
	<xsl:text> == 0x00) {
		</xsl:text>
	<xsl:call-template name="build-varname"/>
	<xsl:text> = "off";
	}
	</xsl:text>
</xsl:template>

<!-- TAKE OUT IF WORKS WITHOUT
<xsl:template match="fieldset" mode="save-input-to-spool">
	<xsl:apply-templates select="form|table" mode="save-input-to-spool"/>
</xsl:template>

<xsl:template match="legend" mode="save-input-to-spool">
</xsl:template>

<xsl:template match="table" mode="save-input-to-spool">
	<xsl:apply-templates select="tr" mode="save-input-to-spool"/>
</xsl:template>

<xsl:template match="tr" mode="save-input-to-spool">
	<xsl:apply-templates select="td" mode="save-input-to-spool"/>
</xsl:template>

<xsl:template match="td" mode="save-input-to-spool">
	<xsl:if test="count(child::*) > 0">
		<xsl:apply-templates select="(input|select)" mode="save-input-to-spool"/>
	</xsl:if>
</xsl:template>
-->

<xsl:template match="input" mode="output-no-stored-settings">
	<xsl:call-template name="build-input"/>
</xsl:template>

<xsl:template match="input" mode="read-stored-settings">
	<xsl:text>
			if (g_ascii_strncasecmp (buf, "</xsl:text>

	<xsl:call-template name="build-varname"/>
	<xsl:text>=", strlen ("</xsl:text>

	<xsl:call-template name="build-varname"/>

	<xsl:text>=")) == 0) {</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:value-of select="$tab"/>
	<xsl:value-of select="$tab"/>
	<xsl:value-of select="$tab"/>
	<xsl:value-of select="$tab"/>

	<xsl:call-template name="build-varname"/>

	<xsl:text> = g_strdup (buf + strlen ("</xsl:text>

	<xsl:call-template name="build-varname"/>

	<xsl:text>="));
			}</xsl:text>
</xsl:template>

<xsl:template match="input" mode="output-stored-settings">
	<xsl:text>
			if (g_ascii_strcasecmp ("off", </xsl:text>

	<xsl:call-template name="build-varname"/>

	<xsl:text>) != 0) {</xsl:text>
	<xsl:call-template name="build-input">
		<xsl:with-param name="stored-value">
			<xsl:call-template name="build-varname"/>
		</xsl:with-param>
	</xsl:call-template>
			<xsl:text>} else {</xsl:text>
			<xsl:call-template name="build-input"/>
			<xsl:text>}</xsl:text>
</xsl:template>

<xsl:template match="select" mode="output-no-stored-settings">
	<xsl:text>
		printf("</xsl:text>
	<xsl:value-of select="@label"/>
	<xsl:text>&lt;select name=\"</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>\"&gt;");</xsl:text>
	<xsl:apply-templates select="*" mode="output-no-stored-settings"/>
	<xsl:text>
		printf("&lt;/select&gt;");
	</xsl:text>
</xsl:template>

<xsl:template match="select" mode="output-stored-settings">
	<xsl:text>
		printf("</xsl:text>
	<xsl:value-of select="@label"/>
	<xsl:text>&lt;select name=\"</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>\"&gt;");</xsl:text>
	<xsl:apply-templates select="*" mode="output-stored-settings"/>
	<xsl:text>
		printf("&lt;/select&gt;");
	</xsl:text>
</xsl:template>

<xsl:template match="select" mode="read-stored-settings">
</xsl:template>

<xsl:template match="option" mode="output-no-stored-settings">
	<xsl:text>
		printf("&lt;option value=\"</xsl:text>
	<xsl:value-of select="@value"/>
	<xsl:text>\"&gt;</xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&lt;/option&gt;");</xsl:text>
</xsl:template>

<xsl:template match="option" mode="output-stored-settings">
	<xsl:text>
		printf("&lt;option value=\"</xsl:text>
	<xsl:value-of select="@value"/>
	<xsl:text>\"&gt;</xsl:text>
	<xsl:value-of select="."/>
	<xsl:text>&lt;/option&gt;");</xsl:text>
</xsl:template>

<xsl:template match="call-print-options-fn" mode="output-no-stored-settings">
	<xsl:text>print_document_</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="../@name"/>
	<xsl:text>_options ("document.</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>.</xsl:text>
	<xsl:value-of select="../@name"/>
	<xsl:text>");</xsl:text>
</xsl:template>

<xsl:template match="call-print-options-fn" mode="output-stored-settings">
	<xsl:text>print_document_</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="../@name"/>
	<xsl:text>_options ("document.</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>.</xsl:text>
	<xsl:value-of select="../@name"/>
	<xsl:text>");</xsl:text>
</xsl:template>

<xsl:template match="call-print-input-fn" mode="output-no-stored-settings">
	<xsl:text>print_document_</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>_input ("document.</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>");</xsl:text>
</xsl:template>

<xsl:template match="call-print-input-fn" mode="output-stored-settings">
	<xsl:text>print_document_</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>_input ("document.</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>");</xsl:text>
</xsl:template>

<xsl:template match="call-print-input-fn" mode="save-input-to-config">
	<xsl:text>save_to_config_document_</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>_input (cgi, "</xsl:text>
	<xsl:value-of select="ancestor::form/@save-to-dir"/>
	<xsl:text>", "document.</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>");</xsl:text>
</xsl:template>

<xsl:template match="call-print-input-fn" mode="save-input-to-spool">
	<xsl:text>save_to_spool_document_</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text>_input (cgi, "</xsl:text>
	<xsl:value-of select="ancestor::form/@save-to-dir"/>
	<xsl:text>", "document.</xsl:text>
	<xsl:value-of select="ancestor::form/@name"/>
	<xsl:text>");</xsl:text>
</xsl:template>

<xsl:template match="br" mode="output-no-stored-settings">
	<xsl:text>printf("&lt;br/&gt;");</xsl:text>
</xsl:template>

<xsl:template match="br" mode="output-stored-settings">
	<xsl:text>printf("&lt;br/&gt;");</xsl:text>
</xsl:template>

<xsl:template match="table" mode="read-stored-settings">
	<xsl:apply-templates select="tr" mode="read-stored-settings"/>
</xsl:template>

<xsl:template match="table" mode="output-no-stored-settings">
	<xsl:text>printf("&lt;table&gt;");</xsl:text>
	<xsl:apply-templates select="tr" mode="output-no-stored-settings"/>
	<xsl:text>printf("&lt;/table&gt;");</xsl:text>
</xsl:template>

<xsl:template match="table" mode="output-stored-settings">
	<xsl:text>printf("&lt;table&gt;");</xsl:text>
	<xsl:apply-templates select="tr" mode="output-stored-settings"/>
	<xsl:text>printf("&lt;/table&gt;");</xsl:text>
</xsl:template>

<xsl:template match="tr" mode="read-stored-settings">
	<xsl:apply-templates select="td" mode="read-stored-settings"/>
</xsl:template>

<xsl:template match="tr" mode="output-no-stored-settings">
	<xsl:text>printf("&lt;tr&gt;");</xsl:text>
	<xsl:apply-templates select="td" mode="output-no-stored-settings"/>
	<xsl:text>printf("&lt;/tr&gt;");</xsl:text>
</xsl:template>

<xsl:template match="tr" mode="output-stored-settings">
	<xsl:text>printf("&lt;tr&gt;");</xsl:text>
	<xsl:apply-templates select="td" mode="output-stored-settings"/>
	<xsl:text>printf("&lt;/tr&gt;");</xsl:text>
</xsl:template>

<xsl:template match="td" mode="read-stored-settings">
	<xsl:apply-templates select="input|select" mode="read-stored-settings"/>
</xsl:template>

<xsl:template match="td" mode="output-no-stored-settings">
	<xsl:text>printf("&lt;td&gt;");</xsl:text>
	<xsl:choose>
		<xsl:when test="count(child::*) > 0">
			<xsl:apply-templates select="*" mode="output-no-stored-settings"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>printf("</xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>");</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>printf("&lt;/td&gt;");</xsl:text>
</xsl:template>

<xsl:template match="td" mode="output-stored-settings">
	<xsl:text>printf("&lt;td&gt;");</xsl:text>
	<xsl:choose>
		<xsl:when test="count(child::*) > 0">
			<xsl:apply-templates select="*" mode="output-stored-settings"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>printf("</xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>");</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>printf("&lt;/td&gt;");</xsl:text>
</xsl:template>

<xsl:template match="submit">
	<xsl:text>
	printf("&lt;p&gt;&lt;input name=\"submit\" type=\"submit\" value=\"</xsl:text>
	<xsl:value-of select="@value"/>
	<xsl:text>\"/&gt;&lt;p&gt;");</xsl:text>
	<xsl:value-of select="$cr"/>
</xsl:template>

</xsl:stylesheet>
