/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.JlineCommandRegistry;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.Styles;
import org.jline.builtins.SystemRegistry;
import org.jline.builtins.SystemRegistryImpl;
import org.jline.console.CmdDesc;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.ConfigurationPath;
import org.jline.console.Printer;
import org.jline.console.ScriptEngine;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EOFError;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Log;
import org.jline.utils.StyleResolver;

public class ConsoleEngineImpl
extends JlineCommandRegistry
implements ConsoleEngine,
Printer {
    private static final String VAR_CONSOLE_OPTIONS = "CONSOLE_OPTIONS";
    private static final String VAR_PRNT_OPTIONS = "PRNT_OPTIONS";
    private static final String VAR_PATH = "PATH";
    private static final String VAR_NANORC = "NANORC";
    private static final String[] OPTION_HELP = new String[]{"-?", "--help"};
    private static final String OPTION_VERBOSE = "-v";
    private static final String END_HELP = "END_HELP";
    private static final int HELP_MAX_SIZE = 30;
    private static final int PRNT_MAX_ROWS = 100000;
    private static final int PRNT_MAX_DEPTH = 1;
    private static final int PRNT_INDENTION = 4;
    private static final int NANORC_MAX_STRING_LENGTH = 400;
    private final ScriptEngine engine;
    private Map<Class<?>, Function<Object, Map<String, Object>>> objectToMap = new HashMap();
    private Map<Class<?>, Function<Object, String>> objectToString = new HashMap();
    private Map<String, Function<Object, AttributedString>> highlightValue = new HashMap<String, Function<Object, AttributedString>>();
    private Exception exception;
    private SystemRegistry systemRegistry;
    private String scriptExtension = "jline";
    private final Supplier<Path> workDir;
    private final ConfigurationPath configPath;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Map<String, List<String>> pipes = new HashMap<String, List<String>>();
    private Path aliasFile;
    private LineReader reader;
    private boolean executing = false;
    private StyleResolver prntStyle;
    private int totLines;

    public ConsoleEngineImpl(ScriptEngine engine, Supplier<Path> workDir, ConfigurationPath configPath) throws IOException {
        this(null, engine, workDir, configPath);
    }

    public ConsoleEngineImpl(Set<Command> commands, ScriptEngine engine, Supplier<Path> workDir, ConfigurationPath configPath) throws IOException {
        this.engine = engine;
        this.workDir = workDir;
        this.configPath = configPath;
        HashMap<Command, String> commandName = new HashMap<Command, String>();
        HashMap<Command, CommandMethods> commandExecute = new HashMap<Command, CommandMethods>();
        HashSet<Command> cmds = null;
        cmds = commands == null ? new HashSet<Command>(EnumSet.allOf(Command.class)) : new HashSet<Command>(commands);
        for (Command c : cmds) {
            commandName.put(c, c.name().toLowerCase());
        }
        commandExecute.put(Command.DEL, new CommandMethods(this::del, this::variableCompleter));
        commandExecute.put(Command.SHOW, new CommandMethods(this::show, this::variableCompleter));
        commandExecute.put(Command.PRNT, new CommandMethods(this::prnt, this::prntCompleter));
        commandExecute.put(Command.SLURP, new CommandMethods(this::slurpcmd, this::slurpCompleter));
        commandExecute.put(Command.ALIAS, new CommandMethods(this::aliascmd, this::aliasCompleter));
        commandExecute.put(Command.UNALIAS, new CommandMethods(this::unalias, this::unaliasCompleter));
        commandExecute.put(Command.DOC, new CommandMethods(this::doc, this::docCompleter));
        commandExecute.put(Command.PIPE, new CommandMethods(this::pipe, this::defaultCompleter));
        this.aliasFile = configPath.getUserConfig("aliases.json");
        if (this.aliasFile == null) {
            this.aliasFile = configPath.getUserConfig("aliases.json", true);
            this.persist(this.aliasFile, this.aliases);
        } else {
            this.aliases.putAll((Map)this.slurp(this.aliasFile));
        }
        this.registerCommands(commandName, commandExecute);
        this.prntStyle = Styles.prntStyle();
    }

    public void setObjectToMap(Map<Class<?>, Function<Object, Map<String, Object>>> objectToMap) {
        this.objectToMap = objectToMap;
    }

    public void setObjectToString(Map<Class<?>, Function<Object, String>> objectToString) {
        this.objectToString = objectToString;
    }

    public void setHighlightValue(Map<String, Function<Object, AttributedString>> highlightValue) {
        this.highlightValue = highlightValue;
    }

    @Override
    public void setLineReader(LineReader reader) {
        this.reader = reader;
    }

    private Parser parser() {
        return this.reader.getParser();
    }

    private Terminal terminal() {
        return this.systemRegistry.terminal();
    }

    @Override
    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void setSystemRegistry(SystemRegistry systemRegistry) {
        this.systemRegistry = systemRegistry;
    }

    @Override
    public void setScriptExtension(String extension) {
        this.scriptExtension = extension;
    }

    @Override
    public boolean hasAlias(String name) {
        return this.aliases.containsKey(name);
    }

    @Override
    public String getAlias(String name) {
        return this.aliases.getOrDefault(name, null);
    }

    @Override
    public Map<String, List<String>> getPipes() {
        return this.pipes;
    }

    @Override
    public List<String> getNamedPipes() {
        ArrayList<String> out = new ArrayList<String>();
        ArrayList<String> opers = new ArrayList<String>();
        for (String string : this.pipes.keySet()) {
            if (string.matches("[a-zA-Z0-9]+")) {
                out.add(string);
                continue;
            }
            opers.add(string);
        }
        opers.addAll(this.systemRegistry.getPipeNames());
        for (Map.Entry entry : this.aliases.entrySet()) {
            if (!opers.contains(((String)entry.getValue()).split(" ")[0])) continue;
            out.add((String)entry.getKey());
        }
        return out;
    }

    private Set<String> variables() {
        return this.engine.find().keySet();
    }

    @Override
    public List<Completer> scriptCompleters() {
        ArrayList<Completer> out = new ArrayList<Completer>();
        out.add(new ArgumentCompleter(new StringsCompleter(this::variables), NullCompleter.INSTANCE));
        out.add(new ArgumentCompleter(new StringsCompleter(this::scriptNames), new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)));
        Completer[] completerArray = new Completer[2];
        completerArray[0] = new StringsCompleter(this.aliases::keySet);
        completerArray[1] = NullCompleter.INSTANCE;
        out.add(new ArgumentCompleter(completerArray));
        return out;
    }

    private Set<String> scriptNames() {
        return this.scripts().keySet();
    }

    @Override
    public Map<String, Boolean> scripts() {
        HashMap<String, Boolean> out = new HashMap<String, Boolean>();
        try {
            ArrayList scripts = new ArrayList();
            if (this.engine.hasVariable(VAR_PATH)) {
                ArrayList<String> dirs = new ArrayList<String>();
                for (String file : (List)this.engine.get(VAR_PATH)) {
                    file = file.startsWith("~") ? file.replace("~", System.getProperty("user.home")) : file;
                    File dir = new File(file);
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    dirs.add(file);
                }
                for (String pp : dirs) {
                    for (String e : this.scriptExtensions()) {
                        String regex = pp + "/*." + e;
                        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + regex);
                        Files.find(Paths.get(new File(regex).getParent(), new String[0]), Integer.MAX_VALUE, (path, f) -> pathMatcher.matches((Path)path), new FileVisitOption[0]).forEach(p -> scripts.add(p));
                    }
                }
            }
            for (Path p2 : scripts) {
                String name = p2.toFile().getName();
                int idx = name.lastIndexOf(".");
                out.put(name.substring(0, idx), name.substring(idx + 1).equals(this.scriptExtension));
            }
        }
        catch (NoSuchFileException e) {
            this.error("Failed reading PATH. No file found: " + e.getMessage());
        }
        catch (InvalidPathException e) {
            this.error("Failed reading PATH. Invalid path:");
            this.error(e.toString());
        }
        catch (Exception e) {
            this.error("Failed reading PATH:");
            this.trace(e);
            this.engine.put("exception", e);
        }
        return out;
    }

    @Override
    public Object[] expandParameters(String[] args) throws Exception {
        Object[] out = new Object[args.length];
        String regexPath = "(.*)\\$\\{(.*?)\\}(/.*)";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].matches(regexPath)) {
                Matcher matcher = Pattern.compile(regexPath).matcher(args[i]);
                if (matcher.find()) {
                    out[i] = matcher.group(1) + (String)this.engine.get(matcher.group(2)) + matcher.group(3);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            out[i] = args[i].startsWith("${") ? this.engine.execute(this.expandName(args[i])) : (args[i].startsWith("$") ? this.engine.get(this.expandName(args[i])) : this.engine.deserialize(args[i]));
        }
        return out;
    }

    private String expandToList(String[] args) {
        return this.expandToList(Arrays.asList(args));
    }

    @Override
    public String expandToList(List<String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (int j = 0; j < params.size(); ++j) {
            if (!first) {
                sb.append(",");
            }
            if (params.get(j).equalsIgnoreCase("true") || params.get(j).equalsIgnoreCase("false") || params.get(j).equalsIgnoreCase("null")) {
                sb.append(params.get(j).toLowerCase());
            } else if (this.isNumber(params.get(j))) {
                sb.append(params.get(j));
            } else {
                sb.append(params.get(j).startsWith("$") ? params.get(j).substring(1) : this.quote(params.get(j)));
            }
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    private String expandName(String name) {
        String regexVar = "[a-zA-Z_]{1,}[a-zA-Z0-9_-]*";
        String out = name;
        if (name.matches("^\\$" + regexVar)) {
            out = name.substring(1);
        } else if (name.matches("^\\$\\{" + regexVar + "\\}.*")) {
            Matcher matcher = Pattern.compile("^\\$\\{(" + regexVar + ")\\}(.*)").matcher(name);
            if (matcher.find()) {
                out = matcher.group(1) + matcher.group(2);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return out;
    }

    private boolean isNumber(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private boolean isCodeBlock(String line) {
        return line.contains("\n") && line.trim().endsWith("}");
    }

    private boolean isCommandLine(String line) {
        String command = this.parser().getCommand(line);
        boolean out = false;
        if (command != null && command.startsWith(":")) {
            if (this.hasAlias(command = command.substring(1))) {
                command = this.getAlias(command);
            }
            if (this.systemRegistry.hasCommand(command)) {
                out = true;
            } else {
                ScriptFile sf = new ScriptFile(command, "", new String[0]);
                if (sf.isScript()) {
                    out = true;
                }
            }
        }
        return out;
    }

    private String quote(String var) {
        if (var.startsWith("\"") && var.endsWith("\"") || var.startsWith("'") && var.endsWith("'")) {
            return var;
        }
        if (var.contains("\\\"")) {
            return "'" + var + "'";
        }
        return "\"" + var + "\"";
    }

    private List<String> scriptExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.addAll(this.engine.getExtensions());
        extensions.add(this.scriptExtension);
        return extensions;
    }

    @Override
    public Object execute(File script, String cmdLine, String[] args) throws Exception {
        ScriptFile file = new ScriptFile(script, cmdLine, args);
        file.execute();
        return file.getResult();
    }

    @Override
    public String expandCommandLine(String line) {
        String out = null;
        if (this.isCommandLine(line)) {
            StringBuilder sb = new StringBuilder();
            List<String> ws = this.parser().parse(line, 0, Parser.ParseContext.COMPLETE).words();
            int idx = ws.get(0).lastIndexOf(":");
            if (idx > 0) {
                sb.append(ws.get(0).substring(0, idx));
            }
            String[] argv = new String[ws.size()];
            for (int i = 1; i < ws.size(); ++i) {
                argv[i] = ws.get(i);
                if (argv[i].startsWith("${")) {
                    Matcher argvMatcher = Pattern.compile("\\$\\{(.*)}").matcher(argv[i]);
                    if (!argvMatcher.find()) continue;
                    argv[i] = argv[i].replace(argv[i], argvMatcher.group(1));
                    continue;
                }
                argv[i] = argv[i].startsWith("$") ? argv[i].substring(1) : this.quote(argv[i]);
            }
            String cmd = this.hasAlias(ws.get(0).substring(idx + 1)) ? this.getAlias(ws.get(0).substring(idx + 1)) : ws.get(0).substring(idx + 1);
            sb.append("org.jline.builtins.SystemRegistry.get().invoke('" + cmd + "'");
            for (int i = 1; i < argv.length; ++i) {
                sb.append(", ");
                sb.append(argv[i]);
            }
            sb.append(")");
            out = sb.toString();
        } else {
            out = line;
        }
        return out;
    }

    @Override
    public Object execute(String cmd, String line, String[] args) throws Exception {
        if (line.trim().startsWith("#")) {
            return null;
        }
        Object out = null;
        ScriptFile file = null;
        if (this.parser().validCommandName(cmd)) {
            file = new ScriptFile(cmd, line, args);
        } else {
            File f = new File(line.split("\\s+")[0]);
            if (f.exists()) {
                file = new ScriptFile(f, line, args);
            }
        }
        if (file != null && file.execute()) {
            out = file.getResult();
        } else {
            if (this.isCodeBlock(line = line.trim())) {
                StringBuilder sb = new StringBuilder();
                for (String s : line.split("\\r?\\n")) {
                    sb.append(this.expandCommandLine(s));
                    sb.append("\n");
                }
                line = sb.toString();
            }
            if (this.engine.hasVariable(line)) {
                out = this.engine.get(line);
            } else if (this.parser().getVariable(line) == null) {
                out = this.engine.execute(line);
                this.engine.put("_", out);
            } else {
                this.engine.execute(line);
            }
        }
        return out;
    }

    @Override
    public void purge() {
        this.engine.del("_*");
    }

    @Override
    public void putVariable(String name, Object value) {
        this.engine.put(name, value);
    }

    @Override
    public Object getVariable(String name) {
        if (!this.engine.hasVariable(name)) {
            throw new IllegalArgumentException("Variable " + name + " does not exists!");
        }
        return this.engine.get(name);
    }

    @Override
    public boolean hasVariable(String name) {
        return this.engine.hasVariable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWidget(Object function) {
        this.engine.put("_reader", this.reader);
        this.engine.put("_widgetFunction", function);
        try {
            if (this.engine.getEngineName().equals("GroovyEngine")) {
                this.engine.execute("def _buffer() {_reader.getBuffer()}");
                this.engine.execute("def _widget(w) {_reader.callWidget(w)}");
            }
            this.engine.execute("_widgetFunction()");
        }
        catch (Exception e) {
            this.trace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.purge();
        }
        return true;
    }

    private Map<String, Object> consoleOptions() {
        return this.engine.hasVariable(VAR_CONSOLE_OPTIONS) ? (Map)this.engine.get(VAR_CONSOLE_OPTIONS) : new HashMap<String, Object>();
    }

    @Override
    public <T> T consoleOption(String option, T defval) {
        Object out = defval;
        try {
            out = this.consoleOptions().getOrDefault(option, defval);
        }
        catch (Exception e) {
            this.trace(new Exception("Bad CONSOLE_OPTION value: " + e.getMessage()));
        }
        return out;
    }

    private boolean consoleOption(String option) {
        boolean out = false;
        try {
            out = this.consoleOptions().containsKey(option);
        }
        catch (Exception e) {
            this.trace(new Exception("Bad CONSOLE_OPTION value: " + e.getMessage()));
        }
        return out;
    }

    @Override
    public ConsoleEngine.ExecutionResult postProcess(String line, Object result, String output) {
        ConsoleEngine.ExecutionResult out = new ConsoleEngine.ExecutionResult(1, null);
        String[] _output = output != null && !output.trim().isEmpty() && !this.consoleOption("no-splittedOutput") ? output.split("\\r?\\n") : output;
        String consoleVar = this.parser().getVariable(line);
        if (consoleVar != null && result != null) {
            this.engine.put("output", _output);
        }
        if (this.systemRegistry.hasCommand(this.parser().getCommand(line))) {
            out = this.postProcess(line, consoleVar != null && result == null ? _output : result);
        } else {
            String[] _result = result == null ? _output : result;
            int status = this.saveResult(consoleVar, _result);
            out = new ConsoleEngine.ExecutionResult(status, consoleVar != null && !consoleVar.startsWith("_") ? null : _result);
        }
        return out;
    }

    private ConsoleEngine.ExecutionResult postProcess(String line, Object result) {
        int status = 0;
        Object out = result != null && result instanceof String && ((String)result).trim().isEmpty() ? null : result;
        String consoleVar = this.parser().getVariable(line);
        if (consoleVar != null) {
            status = this.saveResult(consoleVar, result);
            if (!consoleVar.startsWith("_")) {
                out = null;
            }
        } else if (!this.parser().getCommand(line).equals("show")) {
            status = result != null ? this.saveResult("_", result) : 1;
        }
        return new ConsoleEngine.ExecutionResult(status, out);
    }

    @Override
    public ConsoleEngine.ExecutionResult postProcess(Object result) {
        return new ConsoleEngine.ExecutionResult(this.saveResult(null, result), result);
    }

    private int saveResult(String var, Object result) {
        int out = 0;
        try {
            this.engine.put("_executionResult", result);
            if (var != null) {
                if (var.contains(".") || var.contains("[")) {
                    this.engine.execute(var + " = _executionResult");
                } else {
                    this.engine.put(var, result);
                }
            }
            out = (Integer)this.engine.execute("_executionResult ? 0 : 1");
        }
        catch (Exception e) {
            this.trace(e);
            out = 1;
        }
        return out;
    }

    @Override
    public Object invoke(CommandRegistry.CommandSession session, String command, Object ... args) throws Exception {
        this.exception = null;
        Object out = null;
        if (this.hasCommand(command)) {
            out = this.getCommandMethods(command).executeFunction().apply(new CommandInput(command, args, session));
        } else {
            String[] _args = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String)) {
                    throw new IllegalArgumentException();
                }
                _args[i] = args[i].toString();
            }
            ScriptFile sf = new ScriptFile(command, "", _args);
            if (sf.execute()) {
                out = sf.getResult();
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return out;
    }

    private Map<String, Object> defaultPrntOptions(boolean skipDefault) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        if (!skipDefault && this.engine.hasVariable(VAR_PRNT_OPTIONS)) {
            out.putAll((Map)this.engine.get(VAR_PRNT_OPTIONS));
            out.remove("skipDefaultOptions");
            this.manageBooleanOptions(out);
        }
        out.putIfAbsent("maxrows", 100000);
        out.putIfAbsent("maxDepth", 1);
        out.putIfAbsent("indention", 4);
        out.putIfAbsent("columnsOut", new ArrayList());
        out.putIfAbsent("columnsIn", new ArrayList());
        return out;
    }

    @Override
    public void trace(Object object) {
        Object toPrint = object;
        int level = this.consoleOption("trace", 0);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (level < 2) {
            options.put("exception", "message");
        }
        if (level == 0) {
            if (!(object instanceof Exception)) {
                toPrint = null;
            }
        } else if (level == 1) {
            if (object instanceof SystemRegistryImpl.CommandData) {
                toPrint = ((SystemRegistryImpl.CommandData)object).rawLine();
            }
        } else if (level > 1 && object instanceof SystemRegistryImpl.CommandData) {
            toPrint = ((SystemRegistryImpl.CommandData)object).toString();
        }
        this.internalPrintln(options, toPrint);
    }

    private void error(String message) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.styled(this.prntStyle.resolve(".em"), (CharSequence)message);
        asb.println(this.terminal());
    }

    @Override
    public void println(Object object) {
        this.internalPrintln(this.defaultPrntOptions(false), object);
    }

    private void manageBooleanOptions(Map<String, Object> options) {
        for (String key : Printer.BOOLEAN_KEYS) {
            boolean value;
            if (!options.containsKey(key) || (value = options.get(key) instanceof Boolean ? (Boolean)options.get(key) : false)) continue;
            options.remove(key);
        }
    }

    @Override
    public void println(Map<String, Object> options, Object object) {
        for (Map.Entry<String, Object> entry : this.defaultPrntOptions(options.containsKey("skipDefaultOptions")).entrySet()) {
            options.putIfAbsent(entry.getKey(), entry.getValue());
        }
        this.manageBooleanOptions(options);
        this.internalPrintln(options, object);
    }

    private void internalPrintln(Map<String, Object> options, Object object) {
        if (object == null) {
            return;
        }
        long start = new Date().getTime();
        if (options.containsKey("exclude")) {
            List<String> colOut = this.optionList("exclude", options);
            List<String> colIn = this.optionList("columnsIn", options);
            colIn.removeAll(colOut);
            colOut.addAll((List)options.get("columnsOut"));
            options.put("columnsIn", colIn);
            options.put("columnsOut", colOut);
        }
        if (options.containsKey("include")) {
            List<String> colIn = this.optionList("include", options);
            colIn.addAll((List)options.get("columnsIn"));
            options.put("columnsIn", colIn);
        }
        String valueStyle = (String)options.get("valueStyle");
        if (options.containsKey("valueStyle")) {
            options.put("valueStyle", this.valueHighlighter(valueStyle));
        }
        this.prntStyle = Styles.prntStyle();
        options.putIfAbsent("width", this.terminal().getSize().getColumns());
        String style = (String)options.getOrDefault("style", "");
        int width = (Integer)options.get("width");
        if (!style.isEmpty() && object instanceof String) {
            this.highlightAndPrint(width, style, (String)object);
        } else if (style.equalsIgnoreCase("JSON")) {
            this.highlightAndPrint(width, style, this.engine.toJson(object));
        } else if (options.containsKey("skipDefaultOptions")) {
            this.highlightAndPrint(options, object);
        } else if (object instanceof Exception) {
            this.systemRegistry.trace(options.getOrDefault("exception", "stack").equals("stack"), (Exception)object);
        } else if (object instanceof CmdDesc) {
            this.highlight((CmdDesc)object).println(this.terminal());
        } else if (object instanceof String || object instanceof Number) {
            this.highlightAndPrint(width, valueStyle, object.toString());
        } else {
            this.highlightAndPrint(options, object);
        }
        this.terminal().flush();
        Log.debug("println: ", new Date().getTime() - start, " msec");
    }

    private AttributedString highlight(CmdDesc cmdDesc) {
        StringBuilder sb = new StringBuilder();
        for (AttributedString as : cmdDesc.getMainDesc()) {
            sb.append(as.toString());
            sb.append("\n");
        }
        List<Integer> tabs = Arrays.asList(0, 2, 33);
        for (Map.Entry<String, List<AttributedString>> entry : cmdDesc.getOptsDesc().entrySet()) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.tabs(tabs);
            asb.append("\t");
            asb.append(entry.getKey());
            asb.append("\t");
            boolean first = true;
            for (AttributedString as : entry.getValue()) {
                if (!first) {
                    asb.append("\t");
                    asb.append("\t");
                }
                asb.append(as);
                asb.append("\n");
                first = false;
            }
            sb.append(asb.toString());
        }
        return Options.HelpException.highlight(sb.toString(), Styles.helpStyle());
    }

    private Nano.SyntaxHighlighter valueHighlighter(String style) {
        Nano.SyntaxHighlighter out;
        if (style.matches("[a-z]+:.*")) {
            out = Nano.SyntaxHighlighter.build(style);
        } else {
            Path nanorc;
            Path path = nanorc = this.configPath != null ? this.configPath.getConfig("jnanorc") : null;
            if (this.engine.hasVariable(VAR_NANORC)) {
                nanorc = Paths.get((String)this.engine.get(VAR_NANORC), new String[0]);
            }
            if (nanorc == null) {
                nanorc = Paths.get("/etc/nanorc", new String[0]);
            }
            out = nanorc != null ? Nano.SyntaxHighlighter.build(nanorc, style) : null;
        }
        return out;
    }

    private String truncate4nanorc(String obj) {
        String val = obj;
        if (val.length() > 400 && !val.contains("\n")) {
            val = val.substring(0, 399);
        }
        return val;
    }

    private AttributedString highlight(Integer width, Nano.SyntaxHighlighter highlighter, String object) {
        return this.highlight(width, highlighter, object, this.isValue(object));
    }

    private AttributedString highlight(Integer width, Nano.SyntaxHighlighter highlighter, String object, boolean doValueHighlight) {
        AttributedString out = null;
        AttributedStringBuilder asb = new AttributedStringBuilder();
        String val = object;
        if (highlighter != null && doValueHighlight) {
            val = this.truncate4nanorc(object);
        }
        asb.append(val);
        out = highlighter != null && val.length() < 400 && doValueHighlight ? highlighter.highlight(asb) : asb.toAttributedString();
        if (width != null) {
            out = out.columnSubSequence(0, width);
        }
        return out;
    }

    private boolean isValue(String value) {
        if (value.matches("\"(\\.|[^\"])*\"|'(\\.|[^'])*'") || value.startsWith("[") && value.endsWith("]") || value.startsWith("(") && value.endsWith(")") || value.startsWith("{") && value.endsWith("}") || value.startsWith("<") && value.endsWith(">")) {
            return true;
        }
        return !value.contains(" ") && !value.contains("\t");
    }

    private void highlightAndPrint(int width, String style, String object) {
        Nano.SyntaxHighlighter highlighter = this.valueHighlighter(style);
        boolean doValueHighlight = this.isValue(object);
        for (String s : object.split("\\r?\\n")) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            List<AttributedString> sas = asb.append(s).columnSplitLength(width);
            for (AttributedString as : sas) {
                this.highlight(width, highlighter, as.toString(), doValueHighlight).println(this.terminal());
            }
        }
    }

    private Map<String, Object> keysToString(Map<Object, Object> map) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (entry.getKey() instanceof String) {
                out.put((String)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() != null) {
                out.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            out.put("null", entry.getValue());
        }
        return out;
    }

    private Object mapValue(Map<String, Object> options, String key, Map<String, Object> map) {
        Object out = null;
        if (map.containsKey(key)) {
            out = map.get(key);
        } else if (key.contains(".")) {
            String[] keys = key.split("\\.");
            out = map.get(keys[0]);
            for (int i = 1; i < keys.length; ++i) {
                if (out instanceof Map) {
                    Map<String, Object> m = this.keysToString((Map<Object, Object>)out);
                    out = m.get(keys[i]);
                    continue;
                }
                if (!this.canConvert(out)) break;
                out = this.engine.toMap(out).get(keys[i]);
            }
        }
        if (!(out instanceof Map) && this.canConvert(out)) {
            out = this.objectToMap(options, out);
        }
        return out;
    }

    private List<String> optionList(String key, Map<String, Object> options) {
        ArrayList<String> out = new ArrayList<String>();
        if (options.containsKey(key)) {
            if (options.get(key) instanceof String) {
                out.addAll(Arrays.asList(((String)options.get(key)).split(",")));
            } else if (options.get(key) instanceof Collection) {
                out.addAll((Collection)options.get(key));
            } else {
                throw new IllegalArgumentException("Unsupported option list: {key: " + key + ", type: " + options.get(key).getClass() + "}");
            }
        }
        return out;
    }

    private boolean hasMatch(List<String> regexes, String value) {
        for (String r : regexes) {
            if (!value.matches(r)) continue;
            return true;
        }
        return false;
    }

    private AttributedString addPadding(AttributedString str, int width) {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        for (int i = str.columnLength(); i < width; ++i) {
            sb.append(" ");
        }
        sb.append(str);
        return sb.toAttributedString();
    }

    private String columnValue(String value) {
        return value.replaceAll("\r", "CR").replaceAll("\n", "LF");
    }

    private Map<String, Object> objectToMap(Map<String, Object> options, Object obj) {
        if (obj != null) {
            Map toMap;
            Map map = toMap = options.containsKey("objectToMap") ? (Map)options.get("objectToMap") : new HashMap();
            if (toMap.containsKey(obj.getClass())) {
                return (Map)this.engine.execute(toMap.get(obj.getClass()), obj);
            }
            if (this.objectToMap.containsKey(obj.getClass())) {
                return this.objectToMap.get(obj.getClass()).apply(obj);
            }
        }
        return this.engine.toMap(obj);
    }

    private String objectToString(Map<String, Object> options, Object obj) {
        if (obj != null) {
            Map toString;
            Map map = toString = options.containsKey("objectToString") ? (Map)options.get("objectToString") : new HashMap();
            if (toString.containsKey(obj.getClass())) {
                return (String)this.engine.execute(toString.get(obj.getClass()), obj);
            }
            if (this.objectToString.containsKey(obj.getClass())) {
                return this.objectToString.get(obj.getClass()).apply(obj);
            }
            if (obj instanceof Class) {
                return ((Class)obj).getName();
            }
        }
        return this.engine.toString(obj);
    }

    private AttributedString highlightMapValue(Map<String, Object> options, String key, Map<String, Object> map) {
        return this.highlightValue(options, key, this.mapValue(options, key, map));
    }

    private boolean isHighlighted(AttributedString value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.styleAt(i).getStyle() == AttributedStyle.DEFAULT.getStyle()) continue;
            return true;
        }
        return false;
    }

    private AttributedString highlightValue(Map<String, Object> options, String column, Object obj) {
        Map hv;
        AttributedString out = null;
        Object raw = options.containsKey("toString") && obj != null ? this.objectToString(options, obj) : obj;
        Map map = hv = options.containsKey("highlightValue") ? (Map)options.get("highlightValue") : new HashMap();
        if (column != null && this.simpleObject(raw)) {
            for (Map.Entry entry : hv.entrySet()) {
                if (((String)entry.getKey()).equals("*") || !column.matches((String)entry.getKey())) continue;
                out = (AttributedString)this.engine.execute(hv.get(entry.getKey()), raw);
                break;
            }
            if (out == null) {
                for (Map.Entry<Object, Object> entry : this.highlightValue.entrySet()) {
                    if (((String)entry.getKey()).equals("*") || !column.matches((String)entry.getKey())) continue;
                    out = this.highlightValue.get(entry.getKey()).apply(raw);
                    break;
                }
            }
        }
        if (out == null) {
            out = raw instanceof String ? new AttributedString(this.columnValue((String)raw)) : new AttributedString(this.columnValue(this.objectToString(options, raw)));
        }
        if ((this.simpleObject(raw) || raw == null) && (hv.containsKey("*") || this.highlightValue.containsKey("*")) && !this.isHighlighted(out)) {
            if (hv.containsKey("*")) {
                out = (AttributedString)this.engine.execute(hv.get("*"), out);
            }
            if (this.highlightValue.containsKey("*")) {
                out = this.highlightValue.get("*").apply(out);
            }
        }
        if (options.containsKey("valueStyle") && !this.isHighlighted(out)) {
            out = this.highlight(null, (Nano.SyntaxHighlighter)options.get("valueStyle"), out.toString());
        }
        return this.truncateValue(options, out);
    }

    private AttributedString truncateValue(Map<String, Object> options, AttributedString value) {
        if (value.columnLength() > (Integer)options.getOrDefault("maxColumnWidth", Integer.MAX_VALUE)) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append(value.subSequence(0, (Integer)options.get("maxColumnWidth") - 3));
            asb.append("...");
            return asb.toAttributedString();
        }
        return value;
    }

    private String truncateValue(int maxWidth, String value) {
        if (value.length() > maxWidth) {
            StringBuilder asb = new StringBuilder();
            asb.append(value.subSequence(0, maxWidth - 3));
            asb.append("...");
            return asb.toString();
        }
        return value;
    }

    private List<Object> objectToList(Object obj) {
        ArrayList<Object> out = new ArrayList();
        if (obj instanceof List) {
            out = (List)obj;
        } else if (obj instanceof Collection) {
            out.addAll((Collection)obj);
        } else if (obj instanceof Object[]) {
            out.addAll(Arrays.asList((Object[])obj));
        } else if (obj instanceof Iterator) {
            ((Iterator)obj).forEachRemaining(out::add);
        } else if (obj instanceof Iterable) {
            ((Iterable)obj).forEach(out::add);
        } else {
            out.add(obj);
        }
        return out;
    }

    private boolean similarSets(Set<String> ref, Set<String> c2, double threshold) {
        boolean out = c2.containsAll(ref);
        if (!out) {
            int matches = 0;
            for (String s : ref) {
                if (!c2.contains(s)) continue;
                ++matches;
            }
            double r = 1.0 * (double)matches / (double)ref.size();
            out = r > threshold;
        }
        return out;
    }

    private void println(AttributedString line, int maxrows) {
        line.println(this.terminal());
        ++this.totLines;
        if (this.totLines > maxrows) {
            this.totLines = 0;
            throw new TruncatedOutputException("Truncated output: " + maxrows);
        }
    }

    private String columnName(String name, boolean shortName) {
        String out = name;
        if (shortName) {
            String[] p = name.split("\\.");
            out = p[p.length - 1];
        }
        return out;
    }

    private void highlightAndPrint(Map<String, Object> options, Object obj) {
        String message;
        block43: {
            int width = (Integer)options.get("width");
            boolean rownum = options.containsKey("rownum");
            this.totLines = 0;
            message = null;
            if (obj != null) {
                if (obj instanceof Map) {
                    this.highlightMap(options, this.keysToString((Map)obj), width);
                } else if (this.collectionObject(obj)) {
                    List<Object> collection = this.objectToList(obj);
                    if (collection.size() > (Integer)options.get("maxrows")) {
                        message = "Truncated output: " + (Integer)options.get("maxrows") + "/" + collection.size();
                        collection = collection.subList(collection.size() - (Integer)options.get("maxrows"), collection.size());
                    }
                    if (!collection.isEmpty()) {
                        if (collection.size() == 1 && !options.containsKey("oneRowTable")) {
                            Object elem = collection.iterator().next();
                            if (elem instanceof Map) {
                                this.highlightMap(options, this.keysToString((Map)elem), width);
                            } else if (this.canConvert(elem) && !options.containsKey("toString")) {
                                this.highlightMap(options, this.objectToMap(options, elem), width);
                            } else {
                                this.highlightValue(options, null, this.objectToString(options, obj)).println(this.terminal());
                            }
                        } else {
                            try {
                                Object elem = collection.iterator().next();
                                boolean convert = this.canConvert(elem);
                                if ((elem instanceof Map || convert) && !options.containsKey("toString")) {
                                    List<Object> columnsOut;
                                    Map<String, Object> map = convert ? this.objectToMap(options, elem) : this.keysToString((Map)elem);
                                    List _header = null;
                                    List columnsIn = this.optionList("columnsIn", options);
                                    List<Object> list = columnsOut = !options.containsKey("all") ? this.optionList("columnsOut", options) : new ArrayList();
                                    if (options.containsKey("columns")) {
                                        _header = (List)options.get("columns");
                                    } else {
                                        _header = columnsIn;
                                        _header.addAll(map.keySet().stream().filter(k -> !columnsIn.contains(k) && !this.hasMatch((List<String>)columnsOut, (String)k)).collect(Collectors.toList()));
                                    }
                                    ArrayList<String> header = new ArrayList<String>();
                                    ArrayList<Integer> columns = new ArrayList<Integer>();
                                    int headerWidth = 0;
                                    HashSet<String> refKeys = new HashSet<String>();
                                    for (int i = 0; i < _header.size(); ++i) {
                                        Object val;
                                        if (!map.containsKey(((String)_header.get(i)).split("\\.")[0]) && !map.containsKey(_header.get(i)) || !options.containsKey("columns") && !options.containsKey("structsOnTable") && ((val = this.mapValue(options, (String)_header.get(i), map)) == null || !this.simpleObject(val))) continue;
                                        String rk = map.containsKey(_header.get(i)) ? (String)_header.get(i) : ((String)_header.get(i)).split("\\.")[0];
                                        refKeys.add(rk);
                                        header.add((String)_header.get(i));
                                        String cn = this.columnName((String)_header.get(i), options.containsKey("shortNames"));
                                        columns.add(cn.length() + 1);
                                        if ((headerWidth += cn.length() + 1) > width) break;
                                    }
                                    if (header.size() == 0) {
                                        throw new Exception("No columns for table!");
                                    }
                                    double mapSimilarity = 0.8;
                                    if (options.containsKey("mapSimilarity")) {
                                        mapSimilarity = ((BigDecimal)options.get("mapSimilarity")).doubleValue();
                                    }
                                    for (Object o : collection) {
                                        Map<String, Object> m;
                                        Map<String, Object> map2 = m = convert ? this.objectToMap(options, o) : this.keysToString((Map)o);
                                        if (o instanceof Map && !this.similarSets(refKeys, m.keySet(), mapSimilarity)) {
                                            throw new Exception("Not homogenous list!");
                                        }
                                        for (int i = 0; i < header.size(); ++i) {
                                            int cw = this.highlightMapValue(options, (String)header.get(i), m).columnLength();
                                            if (cw <= (Integer)columns.get(i) - 1) continue;
                                            columns.set(i, cw + 1);
                                        }
                                    }
                                    columns.add(0, 0);
                                    this.toTabStops(columns, collection.size(), rownum);
                                    AttributedStringBuilder asb = new AttributedStringBuilder().tabs(columns);
                                    int firstColumn = 0;
                                    if (rownum) {
                                        asb.append("\t");
                                        firstColumn = 1;
                                    }
                                    for (int i = 0; i < header.size(); ++i) {
                                        asb.styled(this.prntStyle.resolve(".th"), (CharSequence)this.columnName((String)header.get(i), options.containsKey("shortNames")));
                                        asb.append("\t");
                                    }
                                    this.truncate(asb, width).println(this.terminal());
                                    Integer row = 0;
                                    for (Object o : collection) {
                                        AttributedStringBuilder asb2 = new AttributedStringBuilder().tabs(columns);
                                        if (rownum) {
                                            asb2.styled(this.prntStyle.resolve(".rn"), (CharSequence)row.toString()).append(":");
                                            asb2.append("\t");
                                            Integer n = row;
                                            Integer n2 = row = Integer.valueOf(row + 1);
                                        }
                                        Map<String, Object> m = convert ? this.objectToMap(options, o) : this.keysToString((Map)o);
                                        for (int i = 0; i < header.size(); ++i) {
                                            AttributedString v = this.highlightMapValue(options, (String)header.get(i), m);
                                            if (this.isNumber(v.toString())) {
                                                v = this.addPadding(v, (Integer)columns.get(firstColumn + i + 1) - (Integer)columns.get(firstColumn + i) - 1);
                                            }
                                            asb2.append(v);
                                            asb2.append("\t");
                                        }
                                        asb2.subSequence(0, width).println(this.terminal());
                                    }
                                    break block43;
                                }
                                if (this.collectionObject(elem) && !options.containsKey("toString")) {
                                    ArrayList<Integer> columns = new ArrayList<Integer>();
                                    for (Object o : collection) {
                                        List<Object> inner = this.objectToList(o);
                                        for (int i = 0; i < inner.size(); ++i) {
                                            int len1 = this.engine.toString(inner.get(i)).length() + 1;
                                            if (columns.size() <= i) {
                                                columns.add(len1);
                                                continue;
                                            }
                                            if (len1 <= (Integer)columns.get(i)) continue;
                                            columns.set(i, len1);
                                        }
                                    }
                                    this.toTabStops(columns, collection.size(), rownum);
                                    Integer row = 0;
                                    int firstColumn = rownum ? 1 : 0;
                                    for (Object o : collection) {
                                        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(columns);
                                        if (rownum) {
                                            asb.styled(this.prntStyle.resolve(".rn"), (CharSequence)row.toString()).append(":");
                                            asb.append("\t");
                                            Integer headerWidth = row;
                                            Integer refKeys = row = Integer.valueOf(row + 1);
                                        }
                                        List<Object> inner = this.objectToList(o);
                                        for (int i = 0; i < inner.size(); ++i) {
                                            AttributedString v = this.highlightValue(options, null, inner.get(i));
                                            if (this.isNumber(v.toString())) {
                                                v = this.addPadding(v, (Integer)columns.get(firstColumn + i + 1) - (Integer)columns.get(firstColumn + i) - 1);
                                            }
                                            asb.append(v);
                                            asb.append("\t");
                                        }
                                        this.truncate(asb, width).println(this.terminal());
                                    }
                                    break block43;
                                }
                                this.highlightList(options, collection, width);
                            }
                            catch (Exception e) {
                                if (this.consoleOption("trace", 0) > 0) {
                                    this.trace(e);
                                }
                                this.highlightList(options, collection, width);
                            }
                        }
                    } else {
                        this.highlightValue(options, null, this.objectToString(options, obj)).println(this.terminal());
                    }
                } else if (this.canConvert(obj) && !options.containsKey("toString")) {
                    this.highlightMap(options, this.objectToMap(options, obj), width);
                } else {
                    this.highlightValue(options, null, this.objectToString(options, obj)).println(this.terminal());
                }
            }
        }
        if (message != null) {
            this.error(message);
        }
    }

    private void highlightList(Map<String, Object> options, List<Object> collection, int width) {
        this.highlightList(options, collection, width, 0);
    }

    private void highlightList(Map<String, Object> options, List<Object> collection, int width, int depth) {
        Integer row = 0;
        int maxrows = (Integer)options.get("maxrows");
        int indent = (Integer)options.get("indention");
        ArrayList<Integer> tabs = new ArrayList<Integer>();
        tabs.add(indent * depth);
        if (options.containsKey("rownum")) {
            tabs.add(indent * depth + this.digits(collection.size()) + 2);
        }
        options.remove("maxColumnWidth");
        for (Object o : collection) {
            AttributedStringBuilder asb = new AttributedStringBuilder().tabs(tabs);
            if (depth > 0) {
                asb.append("\t");
            }
            if (options.containsKey("rownum")) {
                asb.styled(this.prntStyle.resolve(".rn"), (CharSequence)row.toString()).append(":");
                asb.append("\t");
                Integer n = row;
                Integer n2 = row = Integer.valueOf(row + 1);
            }
            asb.append(this.highlightValue(options, null, o));
            this.println(this.truncate(asb, width), maxrows);
        }
    }

    private boolean collectionObject(Object obj) {
        return obj instanceof Iterator || obj instanceof Iterable || obj instanceof Object[] || obj instanceof Collection;
    }

    private boolean simpleObject(Object obj) {
        return obj instanceof Number || obj instanceof String || obj instanceof Date || obj instanceof File || obj instanceof Boolean || obj instanceof Enum;
    }

    private boolean canConvert(Object obj) {
        return obj != null && !(obj instanceof Class) && !(obj instanceof Map) && !this.simpleObject(obj) && !this.collectionObject(obj);
    }

    private AttributedString truncate(AttributedStringBuilder asb, int width) {
        return asb.columnLength() > width ? asb.subSequence(0, width) : asb.toAttributedString();
    }

    private int digits(int number) {
        if (number < 100) {
            return number < 10 ? 1 : 2;
        }
        if (number < 1000) {
            return 3;
        }
        return number < 10000 ? 4 : 5;
    }

    private void toTabStops(List<Integer> columns, int rows, boolean rownum) {
        int delta = 5;
        if (rownum) {
            delta = this.digits(rows) + 2;
            columns.add(0, delta);
        }
        for (int i = 1; i < columns.size(); ++i) {
            delta = columns.get(i);
            columns.set(i, columns.get(i - 1) + columns.get(i));
        }
        columns.add(columns.get(columns.size() - 1) + delta);
    }

    private void highlightMap(Map<String, Object> options, Map<String, Object> map, int width) {
        if (!map.isEmpty()) {
            this.highlightMap(options, map, width, 0);
        } else {
            this.highlightValue(options, null, this.objectToString(options, map)).println(this.terminal());
        }
    }

    private void highlightMap(Map<String, Object> options, Map<String, Object> map, int width, int depth) {
        int maxrows = (Integer)options.get("maxrows");
        int max = map.keySet().stream().map(String::length).max(Integer::compareTo).get();
        if (max > (Integer)options.getOrDefault("maxColumnWidth", Integer.MAX_VALUE)) {
            max = (Integer)options.get("maxColumnWidth");
        }
        HashMap<String, Object> mapOptions = new HashMap<String, Object>();
        mapOptions.putAll(options);
        mapOptions.remove("maxColumnWidth");
        int indent = (Integer)options.get("indention");
        int maxDepth = (Integer)options.get("maxDepth");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            AttributedStringBuilder asb = new AttributedStringBuilder().tabs(Arrays.asList(0, depth * indent, depth * indent + max + 1));
            if (depth != 0) {
                asb.append("\t");
            }
            asb.styled(this.prntStyle.resolve(".mk"), (CharSequence)this.truncateValue(max, entry.getKey()));
            Object elem = entry.getValue();
            boolean convert = this.canConvert(elem);
            boolean highlightValue = true;
            if (depth < maxDepth && !options.containsKey("toString")) {
                List<Object> collection;
                if (elem instanceof Map || convert) {
                    Map<String, Object> childMap;
                    Map<String, Object> map2 = childMap = convert ? this.objectToMap(options, elem) : this.keysToString((Map)elem);
                    if (!childMap.isEmpty()) {
                        this.println(this.truncate(asb, width), maxrows);
                        this.highlightMap(options, childMap, width, depth + 1);
                        highlightValue = false;
                    }
                } else if (this.collectionObject(elem) && !(collection = this.objectToList(elem)).isEmpty()) {
                    this.println(this.truncate(asb, width), maxrows);
                    HashMap<String, Object> listOptions = new HashMap<String, Object>();
                    listOptions.putAll(options);
                    listOptions.put("toString", true);
                    this.highlightList(listOptions, collection, width, depth + 1);
                    highlightValue = false;
                }
            }
            if (!highlightValue) continue;
            AttributedString val = this.highlightMapValue(mapOptions, entry.getKey(), map);
            asb.append("\t");
            if (map.size() == 1) {
                if (val.contains('\n')) {
                    for (String v : val.toString().split("\\r?\\n")) {
                        asb.append(this.highlightValue(options, entry.getKey(), v));
                        this.println(this.truncate(asb, width), maxrows);
                        asb = new AttributedStringBuilder().tabs(Arrays.asList(0, max + 1));
                    }
                    continue;
                }
                asb.append(val);
                this.println(this.truncate(asb, width), maxrows);
                continue;
            }
            if (val.contains('\n')) {
                val = new AttributedString(Arrays.asList(val.toString().split("\\r?\\n")).toString());
                asb.append(this.highlightValue(options, entry.getKey(), val.toString()));
            } else {
                asb.append(val);
            }
            this.println(this.truncate(asb, width), maxrows);
        }
    }

    private Object show(CommandInput input) {
        String[] usage = new String[]{"show -  list console variables", "Usage: show [VARIABLE]", "  -? --help                       Displays command help"};
        try {
            this.parseOptions(usage, input.args());
            Map<String, Object> options = this.defaultPrntOptions(false);
            options.put("maxDepth", 0);
            this.internalPrintln(options, this.engine.find(input.args().length > 0 ? input.args()[0] : null));
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private Object del(CommandInput input) {
        String[] usage = new String[]{"del -  delete console variables, methods, classes and imports", "Usage: del [var1] ...", "  -? --help                       Displays command help"};
        try {
            this.parseOptions(usage, input.args());
            this.engine.del(input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private Object prnt(CommandInput input) {
        String[] usage = new String[]{"prnt -  print object", "Usage: prnt [OPTIONS] object", "  -? --help                       Displays command help", "  -a --all                        Ignore columnsOut configuration", "  -c --columns=COLUMNS,...        Display given columns on table", "  -e --exclude=COLUMNS,...        Exclude given columns on table", "  -i --include=COLUMNS,...        Include given columns on table", "     --indention=IDENTION         Indention size", "     --maxColumnWidth=WIDTH       Maximum column width", "  -d --maxDepth=DEPTH             Maximum depth objects are resolved", "     --maxrows=ROWS               Maximum number of lines to display", "     --oneRowTable                Display one row data on table", "  -r --rownum                     Display table row numbers", "     --shortNames                 Truncate table column names (property.field -> field)", "     --skipDefaultOptions         Ignore all options defined in PRNT_OPTIONS", "     --structsOnTable             Display structs and lists on table", "  -s --style=STYLE                Use nanorc STYLE", "     --toString                   use object's toString() method to get print value", "                                  DEFAULT: object's fields are put to property map before printing", "     --valueStyle=STYLE           Use nanorc style to highlight column/map values", "  -w --width=WIDTH                Display width (default terminal width)"};
        try {
            Options opt = this.parseOptions(usage, input.xargs());
            boolean skipDefault = opt.isSet("skipDefaultOptions");
            Map<String, Object> options = this.defaultPrntOptions(skipDefault);
            if (opt.isSet("style")) {
                options.put("style", opt.get("style"));
            }
            if (opt.isSet("toString")) {
                options.put("toString", true);
            }
            if (opt.isSet("width")) {
                options.put("width", opt.getNumber("width"));
            }
            if (opt.isSet("rownum")) {
                options.put("rownum", true);
            }
            if (opt.isSet("oneRowTable")) {
                options.put("oneRowTable", true);
            }
            if (opt.isSet("shortNames")) {
                options.put("shortNames", true);
            }
            if (opt.isSet("structsOnTable")) {
                options.put("structsOnTable", true);
            }
            if (opt.isSet("columns")) {
                options.put("columns", Arrays.asList(opt.get("columns").split(",")));
            }
            if (opt.isSet("exclude")) {
                options.put("exclude", Arrays.asList(opt.get("exclude").split(",")));
            }
            if (opt.isSet("include")) {
                options.put("include", Arrays.asList(opt.get("include").split(",")));
            }
            if (opt.isSet("all")) {
                options.put("all", true);
            }
            if (opt.isSet("maxrows")) {
                options.put("maxrows", opt.getNumber("maxrows"));
            }
            if (opt.isSet("maxColumnWidth")) {
                options.put("maxColumnWidth", opt.getNumber("maxColumnWidth"));
            }
            if (opt.isSet("maxDepth")) {
                options.put("maxDepth", opt.getNumber("maxDepth"));
            }
            if (opt.isSet("indention")) {
                options.put("indention", opt.getNumber("indention"));
            }
            if (opt.isSet("valueStyle")) {
                options.put("valueStyle", opt.get("valueStyle"));
            }
            options.put("exception", "stack");
            List<Object> args = opt.argObjects();
            if (args.size() > 0) {
                this.internalPrintln(options, args.get(0));
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private Object slurpcmd(CommandInput input) {
        Object out;
        block6: {
            String[] usage = new String[]{"slurp -  slurp file or string variable context to object", "Usage: slurp [OPTIONS] file|variable", "  -? --help                       Displays command help", "  -e --encoding=ENCODING          Encoding (default UTF-8)", "  -f --format=FORMAT              Serialization format"};
            out = null;
            try {
                Options opt = this.parseOptions(usage, input.xargs());
                if (opt.args().isEmpty()) break block6;
                Object _arg = opt.argObjects().get(0);
                if (!(_arg instanceof String)) {
                    throw new IllegalArgumentException("Invalid parameter type: " + _arg.getClass().getSimpleName());
                }
                String arg = (String)_arg;
                Charset encoding = opt.isSet("encoding") ? Charset.forName(opt.get("encoding")) : StandardCharsets.UTF_8;
                String format = opt.isSet("format") ? opt.get("format") : this.engine.getSerializationFormats().get(0);
                try {
                    Path path = Paths.get(arg, new String[0]);
                    if (path.toFile().exists()) {
                        out = this.slurp(path, encoding, format);
                        break block6;
                    }
                    out = this.engine.deserialize(arg, format);
                }
                catch (Exception e) {
                    out = this.engine.deserialize(arg, format);
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
        return out;
    }

    @Override
    public void persist(Path file, Object object) {
        this.engine.persist(file, object);
    }

    @Override
    public Object slurp(Path file) throws IOException {
        return this.slurp(file, StandardCharsets.UTF_8, this.engine.getSerializationFormats().get(0));
    }

    private Object slurp(Path file, Charset encoding, String format) throws IOException {
        byte[] encoded = Files.readAllBytes(file);
        return this.engine.deserialize(new String(encoded, encoding), format);
    }

    private Object aliascmd(CommandInput input) {
        String[] usage = new String[]{"alias -  create command alias", "Usage: alias [ALIAS] [COMMANDLINE]", "  -? --help                       Displays command help"};
        Map<String, String> out = null;
        try {
            Options opt = this.parseOptions(usage, input.args());
            List<String> args = opt.args();
            if (args.isEmpty()) {
                out = this.aliases;
            } else if (args.size() == 1) {
                out = this.aliases.getOrDefault(args.get(0), null);
            } else {
                String alias = String.join((CharSequence)" ", args.subList(1, args.size()));
                for (int j = 0; j < 10; ++j) {
                    alias = alias.replaceAll("%" + j, "\\$" + j);
                    alias = alias.replaceAll("%\\{" + j + "\\}", "\\$\\{" + j + "\\}");
                    alias = alias.replaceAll("%\\{" + j + ":-", "\\$\\{" + j + ":-");
                }
                alias = alias.replaceAll("%@", "\\$@");
                alias = alias.replaceAll("%\\{@\\}", "\\$\\{@\\}");
                this.aliases.put(args.get(0), alias);
                this.persist(this.aliasFile, this.aliases);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return out;
    }

    private Object unalias(CommandInput input) {
        String[] usage = new String[]{"unalias -  remove command alias", "Usage: unalias [ALIAS...]", "  -? --help                       Displays command help"};
        try {
            Options opt = this.parseOptions(usage, input.args());
            for (String a : opt.args()) {
                this.aliases.remove(a);
            }
            this.persist(this.aliasFile, this.aliases);
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private Object pipe(CommandInput input) {
        String[] usage = new String[]{"pipe -  create/delete pipe operator", "Usage: pipe [OPERATOR] [PREFIX] [POSTFIX]", "       pipe --list", "       pipe --delete [OPERATOR...]", "  -? --help                       Displays command help", "  -d --delete                     Delete pipe operators", "  -l --list                       List pipe operators"};
        try {
            Options opt = this.parseOptions(usage, input.args());
            if (opt.isSet("delete")) {
                if (opt.args().size() == 1 && opt.args().get(0).equals("*")) {
                    this.pipes.clear();
                } else {
                    for (String p : opt.args()) {
                        this.pipes.remove(p.trim());
                    }
                }
            } else if (opt.isSet("list") || opt.args().size() == 0) {
                Map<String, Object> options = this.defaultPrntOptions(false);
                options.put("maxDepth", 0);
                this.internalPrintln(options, this.pipes);
            } else if (opt.args().size() != 3) {
                this.exception = new IllegalArgumentException("Bad number of arguments!");
            } else if (this.systemRegistry.getPipeNames().contains(opt.args().get(0))) {
                this.exception = new IllegalArgumentException("Reserved pipe operator");
            } else {
                ArrayList<String> fixes = new ArrayList<String>();
                fixes.add(opt.args().get(1));
                fixes.add(opt.args().get(2));
                this.pipes.put(opt.args().get(0), fixes);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        return null;
    }

    private Object doc(CommandInput input) {
        block11: {
            String[] usage = new String[]{"doc -  open document on browser", "Usage: doc [OBJECT]", "  -? --help                       Displays command help"};
            try {
                this.parseOptions(usage, input.xargs());
                if (input.xargs().length == 0) {
                    return null;
                }
                if (Desktop.isDesktopSupported()) {
                    Map docs = this.consoleOption("docs", null);
                    boolean done = false;
                    Object arg = input.xargs()[0];
                    if (arg instanceof String) {
                        String address;
                        String string = address = docs != null ? (String)docs.get(input.args()[0]) : null;
                        if (address != null) {
                            done = true;
                            Desktop.getDesktop().browse(new URI(address));
                        }
                    }
                    if (done) break block11;
                    String name = "";
                    name = arg instanceof String && ((String)arg).matches("([a-z]+\\.)+[A-Z][a-zA-Z]+") ? (String)arg : arg.getClass().getCanonicalName();
                    name = name.replaceAll("\\.", "/") + ".html";
                    Object doc = null;
                    for (Map.Entry entry : docs.entrySet()) {
                        if (!name.matches((String)entry.getKey())) continue;
                        doc = entry.getValue();
                        break;
                    }
                    if (doc != null) {
                        if (doc instanceof Collection) {
                            for (Map.Entry o : (Collection)doc) {
                                Desktop.getDesktop().browse(new URI((String)((Object)o) + name));
                            }
                        } else {
                            Desktop.getDesktop().browse(new URI((String)doc + name));
                        }
                        break block11;
                    }
                    throw new IllegalArgumentException("Document not found: " + name);
                }
                throw new IllegalStateException("Desktop is not supported!");
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
        return null;
    }

    private List<Completer> slurpCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        List<Completers.OptDesc> optDescs = this.commandOptions("slurp");
        for (Completers.OptDesc o : optDescs) {
            if (o.shortOption() == null || !o.shortOption().equals("-f")) continue;
            o.setValueCompleter(new StringsCompleter((Iterable<String>)this.engine.getDeserializationFormats()));
            break;
        }
        AggregateCompleter argCompleter = new AggregateCompleter(new Completers.FilesCompleter(this.workDir), new StringsCompleter(this::variableReferences));
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter(Arrays.asList(argCompleter, NullCompleter.INSTANCE), optDescs, 1)));
        return completers;
    }

    private List<Completer> variableCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new StringsCompleter(() -> this.engine.find().keySet()));
        return completers;
    }

    private List<String> variableReferences() {
        ArrayList<String> out = new ArrayList<String>();
        for (String v : this.engine.find().keySet()) {
            out.add("$" + v);
        }
        return out;
    }

    private List<Completer> prntCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter(Arrays.asList(new StringsCompleter(this::variableReferences), NullCompleter.INSTANCE), this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> aliasCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        ArrayList<Completer> params = new ArrayList<Completer>();
        params.add(new StringsCompleter(this.aliases::keySet));
        params.add(new AliasValueCompleter(this.aliases));
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter(params, this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> unaliasCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        Completer[] completerArray = new Completer[2];
        completerArray[0] = NullCompleter.INSTANCE;
        completerArray[1] = new Completers.OptionCompleter((Completer)new StringsCompleter(this.aliases::keySet), this::commandOptions, 1);
        completers.add(new ArgumentCompleter(completerArray));
        return completers;
    }

    private List<String> docs() {
        ArrayList<String> out = new ArrayList<String>();
        for (String v : this.engine.find().keySet()) {
            out.add("$" + v);
        }
        Map docs = this.consoleOption("docs", null);
        if (!docs.isEmpty()) {
            for (String d : docs.keySet()) {
                if (!d.matches("\\w+")) continue;
                out.add(d);
            }
        }
        return out;
    }

    private List<Completer> docCompleter(String command) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter(Arrays.asList(new StringsCompleter(this::docs), NullCompleter.INSTANCE), this::commandOptions, 1)));
        return completers;
    }

    private static class AliasValueCompleter
    implements Completer {
        private final Map<String, String> aliases;

        public AliasValueCompleter(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            String h;
            assert (commandLine != null);
            assert (candidates != null);
            List<String> words = commandLine.words();
            if (words.size() > 1 && (h = words.get(words.size() - 2)) != null && h.length() > 0 && this.aliases.containsKey(h)) {
                String v = this.aliases.get(h);
                candidates.add(new Candidate(AttributedString.stripAnsi(v), v, null, null, null, null, true));
            }
        }
    }

    private static class TruncatedOutputException
    extends RuntimeException {
        public TruncatedOutputException(String message) {
            super(message);
        }
    }

    private class ScriptFile {
        private File script;
        private String extension = "";
        private String cmdLine;
        private String[] args;
        private boolean verbose;
        private Object result;

        public ScriptFile(String command, String cmdLine, String[] args) {
            if (!ConsoleEngineImpl.this.parser().validCommandName(command)) {
                return;
            }
            try {
                this.script = new File(command);
                this.cmdLine = cmdLine;
                if (this.script.exists()) {
                    this.scriptExtension(command);
                } else if (ConsoleEngineImpl.this.engine.hasVariable(ConsoleEngineImpl.VAR_PATH)) {
                    boolean found = false;
                    for (String p : (List)ConsoleEngineImpl.this.engine.get(ConsoleEngineImpl.VAR_PATH)) {
                        for (String e : ConsoleEngineImpl.this.scriptExtensions()) {
                            String file = command + "." + e;
                            Path path = Paths.get(p, file);
                            if (!path.toFile().exists()) continue;
                            this.script = path.toFile();
                            this.scriptExtension(command);
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                }
                this.doArgs(args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ScriptFile(File script, String cmdLine, String[] args) {
            if (!script.exists()) {
                throw new IllegalArgumentException("Script file not found!");
            }
            this.script = script;
            this.cmdLine = cmdLine;
            this.scriptExtension(script.getName());
            this.doArgs(args);
        }

        private void scriptExtension(String command) {
            String name = this.script.getName();
            String string = this.extension = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : "";
            if (!this.isEngineScript() && !this.isConsoleScript()) {
                throw new IllegalArgumentException("Command not found: " + command);
            }
        }

        private void doArgs(String[] args) {
            ArrayList<String> _args = new ArrayList<String>();
            if (this.isConsoleScript()) {
                _args.add(this.script.getAbsolutePath());
            }
            for (String a : args) {
                if (this.isConsoleScript()) {
                    if (!a.equals(ConsoleEngineImpl.OPTION_VERBOSE)) {
                        _args.add(a);
                        continue;
                    }
                    this.verbose = true;
                    continue;
                }
                _args.add(a);
            }
            this.args = _args.toArray(new String[0]);
        }

        private boolean isEngineScript() {
            return ConsoleEngineImpl.this.engine.getExtensions().contains(this.extension);
        }

        private boolean isConsoleScript() {
            return ConsoleEngineImpl.this.scriptExtension.equals(this.extension);
        }

        private boolean isScript() {
            return ConsoleEngineImpl.this.engine.getExtensions().contains(this.extension) || ConsoleEngineImpl.this.scriptExtension.equals(this.extension);
        }

        public boolean execute() throws Exception {
            if (!this.isScript()) {
                return false;
            }
            this.result = null;
            if (Arrays.asList(this.args).contains(OPTION_HELP[0]) || Arrays.asList(this.args).contains(OPTION_HELP[1])) {
                try (BufferedReader br = new BufferedReader(new FileReader(this.script));){
                    String l;
                    int size = 0;
                    StringBuilder usage = new StringBuilder();
                    boolean helpEnd = false;
                    boolean headComment = false;
                    while ((l = br.readLine()) != null) {
                        String line = l = l.replaceAll("\\s+$", "");
                        if (++size > 30 || line.endsWith(ConsoleEngineImpl.END_HELP)) {
                            helpEnd = line.endsWith(ConsoleEngineImpl.END_HELP);
                            break;
                        }
                        if (headComment || size < 3) {
                            String ltr = l.trim();
                            if (ltr.startsWith("*") || ltr.startsWith("#")) {
                                headComment = true;
                                line = ltr.length() > 1 ? ltr.substring(2) : "";
                            } else if (ltr.startsWith("/*") || ltr.startsWith("//")) {
                                headComment = true;
                                line = ltr.length() > 2 ? ltr.substring(3) : "";
                            }
                        }
                        usage.append(line).append('\n');
                    }
                    if (usage.length() > 0) {
                        usage.append("\n");
                        if (!helpEnd) {
                            usage.insert(0, "\n");
                        }
                        throw new Options.HelpException(usage.toString());
                    }
                    this.internalExecute();
                }
            } else {
                this.internalExecute();
            }
            return true;
        }

        private String expandParameterName(String parameter) {
            if (parameter.startsWith("$")) {
                return ConsoleEngineImpl.this.expandName(parameter);
            }
            if (ConsoleEngineImpl.this.isNumber(parameter)) {
                return parameter;
            }
            return ConsoleEngineImpl.this.quote(parameter);
        }

        private void internalExecute() throws Exception {
            if (this.isEngineScript()) {
                this.result = ConsoleEngineImpl.this.engine.execute(this.script, ConsoleEngineImpl.this.expandParameters(this.args));
            } else if (this.isConsoleScript()) {
                ConsoleEngineImpl.this.executing = true;
                boolean done = true;
                String line = "";
                try (BufferedReader br = new BufferedReader(new FileReader(this.script));){
                    String l;
                    while ((l = br.readLine()) != null) {
                        if (l.trim().isEmpty() || l.trim().startsWith("#")) {
                            done = true;
                            continue;
                        }
                        try {
                            line = line + l;
                            done = false;
                            ConsoleEngineImpl.this.parser().parse(line, line.length() + 1, Parser.ParseContext.ACCEPT_LINE);
                            done = true;
                            for (int i = 1; i < this.args.length; ++i) {
                                line = line.replaceAll("\\s\\$" + i + "\\b", " " + this.expandParameterName(this.args[i]) + " ");
                                line = line.replaceAll("\\$\\{" + i + "(|:-.*)\\}", this.expandParameterName(this.args[i]));
                            }
                            line = line.replaceAll("\\$\\{@\\}", ConsoleEngineImpl.this.expandToList(this.args));
                            line = line.replaceAll("\\$@", ConsoleEngineImpl.this.expandToList(this.args));
                            line = line.replaceAll("\\s\\$\\d\\b", "");
                            line = line.replaceAll("\\$\\{\\d+\\}", "");
                            Matcher matcher = Pattern.compile("\\$\\{\\d+:-(.*?)\\}").matcher(line);
                            if (matcher.find()) {
                                line = matcher.replaceAll(this.expandParameterName(matcher.group(1)));
                            }
                            if (this.verbose) {
                                AttributedStringBuilder asb = new AttributedStringBuilder();
                                asb.styled(ConsoleEngineImpl.this.prntStyle.resolve(".vs"), (CharSequence)line);
                                asb.toAttributedString().println(ConsoleEngineImpl.this.terminal());
                                ConsoleEngineImpl.this.terminal().flush();
                            }
                            ConsoleEngineImpl.this.println(ConsoleEngineImpl.this.systemRegistry.execute(line));
                            line = "";
                        }
                        catch (EOFError e) {
                            done = false;
                            line = line + "\n";
                        }
                        catch (SyntaxError e) {
                            throw e;
                        }
                        catch (EndOfFileException e) {
                            done = true;
                            this.result = ConsoleEngineImpl.this.engine.get("_return");
                            ConsoleEngineImpl.this.postProcess(this.cmdLine, this.result);
                            break;
                        }
                        catch (Exception e) {
                            ConsoleEngineImpl.this.executing = false;
                            throw new IllegalArgumentException(line + "\n" + e.getMessage());
                        }
                    }
                    if (!done) {
                        ConsoleEngineImpl.this.executing = false;
                        throw new IllegalArgumentException("Incompleted command: \n" + line);
                    }
                    ConsoleEngineImpl.this.executing = false;
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            try {
                sb.append("script:").append(this.script.getCanonicalPath());
            }
            catch (Exception e) {
                sb.append(e.getMessage());
            }
            sb.append(", ");
            sb.append("extension:").append(this.extension);
            sb.append(", ");
            sb.append("cmdLine:").append(this.cmdLine);
            sb.append(", ");
            sb.append("args:").append(Arrays.asList(this.args));
            sb.append(", ");
            sb.append("verbose:").append(this.verbose);
            sb.append(", ");
            sb.append("result:").append(this.result);
            sb.append("]");
            return sb.toString();
        }
    }

    public static enum Command {
        SHOW,
        DEL,
        PRNT,
        ALIAS,
        PIPE,
        UNALIAS,
        DOC,
        SLURP;

    }
}

