/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.tasty;

import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyHeader;
import dotty.tools.tasty.TastyHeaderUnpickler$Compatibility$;
import dotty.tools.tasty.TastyReader;
import dotty.tools.tasty.TastyVersion;
import dotty.tools.tasty.TastyVersion$;
import dotty.tools.tasty.UnpickleException;
import dotty.tools.tasty.UnpicklerConfig;
import dotty.tools.tasty.UnpicklerConfig$;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class TastyHeaderUnpickler {
    private final UnpicklerConfig config;
    private final TastyReader reader;
    private final int toolMajor;
    private final int toolMinor;
    private final int toolExperimental;

    public TastyHeaderUnpickler(UnpicklerConfig config, TastyReader reader) {
        this.config = config;
        this.reader = reader;
        this.toolMajor = config.majorVersion();
        this.toolMinor = config.minorVersion();
        this.toolExperimental = config.experimentalVersion();
    }

    public TastyHeaderUnpickler(UnpicklerConfig config, byte[] bytes) {
        this(config, new TastyReader(bytes));
    }

    public TastyHeaderUnpickler(TastyReader reader) {
        this(UnpicklerConfig$.MODULE$.generic(), reader);
    }

    public TastyHeaderUnpickler(byte[] bytes) {
        this(new TastyReader(bytes));
    }

    public UUID readHeader() {
        return this.readFullHeader().uuid();
    }

    public TastyHeader readFullHeader() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), TastyFormat$.MODULE$.header().length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.check(this.reader.readByte() == TastyFormat$.MODULE$.header()[i], (Function0<String>)((Function0 & Serializable)TastyHeaderUnpickler::readFullHeader$$anonfun$1$$anonfun$1)));
        int fileMajor = this.reader.readNat();
        if (fileMajor <= 27) {
            int fileMinor = this.reader.readNat();
            TastyVersion fileVersion = TastyVersion$.MODULE$.apply(fileMajor, fileMinor, 0);
            TastyVersion toolVersion = TastyVersion$.MODULE$.apply(this.toolMajor, this.toolMinor, this.toolExperimental);
            String signature = this.signatureString(fileVersion, toolVersion, "Backward", (Option<String>)None$.MODULE$);
            String fix = this.recompileFix(toolVersion.minStable());
            throw new UnpickleException(new StringBuilder(0).append(signature).append(fix).append(this.tastyAddendum()).toString());
        }
        int fileMinor = this.reader.readNat();
        int fileExperimental = this.reader.readNat();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyBuffer$Addr$.MODULE$.$plus$extension(start, length);
        this.reader.goto(end);
        String toolingVersion = new String(this.reader.bytes(), start, length);
        boolean validVersion = TastyFormat$.MODULE$.isVersionCompatible(fileMajor, fileMinor, fileExperimental, this.toolMajor, this.toolMinor, this.toolExperimental);
        this.check(validVersion, (Function0<String>)((Function0 & Serializable)() -> this.readFullHeader$$anonfun$2(fileMajor, fileMinor, fileExperimental, toolingVersion)));
        UUID uuid = new UUID(this.reader.readUncompressedLong(), this.reader.readUncompressedLong());
        return new TastyHeader(uuid, fileMajor, fileMinor, fileExperimental, toolingVersion){};
    }

    public boolean isAtEnd() {
        return this.reader.isAtEnd();
    }

    private void check(boolean cond, Function0<String> msg) {
        if (!cond) {
            throw new UnpickleException((String)msg.apply());
        }
    }

    private String signatureString(TastyVersion fileVersion, TastyVersion toolVersion, String what, Option<String> tool) {
        String optProducedBy = (String)tool.fold(TastyHeaderUnpickler::$anonfun$1, (Function1 & Serializable)t -> new StringBuilder(14).append(", produced by ").append((String)t).toString());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(66).append(what).append(" incompatible TASTy file has version ").append(fileVersion.show()).append(optProducedBy).append(",\n      |  expected ").append(toolVersion.validRange()).append(".\n      |").toString()));
    }

    private String recompileFix(TastyVersion producerVersion) {
        String addendum = this.config.recompileAdditionalInfo();
        String newTool = this.config.upgradedProducerTool(producerVersion);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(51).append("  The source of this file should be recompiled by ").append(newTool).append(".").append(addendum).toString()));
    }

    private String upgradeFix(TastyVersion fileVersion) {
        String addendum = this.config.upgradeAdditionalInfo(fileVersion);
        String newTool = this.config.upgradedReaderTool(fileVersion);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(27).append("  To read this ").append(fileVersion.kind()).append(" file, use ").append(newTool).append(".").append(addendum).toString()));
    }

    private String tastyAddendum() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n  |  Please refer to the documentation for information on TASTy versioning:\n  |  https://docs.scala-lang.org/scala3/reference/language-versions/binary-compatibility.html"));
    }

    private static final String readFullHeader$$anonfun$1$$anonfun$1() {
        return "not a TASTy file";
    }

    private final String readFullHeader$$anonfun$2(int fileMajor$1, int fileMinor$1, int fileExperimental$1, String toolingVersion$1) {
        String string;
        TastyVersion toolVersion;
        TastyVersion fileVersion = TastyVersion$.MODULE$.apply(fileMajor$1, fileMinor$1, fileExperimental$1);
        int compat = TastyHeaderUnpickler$Compatibility$.MODULE$.failReason(fileVersion, toolVersion = TastyVersion$.MODULE$.apply(this.toolMajor, this.toolMinor, this.toolExperimental));
        String what = compat < 0 ? "Backward" : "Forward";
        String signature = this.signatureString(fileVersion, toolVersion, what, (Option<String>)Some$.MODULE$.apply((Object)toolingVersion$1));
        if (compat < 0) {
            TastyVersion newCompiler = compat == -3 ? toolVersion.minStable() : (compat == -2 ? fileVersion.nextStable() : toolVersion);
            string = this.recompileFix(newCompiler);
        } else {
            string = this.upgradeFix(fileVersion);
        }
        String fix = string;
        return new StringBuilder(0).append(signature).append(fix).append(this.tastyAddendum()).toString();
    }

    private static final String $anonfun$1() {
        return "";
    }
}

