/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.CompilationUnitInfo;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.SymDenotations;
import dotty.tools.dotc.core.SymbolLoader;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.classfile.ClassfileTastyUUIDParser;
import dotty.tools.dotc.core.tasty.DottyUnpickler;
import dotty.tools.dotc.core.tasty.DottyUnpickler$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.io.AbstractFile;
import dotty.tools.tasty.UnpickleException;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TastyLoader
extends SymbolLoader {
    private final AbstractFile tastyFile;
    private final DottyUnpickler unpickler;
    private final CompilationUnitInfo compilationUnitInfo;

    public TastyLoader(AbstractFile tastyFile) {
        this.tastyFile = tastyFile;
        this.unpickler = (DottyUnpickler)this.handleUnpicklingExceptions(() -> TastyLoader.$init$$$anonfun$1(tastyFile));
        this.compilationUnitInfo = this.unpickler.compilationUnitInfo();
    }

    public AbstractFile tastyFile() {
        return this.tastyFile;
    }

    @Override
    public CompilationUnitInfo compilationUnitInfo() {
        return this.compilationUnitInfo;
    }

    @Override
    public String description(Contexts.Context x$1) {
        return new StringBuilder(11).append("TASTy file ").append(this.tastyFile().toString()).toString();
    }

    @Override
    public void doComplete(SymDenotations.SymDenotation root, Contexts.Context x$2) {
        this.handleUnpicklingExceptions((Function0 & Serializable)() -> {
            this.doComplete$$anonfun$3(x$2, root);
            return BoxedUnit.UNIT;
        });
    }

    private <T> T handleUnpicklingExceptions(Function0<T> thunk) {
        Object object;
        try {
            object = thunk.apply();
        }
        catch (RuntimeException e) {
            String string;
            RuntimeException runtimeException = e;
            if (runtimeException instanceof UnpickleException) {
                UnpickleException e2 = (UnpickleException)runtimeException;
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(60).append("TASTy file ").append(this.tastyFile().canonicalPath()).append(" could not be read, failing with:\n            |  ").append(Option$.MODULE$.apply((Object)e2.getMessage()).getOrElse(TastyLoader::$anonfun$7)).toString()));
            } else {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(60).append("TASTy file ").append(this.tastyFile().canonicalPath()).append(" is broken, reading aborted with ").append(e.getClass()).append("\n            |  ").append(Option$.MODULE$.apply((Object)e.getMessage()).getOrElse(TastyLoader::$anonfun$8)).toString()));
            }
            String message = string;
            throw new IOException(message, e);
        }
        return (T)object;
    }

    private void checkTastyUUID(Contexts.Context x$1) {
        String className = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.tastyFile().name()), ".tasty");
        AbstractFile classfile = this.tastyFile().resolveSibling(new StringBuilder(6).append(className).append(".class").toString());
        if (classfile != null) {
            UUID tastyUUID = this.unpickler.unpickler().header().uuid();
            new ClassfileTastyUUIDParser(classfile, x$1).checkTastyUUID(tastyUUID, x$1);
            return;
        }
        report$.MODULE$.inform((Function0<String>)((Function0 & Serializable)this::checkTastyUUID$$anonfun$1), report$.MODULE$.inform$default$2(), x$1);
    }

    private boolean mayLoadTreesFromTasty(Contexts.Context x$1) {
        return BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().YretainTrees(), x$1)) || BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().fromTasty(), x$1));
    }

    private static final DottyUnpickler $init$$$anonfun$1(AbstractFile tastyFile$1) {
        byte[] tastyBytes = tastyFile$1.toByteArray();
        return new DottyUnpickler(tastyFile$1, tastyBytes, DottyUnpickler$.MODULE$.$lessinit$greater$default$3());
    }

    private final void doComplete$$anonfun$3(Contexts.Context x$2$11, SymDenotations.SymDenotation root$8) {
        this.checkTastyUUID(x$2$11);
        Tuple2<SymDenotations.ClassDenotation, SymDenotations.ClassDenotation> tuple2 = this.rootDenots(root$8.asClass(), x$2$11);
        SymDenotations.ClassDenotation classRoot = (SymDenotations.ClassDenotation)tuple2._1();
        SymDenotations.ClassDenotation moduleRoot = (SymDenotations.ClassDenotation)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)classRoot, (Object)moduleRoot);
        SymDenotations.ClassDenotation classRoot2 = (SymDenotations.ClassDenotation)tuple22._1();
        SymDenotations.ClassDenotation moduleRoot2 = (SymDenotations.ClassDenotation)tuple22._2();
        this.unpickler.enter((Set<SymDenotations.SymDenotation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SymDenotations.SymDenotation[]{classRoot2, moduleRoot2, Symbols$.MODULE$.toDenot(moduleRoot2.sourceModule(x$2$11), x$2$11)}))), x$2$11.withSource(NoSource$.MODULE$));
        if (this.mayLoadTreesFromTasty(x$2$11)) {
            classRoot2.classSymbol().rootTreeOrProvider_$eq(this.unpickler, x$2$11);
            moduleRoot2.classSymbol().rootTreeOrProvider_$eq(this.unpickler, x$2$11);
            return;
        }
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final String $anonfun$8() {
        return "";
    }

    private final String checkTastyUUID$$anonfun$1() {
        return new StringBuilder(49).append("No classfiles found for ").append(this.tastyFile()).append(" when checking TASTy UUID").toString();
    }
}

