/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.util.data.DataHolder;

public class WikiLinkOptions {
    public final boolean allowInlines;
    public final boolean allowAnchors;
    public final boolean disableRendering;
    public final boolean imageLinks;
    public final boolean linkFirstSyntax;
    public final boolean allowAnchorEscape;
    public final boolean allowPipeEscape;
    public final String imageFileExtension;
    public final String imagePrefix;
    public final String imagePrefixAbsolute;
    public final String linkFileExtension;
    public final String linkPrefix;
    public final String linkPrefixAbsolute;
    public final String linkReplaceChars;
    public final String linkEscapeChars;

    public WikiLinkOptions(DataHolder options) {
        this.allowInlines = (Boolean)WikiLinkExtension.ALLOW_INLINES.get(options);
        this.allowAnchors = (Boolean)WikiLinkExtension.ALLOW_ANCHORS.get(options);
        this.disableRendering = (Boolean)WikiLinkExtension.DISABLE_RENDERING.get(options);
        this.imageLinks = (Boolean)WikiLinkExtension.IMAGE_LINKS.get(options);
        this.linkFirstSyntax = (Boolean)WikiLinkExtension.LINK_FIRST_SYNTAX.get(options);
        this.allowAnchorEscape = (Boolean)WikiLinkExtension.ALLOW_ANCHOR_ESCAPE.get(options);
        this.allowPipeEscape = (Boolean)WikiLinkExtension.ALLOW_PIPE_ESCAPE.get(options);
        this.imageFileExtension = (String)WikiLinkExtension.IMAGE_FILE_EXTENSION.get(options);
        this.imagePrefix = (String)WikiLinkExtension.IMAGE_PREFIX.get(options);
        this.imagePrefixAbsolute = (String)WikiLinkExtension.IMAGE_PREFIX_ABSOLUTE.get(options);
        this.linkFileExtension = (String)WikiLinkExtension.LINK_FILE_EXTENSION.get(options);
        this.linkPrefix = (String)WikiLinkExtension.LINK_PREFIX.get(options);
        this.linkPrefixAbsolute = (String)WikiLinkExtension.LINK_PREFIX_ABSOLUTE.get(options);
        this.linkEscapeChars = (String)WikiLinkExtension.LINK_ESCAPE_CHARS.get(options);
        this.linkReplaceChars = (String)WikiLinkExtension.LINK_REPLACE_CHARS.get(options);
    }

    public Object getLinkPrefix(boolean absolute) {
        return absolute ? this.linkPrefixAbsolute : this.linkPrefix;
    }

    public Object getImagePrefix(boolean absolute) {
        return absolute ? this.imagePrefixAbsolute : this.imagePrefix;
    }
}

