/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liqp.TemplateContext;
import liqp.filters.Filter;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class Sort
extends Filter {
    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        if (value == null) {
            return "";
        }
        if (!super.isArray(value)) {
            throw new RuntimeException("cannot sort: " + value);
        }
        Object[] array = super.asArray(value, context);
        String property = params.length == 0 ? null : super.asString(params[0], context);
        List<Comparable> list = this.asComparableList(context, array, property);
        Collections.sort(list);
        return property == null ? list.toArray(new Comparable[list.size()]) : list.toArray(new SortableMap[list.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private List<Comparable> asComparableList(TemplateContext context, Object[] array, String property) {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (Object object : array) {
            void var8_8;
            if (property != null && object instanceof Inspectable) {
                LiquidSupport evaluated = context.renderSettings.evaluate(context.parseSettings.mapper, object);
                Map<String, Object> map = evaluated.toLiquid();
            }
            if (var8_8 instanceof Map && property != null) {
                list.add(new SortableMap((Map)var8_8, property));
                continue;
            }
            list.add((Comparable)var8_8);
        }
        return list;
    }

    static class SortableMap
    extends HashMap<String, Comparable>
    implements Comparable<SortableMap> {
        final String property;

        SortableMap(Map<String, Comparable> map, String property) {
            super.putAll(map);
            this.property = property;
        }

        @Override
        public int compareTo(SortableMap that) {
            Comparable thisValue = (Comparable)this.get(this.property);
            Comparable thatValue = (Comparable)that.get(this.property);
            if (thisValue == null || thatValue == null) {
                throw new RuntimeException("Liquid error: comparison of Hash with Hash failed");
            }
            return thisValue.compareTo(thatValue);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : super.entrySet()) {
                builder.append(entry.getKey()).append(entry.getValue());
            }
            return builder.toString();
        }
    }
}

