/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.sort.ModuleDescriptorSorter;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;

public final class SortEngine {
    private SortEngineSettings settings;

    public SortEngine(SortEngineSettings sortEngineSettings) {
        if (sortEngineSettings == null) {
            throw new NullPointerException("SortEngine.settings can not be null");
        }
        this.settings = sortEngineSettings;
    }

    public final List sortNodes(Collection collection, SortOptions sortOptions) {
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> linkedHashMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        Object object = collection.iterator();
        while (object.hasNext()) {
            IvyNode ivyNode = (IvyNode)object.next();
            if (ivyNode.getDescriptor() == null) {
                arrayList.add(ivyNode);
                continue;
            }
            ArrayList<IvyNode> arrayList2 = (ArrayList<IvyNode>)linkedHashMap.get(ivyNode.getDescriptor());
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<IvyNode>();
                linkedHashMap.put(ivyNode.getDescriptor(), arrayList2);
            }
            arrayList2.add(ivyNode);
        }
        SortOptions sortOptions2 = sortOptions;
        Set set = linkedHashMap.keySet();
        SortEngine sortEngine = this;
        LogOptions.checkNotNull(sortOptions2, "options");
        object = new ModuleDescriptorSorter(set, sortEngine.settings.getVersionMatcher(), sortOptions2.getNonMatchingVersionReporter(), sortOptions2.isUseCircularDependencyStrategy() ? sortEngine.settings.getCircularDependencyStrategy() : IgnoreCircularDependencyStrategy.getInstance()).sortModuleDescriptors();
        ArrayList<IvyNode> arrayList3 = new ArrayList<IvyNode>((int)((double)object.size() * 1.3 + (double)arrayList.size()));
        for (int i = 0; i < object.size(); ++i) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object.get(i);
            List list = (List)linkedHashMap.get(moduleDescriptor);
            arrayList3.addAll(list);
        }
        arrayList3.addAll(0, arrayList);
        return arrayList3;
    }
}

