/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Chmod
extends ExecuteOn {
    private FileSet defaultSet = new FileSet();
    private boolean havePerm = false;

    public Chmod() {
        super.setExecutable("chmod");
        super.setParallel(true);
    }

    public void setFile(File file) {
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(file.getParent()));
        fileSet.createInclude().setName(file.getName());
        this.addFileset(fileSet);
    }

    public void setDir(File file) {
        this.defaultSet.setDir(file);
    }

    public void setPerm(String string) {
        this.createArg().setValue(string);
        this.havePerm = true;
    }

    public PatternSet.NameEntry createInclude() {
        return this.defaultSet.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        return this.defaultSet.createExclude();
    }

    public PatternSet createPatternSet() {
        return this.defaultSet.createPatternSet();
    }

    public void setIncludes(String string) {
        this.defaultSet.setIncludes(string);
    }

    public void setExcludes(String string) {
        this.defaultSet.setExcludes(string);
    }

    public void setDefaultexcludes(boolean bl) {
        this.defaultSet.setDefaultexcludes(bl);
    }

    protected void checkConfiguration() {
        if (!this.havePerm) {
            throw new BuildException("Required attribute perm not set in chmod", this.location);
        }
        if (this.defaultSet.getDir(this.project) != null) {
            this.addFileset(this.defaultSet);
        }
        super.checkConfiguration();
    }

    public void setExecutable(String string) {
        throw new BuildException(this.taskType + " doesn't support the executable attribute", this.location);
    }

    public void setCommand(String string) {
        throw new BuildException(this.taskType + " doesn't support the command attribute", this.location);
    }

    protected boolean isValidOs() {
        return System.getProperty("path.separator").equals(":") && (!System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").endsWith("X")) && super.isValidOs();
    }
}

