/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.optional.ide.VAJAntTool;
import org.apache.tools.ant.taskdefs.optional.ide.VAJBuildInfo;

public class VAJAntToolGUI
extends Frame {
    private VAJBuildLogger logger = new VAJBuildLogger();
    private String lineSeparator = "\r\n";
    private PrivateEventHandler iEventHandler = new PrivateEventHandler();
    private VAJBuildInfo iBuildInfo = null;
    private MenuBar iAntMakeMenuBar = null;
    private Menu iFileMenu = null;
    private MenuItem iSaveMenuItem = null;
    private MenuItem iMenuSeparator = null;
    private MenuItem iShowLogMenuItem = null;
    private Menu iHelpMenu = null;
    private MenuItem iAboutMenuItem = null;
    private Panel iContentsPane = null;
    private Panel iOptionenPanel = null;
    private Panel iCommandButtonPanel = null;
    private FlowLayout iCommandButtonPanelFlowLayout = null;
    private Label iProjectLabel = null;
    private Label iProjectText = null;
    private Label iBuildFileLabel = null;
    private TextField iBuildFileTextField = null;
    private boolean iConnPtoP2Aligning = false;
    private Button iBrowseButton = null;
    private FileDialog iFileDialog = null;
    private Choice iMessageOutputLevelChoice = null;
    private Label iMessageOutputLevelLabel = null;
    private Label iTargetLabel = null;
    private List iTargetList = null;
    private Button iBuildButton = null;
    private Button iReloadButton = null;
    private Button iCloseButton = null;
    private Frame iMessageFrame = null;
    private Panel iMessageCommandPanel = null;
    private Panel iMessageContentPanel = null;
    private TextArea iMessageTextArea = null;
    private Button iMessageOkButton = null;
    private Button iMessageClearLogButton = null;
    private Dialog iAboutDialog = null;
    private Panel iAboutDialogContentPanel = null;
    private Panel iAboutInfoPanel = null;
    private Panel iAboutCommandPanel = null;
    private Label iAboutTitleLabel = null;
    private Label iAboutDevLabel = null;
    private Label iAboutContactLabel = null;
    private Button iAboutOkButton = null;

    private VAJAntToolGUI() {
        this.initialize();
    }

    public VAJAntToolGUI(VAJBuildInfo vAJBuildInfo) {
        this.setBuildInfo(vAJBuildInfo);
        this.initialize();
    }

    public static void centerDialog(Dialog dialog) {
        ((Component)dialog).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getSize().height / 2);
    }

    private void connectBuildFileNameToTextField() {
        try {
            if (!this.iConnPtoP2Aligning) {
                this.iConnPtoP2Aligning = true;
                if (this.getBuildInfo() != null) {
                    this.getBuildFileTextField().setText(this.getBuildInfo().getBuildFileName());
                }
                this.iConnPtoP2Aligning = false;
            }
        }
        catch (Throwable throwable) {
            this.iConnPtoP2Aligning = false;
            this.handleException(throwable);
        }
    }

    private void connectProjectNameToLabel() {
        try {
            if (this.getBuildInfo() != null) {
                this.getProjectText().setText(this.getBuildInfo().getVAJProjectName());
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connectTextFieldToBuildFileName() {
        try {
            if (!this.iConnPtoP2Aligning) {
                this.iConnPtoP2Aligning = true;
                if (this.getBuildInfo() != null) {
                    this.getBuildInfo().setBuildFileName(this.getBuildFileTextField().getText());
                }
                this.iConnPtoP2Aligning = false;
            }
        }
        catch (Throwable throwable) {
            this.iConnPtoP2Aligning = false;
            this.handleException(throwable);
        }
    }

    private void executeTarget() {
        try {
            this.getMessageFrame().show();
            this.logger.buildStarted(null);
            this.getBuildInfo().executeProject(this.logger);
            this.logger.buildSuccessful();
        }
        catch (Throwable throwable) {
            this.logger.buildFailed(throwable);
        }
    }

    private void fillList() {
        this.getTargetList().removeAll();
        Vector vector = this.getBuildInfo().getProjectTargets();
        int n = 0;
        while (n < vector.size()) {
            this.getTargetList().add(vector.elementAt(n).toString());
            ++n;
        }
        this.getTargetList().select(this.iBuildInfo.getProjectTargets().indexOf(this.iBuildInfo.getTarget()));
        if (this.getTargetList().getSelectedIndex() >= 0) {
            this.getBuildButton().setEnabled(true);
        }
    }

    public static String formatTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        if (l3 > 0L) {
            return String.valueOf(Long.toString(l3)) + " minute" + (l3 == 1L ? " " : "s ") + Long.toString(l2 % 60L) + " second" + (l2 % 60L == 1L ? "" : "s");
        }
        return String.valueOf(Long.toString(l2)) + " second" + (l2 % 60L == 1L ? "" : "s");
    }

    private Panel getAboutCommandPanel() {
        block2: {
            if (this.iAboutCommandPanel != null) break block2;
            try {
                this.iAboutCommandPanel = new Panel();
                this.iAboutCommandPanel.setName("AboutCommandPanel");
                this.iAboutCommandPanel.setLayout(new FlowLayout());
                this.getAboutCommandPanel().add((Component)this.getAboutOkButton(), this.getAboutOkButton().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutCommandPanel;
    }

    private Label getAboutContactLabel() {
        block2: {
            if (this.iAboutContactLabel != null) break block2;
            try {
                this.iAboutContactLabel = new Label();
                this.iAboutContactLabel.setName("AboutContactLabel");
                this.iAboutContactLabel.setAlignment(1);
                this.iAboutContactLabel.setText("contact: wolf.siberski@tui.de or christoph.wilhelms@tui.de");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutContactLabel;
    }

    private Label getAboutDevLabel() {
        block2: {
            if (this.iAboutDevLabel != null) break block2;
            try {
                this.iAboutDevLabel = new Label();
                this.iAboutDevLabel.setName("AboutDevLabel");
                this.iAboutDevLabel.setAlignment(1);
                this.iAboutDevLabel.setText("developed by Wolf Siberski & Christoph Wilhelms");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutDevLabel;
    }

    private Dialog getAboutDialog() {
        block2: {
            if (this.iAboutDialog != null) break block2;
            try {
                this.iAboutDialog = new Dialog(this);
                this.iAboutDialog.setName("AboutDialog");
                this.iAboutDialog.setResizable(false);
                this.iAboutDialog.setLayout(new BorderLayout());
                ((Component)this.iAboutDialog).setBounds(550, 14, 383, 142);
                this.iAboutDialog.setModal(true);
                this.iAboutDialog.setTitle("About...");
                this.getAboutDialog().add((Component)this.getAboutDialogContentPanel(), "Center");
                this.iAboutDialog.pack();
                VAJAntToolGUI.centerDialog(this.iAboutDialog);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutDialog;
    }

    private Panel getAboutDialogContentPanel() {
        block2: {
            if (this.iAboutDialogContentPanel != null) break block2;
            try {
                this.iAboutDialogContentPanel = new Panel();
                this.iAboutDialogContentPanel.setName("AboutDialogContentPanel");
                this.iAboutDialogContentPanel.setLayout(new BorderLayout());
                this.getAboutDialogContentPanel().add((Component)this.getAboutCommandPanel(), "South");
                this.getAboutDialogContentPanel().add((Component)this.getAboutInfoPanel(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutDialogContentPanel;
    }

    private Panel getAboutInfoPanel() {
        block2: {
            if (this.iAboutInfoPanel != null) break block2;
            try {
                this.iAboutInfoPanel = new Panel();
                this.iAboutInfoPanel.setName("AboutInfoPanel");
                this.iAboutInfoPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(4, 0, 4, 0);
                this.getAboutInfoPanel().add((Component)this.getAboutTitleLabel(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 1;
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.insets = new Insets(4, 0, 0, 0);
                this.getAboutInfoPanel().add((Component)this.getAboutDevLabel(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 0;
                gridBagConstraints3.gridy = 2;
                gridBagConstraints3.fill = 2;
                gridBagConstraints3.weightx = 1.0;
                gridBagConstraints3.insets = new Insets(2, 0, 4, 0);
                this.getAboutInfoPanel().add((Component)this.getAboutContactLabel(), gridBagConstraints3);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutInfoPanel;
    }

    private MenuItem getAboutMenuItem() {
        block2: {
            if (this.iAboutMenuItem != null) break block2;
            try {
                this.iAboutMenuItem = new MenuItem();
                this.iAboutMenuItem.setLabel("About...");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutMenuItem;
    }

    private Button getAboutOkButton() {
        block2: {
            if (this.iAboutOkButton != null) break block2;
            try {
                this.iAboutOkButton = new Button();
                this.iAboutOkButton.setName("AboutOkButton");
                this.iAboutOkButton.setLabel("OK");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutOkButton;
    }

    private Label getAboutTitleLabel() {
        block2: {
            if (this.iAboutTitleLabel != null) break block2;
            try {
                this.iAboutTitleLabel = new Label();
                this.iAboutTitleLabel.setName("AboutTitleLabel");
                this.iAboutTitleLabel.setFont(new Font("Arial", 1, 12));
                this.iAboutTitleLabel.setAlignment(1);
                this.iAboutTitleLabel.setText("Ant VisualAge for Java Tool-Integration");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAboutTitleLabel;
    }

    private MenuBar getAntMakeMenuBar() {
        block2: {
            if (this.iAntMakeMenuBar != null) break block2;
            try {
                this.iAntMakeMenuBar = new MenuBar();
                this.iAntMakeMenuBar.add(this.getFileMenu());
                this.iAntMakeMenuBar.add(this.getHelpMenu());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iAntMakeMenuBar;
    }

    private Button getBrowseButton() {
        block2: {
            if (this.iBrowseButton != null) break block2;
            try {
                this.iBrowseButton = new Button();
                this.iBrowseButton.setName("BrowseButton");
                this.iBrowseButton.setLabel("...");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iBrowseButton;
    }

    private Button getBuildButton() {
        block2: {
            if (this.iBuildButton != null) break block2;
            try {
                this.iBuildButton = new Button();
                this.iBuildButton.setName("BuildButton");
                this.iBuildButton.setLabel("Build");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iBuildButton;
    }

    private Label getBuildFileLabel() {
        block2: {
            if (this.iBuildFileLabel != null) break block2;
            try {
                this.iBuildFileLabel = new Label();
                this.iBuildFileLabel.setName("BuildFileLabel");
                this.iBuildFileLabel.setText("Ant-Buildfile:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iBuildFileLabel;
    }

    private TextField getBuildFileTextField() {
        block2: {
            if (this.iBuildFileTextField != null) break block2;
            try {
                this.iBuildFileTextField = new TextField();
                this.iBuildFileTextField.setName("BuildFileTextField");
                ((Component)this.iBuildFileTextField).setBackground(SystemColor.textHighlightText);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iBuildFileTextField;
    }

    private VAJBuildInfo getBuildInfo() {
        return this.iBuildInfo;
    }

    private Button getCloseButton() {
        block2: {
            if (this.iCloseButton != null) break block2;
            try {
                this.iCloseButton = new Button();
                this.iCloseButton.setName("CloseButton");
                this.iCloseButton.setLabel("Close");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iCloseButton;
    }

    private Panel getCommandButtonPanel() {
        block2: {
            if (this.iCommandButtonPanel != null) break block2;
            try {
                this.iCommandButtonPanel = new Panel();
                this.iCommandButtonPanel.setName("CommandButtonPanel");
                this.iCommandButtonPanel.setLayout(this.getCommandButtonPanelFlowLayout());
                this.iCommandButtonPanel.setBackground(SystemColor.control);
                this.iCommandButtonPanel.add(this.getReloadButton());
                this.getCommandButtonPanel().add((Component)this.getBuildButton(), this.getBuildButton().getName());
                this.getCommandButtonPanel().add((Component)this.getCloseButton(), this.getCloseButton().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iCommandButtonPanel;
    }

    private FlowLayout getCommandButtonPanelFlowLayout() {
        FlowLayout flowLayout = null;
        try {
            flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return flowLayout;
    }

    private Panel getContentsPane() {
        block2: {
            if (this.iContentsPane != null) break block2;
            try {
                this.iContentsPane = new Panel();
                this.iContentsPane.setName("ContentsPane");
                this.iContentsPane.setLayout(new BorderLayout());
                this.getContentsPane().add((Component)this.getCommandButtonPanel(), "South");
                this.getContentsPane().add((Component)this.getOptionenPanel(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iContentsPane;
    }

    private FileDialog getFileDialog() {
        block2: {
            if (this.iFileDialog != null) break block2;
            try {
                this.iFileDialog = new FileDialog(this);
                this.iFileDialog.setName("FileDialog");
                this.iFileDialog.setLayout(null);
                VAJAntToolGUI.centerDialog(this.iFileDialog);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iFileDialog;
    }

    private Menu getFileMenu() {
        block2: {
            if (this.iFileMenu != null) break block2;
            try {
                this.iFileMenu = new Menu();
                this.iFileMenu.setLabel("File");
                this.iFileMenu.add(this.getSaveMenuItem());
                this.iFileMenu.add(this.getMenuSeparator());
                this.iFileMenu.add(this.getShowLogMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iFileMenu;
    }

    private Menu getHelpMenu() {
        block2: {
            if (this.iHelpMenu != null) break block2;
            try {
                this.iHelpMenu = new Menu();
                this.iHelpMenu.setLabel("Help");
                this.iHelpMenu.add(this.getAboutMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iHelpMenu;
    }

    private MenuItem getMenuSeparator() {
        block2: {
            if (this.iMenuSeparator != null) break block2;
            try {
                this.iMenuSeparator = new MenuItem();
                this.iMenuSeparator.setLabel("-");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMenuSeparator;
    }

    private Button getMessageClearLogButton() {
        block2: {
            if (this.iMessageClearLogButton != null) break block2;
            try {
                this.iMessageClearLogButton = new Button();
                this.iMessageClearLogButton.setName("MessageClearLogButton");
                this.iMessageClearLogButton.setLabel("Clear Log");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageClearLogButton;
    }

    private Panel getMessageCommandPanel() {
        block2: {
            if (this.iMessageCommandPanel != null) break block2;
            try {
                this.iMessageCommandPanel = new Panel();
                this.iMessageCommandPanel.setName("MessageCommandPanel");
                this.iMessageCommandPanel.setLayout(new FlowLayout());
                this.getMessageCommandPanel().add((Component)this.getMessageClearLogButton(), this.getMessageClearLogButton().getName());
                this.getMessageCommandPanel().add((Component)this.getMessageOkButton(), this.getMessageOkButton().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageCommandPanel;
    }

    private Panel getMessageContentPanel() {
        block2: {
            if (this.iMessageContentPanel != null) break block2;
            try {
                this.iMessageContentPanel = new Panel();
                this.iMessageContentPanel.setName("MessageContentPanel");
                this.iMessageContentPanel.setLayout(new BorderLayout());
                this.iMessageContentPanel.setBackground(SystemColor.control);
                this.getMessageContentPanel().add((Component)this.getMessageTextArea(), "Center");
                this.getMessageContentPanel().add((Component)this.getMessageCommandPanel(), "South");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageContentPanel;
    }

    private Frame getMessageFrame() {
        block2: {
            if (this.iMessageFrame != null) break block2;
            try {
                this.iMessageFrame = new Frame();
                this.iMessageFrame.setName("MessageFrame");
                this.iMessageFrame.setLayout(new BorderLayout());
                ((Component)this.iMessageFrame).setBounds(0, 0, 750, 250);
                this.iMessageFrame.setTitle("Message Log");
                this.iMessageFrame.add((Component)this.getMessageContentPanel(), "Center");
                ((Component)this.iMessageFrame).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.iMessageFrame.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageFrame;
    }

    private Button getMessageOkButton() {
        block2: {
            if (this.iMessageOkButton != null) break block2;
            try {
                this.iMessageOkButton = new Button();
                this.iMessageOkButton.setName("MessageOkButton");
                this.iMessageOkButton.setLabel("Close");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageOkButton;
    }

    private Choice getMessageOutputLevelChoice() {
        block2: {
            if (this.iMessageOutputLevelChoice != null) break block2;
            try {
                this.iMessageOutputLevelChoice = new Choice();
                this.iMessageOutputLevelChoice.setName("MessageOutputLevelChoice");
                this.iMessageOutputLevelChoice.add("Error");
                this.iMessageOutputLevelChoice.add("Warning");
                this.iMessageOutputLevelChoice.add("Info");
                this.iMessageOutputLevelChoice.add("Verbose");
                this.iMessageOutputLevelChoice.add("Debug");
                this.iMessageOutputLevelChoice.select(2);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageOutputLevelChoice;
    }

    private Label getMessageOutputLevelLabel() {
        block2: {
            if (this.iMessageOutputLevelLabel != null) break block2;
            try {
                this.iMessageOutputLevelLabel = new Label();
                this.iMessageOutputLevelLabel.setName("MessageOutputLevelLabel");
                this.iMessageOutputLevelLabel.setText("Message Level:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageOutputLevelLabel;
    }

    private TextArea getMessageTextArea() {
        block2: {
            if (this.iMessageTextArea != null) break block2;
            try {
                this.iMessageTextArea = new TextArea();
                this.iMessageTextArea.setName("MessageTextArea");
                this.iMessageTextArea.setFont(new Font("monospaced", 0, 12));
                this.iMessageTextArea.setText("");
                this.iMessageTextArea.setEditable(false);
                this.iMessageTextArea.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iMessageTextArea;
    }

    private Panel getOptionenPanel() {
        block2: {
            if (this.iOptionenPanel != null) break block2;
            try {
                this.iOptionenPanel = new Panel();
                this.iOptionenPanel.setName("OptionenPanel");
                this.iOptionenPanel.setLayout(new GridBagLayout());
                this.iOptionenPanel.setBackground(SystemColor.control);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getProjectLabel(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 1;
                gridBagConstraints2.anchor = 17;
                gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getBuildFileLabel(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 0;
                gridBagConstraints3.gridy = 2;
                gridBagConstraints3.anchor = 18;
                gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getTargetLabel(), gridBagConstraints3);
                GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
                gridBagConstraints4.gridx = 1;
                gridBagConstraints4.gridy = 0;
                gridBagConstraints4.gridwidth = 2;
                gridBagConstraints4.fill = 2;
                gridBagConstraints4.anchor = 17;
                gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getProjectText(), gridBagConstraints4);
                GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
                gridBagConstraints5.gridx = 1;
                gridBagConstraints5.gridy = 1;
                gridBagConstraints5.fill = 2;
                gridBagConstraints5.anchor = 17;
                gridBagConstraints5.weightx = 1.0;
                gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getBuildFileTextField(), gridBagConstraints5);
                GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
                gridBagConstraints6.gridx = 2;
                gridBagConstraints6.gridy = 1;
                gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getBrowseButton(), gridBagConstraints6);
                GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
                gridBagConstraints7.gridx = 1;
                gridBagConstraints7.gridy = 2;
                gridBagConstraints7.gridheight = 2;
                gridBagConstraints7.fill = 1;
                gridBagConstraints7.weightx = 1.0;
                gridBagConstraints7.weighty = 1.0;
                gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getTargetList(), gridBagConstraints7);
                GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
                gridBagConstraints8.gridx = 0;
                gridBagConstraints8.gridy = 4;
                gridBagConstraints8.anchor = 17;
                gridBagConstraints8.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getMessageOutputLevelLabel(), gridBagConstraints8);
                GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
                gridBagConstraints9.gridx = 1;
                gridBagConstraints9.gridy = 4;
                gridBagConstraints9.fill = 2;
                gridBagConstraints9.anchor = 17;
                gridBagConstraints9.weightx = 1.0;
                gridBagConstraints9.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getMessageOutputLevelChoice(), gridBagConstraints9);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iOptionenPanel;
    }

    private Label getProjectLabel() {
        block2: {
            if (this.iProjectLabel != null) break block2;
            try {
                this.iProjectLabel = new Label();
                this.iProjectLabel.setName("ProjectLabel");
                this.iProjectLabel.setText("Projectname:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iProjectLabel;
    }

    private Label getProjectText() {
        block2: {
            if (this.iProjectText != null) break block2;
            try {
                this.iProjectText = new Label();
                this.iProjectText.setName("ProjectText");
                this.iProjectText.setText(" ");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iProjectText;
    }

    private Button getReloadButton() {
        block2: {
            if (this.iReloadButton != null) break block2;
            try {
                this.iReloadButton = new Button();
                this.iReloadButton.setName("ReloadButton");
                this.iReloadButton.setLabel("(Re)Load");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iReloadButton;
    }

    private MenuItem getSaveMenuItem() {
        block2: {
            if (this.iSaveMenuItem != null) break block2;
            try {
                this.iSaveMenuItem = new MenuItem();
                this.iSaveMenuItem.setLabel("Save BuildInfo To Repository");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iSaveMenuItem;
    }

    private MenuItem getShowLogMenuItem() {
        block2: {
            if (this.iShowLogMenuItem != null) break block2;
            try {
                this.iShowLogMenuItem = new MenuItem();
                this.iShowLogMenuItem.setLabel("Log");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iShowLogMenuItem;
    }

    private Label getTargetLabel() {
        block2: {
            if (this.iTargetLabel != null) break block2;
            try {
                this.iTargetLabel = new Label();
                this.iTargetLabel.setName("TargetLabel");
                this.iTargetLabel.setText("Target:");
                this.iTargetLabel.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iTargetLabel;
    }

    private List getTargetList() {
        block2: {
            if (this.iTargetList != null) break block2;
            try {
                this.iTargetList = new List();
                this.iTargetList.setName("TargetList");
                this.iTargetList.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.iTargetList;
    }

    private void handleException(Throwable throwable) {
        this.getMessageTextArea().append(String.valueOf(this.lineSeparator) + this.lineSeparator + throwable.getMessage());
        this.getMessageFrame().show();
    }

    private void initConnections() throws Exception {
        this.addWindowListener(this.iEventHandler);
        this.getBrowseButton().addActionListener(this.iEventHandler);
        this.getCloseButton().addActionListener(this.iEventHandler);
        this.getBuildButton().addActionListener(this.iEventHandler);
        this.getSaveMenuItem().addActionListener(this.iEventHandler);
        this.getAboutOkButton().addActionListener(this.iEventHandler);
        this.getAboutMenuItem().addActionListener(this.iEventHandler);
        this.getMessageOkButton().addActionListener(this.iEventHandler);
        this.getMessageClearLogButton().addActionListener(this.iEventHandler);
        this.getMessageOkButton().addActionListener(this.iEventHandler);
        this.getShowLogMenuItem().addActionListener(this.iEventHandler);
        this.getAboutDialog().addWindowListener(this.iEventHandler);
        this.getMessageFrame().addWindowListener(this.iEventHandler);
        this.getReloadButton().addActionListener(this.iEventHandler);
        this.getTargetList().addItemListener(this.iEventHandler);
        this.getMessageOutputLevelChoice().addItemListener(this.iEventHandler);
        this.getBuildFileTextField().addTextListener(this.iEventHandler);
        this.connectProjectNameToLabel();
        this.connectBuildFileNameToTextField();
    }

    private void initialize() {
        try {
            this.setName("AntMake");
            this.setMenuBar(this.getAntMakeMenuBar());
            this.setLayout(new BorderLayout());
            ((Component)this).setSize(389, 222);
            this.setTitle("Ant VisualAge for Java Tool-Integration");
            this.add((Component)this.getContentsPane(), "Center");
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        ((Component)this).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getSize().height);
        if (this.getTargetList().getItemCount() == 0 || this.getTargetList().getSelectedIndex() < 0) {
            this.getBuildButton().setEnabled(false);
        }
    }

    private void saveBuildInfo() {
        try {
            VAJAntTool.saveBuildData(this.getBuildInfo());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void setBuildInfo(VAJBuildInfo vAJBuildInfo) {
        block5: {
            if (this.iBuildInfo == vAJBuildInfo) break block5;
            try {
                if (this.iBuildInfo != null) {
                    this.iBuildInfo.removePropertyChangeListener(this.iEventHandler);
                }
                this.iBuildInfo = vAJBuildInfo;
                if (this.iBuildInfo != null) {
                    this.iBuildInfo.addPropertyChangeListener(this.iEventHandler);
                }
                this.connectProjectNameToLabel();
                this.connectBuildFileNameToTextField();
                this.getMessageOutputLevelChoice().select(this.iBuildInfo.getOutputMessageLevel());
                this.fillList();
                if (this.iBuildInfo.getVAJProjectName() == null || this.iBuildInfo.getVAJProjectName().equals("")) {
                    this.getSaveMenuItem().setEnabled(false);
                }
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    private class VAJBuildLogger
    implements BuildListener {
        private long startTime = System.currentTimeMillis();

        public void buildFailed(Throwable throwable) {
            VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "BUILD FAILED" + VAJAntToolGUI.this.lineSeparator);
            if (throwable instanceof BuildException) {
                VAJAntToolGUI.this.getMessageTextArea().append(throwable.toString());
                Throwable throwable2 = ((BuildException)throwable).getException();
                if (throwable2 != null) {
                    throwable2.printStackTrace(System.err);
                }
            } else {
                throwable.printStackTrace(System.err);
            }
            VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "Total time: " + VAJAntToolGUI.formatTime(System.currentTimeMillis() - this.startTime));
        }

        public void buildFinished(BuildEvent buildEvent) {
            Throwable throwable = buildEvent.getException();
            if (throwable == null) {
                VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "BUILD SUCCESSFUL");
            } else {
                VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "BUILD FAILED" + VAJAntToolGUI.this.lineSeparator);
                if (throwable instanceof BuildException) {
                    VAJAntToolGUI.this.getMessageTextArea().append(throwable.toString());
                    Throwable throwable2 = ((BuildException)throwable).getException();
                    if (throwable2 != null) {
                        throwable2.printStackTrace(System.err);
                    }
                } else {
                    throwable.printStackTrace(System.err);
                }
            }
            VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "Total time: " + VAJAntToolGUI.formatTime(System.currentTimeMillis() - this.startTime));
        }

        public void buildStarted(BuildEvent buildEvent) {
            this.startTime = System.currentTimeMillis();
            VAJAntToolGUI.this.getMessageTextArea().append(VAJAntToolGUI.this.lineSeparator);
        }

        public void buildSuccessful() {
            VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "BUILD SUCCESSFUL");
            VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + "Total time: " + VAJAntToolGUI.formatTime(System.currentTimeMillis() - this.startTime));
        }

        public void messageLogged(BuildEvent buildEvent) {
            if (buildEvent.getPriority() <= VAJAntToolGUI.this.getBuildInfo().getOutputMessageLevel()) {
                String string = "";
                if (buildEvent.getTask() != null) {
                    string = "[" + buildEvent.getTask().getTaskName() + "] ";
                }
                VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + string + buildEvent.getMessage());
            }
        }

        public void targetFinished(BuildEvent buildEvent) {
        }

        public void targetStarted(BuildEvent buildEvent) {
            if (VAJAntToolGUI.this.getBuildInfo().getOutputMessageLevel() <= 2) {
                VAJAntToolGUI.this.getMessageTextArea().append(String.valueOf(VAJAntToolGUI.this.lineSeparator) + buildEvent.getTarget().getName() + ":");
            }
        }

        public void taskFinished(BuildEvent buildEvent) {
        }

        public void taskStarted(BuildEvent buildEvent) {
        }
    }

    private class PrivateEventHandler
    implements ActionListener,
    ItemListener,
    TextListener,
    WindowListener,
    PropertyChangeListener {
        PrivateEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == VAJAntToolGUI.this.getBrowseButton()) {
                    VAJAntToolGUI.this.getFileDialog().setDirectory(VAJAntToolGUI.this.getBuildFileTextField().getText().substring(0, VAJAntToolGUI.this.getBuildFileTextField().getText().lastIndexOf(92) + 1));
                    VAJAntToolGUI.this.getFileDialog().setFile("*.xml");
                    VAJAntToolGUI.this.getFileDialog().show();
                    if (!VAJAntToolGUI.this.getFileDialog().getFile().equals("")) {
                        VAJAntToolGUI.this.getBuildFileTextField().setText(String.valueOf(VAJAntToolGUI.this.getFileDialog().getDirectory()) + VAJAntToolGUI.this.getFileDialog().getFile());
                    }
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getCloseButton()) {
                    VAJAntToolGUI.this.dispose();
                    System.exit(0);
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getBuildButton()) {
                    VAJAntToolGUI.this.executeTarget();
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getReloadButton()) {
                    try {
                        VAJAntToolGUI.this.getBuildInfo().updateTargetList();
                        VAJAntToolGUI.this.fillList();
                    }
                    catch (Throwable throwable) {
                        VAJAntToolGUI.this.handleException(throwable);
                        VAJAntToolGUI.this.getTargetList().removeAll();
                        VAJAntToolGUI.this.getBuildButton().setEnabled(false);
                    }
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getSaveMenuItem()) {
                    VAJAntToolGUI.this.saveBuildInfo();
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getAboutMenuItem()) {
                    VAJAntToolGUI.this.getAboutDialog().show();
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getShowLogMenuItem()) {
                    VAJAntToolGUI.this.getMessageFrame().show();
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getAboutOkButton()) {
                    VAJAntToolGUI.this.getAboutDialog().dispose();
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getMessageOkButton()) {
                    VAJAntToolGUI.this.getMessageFrame().dispose();
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getMessageClearLogButton()) {
                    VAJAntToolGUI.this.getMessageTextArea().setText("");
                }
                if (actionEvent.getSource() == VAJAntToolGUI.this.getMessageOkButton()) {
                    VAJAntToolGUI.this.getMessageFrame().dispose();
                }
            }
            catch (Throwable throwable) {
                VAJAntToolGUI.this.handleException(throwable);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                if (itemEvent.getSource() == VAJAntToolGUI.this.getTargetList()) {
                    VAJAntToolGUI.this.getBuildButton().setEnabled(true);
                }
                if (itemEvent.getSource() == VAJAntToolGUI.this.getMessageOutputLevelChoice()) {
                    VAJAntToolGUI.this.getBuildInfo().setOutputMessageLevel(VAJAntToolGUI.this.getMessageOutputLevelChoice().getSelectedIndex());
                }
                if (itemEvent.getSource() == VAJAntToolGUI.this.getTargetList()) {
                    VAJAntToolGUI.this.getBuildInfo().setTarget(VAJAntToolGUI.this.getTargetList().getSelectedItem());
                }
            }
            catch (Throwable throwable) {
                VAJAntToolGUI.this.handleException(throwable);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == VAJAntToolGUI.this.getBuildInfo() && propertyChangeEvent.getPropertyName().equals("projectName")) {
                VAJAntToolGUI.this.connectProjectNameToLabel();
            }
            if (propertyChangeEvent.getSource() == VAJAntToolGUI.this.getBuildInfo() && propertyChangeEvent.getPropertyName().equals("buildFileName")) {
                VAJAntToolGUI.this.connectBuildFileNameToTextField();
            }
        }

        public void textValueChanged(TextEvent textEvent) {
            if (textEvent.getSource() == VAJAntToolGUI.this.getBuildFileTextField()) {
                VAJAntToolGUI.this.connectTextFieldToBuildFileName();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            try {
                if (windowEvent.getSource() == VAJAntToolGUI.this) {
                    VAJAntToolGUI.this.dispose();
                    System.exit(0);
                }
                if (windowEvent.getSource() == VAJAntToolGUI.this.getAboutDialog()) {
                    VAJAntToolGUI.this.getAboutDialog().dispose();
                }
                if (windowEvent.getSource() == VAJAntToolGUI.this.getMessageFrame()) {
                    VAJAntToolGUI.this.getMessageFrame().dispose();
                }
            }
            catch (Throwable throwable) {
                VAJAntToolGUI.this.handleException(throwable);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

