#ifndef SANCP_H
#include "sancp.h"
#endif
/**************************************************************************
 * *SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/


/******************/
/*    retroactive */
//  
//  traverses all active connections modifying 
//  acl settings as applicable
//
/****************/

void retroactive( struct acl *myacl) {
        extern struct gvars gVars;
 	struct cnx *tc;	
	int t;
	char *ftmp=0;
	for( t = 0; t < HASH_KEYS; t++) {
		tc = gVars.cnx_head[t];
		while(tc) {
			if ( ( tc->h_proto<=myacl->h_proto_h) && ( tc->h_proto>=myacl->h_proto_l )
			&& ( ( tc->proto<=myacl->proto_h) && ( tc->proto>=myacl->proto_l ) 
			&& ( ( ( ntohs(tc->s_port)<=myacl->s_port_h ) && ( ntohs(tc->s_port)>=myacl->s_port_l )  
			&& ( ( tc->s_ip & (myacl->s_ip&myacl->s_mask) ) ^ (myacl->s_ip&myacl->s_mask) )==0 ) )
		    	&& ( ( ntohs(tc->d_port)<=myacl->d_port_h ) && ( ntohs(tc->d_port)>=myacl->d_port_l )
		 	&& ( ( ( tc->d_ip & (myacl->d_ip&myacl->d_mask) ) ^ (myacl->d_ip&myacl->d_mask) )==0 )) ) ){ 
				tc->cmode=myacl->cmode;	
				tc->pcap=myacl->pcap;	
				tc->realtime=myacl->realtime;	
				tc->stats=myacl->stats;	
				tc->limit=myacl->limit;	
				tc->timeout=myacl->timeout;	
				tc->tcplag=myacl->tcplag;	
				tc->status=myacl->status;	
				tc->rid=myacl->rid;	

				if(myacl->pmode==OMODE_UNIQ)
				{
					if(tc->fH){ tc->fH->destroy(); tc->fH=0; }

					ftmp=createPcapFileName(tc);
					tc->fH= new pcapFileHandle(ftmp);
					free(ftmp);
				}else{
					if(myacl->fH){
						if(tc->fH){ tc->fH->destroy(); tc->fH=0; }
						tc->fH=myacl->fH->attach();	
					}
				}
#ifdef DEBUG				
				if(tc->fH){ fprintf(stderr,"retro cnx logging to %s\n",tc->fH->getFileName()); }
#endif
				tc->retro=true;
				myacl->ctr++;	
				if(tc->realtime) {
                                	record(tc,gVars.rfH);
	                        }
			}
tc=tc->next;	
		}
	}
}

/****************/
/*  apply_rule  */
/****************/
void apply_rule(struct cnx *nc) {
	extern struct gvars gVars;
	struct acl* myacl;
	myacl=gVars.acl_head;
	while(myacl!=NULL){
		if( ( nc->h_proto<=myacl->h_proto_h) && ( nc->h_proto>=myacl->h_proto_l) &&
		( (nc->proto<=myacl->proto_h) && ( nc->proto>=myacl->proto_l ) 
		&& ( ( ( nc->s_ip & (myacl->s_ip&myacl->s_mask) ) ^ (myacl->s_ip&myacl->s_mask) )==0 ) 
	    	&& ( ( ntohs(nc->s_port)<=myacl->s_port_h ) && ( ntohs(nc->s_port)>=myacl->s_port_l ) ) 
	 	&& ( ( ( nc->d_ip & (myacl->d_ip&myacl->d_mask) ) ^ (myacl->d_ip&myacl->d_mask) )==0 ) 
	    	&& ( ( ntohs(nc->d_port)<=myacl->d_port_h ) && ( ntohs(nc->d_port)>=myacl->d_port_l )))){ 
			if(myacl->pmode==OMODE_UNIQ)
			{
				if(nc->fH){ nc->fH->destroy(); nc->fH=0; }
				nc->fH = new pcapFileHandle(createPcapFileName(nc));
			}else{
				if(myacl->fH)
				{
					if(nc->fH){ nc->fH->destroy(); nc->fH=0; }
					nc->fH = myacl->fH->attach();
				}
			}
			nc->cmode=myacl->cmode;	
			nc->pcap=myacl->pcap;	
			nc->realtime=myacl->realtime;	
			nc->stats=myacl->stats;	
			nc->limit=myacl->limit;	
			nc->timeout=myacl->timeout;	
			nc->tcplag=myacl->tcplag;	
			nc->status=myacl->status;	
			nc->rid=myacl->rid;	
			nc->rgid=myacl->rgid;	
			nc->zone=myacl->zone;	
			nc->node=myacl->node;	
			myacl->ctr++;	
			return;
		}
		myacl=myacl->next;	
	}
	// Perform default collect any non-matches
	if(gVars.pfH){	
		if(nc->fH){ nc->fH->destroy(); nc->fH=0; }
		nc->fH=gVars.pfH->attach();	
	}
	nc->stats=gVars.smode?1:0;
	nc->pcap=gVars.pmode?1:0;
	nc->realtime=gVars.rmode?1:0;
	nc->limit=gVars.default_limit;	
	nc->status=gVars.default_status;	
	nc->timeout=gVars.default_timeout;	
	nc->tcplag=gVars.default_tcplag;	
	nc->node=gVars.default_node;	
	gVars.default_ctr++;
#ifdef DEBUG
	printf("Setting stats: %d  pcap: %d realtime: %d limit: %d timeout: %d tcplag: %d\n", nc->stats, nc->pcap, nc->realtime, nc->limit, nc->timeout, nc->tcplag);
#endif
	return;
}
