<?php

/**
* daoTest
*
* PHP version 5
*
* LICENSE: This source file is subject to LGPL license
* that is available through the world-wide-web at the following URI:
* http://www.gnu.org/copyleft/lesser.html
*
* @author       Antonio Alcorn
* @author       Giovanni Capalbo
* @author		Sylvia Hristakeva
* @author		Kumud Nepal
* @author		Ernel Wint
* @copyright    Lanka Software Foundation - http://www.opensource.lk
* @copyright    Trinity Humanitarian-FOSS Project - http://www.cs.trincoll.edu/hfoss
* @package      sahana
* @subpackage   vm
* @tutorial
* @license        http://www.gnu.org/copyleft/lesser.html GNU Lesser General
* Public License (LGPL)
*/

// Call daoTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "daoTest::main");
}

/**
 * Test class for dao.
 * Generated by PHPUnit_Util_Skeleton on 2007-06-19 at 11:42:45.
 */
class daoTest extends PHPUnit_Framework_TestCase {

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    	//Include the ADOdb Library
    	global $global,$dao;
    	$global=array('approot'=>realpath(dirname(__FILE__)).'/../../../');
		require_once($global['approot'].'3rd/adodb/adodb.inc.php');
		require_once($global['approot'].'mod/vm/main.inc');

		//Make the connection to $global['db']
		$global['db'] = NewADOConnection('mysql');
		$global['db']->Connect(TEST_DB_HOST, TEST_DB_USER,TEST_DB_PASSWD,TEST_DB_NAME);
		$dao = new DAO($global['db']);
    	$this->fixture = $dao;

		//SavePostion()
		$this->fixture->execute("INSERT INTO vm_position ( pos_id,proj_id, ptype_id, title,slots, description, status) values ('doc', '8', 'asdf','Triage Doctor', '3', 'Treat patients at the triage center at the entrance', 'active' )");
		$this->fixture->execute("INSERT INTO vm_position_full( pos_id,proj_id, ptype_id, title,slots, description, ptype_title, ptype_description, status skill_code) values ('doc', '8', 'asdf','Triage Doctor', '3', 'Treat patients at the triage center at the entrance', '', '', 'active', '' )");

		//getVolSkillsArray
		$this->fixture->execute("INSERT INTO vm_vol_skills (opt_skill_code, p_uuid) values ('SPO3', 'test5')");
		$this->fixture->execute("INSERT INTO vm_proj_skills (opt_skill_code, p_uuid) values('SPO4', 'test4')");

    	// volIsAssignedToProject
		$this->fixture->execute("insert into vm_proj_vol (p_uuid, proj_id) values ('test2', '1000'), ('mgr_id', '8')");
		$this->fixture->execute("delete from vm_proj_vol where p_uuid = 'test3'");
		$this->fixture->execute("delete from vm_proj_vol where p_uuid = 'test4'");

		$this->fixture->execute("insert into vm_vol_assignment (p_uuid, proj_id) values ('test2', '1000'), ('mgr_id', '8')");


		//getProjectName() and getProject() and listProjects
		$this->fixture->execute("INSERT INTO vm_projects (proj_id, name, mgr_id, location_id, start_date, end_date, description) VALUES ('1000', 'Project Name', 'mgr_id', 'loc_id', '2000-11-05', '2007-01-20', 'description')");
		$this->fixture->execute("INSERT INTO vm_proj_skills (p_uuid, opt_skill_code) VALUES ('1000', 'VEH1'),('1000','ELE3')");

		$this->fixture->execute("DELETE FROM vm_projects WHERE proj_id ='1001'");


		//getPersonName()
		$this->fixture->execute(" INSERT INTO person_uuid(p_uuid, full_name) VALUES('test1','Volunteer1'),('test2','Volunteer2')");
		$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid = 'test3'");

		//isVolunteer and deleteVolunteer()
		$this->fixture->execute("INSERT INTO vm_vol_details (p_uuid,date_avail_start, date_avail_end, hrs_avail_start, hrs_avail_end, org_id) VALUES ('test1','2007-09-10','2007-10-28','6:00','4:00','8')");
		$this->fixture->execute("DELETE FROM vm_vol_details WHERE p_uuid='test2'");

		//getLocation()
		$this->fixture->execute("INSERT INTO location (loc_uuid, opt_location_type, iso_code, name, description) VALUES ('test1','1', 'iso_code','USA','description')");
		$this->fixture->execute("DELETE FROM location WHERE loc_uuid='test2'");

		//deleteVolunteer()

		$this->fixture->execute("INSERT INTO location_details (location_id,poc_uuid) VALUES ('489slc-3','test1')");
		$this->fixture->execute("INSERT INTO location_details (location_id,poc_uuid) VALUES ('489slc-3','test2')");
		$this->fixture->execute("INSERT INTO contact (opt_contact_type,contact_value,pgoc_uuid) VALUES ('curr','865545565','test1'),('emai','email@star.com','test1')");
		$this->fixture->execute("INSERT INTO contact (opt_contact_type,contact_value,pgoc_uuid) VALUES ('curr','765444465','test2'),('pmob','787878788','test2')");
		$this->fixture->execute("INSERT INTO identity_to_person (p_uuid, serial, opt_id_type) VALUES ('test1', 'serial', 'dln')");
		$this->fixture->execute("INSERT INTO person_details (p_uuid, birth_date) VALUES ('test1', '1986-07-25')");

		$this->fixture->execute("INSERT INTO identity_to_person (p_uuid, serial,opt_id_type) VALUES ('test2', 'cereal','dln')");
		$this->fixture->execute("INSERT INTO person_details (p_uuid, birth_date) VALUES ('test2', '1982-09-02')");
		$this->fixture->execute("INSERT INTO vm_mailbox (p_uuid, message_id) VALUES ('test1','1000')");

		$this->fixture->execute("INSERT INTO users (p_uuid, user_name) VALUES ('test1', 'user')");
		$this->fixture->execute("INSERT INTO users (p_uuid, user_name) VALUES ('test2', 'crew')");


		//isSitemanager() and deleteVolunteer()
		$this->fixture->execute("INSERT INTO vm_vol_skills (p_uuid, opt_skill_code) VALUES ('test1', 'mgr')");
		$this->fixture->execute("INSERT INTO vm_vol_skills (p_uuid, opt_skill_code) VALUES ('test3', 'FOO3')");
		$this->fixture->execute("DELETE FROM vm_vol_skills WHERE p_uuid ='test2'");

		//getToList and getMessage() and deleteMessage() and getMessages()
		$this->fixture->execute("INSERT INTO vm_courier (message_id, to_id, from_id) VALUES ('1000', 'to_id_1', 'from_id')");
		$this->fixture->execute("INSERT INTO vm_courier (message_id, to_id, from_id) VALUES ('1001', 'to_id_1', 'from_id'), ('1001', 'to_id_2', 'from_id'), ('1001', 'to_id_3', 'from_id'), ('2000', 'to_id_1', 'from_id')");
		$this->fixture->execute("INSERT INTO vm_courier (message_id, to_id, from_id) VALUES ('1003', 'to_id_no', 'from_id')");
		$this->fixture->execute("DELETE FROM vm_courier WHERE message_id = '1002'");

		$this->fixture->execute("INSERT INTO vm_message (message_id, message, time) VALUES ('1000', 'message text', '2007-06-15 17:32:20'), ('2000', 'next message', '2007-06-15 17:32:29')");
		$this->fixture->execute("DELETE FROM vm_message WHERE message_id='1010'");

		$this->fixture->execute("INSERT INTO vm_mailbox (p_uuid, message_id, box, checked) VALUES ('to_id_1','1000', '0', '0'), ('to_id_1','2000', '0', '0'), ('from_id','2000', '1', '0'), ('from_id','1000', '1', '0')");
		$this->fixture->execute("INSERT INTO vm_mailbox (p_uuid, message_id, box, checked) VALUES ('test3','1000', '0', '0')");
		$this->fixture->execute("INSERT INTO vm_mailbox (p_uuid, message_id, box, checked) VALUES ('test3','1000', '1', '0')");
		$this->fixture->execute("DELETE FROM vm_mailbox WHERE p_uuid = test2");

		$this->fixture->execute("INSERT INTO person_uuid (p_uuid, full_name) VALUES ('to_id_1', 'Full Name'), ('to_id_2', 'Full Name 2'), ('to_id_3', 'Full Name 3')");
		$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid = 'to_id_no'");


		//getOrganizationInfo()
    	$this->fixture->execute("DELETE FROM org_main WHERE o_uuid = 'test2')");

		//getOrganizations()
		$this->fixture->execute ("INSERT INTO org_main (o_uuid, name) VALUES ('test5', 'Org Name')");

		// skills
		$this->fixture->execute("insert into field_options (field_name, option_code) values ('opt_skill_type', 'skl1'), ('opt_skill_type', 'skl2')");
		$this->fixture->execute("delete from field_options where field_name = 'opt_skill_type' and option_code = 'skl3' or option_code = 'skl4'");

    	// pictures
    	$this->fixture->execute("insert into vm_image (img_uuid, p_uuid) values ('img1', 'usr1')");
		$this->fixture->execute("delete from vm_image where p_uuid = 'usr2'");

		//access control
		$this->fixture->execute("INSERT INTO vm_access_constraint (constraint_id, description) VALUES ('constraint1', 'description1'), ('constraint2', 'description2')");
		$this->fixture->execute("INSERT INTO vm_access_request (request_id, act, vm_action, description) VALUES ('10000','act_test1', 'vm_action_test1','description1')");
		$this->fixture->execute("INSERT INTO vm_access_constraint_to_request (request_id, constraint_id) VALUES ('10000','constraint1')");

		//create a new volunteer to e used in getVolSearchResults
		$this->fixture->execute("INSERT INTO person_uuid (p_uuid, full_name) VALUES ('search_1', 'Search Name')");
		$this->fixture->execute("INSERT INTO vm_vol_details (p_uuid, date_avail_start, date_avail_end, hrs_avail_start, hrs_avail_end, org_id) VALUES ('search_1','2007-01-01','2008-01-01','00:00','1:00','489so-2')");
		$this->fixture->execute("INSERT INTO identity_to_person (opt_id_type,serial, p_uuid) values ('pas','Pass12345'  ,'search_1')");
		$this->fixture->execute("INSERT INTO vm_vol_skills VALUES ('search_1', 'mgr'), ('search_1', 'VEH1')");
		$this->fixture->execute("INSERT INTO location_details (poc_uuid, location_id) VALUES ('search_1', '489slc-3')");
		$this->fixture->execute("INSERT INTO phonetic_word (pgl_uuid, encode1, encode2) VALUES ('search_1', '".soundex('Search')."', '".metaphone('Search')."')");
		$this->fixture->execute("INSERT INTO phonetic_word (pgl_uuid, encode1, encode2) VALUES ('search_1', '".soundex('Name')."', '".metaphone('Name')."')");

    	//remove position
    	$this->fixture->execute("INSERT INTO vm_position(pos_id, proj_id, title, slots, description, status, payrate) VALUES ('pos420', 'proj420', 'title', '2', 'description', 'active', '20')");

    	//deleteVolunteer() and deletefromProject()
    	$this->fixture->execute ("INSERT INTO vm_vol_details (p_uuid, date_avail_start, date_avail_end, status) values ('jpt420', '2007-05-28', '2007-06-28', 'active')");
		$this->fixture->execute ("INSERT INTO vm_vol_assignment (p_uuid, proj_id, status) VALUES ('jpt420', '4200', 'active')");

		//deleteProject()
		$this->fixture->execute("INSERT INTO vm_projects (proj_id, name, status) VALUES ('4201', 'name', 'active')");
		$this->fixture->execute ("INSERT INTO vm_vol_assignment (p_uuid, proj_id, status) VALUES ('jpt421', '4201', 'active')");

   		//isSiteManager()

   		$this->fixture->execute ("INSERT INTO vm_vol_skills (p_uuid, opt_skill_code, status) VALUES ('fchxp-5','MGR', 'approved')");
		$this->fixture->execute ("INSERT INTO vm_vol_skills (p_uuid, opt_skill_code, status) VALUES ('fchxp-6','MGR', 'denied')");
		$this->fixture->execute ("INSERT INTO vm_vol_active (p_uuid, date_avail_start, date_avail_end, status) VALUES ('fchxp-5','2007-05-28', '2007-06-28', 'active')");
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
			global $time;

		$this->fixture->execute("Delete FROM person_uuid WHERE p_uuid='test1' or p_uuid='test2'");
		$this->fixture->execute("Delete FROM identity_to_person WHERE p_uuid='test1' or p_uuid='test2'");
		$this->fixture->execute("Delete FROM location_details WHERE poc_uuid='test1' or poc_uuid='test2'");
		$this->fixture->execute("Delete FROM vm_proj_vol WHERE p_uuid='test1' or p_uuid='test2'");
		$this->fixture->execute("Delete FROM person_details WHERE p_uuid='test1' or p_uuid='test2'");
		$this->fixture->execute("Delete FROM vm_vol_details WHERE p_uuid='test1' or p_uuid='test2'");
		$this->fixture->execute("Delete FROM contact WHERE pgoc_uuid='test1' or pgoc_uuid='test2'");

		// getVolSkillsArray
		$this->fixture->execute("DELETE FROM vm_vol_skills WHERE p_uuid ='test5'");
		$this->fixture->execute("DELETE FROM vm_proj_skills where p_uuid='test4'");

    	//volIsAssigned
    	$this->fixture->execute("delete from vm_proj_vol where p_uuid = 'test2' OR p_uuid = 'mgr_id'");

		//SaveVol
		$person_id = $this->fixture->execute("SELECT p_uuid From person_uuid WHERE full_name = 'Marky Mark'");
		$id = $person_id->fields['p_uuid'];


		$this->fixture->execute("DELETE FROM vm_vol_details WHERE p_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16' ,'489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM identity_to_person WHERE p_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM contact WHERE pgoc_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM person_details WHERE p_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM vm_vol_skills WHERE p_uuid NOT IN('xyz-60','489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM location_details WHERE poc_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM  phonetic_word WHERE pgl_uuid NOT IN('489sp-12','489sp-13','489sp-17','4eiop-19','489sp-16','489sp-15','489sp-14','test1','sahap-2','2') ");
		$this->fixture->execute("DELETE FROM users WHERE user_name= 'Marky_user'");

		//getProjectName() and deleteProject() and listProject() and saveProject()
    	$this->fixture->execute("DELETE FROM vm_projects WHERE proj_id ='4201'");
    	$this->fixture->execute ("DELETE FROM vm_vol_assignment WHERE proj_id ='4200'");
    	$this->fixture->execute("DELETE FROM vm_projects WHERE proj_id ='1000'");
    	$this->fixture->execute("DELETE FROM vm_projects WHERE name ='tank'");
    	$this->fixture->execute("DELETE FROM vm_projects WHERE name ='Manchanic'");
    	$this->fixture->execute("DELETE FROM vm_proj_skills WHERE opt_skill_code = 'SKILL1' OR opt_skill_code = 'SKILL2' OR opt_skill_code = 'SKILL3'");
    	$this->fixture->execute("DELETE FROM vm_proj_skills WHERE p_uuid ='1000'");
    	$this->fixture->execute("DELETE FROM vm_proj_vol WHERE proj_id ='1000'");
    	$this->fixture->execute("DELETE FROM vm_vol_assignment WHERE pos_id ='doc'");
        $this->fixture->execute("DELETE FROM vm_position WHERE pos_id ='doc'");

    	//getPersonName()
    	$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid = 'test1'");
    	$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid = 'test2'");

    	//isVolunteer
    	$this->fixture->execute("DELETE FROM vm_vol_details WHERE p_uuid='test1'");

    	//getLocation
    	$this->fixture->execute("DELETE FROM location WHERE loc_uuid='test1'");
    	$this->fixture->execute("DELETE FROM location_details WHERE poc_uuid ='test1'");

		//deleteVolunteer
		$this->fixture->execute("DELETE FROM contact WHERE pgoc_uuid='test1'");
		$this->fixture->execute("DELETE FROM identity_to_person WHERE p_uuid='test1')");
		$this->fixture->execute("DELETE FROM person_details WHERE p_uuid='test1')");
		$this->fixture->execute("DELETE FROM users WHERE p_uuid = 'test1'");


    	//isSiteManager
    	$this->fixture->execute("DELETE FROM vm_vol_skills WHERE p_uuid= 'test1'");
    	$this->fixture->execute("DELETE FROM vm_vol_skills WHERE p_uuid= 'test3'");

    	//getToList and getMessage and deleteMessage
    	$this->fixture->execute("DELETE FROM vm_courier WHERE message_id = '1000' OR message_id='1001' OR message_id='1003'");
    	$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid = 'to_id_1' OR p_uuid='to_id_2' OR p_uuid='to_id_3'");

		$this->fixture->execute("DELETE FROM vm_mailbox WHERE message_id = '1000' OR p_uuid='test1' OR message_id = '2000'");

		//sendMessage() and assignToProject()
		$this->fixture->execute("DELETE FROM vm_message WHERE message = 'message text 2' OR message = 'message text 3' OR message_id = '1000' OR message = 'next message'");
		$this->fixture->execute("DELETE FROM vm_courier WHERE to_id = 'to_id_10' OR to_id='to_id_15' OR to_id = 'to_id_14' OR to_id = 'to_id_1'");
		$this->fixture->execute("DELETE FROM vm_mailbox WHERE p_uuid = 'to_id_10' OR p_uuid = 'from_id_10' OR p_uuid='to_id_15' OR p_uuid = 'from_id_15' OR p_uuid='to_id_14'");

		$this->fixture->execute("DELETE FROM vm_message WHERE message = 'Your site manager status request has been approved. \n\n (This is an automated message)'");
		$this->fixture->execute("DELETE FROM vm_message WHERE message = 'Your site manager status has been revoked. \n\n (This is an automated message)'");
		$this->fixture->execute("DELETE FROM vm_message WHERE time = '$time'");
		$this->fixture->execute("DELETE FROM vm_courier WHERE to_id = 'test2' OR from_id = ''");
		$this->fixture->execute("DELETE FROM vm_mailbox WHERE p_uuid = 'test2' OR p_uuid = 'mgr_id' OR p_uuid = '' OR p_uuid = 'search_1'");

		//volIsAssignedToProject
		$this->fixture->execute("DELETE from vm_vol_assignment (p_uuid, proj_id) values ('test2', '1000'), ('mgr_id', '8')");

		//geOrganizations()
		$this->fixture->execute("DELETE FROM org_main where o_uuid='test5' ");

		// skills
		$this->fixture->execute("delete from field_options where field_name = 'opt_skill_type' and option_code = 'skl1' or option_code = 'skl2'");

    	//pictures
    	$this->fixture->execute("delete from vm_image where img_uuid = 'img1'");

    	//access control
    	$this->fixture->execute("DELETE FROM vm_access_constraint WHERE constraint_id ='constraint1' OR constraint_id = 'constraint2'");
    	$this->fixture->execute("DELETE FROM vm_access_request WHERE request_id = '10000'");
		$this->fixture->execute("DELETE FROM vm_access_constraint_to_request WHERE request_id = '10000' AND constraint_id ='constraint1'");
		$this->fixture->execute("DELETE FROM vm_access_constraint_to_request WHERE constraint_id ='constraint3'");

		//create a new volunteer to test getVolSeachResults
		$this->fixture->execute("DELETE FROM person_uuid WHERE p_uuid= 'search_1'");
		$this->fixture->execute("DELETE FROM vm_vol_details WHERE p_uuid= 'search_1'");
		$this->fixture->execute("DELETE FROM identity_to_person WHERE p_uuid= 'search_1'");
		$this->fixture->execute("DELETE FROM vm_vol_skills WHERE p_uuid= 'search_1'");
		$this->fixture->execute("DELETE FROM location_details WHERE poc_uuid= 'search_1'");
		$this->fixture->execute("DELETE FROM phonetic_word WHERE pgl_uuid = 'search_1'");

		//delete entries created for removePosition
		$this->fixture->execute("DELETE FROM vm_position WHERE pos_id = 'pos420''");

		//delete entries created for deleteVolunteer()
		$this->fixture->execute ("DELETE FROM vm_vol_details WHERE p_uuid = 'jpt420'");
		$this->fixture->execute ("DELETE FROM vm_vol_assignment WHERE p_uuid = 'jpt420'");

		//delete entries created for isSiteManager()
		$this->fixture->execute ("DELETE FROM vm_vol_skills WHERE p_uuid = 'fchxp-5' AND opt_skill_code = 'MGR' AND status = 'approved'");
	$this->fixture->execute ("DELETE FROM vm_vol_skills WHERE p_uuid = 'fchxp-6' AND opt_skill_code = 'MGR' AND status = 'denied'");
		$this->fixture->execute ("DELETE FROM vm_vol_active WHERE p_uuid = ' fchxp-5'");
    }

    public function testGetVol() {

		$test1 = array(
			'full_name' => 'Volunteer1',
			'ids' => array('dln' => 'serial'),
			'locations' => array('489slc-3','489slc-2','489slc-1'),
			'proj_id' => array(),
			'gender' => null,
			'dob' => '1986-07-25',
			'occupation' => null,
			'status' => 'Unassigned',
			'date_start' => '2007-09-10',
			'date_end' => '2007-10-28',
			'hour_start' => '06:00:00',
			'hour_end' => '04:00:00',
			'affiliation' => 8,
			'contact' => array('curr' => '865545565','emai' => 'email@star.com'),
			'messages' => '1'
		);


		$test2 = array(
			'full_name' => 'Volunteer2',
			'ids' => array('dln' => 'cereal'),
			'locations' => array('489slc-3','489slc-2','489slc-1'),
			'proj_id' => array(1000),
			'gender' => null,
			'dob' => '1982-09-02',
			'occupation' => null,
			'status' => 'Assigned',
			'date_start' => null,
			'date_end' => null,
			'hour_start' => null,
			'hour_end' => null,
			'affiliation' => null,
			'contact' => array('curr' => '765444465','pmob' => '787878788'),
			'messages' => '0'
		);
	$this->assertTrue(array_intersect($test1,$this->fixture->getVol('test1'))==$test1);
	$this->assertTrue(array_intersect($test2,$this->fixture->getVol('test2'))==$test2);
	$this->assertFalse($this->fixture->getVol('test3'));
	$this->assertFalse($this->fixture->getVol('test4'));

    }

    /**
     * A function to assist testGetVolunteers() to make it easier to fix the tests when the database changes
     *
     * @param $result_entry 	an entry in the resulting array from testGetVolunteers
     * @param $p_uuid 			the p_uuid of the volunteer whose information is represented by $result_entry
     * @param $search		 	if $result_entry is a result from getVolSearchResults(), an array that contains:
     *
     * 							Array
     * 							(
     * 								'id_searched' 	=> the Identification card searched by
     * 								'name'			=> the name searched by
     * 							)
     *
     * @return true if $result_entry contains all information it is supposed to and all information is accurate
     *
     *
     * A quick reminder of what the result_entry should contain:
     *
     *	Array
     * (
     * 		'full_name'		=> the volunteer's full name
     *		'ids'			=> an array  of the volunteer's IDs, where each key is
     *							the full description for ID type and each value is the ID code
     *		'skills'		=> an array of skill codes => descriptions for the volunteer
     *		'date_start'	=>the volunteer's available start date
     *		'date_end'		=> the volunteer's available end date
     *		'projs'			=> an array of project IDs that the volunteer is assigned to
     *		'locations'		=> an array of the volunteer's location and its parents
     *		'affiliation'	=> the organization that the volunteer is affiliated with
     * )
     */

    private function volResultEntryIsAccurate($result_entry, $p_uuid, $search=null)
    {
    	//full_name

		$r = $this->fixture->execute("SELECT full_name FROM person_uuid WHERE p_uuid = '$p_uuid'");
		if($result_entry['full_name'] != $r->fields['full_name'])
		{
			echo "Volunteer $p_uuid's full name is inaccurate\r\n";
			return false;
		}

		//levenshtein distance (if checking from getVolSearchResults())

		if(!empty($search))
		{
			if($result_entry['levenshtein'] != levenshtein(strtoupper($search['name']), strtoupper($r->fields['full_name'])))
			{
				echo "Volunteer $p_uuid's levenshtein distance is inaccurate\r\n";
				return false;
			}
		}

		//ids

		$r = $this->fixture->execute("SELECT option_description, serial FROM identity_to_person, field_options WHERE p_uuid = '$p_uuid' AND opt_id_type = option_code");
    	$count = 0;
    	while(!$r->EOF)
    	{
    		if($result_entry['ids'][$r->fields['option_description']] != $r->fields['serial'])
    		{
    			echo "Volunteer $p_uuid's IDs are inaccurate\r\n";
    			return false;
    		}
    		$r->MoveNext();
    		$count++;
    	}

    	if($count != count($result_entry['ids']))
    	{
    		echo "Volunteer $p_uuid's number of IDS returned is inaccurate\r\n";
    		return false;
    	}

    	//skills

    	$r = $this->fixture->getSkillsAndDescriptions($p_uuid);
    	foreach($r as $code => $desc)
    	{
    		if($result_entry['skills'][$code] != $desc)
    		{
    			echo "Volunteer $p_uuid's skills are inaccurate\r\n";
    			return false;
    		}
    	}

    	if(count($r) != count($result_entry['skills']))
    	{
    		echo "Volunteer $p_uuid's number of skills returned is inaccurate\r\n";
    		return false;
    	}

    	//availability

    	$r = $this->fixture->execute("SELECT date_avail_start, date_avail_end FROM vm_vol_details WHERE p_uuid = '$p_uuid'");
    	if($r->fields['date_avail_start'] != $result_entry['date_start'] || $r->fields['date_avail_end'] != $result_entry['date_end'])
    	{
    		echo "Volunteer $p_uuid's availability is inaccurate\r\n";
    		return false;
    	}

    	//projs

    	$r = $this->fixture->execute("SELECT proj_id, task FROM vm_proj_vol WHERE p_uuid = '$p_uuid'");
    	$count = 0;
    	while(!$r->EOF)
    	{
    		if($result_entry['projs'][$r->fields['proj_id']] != $r->fields['task'])
    		{
	    		echo "Volunteer $p_uuid's projects are inaccurate\r\n";
	    		return false;
    		}
    		$count++;
    		$r->MoveNext();
    	}
    	if($count != count($result_entry['projs']))
    	{
    		echo "Volunteer $p_uuid's number of projects returned is inaccurate\r\n";
    		return false;
    	}

    	//locations

    	$loc = $this->fixture->execute("SELECT location_id FROM location_details WHERE poc_uuid = '$p_uuid'");
    	$loc_id = $loc->fields['location_id'];

    	$r = $this->fixture->getParentLocations($loc_id);
    	foreach($r as $code => $desc)
    	{
    		if($result_entry['locations'][$code] != $desc)
    		{
    			echo "Volunteer $p_uuid's locations are inaccurate\r\n";
    			return false;
    		}
    	}
    	if(count($r) != count($result_entry['locations']))
    	{
			echo "Volunteer $p_uuid's number of locations returned is inaccurate\r\n";
			return false;
		}

		//affiliation

		$org = $this->fixture->execute("SELECT name FROM org_main WHERE o_uuid = (SELECT org_id FROM vm_vol_details WHERE p_uuid = '$p_uuid')");
		if($org->fields['name'] != $result_entry['affiliation'])
		{
			echo "Volunteer $p_uuid's organization affiliation is inaccurate\r\n";
			return false;
		}

		//ID searched by (if checking from getVolSearchResults())

		if(!empty($search))
		{
			if($result_entry['id_searched'] != $search['id_searched'])
			{
				echo "Volunteer $p_uuid's ID searched by (key 'id_searched') is inaccurate\r\n";
				return false;
			}
		}

	    return true;

    }

    /**
     * Checks to make sure that the results from getVolunteers() or getVolSearchResults() are accurate
     *
     * $results				the results returned from one of the functions above
     * $expected_p_uuids	an array containing the expected p_uuids that should be the keys in $results
     * $search				if $results are results from getVolSearchResults(), an array that contains:
     *
     * 							Array
     * 							(
     * 								'id_searched' 	=> the Identification card searched by
     * 								'name'			=> the name searched by
     * 							)
     */

	private function volResultsAreAccurate($results, $expected_p_uuids, $search=null)
	{
		foreach($results as $p_uuid => $entry)
		{
			if(!$this->volResultEntryIsAccurate($entry, $p_uuid, $search))
				return false;
		}

		foreach($expected_p_uuids as $p_uuid)
		{
			if(!in_array($p_uuid, array_keys($results)))
			{
				echo "Expected p_uuids are inaccurate\r\n";
				return false;
			}
		}

		if(count($expected_p_uuids) != count($results))
		{
			echo "Expected number of p_uuids is inaccurate\r\n";
			return false;
		}

		return true;
	}

    public function testGetVolunteers()
    {
    	///////////////////////       all volunteers         ///////////////////////

    	$r = $this->fixture->execute("SELECT p_uuid FROM vm_vol_details");
		$expected_vols = array();

		while(!$r->EOF)
		{
			$expected_vols[] = $r->fields['p_uuid'];
			$r->MoveNext();
		}

		$this->assertTrue($this->volResultsAreAccurate($this->fixture->getVolunteers(), $expected_vols));

    	///////////////////////  all unassigned volunteers   ///////////////////////

    	$r = $this->fixture->execute("SELECT p_uuid FROM vm_vol_details WHERE p_uuid NOT IN (SELECT p_uuid FROM vm_proj_vol)");
		$expected_vols = array();

		while(!$r->EOF)
		{
			$expected_vols[] = $r->fields['p_uuid'];
			$r->MoveNext();
		}

		$this->assertTrue($this->volResultsAreAccurate($this->fixture->getVolunteers(null, VM_SHOW_ALL_VOLUNTEERS_UNASSIGNED), $expected_vols));

    	///////////////////////   all assigned volunteers    ///////////////////////

		$r = $this->fixture->execute("SELECT p_uuid FROM vm_vol_details WHERE p_uuid IN (SELECT p_uuid FROM vm_proj_vol)");
		$expected_vols = array();

		while(!$r->EOF)
		{
			$expected_vols[] = $r->fields['p_uuid'];
			$r->MoveNext();
		}

		$this->assertTrue($this->volResultsAreAccurate($this->fixture->getVolunteers(null, VM_SHOW_ALL_VOLUNTEERS_ASSIGNED), $expected_vols));

		///////////////////////   volunteers by project      ///////////////////////

		$r = $this->fixture->execute("SELECT p_uuid FROM vm_vol_details JOIN vm_proj_vol USING (p_uuid) WHERE proj_id = 9"); //do the join to make sure we only get volunteers (db may be corrupt)
		$expected_vols = array();

		while(!$r->EOF)
		{
			$expected_vols[] = $r->fields['p_uuid'];
			$r->MoveNext();
		}

		$this->assertTrue($this->volResultsAreAccurate($this->fixture->getVolunteers(9), $expected_vols));

    }


	public function testRemoveArrayKeys() {
		$test = array(
			0 => 'John Doe',
			'name' => 'John Doe',
			1 => '12-21-1986',
			'birthday' => '12-21-1986',
			2 => 'John Doe',
			'name1' => 'John Doe',
			3 => '12-21-1986',
			'birthday1' => '12-21-1986',

		);
		$this->fixture->remove_keys($test);
		$expected = array(
			'name' => 'John Doe',
			'birthday' => '12-21-1986',
			'name1' => 'John Doe',
			'birthday1' => '12-21-1986',

		);

		$this->assertEquals($test, $expected);

		$test = array(
			0 => 'John Doe',
			'name' => 'John Doe',
			1 => '12-21-1986',
			'birthday' => '12-21-1986',
			2 => 'John Doe',
			'name1' => 'John Doe',
			3 => '12-21-1986',
			'birthday1' => '12-21-1986',
		);
		$this->fixture->remove_keys($test, MYSQL_ASSOC);
		$expected = array('John Doe','12-21-1986', 'John Doe','12-21-1986');
		$this->assertEquals($test, $expected);

	}

	public function testSaveVol() {

		$p= new Volunteer();
		$p->info['date_start']= '2007-06-25';
		$p->info['date_end']= '2008-06-21';
		$p->info['hour_start']= '6:00';
		$p->info['hour_end']= '12:00:00';
		$p->info['locations']= array('489slc-5');
		$p->info['full_name']='Marky Mark';
		$p->info['gender']= 'M';
		$p->info['dob']= '1986-12-18';
		$p->info['occupation']= 'Dentist';
		$p->info['key']= 'pmob';
		$p->info['value']= '860-555-4444';
		$p->info['ids']= array('dln'=>'777777');
		$p->info['contact']= array('pmob' =>'860-555-4444' );
		$p->info['skills']= array( 'VEH2','ELE3');
		$p->info['locations'][0]= 'location_id';
		$p->info['account_info'] = array('account_name'=>'Marky Mark', 'user_name'=>'Marky_user', 'pass'=>'pass');
		sort($p->info['skills']);
		$this->fixture->saveVol($p);

		$result = $this->fixture->execute("SELECT full_name From person_uuid WHERE p_uuid= '{$p->p_uuid}' ")	;
		$this->assertEquals($p->info['full_name'],$result->fields['full_name']);

		$result = $this->fixture->execute("SELECT date_avail_start,date_avail_end,hrs_avail_start,hrs_avail_end FROM vm_vol_details WHERE p_uuid='{$p->p_uuid}' ");
		$this->assertEquals($p->info['date_start'],$result->fields['date_avail_start']);
		$this->assertEquals($p->info['date_end'],$result->fields['date_avail_end']);
		$this->assertEquals('06:00:00',$result->fields['hrs_avail_start']);
		$this->assertEquals($p->info['hour_end'],$result->fields['hrs_avail_end']);


		$result = $this->fixture->execute("Select opt_id_type,serial FROM identity_to_person WHERE p_uuid='{$p->p_uuid}'");
		$this->assertEquals($p->info['ids'],array( $result->fields['opt_id_type']=>$result->fields['serial']));



		$result=$this->fixture->execute("SELECT opt_gender,birth_date,occupation FROM person_details WHERE p_uuid='{$p->p_uuid}'");
		$this->assertEquals($p->info['gender'],$result->fields['opt_gender']);
		$this->assertEquals($p->info['dob'],$result->fields['birth_date']);
		$this->assertEquals($p->info['occupation'],$result->fields['occupation']);


		$result = $this->fixture->execute("SELECT  pgoc_uuid, opt_contact_type, contact_value From contact WHERE pgoc_uuid='{$p->p_uuid}'");
		$this->assertEquals($p->info['key'],$result->fields['opt_contact_type']);
		$this->assertEquals($p->info['value'],$result->fields['contact_value']);

		$result = $this->fixture->execute("SELECT encode1, encode2 FROM  phonetic_word WHERE pgl_uuid='{$p->p_uuid}'");
		$this->assertEquals($result->fields['encode1'],soundex('Mark'));
		$this->assertEquals($result->fields['encode2'],metaphone('Mark'));

		$result= $this->fixture->getVolSkillsArray($p->p_uuid);
		sort($result);
		$this->assertEquals($p->info['skills'],$result);


		$result = $this->fixture->execute("SELECT location_id From location_details WHERE poc_uuid='{$p->p_uuid}'");
		$this->assertEquals($p->info['locations'][0],$result->fields['location_id']);

		$result = $this->fixture->execute("SELECT user_name FROM users WHERE p_uuid = '{$p->p_uuid}'");
		$this->assertEquals($p->info['account_info']['user_name'], $result->fields['user_name']);

		/////UPDATE saveVol($p->p_uuid)

		$d= new Volunteer();
		$d->info['date_start']= '2005-07-07';
		$d->info['date_end']= '2008-08-08';
		$d->info['hour_start']= '2:00';
		$d->info['hour_end']= '07:47:45';
		$d->info['locations']= array('489slc-1');
		$d->info['full_name']='Clone Man';
		$this->fixture->saveVol($d);

		//$result= $this->fixture->execute("UPDATE vm_vol_details SET date_avail_start='{$d->info['date_start']}' ,date_avail_end='{$d->info['date_end']}',hrs_avail_start='{$d->info['hour_start']}',hrs_avail_end='{$d->info['hour_end']}'  start WHERE p_uuid = '{$p->p_uuid}'");
		$result = $this->fixture->execute("SELECT date_avail_start, date_avail_end, hrs_avail_start, hrs_avail_end FROM vm_vol_details WHERE p_uuid='{$d->p_uuid}' ");
		//$this->fixture->remove_keys($result->fields);
		//var_export($result->fields);
		$this->assertEquals($d->info['date_start'],$result->fields['date_avail_start']);
		$this->assertEquals($d->info['date_end'],$result->fields['date_avail_end']);
		$this->assertEquals('02:00:00',$result->fields['hrs_avail_start']);
		$this->assertEquals($d->info['hour_end'],$result->fields['hrs_avail_end']);

		$result = $this->fixture->execute("SELECT full_name From person_uuid WHERE p_uuid= '{$d->p_uuid}' ")	;
		$this->assertEquals($d->info['full_name'],$result->fields['full_name']);
		//var_export($result->fields);

		$result = $this->fixture->execute("SELECT encode1, encode2 FROM  phonetic_word WHERE pgl_uuid='{$d->p_uuid}' ORDER BY encode1");
		$this->assertEquals($result->fields['encode1'],soundex('Clone'));
		$this->assertEquals($result->fields['encode2'],metaphone('Clone'));
		$result->moveNext();
		$this->assertEquals($result->fields['encode1'],soundex('Man'));
		$this->assertEquals($result->fields['encode2'],metaphone('Man'));

	}

	public function testVolIsAssignedToProject() {
		$this->assertTrue($this->fixture->volIsAssignedToProject('fchxp-5'));
		//$this->assertTrue($this->fixture->volIsAssignedToProject('test2', '1000'));
		$this->assertFalse($this->fixture->volIsAssignedToProject('test3', 'proj_id'));
		$this->assertFalse($this->fixture->volIsAssignedToProject('test4'));
	}

	public function testGetProjectName(){

		$test = $this->fixture->getProjectName('1000');
		$this->assertEquals($test, 'Project Name');

		$test1 = $this->fixture->getProjectName('1001');
		$this->assertFalse($test1);


	}

	public function testGetPersonName()
	{
		$test = $this->fixture->getPersonName('test1');
		$this->assertEquals($test, 'Volunteer1');

		$test1 = $this->fixture->getPersonName('test2');
		$this->assertEquals($test1, 'Volunteer2');

		$test2 = $this->fixture->getPersonName('test3');
		$this->assertFalse($test2);
	}

	public function testIsVolunteer(){

		$test= $this->fixture->isVolunteer('test1');
		$this->assertTrue($test);

		$test= $this->fixture->isVolunteer('test2');
		$this->assertFalse($test);

	}

	public function testGetLocation()
	{

		$test1 = $this->fixture->getLocation('test1');
		$expected = array('opt_location_type'=>'1', 'name'=>'USA', 'iso_code'=>'iso_code', 'description'=>'description');
		$this->assertEquals($test1, $expected);

		$test2=$this->fixture->getLocation('test2');
		$this->assertFalse($test2);
	}

	public function testGetIdTypes()
	{
		$result = $this->fixture->getIdTypes();
		$expected = array('nic'=>'National Identity Card', 'pas'=>'Passport', 'dln'=>'Driving License Number', 'oth'=>'Other');
		$this->assertEquals($result, $expected);
	}


	public function testGetContactTypes()
	{
		$result = $this->fixture->getContactTypes();
		$expected = array('emphone'=> 'Emergency Phone Contact','home'=>'Home(permanent address)', 'name'=>'Contact Person', 'pmob'=>'Personal Mobile', 'curr'=>'Current Phone', 'cmob'=>'Current Mobile', 'emai'=>'Email address', 'fax'=>'Fax Number', 'web'=>'Website', 'inst'=>'Instant Messenger');
		$this->assertEquals($result, $expected);
	}

	public function testGetVolSkillsArray() {
        $test1 = $this->fixture->getVolSkillsArray('test5');
        sort($test1);
		$expected = array('0'=>'SPO3');
		$this->assertEquals($test1, $expected);

		}

	public function testgetVolHoursAndRate() {


		$r = $this->fixture->execute("SELECT  proj_id, project_name, status, pos_id, title, payrate
				 FROM    vm_vol_assignment
				 WHERE   p_uuid = 'fchxp-3' AND proj_id = 'null'");

		$info = array();

		while(!$r->EOF)
		{
			if(!isset($info[$r->fields['proj_id']]))
				$info[$r->fields['proj_id']] = array('project_name' => $r->fields['project_name']);

			$info[$r->fields['proj_id']][$r->fields['pos_id']] = array
			(
				'title'		=> $r->fields['title'],
				'payrate'	=> $r->fields['payrate'],
				'status'	=> $r->fields['status']
			);

			$r->MoveNext();

			}
			$this->assertEquals($info, $this->fixture->getVolHoursAndRate('fchxp-3', 'null'));
	}
	public function testGetPosition()
	{

		$test1 = $this->fixture->getPosition('pos420');
		$expected = array ('numVolunteers'=>'0');
		$this->assertEquals($expected, $test1);

		//$test2 = $this->fixture->getProject('489sp-76');
		//$this->assertFalse($test2);

		//$result = $this->$this->execute("select count(*) numVolunteers from vm_vol_assignment_active where pos_id = 'pos420'");
		//$expected['numVolunteers']=$result->fields['numVolunteers'];
		//$this->assertFalse($test2['numVolunteers'], $expected['numVolunteers']);
	}

	public function testIsSiteManager()
	{
		$this->assertTrue($this->fixture->isSiteManager('fchxp-5'));
		$this->assertFalse($this->fixture->isSiteManager('fchxp-6'));
		$this->assertFalse($this->fixture->isSiteManager('489sp-16'));
	}


	public function testGetOrganizationInfo()
	{
		$test1 = $this->fixture->getOrganizationInfo('test5');
		$this->assertEquals(array('name'=>'Org Name'), $test1);

		$test2 = $this->fixture->getOrganizationInfo('test2');
		$this->assertEquals(array(), $test2);

	}

		private function orgResultEntryIsAccurate($result_entry, $o_uuid, $search_result=false)
	{
		// name
		$r = $this->fixture->execute("SELECT name FROM org_main WHERE o_uuid = '$o_uuid'");

		if($result_entry != $r->fields['name'])
		{
			echo "Organization $o_uuid's name is inaccurate\r\n";
			return false;
		}

		return true;

	}

	private function orgResultsAreAccurate($results, $expected_org_ids, $search_results=false)
	{

		foreach ($results as $o_uuid =>$entry)
		{
			if(!$this->orgResultEntryIsAccurate($entry, $o_uuid, $search_results))
				return false;
		}
		foreach($expected_org_ids as $o_uuid)
		{
			if(!in_array($o_uuid, array_keys($results)))
			{
				echo "Expected org_ids are inaccurate\r\n";
				return false;
			}
		}

		return true;
	}

	public function testGetOrganizations() {

		$r = $this->fixture->execute("SELECT o_uuid FROM org_main");
		$expected_orgs = array();
		while(!$r->EOF)
		{
			$expected_orgs[] = $r->fields['o_uuid'];
			$r->moveNext();
		}
		$this->assertTrue($this->orgResultsAreAccurate($this->fixture->getOrganizations(), $expected_orgs));


	}

	private function projResultEntryIsAccurate($result_entry, $proj_id, $search_result=false)
	{
		// name

		$r = $this->fixture->execute("SELECT name FROM vm_projects WHERE proj_id = '$proj_id'");
		if($result_entry['name'] != $r->fields['name'])
		{
			echo "Project $proj_id's name is inaccurate\r\n";
			return false;
		}

		//description
		$r = $this->fixture->execute("SELECT description FROM vm_projects WHERE proj_id = '$proj_id'");
		if($result_entry['description'] != $r->fields['description'])
		{
			echo "Project $proj_id's description is inaccurate\r\n";
			return false;
		}

		return true;

	}

	private function projResultsAreAccurate($results, $expected_proj_ids, $search_results=false)
	{
		foreach ($results as $proj_id =>$entry)
		{
			if(!$this->projResultEntryIsAccurate($entry, $proj_id, $search_results))
				return false;
		}
		foreach($expected_proj_ids as $proj_id)
		{
			if(!in_array($proj_id, array_keys($results)))
			{
				echo "Expected proj_ids are inaccurate\r\n";
				return false;
			}
		}

		return true;
	}


	public function testListPositions()
	{
		//list all positions
		$r= $this->fixture->execute("SELECT pos_id, proj_id,project_name, ptype_id, slots, title, description, ptype_title, ptype_description, skill_code FROM vm_vol_assignment ORDER BY proj_id ");
		$expected = array();
		while (!$r->EOF)
		{
			$this->fixture->remove_keys($r->fields);
			$expected[] =$r->fields;
			$r->moveNext();
		}

		$this->assertEquals($this->fixture->listPositions(null, null), $expected);

		/*$r= $this->fixture->execute("SELECT pos_id, proj_id,project_name, ptype_id, slots, title, description, ptype_title, ptype_description, skill_code FROM vm_vol_assignment WHERE p_uuid = '$p_uuid' AND status = 'active' ORDER BY proj_id ");
		$expected_projs = array();
		while (!$r->EOF)
		{

			$this->fixture->remove_keys($r->fields);
			$expected_projs[] =$r->fields;
			$r->moveNext();
		}
		$this->assertEquals($this->fixture->listProjects(null, 'fchxp-3'), $expected_projs);

		$r= $this->fixture->execute("SELECT pos_id, proj_id,project_name, ptype_id, slots, title, description, ptype_title, ptype_description, skill_code FROM vm_vol_assignment WHERE proj_id = '$proj_id' ORDER BY proj_id ");
		$expected_projs = array();
		while (!$r->EOF)
		{
			$this->fixture->remove_keys($r->fields);
			$expected_projs[] =$r->fields;
			$r->moveNext();
		}
		$this->assertEquals($this->fixture->listProjects('30', null), $expected_projs);

		$r= $this->fixture->execute("SELECT pos_id, proj_id,project_name, ptype_id, slots, title, description, ptype_title, ptype_description, skill_code FROM vm_vol_assignment WHERE proj_id = '$proj_id' AND p_uuid = '$p_uuid' ORDER BY proj_id ");
		$expected_projs = array('');
		while (!$r->EOF)
		{
			$this->fixture->remove_keys($r->fields);
			$expected_projs[] =$r->fields;
			$r->moveNext();
		}
		$this->assertEquals($this->fixture->listProjects('30', 'fchxp-7'), $expected_projs);*/


	}

	public function testListProjects()
	{


    	$result = $this->fixture->execute("SELECT proj_id, name, description FROM vm_projects_active");
		$projects = array();
		while(!$result->EOF)
		{
			if($simple)
				$projects[$result->fields['proj_id']] = $result->fields['name'];
			else
				$projects[$result->fields['proj_id']] = array('name' => $result->fields['name'], 'description' => $result->fields['description']);
			$result->moveNext();
		}

		$this->assertEquals($projects, $this->fixture->listProjects(null, false, false));
	}

	public function testAssignToProject()
	{

		global $time;
		$this->fixture->assignToProject('jpt500', '5000');
		$result = $this->fixture->execute("SELECT p_uuid, proj_id, opt_skill_type FROM vm_vol_assignment WHERE p_uuid='jpt500'");
		$this->assertTrue(!$result->EOF);

		}


	public function testDeleteVolunteer()
	{

		$this->fixture->deleteVolunteer('jpt420');
		$result = $this->fixture->execute("SELECT status FROM vm_vol_details WHERE p_uuid = 'jpt420'");
		//$result2 = $this->fixture->execute("SELECT status FROM vm_vol_assigment WHERE p_uuid = 'jpt420'");

		$ptypes = array();
		while(!$result->EOF) {
			$this->fixture->remove_keys($result->fields);
			$ptypes[] = $result->fields;
			$result->moveNext();
		}

		//$ptypes2 = array();
		//while(!$result2->EOF) {
			//$this->fixture->remove_keys($result2->fields);
			//$ptypes2[] = $result2->fields;
			///$result2->moveNext();
		//}
		$this->assertEquals($ptypes,array('0' => Array( 'status' => 'retired')));
	}

	public function testDeleteProject()
	{
		$this->fixture->deleteProject('4201');

		$result = $this->fixture->execute("SELECT status FROM vm_projects WHERE proj_id = '4201'");
		$ptypes = array();
		while(!$result->EOF) {
			$this->fixture->remove_keys($result->fields);
			$ptypes[] = $result->fields;
			$result->moveNext();
		}
		$this->assertEquals($ptypes,array('0' => Array( 'status' => 'completed')));

		/*$result2 = $this->fixture->execute("SELECT status FROM vm_vol_assignment WHERE proj_id = '42000'");
		$ptypes = array();
				while(!$result->EOF) {
			$this->fixture->remove_keys($result->fields);
			$ptypes[] = $result->fields;
			$result->moveNext();
		}

		$this->assertEquals($ptypes,array('0' => Array( 'status' => 'retired')));
		*/
	}

	public function testRemovePosition() {

   		$this->fixture->removePosition('pos420');
    	$result = $this->fixture->execute ("SELECT status FROM vm_position WHERE pos_id = 'pos420'");
       	$this->fixture->remove_keys($result->fields);
    	$this->assertEquals($result->fields, array ('status'=>'retired'));
    }


    public function testGetlistPositionTypes() {



    	$result = $this->fixture->listPositionTypes();
    	$resultshouldbe = $this->fixture->execute ("SELECT ptype_id, title, description, skill_code FROM vm_positiontype");
    	$expected = array();
		while(!$resultshouldbe->EOF) {
			$this->fixture->remove_keys($resultshouldbe->fields);
			$expected[] = $resultshouldbe->fields;
			$resultshouldbe->moveNext();
		}
		$this->assertEquals($result, $expected);


    }

	public function testListPositionTypes() {
		$result = $this->fixture->execute("select ptype_id, title, description, skill_code from vm_positiontype");
		$ptypes = array();
		while(!$result->EOF) {
			$this->fixture->remove_keys($result->fields);
			$ptypes[] = $result->fields;
			$result->moveNext();
		}
		$actualfunc = $this->fixture->listPositionTypes();
		$this->assertEquals($ptypes,$actualfunc);
	}

	public function testDeleteFromProject()
	{
		global $time;

		$this->fixture->deleteFromProject('jpt420', '4200');

		$time = $this->fixture->execute("SELECT NOW()");
		$result = $this->fixture->execute("SELECT status FROM vm_vol_assignment WHERE proj_id ='4200' AND p_uuid = 'jpt420'");
		$ptypes = array();
		while(!$result->EOF) {
			$this->fixture->remove_keys($result->fields);
			$ptypes[] = $result->fields;
			$result->moveNext();
		$this->assertEquals($ptypes,array('0' => Array( 'status' => 'retired')));
	}
	}

	public function testGetToList()
	{
		$result = $this->fixture->getToList('1000');
		$this->assertEquals($result, array('to_id_1'=>'Full Name'));

		$result = $this->fixture->getToList('1001');
		$this->assertEquals($result, array('to_id_1'=>'Full Name', 'to_id_2'=>'Full Name 2', 'to_id_3'=>'Full Name 3'));

		$result = $this->fixture->getToList('1002');
		$this->assertEquals($result, array());

		$result = $this->fixture->getToList('1003');
		$this->assertEquals($result, array());
	}


	public function testGetMessage()
	{
		$result = $this->fixture->getMessage('test3', '1000', true);
		unset($result['time']);
		$this->assertEquals($result, array('from_id'=>'from_id', 'message_id'=>'1000', 'message'=>'message text', 'checked'=>'0'));
		$test_checked = $this->fixture->execute("SELECT checked FROM vm_mailbox WHERE p_uuid = 'test3' AND message_id = '1000' AND box = '0'");
		$this->assertEquals($test_checked->fields['checked'], '1');

		$result = $this->fixture->getMessage('test1', '1010', 'true');
		$this->assertEquals($result, array());

		$result = $this->fixture->getMessage('test2', '1000', 'true');
		$this->assertEquals($result, array());

		$result = $this->fixture->getMessage('test3', '1000', false);
		unset($result['time']);
		$this->assertEquals($result, array('from_id'=>'from_id', 'message_id'=>'1000', 'message'=>'message text', 'checked'=>'0'));
		$test_checked = $this->fixture->execute("SELECT checked FROM vm_mailbox WHERE p_uuid = 'test3' AND message_id = '1000' AND box = '1'");
		$this->assertEquals($test_checked->fields['checked'], '1');
	}


	public function testSendMessage()
	{
		$this->fixture->sendMessage('from_id_10', array('to_id_10'), 'message text 2');

		$result =$this->fixture->execute("SELECT message FROM vm_message WHERE message='message text 2'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields,array('message'=>'message text 2'));

		$result =$this->fixture->execute("SELECT to_id, from_id FROM vm_courier WHERE to_id = 'to_id_10'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('to_id'=>'to_id_10', 'from_id'=>'from_id_10'));

		$result =$this->fixture->execute("SELECT p_uuid, box, checked FROM vm_mailbox WHERE p_uuid = 'to_id_10'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('p_uuid'=>'to_id_10', 'box'=>'0', 'checked'=>'0'));

		$result =$this->fixture->execute("SELECT p_uuid, box, checked FROM vm_mailbox WHERE p_uuid = 'from_id_10'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('p_uuid'=>'from_id_10', 'box'=>'1', 'checked'=>'0'));

	//test send message to multiple recepients
		$this->fixture->sendMessage('from_id_15', array('to_id_14', 'to_id_15'), 'message text 3');

		$result =$this->fixture->execute("SELECT message FROM vm_message WHERE message='message text 3'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields,array('message'=>'message text 3'));

		$result =$this->fixture->execute("SELECT to_id, from_id FROM vm_courier WHERE to_id = 'to_id_14'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('to_id'=>'to_id_14', 'from_id'=>'from_id_15'));

		$result =$this->fixture->execute("SELECT to_id, from_id FROM vm_courier WHERE to_id = 'to_id_15'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('to_id'=>'to_id_15', 'from_id'=>'from_id_15'));

		$result =$this->fixture->execute("SELECT p_uuid, box, checked FROM vm_mailbox WHERE p_uuid = 'to_id_14'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('p_uuid'=>'to_id_14', 'box'=>'0', 'checked'=>'0'));

		$result =$this->fixture->execute("SELECT p_uuid, box, checked FROM vm_mailbox WHERE p_uuid = 'to_id_15'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('p_uuid'=>'to_id_15', 'box'=>'0', 'checked'=>'0'));

		$result =$this->fixture->execute("SELECT p_uuid, box, checked FROM vm_mailbox WHERE p_uuid = 'from_id_15'");
		$this->fixture->remove_keys($result->fields);
		$this->assertEquals($result->fields, array('p_uuid'=>'from_id_15', 'box'=>'1', 'checked'=>'0'));

	}


	public function testDeleteMessage()
	{
		$this->fixture->deleteMessage('test3', '1000', true);

		$result = $this->fixture->execute("SELECT p_uuid FROM vm_mailbox WHERE p_uuid = 'test3' AND message_id ='1000' AND box = '0'");
		$this->assertTrue($result->EOF);

		$this->fixture->deleteMessage('test3', '1000', false);

		$result = $this->fixture->execute("SELECT p_uuid FROM vm_mailbox WHERE p_uuid = 'test3' AND message_id ='1000' AND box = '1'");
		$this->assertTrue($result->EOF);
	}


	public function testGetMessages()
	{
		//messages from inbox
		$result= $this->fixture->getMessages('to_id_1');
		$expected = array(0=>array('from_id'=>'from_id', 'message_id'=>'2000', 'time'=>'2007-06-15 17:32:29','message'=>'next message', 'checked'=>'0'), 1=>array('from_id'=>'from_id', 'message_id'=>'1000', 'time'=>'2007-06-15 17:32:20','message'=>'message text', 'checked'=>'0'));
		$this->assertEquals($result, $expected);

		//messages from outbox
		$result= $this->fixture->getMessages('from_id', false);
		$expected = array(0=>array('message_id'=>'2000', 'time'=>'2007-06-15 17:32:29','message'=>'next message', 'checked'=>'0'), 1=>array('message_id'=>'1000', 'time'=>'2007-06-15 17:32:20','message'=>'message text', 'checked'=>'0'));
		$this->assertEquals($result, $expected);

		//no  messages in inbox
		$result= $this->fixture->getMessages('from_id');
		$this->assertEquals($result,array());

	}

	public function testGetUnreadMessages()
	{
		$result = $this->fixture->getUnreadMessages('to_id_1');
		$this->assertEquals($result, 2);

		$result = $this->fixture->getUnreadMessages('from_id');
		$this->assertEquals($result, 0);
	}


	public function testRemoveSkill() {
		$result = $this->fixture->execute("select * from field_options where field_name = 'opt_skill_type' and option_code = 'skl1'");
		$this->assertFalse($result->EOF);
		$this->fixture->removeSkill('skl1');
		$result = $this->fixture->execute("select * from field_options where field_name = 'opt_skill_type' and option_code = 'skl1'");
		$this->assertTrue($result->EOF);

		$result = $this->fixture->execute("select * from field_options where field_name = 'opt_skill_type' and option_code = 'skl2'");
		$this->assertFalse($result->EOF);
		$this->fixture->removeSkill('skl2');
		$result = $this->fixture->execute("select * from field_options where field_name = 'opt_skill_type' and option_code = 'skl2'");
		$this->assertTrue($result->EOF);
	}

	public function testAddSkill() {
		$result = $this->fixture->execute("select * from field_options where option_code = 'opt_skill_type' and field_name = 'skl3'");
		$this->assertTrue($result->EOF);
		$this->fixture->addSkill('skl3', 'Skill3');
		$result = $this->fixture->execute("select option_code, field_name, option_description from field_options where option_code = 'skl3' and field_name = 'opt_skill_type'");
		$this->assertEquals($result->fields['option_code'], 'skl3');
		$this->assertEquals($result->fields['field_name'], 'opt_skill_type');
		$this->assertEquals($result->fields['option_description'], 'Skill3');
	}

	public function testGetSkillIDs() {
		$result = $this->fixture->getSkillIDs();
		$expected = $this->fixture->execute("SELECT option_code FROM field_options WHERE field_name = 'opt_skill_type'");
		if(!$expected -> EOF)
		{
			while(!$expected->EOF)
			{
				$this->assertTrue(in_array($expected->fields['option_code'], $result));
				$expected->MoveNext();
			}
		}
		else
			$this->assertTrue(empty($result));
	}

	public function testGetPictureID() {
		$this->assertEquals($this->fixture->getPictureID('usr1'), 'img1');
		$this->assertFalse($this->fixture->getPictureID('usr2'));
	}

	public function testGetVMPicture() {
		$result = $this->fixture->getVMPicture('ant_pic');
		$result[0] = md5($result[0]);
		$result[1] = md5($result[1]);
		$expected = array(
			md5(file_get_contents('ant_pic.jpg')),
			md5(file_get_contents('ant_thumb.jpg')),
			'ant_guy',
			320, 240,
			160, 120,
			'image/jpeg',
			'ant.jpeg'
		);
		$this->assertEquals($result, $expected);
		$this->assertFalse($this->fixture->getVMPicture('img6'));
	}

	public function testSaveVMPicture() {
		$pic = new VMPicture();
		$pic->original = file_get_contents('ant_pic.jpg');
		$pic->resize();
		$pic->img_uuid = 'save_test';
		$pic->p_uuid = 'save_test_person';
		$pic->name = 'ant.jpg';
		$this->fixture->saveVMPicture($pic);
		$expected = array(
			// this is likely a bad idea, as small changes in gd will break it.
			// probably the only way to test generated images without getting complex.
			'fbfa2f68b52b8ccd8d24b7b31c90d7d4',
			'e4687afe05b6d5c4539b9f1b3b92f95c',
			'save_test_person',
			320, 240,
			160, 120,
			'image/jpeg',
			'ant.jpg'
		);
		$result = $this->fixture->getVMPicture('save_test');
		$result[0] = md5($result[0]);
		$result[1] = md5($result[1]);
		$this->assertEquals($result, $expected);
	}

	public function testDeletePicture() {
		$result = $this->fixture->execute("select * from vm_image");
		$this->assertFalse($result->EOF);
		$this->fixture->deletePicture('img1');
		$result = $this->fixture->execute("select * from vm_image where img_uuid = 'img1'");
		$this->assertTrue($result->EOF);
	}

	public function testGenerateSelectPhoneticClauses()
	{
		$result = $this->fixture->generateSelectPhoneticClauses('Volunteer1 One');
		$expected = " ( encode1 = '".soundex('Volunteer1')."' OR  encode2 = '".metaphone('Volunteer1')."' OR  encode1 = '".soundex('One')."' OR  encode2 = '".metaphone('One')."' ) ";
		$this->assertEquals($result, $expected);

		$result = $this->fixture->generateSelectPhoneticClauses('Volunteer1', true);
		$expected = " ( encode2 LIKE '%".metaphone('Volunteer1'). "%' OR '".metaphone('Volunteer1')."' LIKE  concat('%', encode2, '%') ) ";
		$this->assertEquals($result, $expected);

		$result = $this->fixture->generateSelectPhoneticClauses('', true);
		$expected = '';
		$this->assertEquals($result, $expected);

	}

	public function testGetSkillList() {
		$result = $this->fixture->getSkillList();
		$expected = $this->fixture->execute("SELECT option_code, option_description FROM field_options WHERE field_name = 'opt_skill_type'");
		if(!$expected -> EOF)
		{
			//make sure each skill code and description lines up

			while(!$expected->EOF)
			{
				$this->assertEquals($result[$expected->fields['option_code']], $expected->fields['option_description']);
				$expected->MoveNext();
			}

			//make sure there is the same number

			$expected_num = $this->fixture->execute("SELECT COUNT(*) FROM field_options WHERE field_name = 'opt_skill_type'");
			$this->assertEquals($expected_num->fields[0], count($result));
		}
		else
			$this->assertTrue(empty($result));
	}

	public function testGetPossibleAccessConstraints()
	{

		$count = 0;

		foreach($this->fixture->getPossibleAccessConstraints() as $constraint_id => $entry)
		{
			$description = $this->fixture->execute("SELECT description FROM vm_access_constraint WHERE constraint_id = '$constraint_id'");
			$this->assertEquals($entry, $description->fields['description']);
			$count++;
		}

		$r = $this->fixture->execute("SELECT COUNT(*) count FROM vm_access_constraint");
		$this->assertTrue($count == $r->fields['count']);
	}


	public function testGetAccessRequests()
	{

		$count = 0;
		foreach($this->fixture->getAccessRequests() as $act => $info)
			foreach($info as $vm_action => $desc)
			{
				$description = $this->fixture->execute("SELECT description from vm_access_request WHERE act = '$act' AND vm_action = '$vm_action'");
				$this->assertEquals($desc, $description->fields['description']);
				$count++;
			}

		$r = $this->fixture->execute("SELECT COUNT(*) count FROM vm_access_request");
		$this->assertTrue($count == $r->fields['count']);

	}


	public function testGetSpecificAccessRequestConstraints()
	{
		$result = $this->fixture->getSpecificAccessRequestConstraints('act_test1', 'vm_action_test1');
		$expected =
		array
		(
			'extra'	=>	array('constraint1'),
			'tables' => array()
		);
		$this->assertEquals($result, $expected);

		$result = $this->fixture->getSpecificAccessRequestConstraints(null,null);
		$this->assertEquals($result, array('tables'=>array(), 'extra'=>array()));

	}

	public function testGetAccessRequestDescription()
	{
		$result = $this->fixture->getAccessRequestDescription('act_test1', 'vm_action_test1');
		$this->assertEquals($result, 'description1');

		$result = $this->fixture->getAccessRequestDescription(null,null);
		$this->assertEquals($result, NULL);
	}

	public function testGetDBTables() {


		$functionresult=$this->fixture->getDBTables();
		$expectedtables = array();
		$result = $this->fixture->execute("SHOW TABLES");
		while(!$result->EOF)
		{
			$expectedtables[]=$result->fields[0];
			$result->MoveNext();
		}
		$this->assertEquals($functionresult, $expectedtables);
	}

	public function testGetAccessRequestConstraints()
		{
			$count = 0;
			foreach($this->fixture->getAccessRequestConstraints() as $act => $info)
				foreach($info as $vm_action => $info)
				{
					if(isset($info['extra']))
					{
						$r = $this->fixture->execute(	"SELECT constraint_id
														 FROM vm_access_constraint_to_request
														 WHERE request_id =
														 (SELECT request_id
														 FROM vm_access_request
														 WHERE act = '$act' AND vm_action = '$vm_action')");
						while(!$r->EOF)
						{
							$this->assertTrue(in_array($r->fields['constraint_id'], $info['extra']));
							$r->MoveNext();
							$count++;
						}
					}

					if(isset($info['tables']))
					{
						$r = $this->fixture->execute(	"SELECT table_name, crud
														 FROM vm_access_classification_to_request
														 WHERE request_id =
														 (SELECT request_id
														 FROM vm_access_request
														 WHERE act = '$act' AND vm_action = '$vm_action')");
						while(!$r->EOF)
						{
							$this->assertTrue($info['tables'][$r->fields['table_name']] == $r->fields['crud']);
							$r->MoveNext();
							$count++;
						}
					}
				}

			$r = $this->fixture->execute(	"SELECT COUNT(*) count
											 FROM vm_access_constraint_to_request
											 WHERE request_id IN (SELECT request_id FROM vm_access_request)

											 UNION

											 SELECT COUNT(*)
											 FROM vm_access_classification_to_request
											 WHERE request_id IN (SELECT request_id FROM vm_access_request)");
			$actual_count = $r->fields['count'];
			$r->MoveNext();
			$actual_count += $r->fields['count'];

			$this->assertEquals($count, $actual_count);
		}

		public function testAddConstraint()
		{
			$this->fixture->addConstraint('act_test1', 'vm_action_test1', 'constraint3');
			$result = $this->fixture->execute("SELECT request_id, constraint_id FROM vm_access_constraint_to_request WHERE constraint_id = 'constraint3'");
			$this->fixture->remove_keys($result->fields);
			$this->assertEquals($result->fields, array('request_id'=>'10000', 'constraint_id'=>'constraint3'));

			$this->fixture->addConstraint('act_test4', 'vm_action_test1', 'constraint4');
			$result = $this->fixture->execute("SELECT request_id, constraint_id FROM vm_access_constraint_to_request WHERE constraint_id = 'constraint4'");
			$this->assertTrue($result->EOF);
		}

		public function testRemoveConstraints()
		{
			$this->fixture->removeConstraints('act_test1', 'vm_action_test1');
			$result = $this->fixture->execute("SELECT request_id, constraint_id FROM vm_access_constraint_to_request WHERE request_id =
												(SELECT request_id FROM vm_access_request WHERE act = 'act_test1' AND vm_action = 'vm_action_test1')");
			$this->assertTrue($result->EOF);
		}


		 public function testGetSkillsAndDescriptions()
		 {
		 	$result = $this->fixture->getSkillsAndDescriptions('xyz-60');
		 	$expected = array
						(
						    'WAR1' => 'Unskilled-Warehouse-Forklift',
						 );

		 	$this->assertEquals($result, $expected);

		 	$result = $this->fixture->getSkillsAndDescriptions(null);
		 	$this->assertEquals($result, array());

		 }

		 public function testGetVolunteerNames(){

		 	$result = $this->fixture->execute("SELECT person_uuid.p_uuid, full_name FROM vm_vol_details JOIN person_uuid USING(p_uuid) WHERE status  = 'active' ");
			$vols = array();
			while(!$result->EOF)
			{
				$vols[$result->fields['p_uuid']] = $result->fields['full_name'];
				$result->moveNext();
			}
			$this->assertEquals($vols, $this->fixture->getVolunteerNames('false'));

		}


		public function testLogShift(){

			 $this->fixture->logshift('fchxp-3600', '11', '2020-01-03 09:30:00', '2020-01-06 11:00:00');
			 $result=$this->fixture->execute("SELECT shift_start FROM vm_hours WHERE p_uuid='fchxp-3600'");
			 $this->assertFalse($result->EOF);
             $this->fixture->execute("DELETE FROM vm_hours WHERE p_uuid='fchxp-3600' AND pos_id='11' ");
			 $this->fixture->logshift('fchxp-3600', '', '', '2020-01-06 11:00:00');
			 $result=$this->fixture->execute("SELECT shift_id FROM vm_hours WHERE p_uuid='fchxp-3600' AND shift_end = '2020-01-06 11:00:00'");
		     $this->assertTrue($result->EOF);

		}

}
?>