<?php
/**
* AccessControllerTest
*
* PHP version 5
*
* LICENSE: This source file is subject to LGPL license
* that is available through the world-wide-web at the following URI:
* http://www.gnu.org/copyleft/lesser.html
*
* @author       Antonio Alcorn
* @author       Giovanni Capalbo
* @author		Sylvia Hristakeva
* @author		Kumud Nepal
* @author		Ernel Wint
* @copyright    Lanka Software Foundation - http://www.opensource.lk
* @copyright    Trinity Humanitarian-FOSS Project - http://www.cs.trincoll.edu/hfoss
* @package      sahana
* @subpackage   vm
* @tutorial
* @license        http://www.gnu.org/copyleft/lesser.html GNU Lesser General
* Public License (LGPL)
*/


// Call AccessControllerTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "AccessControllerTest::main");
}

/**
 * Test class for AccessController.
 * Generated by PHPUnit_Util_Skeleton on 2007-06-19 at 11:08:45.
 */
class AccessControllerTest extends PHPUnit_Framework_TestCase {

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {

    	global $global,$dao;
    	$global=array('approot'=>realpath(dirname(__FILE__)).'/../../../');
		require_once($global['approot'].'3rd/adodb/adodb.inc.php');

    	//Make the connection to $global['db']
		$global['db'] = NewADOConnection('mysql');
		$global['db']->Connect(TEST_DB_HOST, TEST_DB_USER,TEST_DB_PASSWD,TEST_DB_NAME);
		error_reporting(E_ALL ^ E_NOTICE);
		$dao = new DAO($global['db']);

    	require_once('../main.inc');
    	shn_vm_load_db();
    	$this->fixture = new AccessController();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

	public function testIsAuthorized()
	{
	//user MainOps, act - volunteer, vm_action - listVolunteers
		$_SESSION['user_id'] = '489sp-15';
		$this->assertTrue($this->fixture->isAuthorized(true, array('act'=>'volunteer', 'vm_action' =>'listVolunteers')));

	//user MainOps, act - notInList(volunteer), vm_action - notInList (default)
		$this->assertTrue($this->fixture->isAuthorized(true, array('act'=>'notInList', 'vm_action' =>'delete')));

	//user Admin
		unset($_SESSION);
		$_SESSION['user_id'] = '489sp-13';
		$this->assertFalse($this->fixture->isAuthorized(false, array('act'=>'project', 'vm_action' =>'delete')));
		$this->assertTrue($this->fixture->isAuthorized(true, array('act'=>'volunteer', 'vm_action' =>'search', 'proj_id' => '7')));
		$this->assertTrue($this->fixture->isAuthorized(true, array('act'=>'volunteer', 'vm_action' =>'listVolunteers', 'proj_id' => '7')));
		$_SESSION['logged_in'] = true;
		$this->assertTrue($this->fixture->isAuthorized(true, array('act'=>'volunteer', 'vm_action' =>'changePass')));
		$this->assertTrue($this->fixture->isAuthorized(true, array('act'=>'project', 'vm_action' =>'listMyProjects')));
		unset($_SESSION['logged_in']);
		$this->assertTrue($this->fixture->isAuthorized(true, array('p_uuid'=>'489sp-13', 'act'=>'volunteer', 'vm_action' =>'edit')));

		$this->assertFalse($this->fixture->isAuthorized(false, array('act'=>'volunteer', 'vm_action' =>'delete')));
	}

 	public function testDataAccessIsAuthorized()
 	{
 		$_SESSION['user_id'] = '489sp-15';;
 		$this->assertTrue($this->fixture->dataAccessIsAuthorized($this->fixture->access['volunteer']['listVolunteers']['tables']));

 		unset($_SESSION['user_id']);
 		$_SESSION['user_id'] = '489sp-13';
 		$this->assertTrue($this->fixture->dataAccessIsAuthorized($this->fixture->access['project']['disp_proj']['tables']));
 		$this->assertFalse($this->fixture->dataAccessIsAuthorized($this->fixture->access['volunteer']['search']['tables'], false));
 		$this->assertFalse($this->fixture->dataAccessIsAuthorized($this->fixture->access['volunteer']['confirmDelete']['tables'], false));
 	}

}


?>