/*
** (c) Copyright 2003-2005 Matt Messier and John Viega
** All rights reserved.
** 
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
** 
** Redistributions of source code must retain the above copyright notice,
** this list of conditions and the following disclaimer.
** 
** Redistributions in binary form must reproduce the above copyright
** notice, this list of conditions and the following disclaimer in the
** documentation and/or other materials provided with the distribution.
** 
** Neither the name of the primary nor the names of the contributors may
** be used to endorse or promote products derived from this software
** without specific prior written permission.
** 
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef ISAFESTR_H
#define ISAFESTR_H

#ifndef WIN32
#include "config.h"
#include "safestr.h"

#if defined(STDC_HEADERS)
#include <stdlib.h>
#include <string.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#else
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif
#include <windows.h>
#include <wincrypt.h>
#include <limits.h>
#include "safestr.h"
#endif

#define XXL_ENFORCE_PREFIX
#include <xxl.h>

/* Reference counting macros */
#define REF_COUNT(x)        (x)->hdr.refs
#define INC_REF_COUNT(x)    (x)->hdr.refs++
#define DEC_REF_COUNT(x)    (x)->hdr.refs--

/* Internal string header flags */
#define SAFESTR_ORIGINAL    0x00000100
#define SAFESTR_RESIZED     0x00000200

#define SAFESTR_ASSET_MASK  0x00000030

/* Flags for safestr_get() */
#define SAFESTR_GET_READONLY    0x00000000
#define SAFESTR_GET_WRITABLE    0x00000001

typedef struct small_isafestr_struct_t
{
    /* Number of characters you have room for in the string.  That is, this
     * number is the total allocated size minus the length of the header and
     * the byte for the NUL terminating character.
     */
    u_int32_t           size;     
    u_int32_t           length;   
    u_int32_t           flags;
    u_int32_t           refs;
    u_int32_t           cookie;
} small_isafestr_t;

typedef struct isafestr_struct_t
{
    small_isafestr_t    hdr;
    char                str[1];
} *isafestr_t;

#define SAFESTR_ROUND(x)    ((((x) + 127) / 128) * 128)
#define SAFESTR_MAX(a, b)   ((a) > (b) ? (a) : (b))
#define SAFESTR_MIN(a, b)   ((a) > (b) ? (b) : (a))
#define SAFESTR_ABS(x)      ((x) < 0 ? -(x) : (x))

extern SAFESTR_API u_int32_t         safestr_cookie;
extern SAFESTR_API u_int64_t         safestr_maxlength;
extern SAFESTR_API safestr_malloc_t  safestr_malloc_fn;
extern SAFESTR_API safestr_realloc_t safestr_realloc_fn;
extern SAFESTR_API safestr_free_t    safestr_free_fn;

extern SAFESTR_API void *     safestr_malloc(size_t, xxl_assettype_t, const char *, unsigned int);
extern SAFESTR_API void *     safestr_realloc(void *, size_t, const char *, unsigned int);
extern SAFESTR_API isafestr_t safestr_get(safestr_t, u_int32_t);
extern SAFESTR_API isafestr_t safestr_resize(isafestr_t, u_int32_t);
extern SAFESTR_API safestr_t  safestr_complete(isafestr_t, isafestr_t);

extern SAFESTR_API unsigned char safestr_casemap_none[256];
extern SAFESTR_API unsigned char safestr_casemap_upper[256];
extern SAFESTR_API unsigned char safestr_casemap_lower[256];

#endif
