/* rygel-basic-management-test-ping.c generated by valac 0.26.0.3-ba43c, the Vala compiler
 * generated from rygel-basic-management-test-ping.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;
typedef struct _RygelBasicManagementTestPingPrivate RygelBasicManagementTestPingPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_TYPE_PROCESS_STATE (rygel_basic_management_test_ping_process_state_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_TYPE_STATUS (rygel_basic_management_test_ping_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestPing {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestPingPrivate * priv;
};

struct _RygelBasicManagementTestPingClass {
	RygelBasicManagementTestClass parent_class;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT
} RygelBasicManagementTestPingProcessState;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER
} RygelBasicManagementTestPingStatus;

struct _RygelBasicManagementTestPingPrivate {
	gchar* _host;
	guint _repeat_count;
	guint _data_block_size;
	guint _dscp;
	guint32 _interval_time_out;
	RygelBasicManagementTestPingProcessState state;
	RygelBasicManagementTestPingStatus status;
	gchar* additional_info;
	guint success_count;
	guint failure_count;
	guint32 avg_response_time;
	guint32 min_response_time;
	guint32 max_response_time;
};


static gpointer rygel_basic_management_test_ping_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST;
static GType rygel_basic_management_test_ping_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ping_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE
};
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT ((guint) 1)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE ((guint) 32)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP ((guint) 30)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT ((guint) 1000)
static gchar* rygel_basic_management_test_ping_status_to_string (RygelBasicManagementTestPingStatus self);
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT ((guint) 100)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPLY_TIMEOUT ((guint) 10000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT ((guint) 30000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE ((guint) 20)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP ((guint) 64)
RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
static void rygel_basic_management_test_ping_real_constructed (GObject* base);
guint rygel_basic_management_test_ping_get_repeat_count (RygelBasicManagementTestPing* self);
guint32 rygel_basic_management_test_ping_get_interval_time_out (RygelBasicManagementTestPing* self);
guint rygel_basic_management_test_ping_get_data_block_size (RygelBasicManagementTestPing* self);
guint rygel_basic_management_test_ping_get_dscp (RygelBasicManagementTestPing* self);
const gchar* rygel_basic_management_test_ping_get_host (RygelBasicManagementTestPing* self);
static gboolean rygel_basic_management_test_ping_real_finish_iteration (RygelBasicManagementTest* base);
gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_ping_real_handle_error (RygelBasicManagementTest* base, const gchar* line);
static void rygel_basic_management_test_ping_real_handle_output (RygelBasicManagementTest* base, const gchar* line);
void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar** status, gchar** additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time);
static void rygel_basic_management_test_ping_set_host (RygelBasicManagementTestPing* self, const gchar* value);
static void rygel_basic_management_test_ping_set_repeat_count (RygelBasicManagementTestPing* self, guint value);
static void rygel_basic_management_test_ping_set_data_block_size (RygelBasicManagementTestPing* self, guint value);
static void rygel_basic_management_test_ping_set_dscp (RygelBasicManagementTestPing* self, guint value);
static void rygel_basic_management_test_ping_set_interval_time_out (RygelBasicManagementTestPing* self, guint32 value);
static void rygel_basic_management_test_ping_finalize (GObject* obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_ping_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_test_ping_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType rygel_basic_management_test_ping_process_state_get_type (void) {
	static volatile gsize rygel_basic_management_test_ping_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS", "statistics"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT", "rtt"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ping_process_state_type_id;
		rygel_basic_management_test_ping_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestPingProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_ping_process_state_type_id__volatile, rygel_basic_management_test_ping_process_state_type_id);
	}
	return rygel_basic_management_test_ping_process_state_type_id__volatile;
}


static gchar* rygel_basic_management_test_ping_status_to_string (RygelBasicManagementTestPingStatus self) {
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Error_CannotResolveHostName");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("Error_Internal");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("Error_Other");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GType rygel_basic_management_test_ping_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_ping_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME", "error-cannot-resolve-hostname"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ping_status_type_id;
		rygel_basic_management_test_ping_status_type_id = g_enum_register_static ("RygelBasicManagementTestPingStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ping_status_type_id__volatile, rygel_basic_management_test_ping_status_type_id);
	}
	return rygel_basic_management_test_ping_status_type_id__volatile;
}


RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp) {
	RygelBasicManagementTestPing * self = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint32 _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = host;
	_tmp1_ = repeat_count;
	_tmp2_ = interval_time_out;
	_tmp3_ = data_block_size;
	_tmp4_ = dscp;
	self = (RygelBasicManagementTestPing*) g_object_new (object_type, "host", _tmp0_, "repeat-count", _tmp1_, "interval-time-out", _tmp2_, "data-block-size", _tmp3_, "dscp", _tmp4_, NULL);
	return self;
}


RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp) {
	return rygel_basic_management_test_ping_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, host, repeat_count, interval_time_out, data_block_size, dscp);
}


static void rygel_basic_management_test_ping_real_constructed (GObject* base) {
	RygelBasicManagementTestPing * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint32 _tmp9_ = 0U;
	guint32 _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	self = (RygelBasicManagementTestPing*) base;
	G_OBJECT_CLASS (rygel_basic_management_test_ping_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL;
	self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->additional_info);
	self->priv->additional_info = _tmp0_;
	self->priv->success_count = (guint) 0;
	self->priv->failure_count = (guint) 0;
	self->priv->avg_response_time = (guint32) 0;
	self->priv->min_response_time = (guint32) 0;
	self->priv->max_response_time = (guint32) 0;
	_tmp1_ = g_strdup ("ping");
	_tmp2_ = g_strdup ("-c");
	_tmp3_ = rygel_basic_management_test_ping_get_repeat_count (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
	_tmp6_ = g_strdup ("-W");
	_tmp7_ = g_strdup_printf ("%u", RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPLY_TIMEOUT / 1000);
	_tmp8_ = g_strdup ("-i");
	_tmp9_ = rygel_basic_management_test_ping_get_interval_time_out (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%u", _tmp10_ / 1000);
	_tmp12_ = g_strdup ("-s");
	_tmp13_ = rygel_basic_management_test_ping_get_data_block_size (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%u", _tmp14_);
	_tmp16_ = g_strdup ("-Q");
	_tmp17_ = rygel_basic_management_test_ping_get_dscp (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%u", _tmp18_ >> 2);
	_tmp20_ = self->priv->_host;
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = g_new0 (gchar*, 12 + 1);
	_tmp22_[0] = _tmp1_;
	_tmp22_[1] = _tmp2_;
	_tmp22_[2] = _tmp5_;
	_tmp22_[3] = _tmp6_;
	_tmp22_[4] = _tmp7_;
	_tmp22_[5] = _tmp8_;
	_tmp22_[6] = _tmp11_;
	_tmp22_[7] = _tmp12_;
	_tmp22_[8] = _tmp15_;
	_tmp22_[9] = _tmp16_;
	_tmp22_[10] = _tmp19_;
	_tmp22_[11] = _tmp21_;
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
	((RygelBasicManagementTest*) self)->command = _tmp22_;
	((RygelBasicManagementTest*) self)->command_length1 = 12;
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
	_tmp23_ = rygel_basic_management_test_ping_get_repeat_count (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT) {
		gchar* msg = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		guint _tmp28_ = 0U;
		gchar* _tmp29_ = NULL;
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
		_tmp25_ = g_strdup ("NumberOfRepetitions %u is not in allowed range [0, %u]");
		msg = _tmp25_;
		_tmp26_ = msg;
		_tmp27_ = rygel_basic_management_test_ping_get_repeat_count (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf (_tmp26_, _tmp28_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT);
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp29_;
		_g_free0 (msg);
	} else {
		gboolean _tmp30_ = FALSE;
		guint32 _tmp31_ = 0U;
		guint32 _tmp32_ = 0U;
		_tmp31_ = rygel_basic_management_test_ping_get_interval_time_out (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ < ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT)) {
			_tmp30_ = TRUE;
		} else {
			guint32 _tmp33_ = 0U;
			guint32 _tmp34_ = 0U;
			_tmp33_ = rygel_basic_management_test_ping_get_interval_time_out (self);
			_tmp34_ = _tmp33_;
			_tmp30_ = _tmp34_ > ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT);
		}
		if (_tmp30_) {
			gchar* msg = NULL;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			guint32 _tmp37_ = 0U;
			guint32 _tmp38_ = 0U;
			gchar* _tmp39_ = NULL;
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
			_tmp35_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
			msg = _tmp35_;
			_tmp36_ = msg;
			_tmp37_ = rygel_basic_management_test_ping_get_interval_time_out (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup_printf (_tmp36_, _tmp38_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp39_;
			_g_free0 (msg);
		} else {
			gboolean _tmp40_ = FALSE;
			guint _tmp41_ = 0U;
			guint _tmp42_ = 0U;
			_tmp41_ = rygel_basic_management_test_ping_get_data_block_size (self);
			_tmp42_ = _tmp41_;
			if (_tmp42_ < RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE) {
				_tmp40_ = TRUE;
			} else {
				guint _tmp43_ = 0U;
				guint _tmp44_ = 0U;
				_tmp43_ = rygel_basic_management_test_ping_get_data_block_size (self);
				_tmp44_ = _tmp43_;
				_tmp40_ = _tmp44_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE;
			}
			if (_tmp40_) {
				gchar* msg = NULL;
				gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				guint _tmp47_ = 0U;
				guint _tmp48_ = 0U;
				gchar* _tmp49_ = NULL;
				((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
				self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
				_tmp45_ = g_strdup ("DataBlockSize %u is not in allowed range [%u, %u]");
				msg = _tmp45_;
				_tmp46_ = msg;
				_tmp47_ = rygel_basic_management_test_ping_get_data_block_size (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup_printf (_tmp46_, _tmp48_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE);
				_g_free0 (self->priv->additional_info);
				self->priv->additional_info = _tmp49_;
				_g_free0 (msg);
			} else {
				guint _tmp50_ = 0U;
				guint _tmp51_ = 0U;
				_tmp50_ = rygel_basic_management_test_ping_get_dscp (self);
				_tmp51_ = _tmp50_;
				if (_tmp51_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP) {
					gchar* msg = NULL;
					gchar* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					guint _tmp54_ = 0U;
					guint _tmp55_ = 0U;
					gchar* _tmp56_ = NULL;
					((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
					_tmp52_ = g_strdup ("DSCP %u is not in allowed range [0, %u]");
					msg = _tmp52_;
					_tmp53_ = msg;
					_tmp54_ = rygel_basic_management_test_ping_get_dscp (self);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strdup_printf (_tmp53_, _tmp55_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP);
					_g_free0 (self->priv->additional_info);
					self->priv->additional_info = _tmp56_;
					_g_free0 (msg);
				}
			}
		}
	}
}


static gboolean rygel_basic_management_test_ping_real_finish_iteration (RygelBasicManagementTest* base) {
	RygelBasicManagementTestPing * self;
	gboolean result = FALSE;
	RygelBasicManagementTestInitState _tmp0_ = 0;
	gboolean _tmp2_ = FALSE;
	self = (RygelBasicManagementTestPing*) base;
	_tmp0_ = ((RygelBasicManagementTest*) self)->init_state;
	if (_tmp0_ == RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED) {
		gchar* _tmp1_ = NULL;
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL;
		_tmp1_ = g_strdup ("Failed to spawn ping");
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp1_;
	}
	_tmp2_ = RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ping_parent_class)->finish_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	result = _tmp2_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void rygel_basic_management_test_ping_real_handle_error (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestPing * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (RygelBasicManagementTestPing*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = string_contains (_tmp0_, "ping: unknown host");
	if (_tmp1_) {
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME;
	} else {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = line;
		_tmp3_ = string_contains (_tmp2_, "ping:");
		if (_tmp3_) {
			const gchar* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
			_tmp4_ = line;
			_tmp5_ = strlen ("ping:");
			_tmp6_ = _tmp5_;
			_tmp7_ = string_substring (_tmp4_, (glong) _tmp6_, (glong) (-1));
			_tmp8_ = _tmp7_;
			_tmp9_ = string_strip (_tmp8_);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp9_;
			_g_free0 (_tmp8_);
		}
	}
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void rygel_basic_management_test_ping_real_handle_output (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestPing * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelBasicManagementTestPingProcessState _tmp3_ = 0;
	self = (RygelBasicManagementTestPing*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->state;
	if (_tmp3_ == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT) {
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = line;
		_tmp5_ = string_contains (_tmp4_, "statistics ---");
		if (_tmp5_) {
			self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS;
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS;
		}
	} else {
		RygelBasicManagementTestPingProcessState _tmp6_ = 0;
		_tmp6_ = self->priv->state;
		if (_tmp6_ == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS) {
			const gchar* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp7_ = line;
			_tmp8_ = string_contains (_tmp7_, "packets transmitted");
			if (_tmp8_) {
				gchar** rtt_values = NULL;
				const gchar* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gint rtt_values_length1 = 0;
				gint _rtt_values_size_ = 0;
				guint tx = 0U;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				const gchar* _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				const gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				guint _tmp19_ = 0U;
				guint rx = 0U;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				const gchar* _tmp21_ = NULL;
				gchar** _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				guint _tmp27_ = 0U;
				guint _tmp28_ = 0U;
				guint _tmp29_ = 0U;
				guint _tmp30_ = 0U;
				self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT;
				_tmp9_ = line;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ", ", 3);
				rtt_values = _tmp11_;
				rtt_values_length1 = _vala_array_length (_tmp10_);
				_rtt_values_size_ = rtt_values_length1;
				_tmp12_ = rtt_values;
				_tmp12__length1 = rtt_values_length1;
				_tmp13_ = _tmp12_[0];
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 3);
				_tmp16_ = _tmp15_;
				_tmp16__length1 = _vala_array_length (_tmp14_);
				_tmp17_ = _tmp16_[0];
				_tmp18_ = atoi (_tmp17_);
				_tmp19_ = (guint) _tmp18_;
				_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
				tx = _tmp19_;
				_tmp20_ = rtt_values;
				_tmp20__length1 = rtt_values_length1;
				_tmp21_ = _tmp20_[1];
				_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, " ", 3);
				_tmp24_ = _tmp23_;
				_tmp24__length1 = _vala_array_length (_tmp22_);
				_tmp25_ = _tmp24_[0];
				_tmp26_ = atoi (_tmp25_);
				_tmp27_ = (guint) _tmp26_;
				_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
				rx = _tmp27_;
				_tmp28_ = tx;
				_tmp29_ = rx;
				self->priv->failure_count = _tmp28_ - _tmp29_;
				_tmp30_ = rx;
				self->priv->success_count = _tmp30_;
				rtt_values = (_vala_array_free (rtt_values, rtt_values_length1, (GDestroyNotify) g_free), NULL);
			}
		} else {
			RygelBasicManagementTestPingProcessState _tmp31_ = 0;
			_tmp31_ = self->priv->state;
			if (_tmp31_ == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT) {
				const gchar* _tmp32_ = NULL;
				gboolean _tmp33_ = FALSE;
				_tmp32_ = line;
				_tmp33_ = string_contains (_tmp32_, "min/avg/max");
				if (_tmp33_) {
					gchar** rtt = NULL;
					const gchar* _tmp34_ = NULL;
					gchar** _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gint rtt_length1 = 0;
					gint _rtt_size_ = 0;
					gchar** _tmp37_ = NULL;
					gint _tmp37__length1 = 0;
					_tmp34_ = line;
					_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "=", 2);
					rtt = _tmp36_;
					rtt_length1 = _vala_array_length (_tmp35_);
					_rtt_size_ = rtt_length1;
					_tmp37_ = rtt;
					_tmp37__length1 = rtt_length1;
					if (_tmp37__length1 >= 2) {
						gchar** rtt_values = NULL;
						gchar** _tmp38_ = NULL;
						gint _tmp38__length1 = 0;
						const gchar* _tmp39_ = NULL;
						gchar** _tmp40_ = NULL;
						gchar** _tmp41_ = NULL;
						gint rtt_values_length1 = 0;
						gint _rtt_values_size_ = 0;
						gchar** _tmp42_ = NULL;
						gint _tmp42__length1 = 0;
						_tmp38_ = rtt;
						_tmp38__length1 = rtt_length1;
						_tmp39_ = _tmp38_[1];
						_tmp41_ = _tmp40_ = g_strsplit (_tmp39_, "/", 4);
						rtt_values = _tmp41_;
						rtt_values_length1 = _vala_array_length (_tmp40_);
						_rtt_values_size_ = rtt_values_length1;
						_tmp42_ = rtt_values;
						_tmp42__length1 = rtt_values_length1;
						if (_tmp42__length1 >= 3) {
							gchar** _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							const gchar* _tmp44_ = NULL;
							gdouble _tmp45_ = 0.0;
							gdouble _tmp46_ = 0.0;
							gchar** _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							const gchar* _tmp48_ = NULL;
							gdouble _tmp49_ = 0.0;
							gdouble _tmp50_ = 0.0;
							gchar** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							const gchar* _tmp52_ = NULL;
							gdouble _tmp53_ = 0.0;
							gdouble _tmp54_ = 0.0;
							_tmp43_ = rtt_values;
							_tmp43__length1 = rtt_values_length1;
							_tmp44_ = _tmp43_[0];
							_tmp45_ = double_parse (_tmp44_);
							_tmp46_ = round (_tmp45_);
							self->priv->min_response_time = (guint32) ((guint) _tmp46_);
							_tmp47_ = rtt_values;
							_tmp47__length1 = rtt_values_length1;
							_tmp48_ = _tmp47_[1];
							_tmp49_ = double_parse (_tmp48_);
							_tmp50_ = round (_tmp49_);
							self->priv->avg_response_time = (guint32) ((guint) _tmp50_);
							_tmp51_ = rtt_values;
							_tmp51__length1 = rtt_values_length1;
							_tmp52_ = _tmp51_[2];
							_tmp53_ = double_parse (_tmp52_);
							_tmp54_ = round (_tmp53_);
							self->priv->max_response_time = (guint32) ((guint) _tmp54_);
						}
						rtt_values = (_vala_array_free (rtt_values, rtt_values_length1, (GDestroyNotify) g_free), NULL);
					}
					rtt = (_vala_array_free (rtt, rtt_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
}


void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar** status, gchar** additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time) {
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint _vala_success_count = 0U;
	guint _vala_failure_count = 0U;
	guint32 _vala_avg_response_time = 0U;
	guint32 _vala_min_response_time = 0U;
	guint32 _vala_max_response_time = 0U;
	RygelBasicManagementTestPingStatus _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint32 _tmp6_ = 0U;
	guint32 _tmp7_ = 0U;
	guint32 _tmp8_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status;
	_tmp1_ = rygel_basic_management_test_ping_status_to_string (_tmp0_);
	_g_free0 (_vala_status);
	_vala_status = _tmp1_;
	_tmp2_ = self->priv->additional_info;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_vala_additional_info);
	_vala_additional_info = _tmp3_;
	_tmp4_ = self->priv->success_count;
	_vala_success_count = _tmp4_;
	_tmp5_ = self->priv->failure_count;
	_vala_failure_count = _tmp5_;
	_tmp6_ = self->priv->avg_response_time;
	_vala_avg_response_time = _tmp6_;
	_tmp7_ = self->priv->min_response_time;
	_vala_min_response_time = _tmp7_;
	_tmp8_ = self->priv->max_response_time;
	_vala_max_response_time = _tmp8_;
	if (status) {
		*status = _vala_status;
	} else {
		_g_free0 (_vala_status);
	}
	if (additional_info) {
		*additional_info = _vala_additional_info;
	} else {
		_g_free0 (_vala_additional_info);
	}
	if (success_count) {
		*success_count = _vala_success_count;
	}
	if (failure_count) {
		*failure_count = _vala_failure_count;
	}
	if (avg_response_time) {
		*avg_response_time = _vala_avg_response_time;
	}
	if (min_response_time) {
		*min_response_time = _vala_min_response_time;
	}
	if (max_response_time) {
		*max_response_time = _vala_max_response_time;
	}
}


const gchar* rygel_basic_management_test_ping_get_host (RygelBasicManagementTestPing* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ping_set_host (RygelBasicManagementTestPing* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_host);
	self->priv->_host = _tmp1_;
	g_object_notify ((GObject *) self, "host");
}


guint rygel_basic_management_test_ping_get_repeat_count (RygelBasicManagementTestPing* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_repeat_count;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ping_set_repeat_count (RygelBasicManagementTestPing* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_repeat_count = _tmp0_;
	_tmp1_ = self->priv->_repeat_count;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_repeat_count = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT;
	}
	g_object_notify ((GObject *) self, "repeat-count");
}


guint rygel_basic_management_test_ping_get_data_block_size (RygelBasicManagementTestPing* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_data_block_size;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ping_set_data_block_size (RygelBasicManagementTestPing* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_data_block_size = _tmp0_;
	_tmp1_ = self->priv->_data_block_size;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE;
	}
	g_object_notify ((GObject *) self, "data-block-size");
}


guint rygel_basic_management_test_ping_get_dscp (RygelBasicManagementTestPing* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_dscp;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ping_set_dscp (RygelBasicManagementTestPing* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_dscp = _tmp0_;
	_tmp1_ = self->priv->_dscp;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP;
	}
	g_object_notify ((GObject *) self, "dscp");
}


guint32 rygel_basic_management_test_ping_get_interval_time_out (RygelBasicManagementTestPing* self) {
	guint32 result;
	guint32 _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_interval_time_out;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ping_set_interval_time_out (RygelBasicManagementTestPing* self, guint32 value) {
	guint32 _tmp0_ = 0U;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_interval_time_out = _tmp0_;
	_tmp1_ = self->priv->_interval_time_out;
	if (_tmp1_ == ((guint32) 0)) {
		self->priv->_interval_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT;
	}
	g_object_notify ((GObject *) self, "interval-time-out");
}


static const gchar* rygel_basic_management_test_ping_real_get_method_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestPing* self;
	self = (RygelBasicManagementTestPing*) base;
	result = "Ping";
	return result;
}


static const gchar* rygel_basic_management_test_ping_real_get_results_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestPing* self;
	self = (RygelBasicManagementTestPing*) base;
	result = "GetPingResult";
	return result;
}


static void rygel_basic_management_test_ping_class_init (RygelBasicManagementTestPingClass * klass) {
	rygel_basic_management_test_ping_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelBasicManagementTestPingPrivate));
	((GObjectClass *) klass)->constructed = rygel_basic_management_test_ping_real_constructed;
	((RygelBasicManagementTestClass *) klass)->finish_iteration = rygel_basic_management_test_ping_real_finish_iteration;
	((RygelBasicManagementTestClass *) klass)->handle_error = rygel_basic_management_test_ping_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->handle_output = rygel_basic_management_test_ping_real_handle_output;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_ping_real_get_method_type;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_ping_real_get_results_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_ping_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_ping_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_ping_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST, g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT, g_param_spec_uint ("repeat-count", "repeat-count", "repeat-count", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE, g_param_spec_uint ("data-block-size", "data-block-size", "data-block-size", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP, g_param_spec_uint ("dscp", "dscp", "dscp", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT, g_param_spec_uint ("interval-time-out", "interval-time-out", "interval-time-out", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE, g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE, g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_basic_management_test_ping_instance_init (RygelBasicManagementTestPing * self) {
	gchar* _tmp0_ = NULL;
	self->priv = RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host = _tmp0_;
}


static void rygel_basic_management_test_ping_finalize (GObject* obj) {
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
	_g_free0 (self->priv->_host);
	_g_free0 (self->priv->additional_info);
	G_OBJECT_CLASS (rygel_basic_management_test_ping_parent_class)->finalize (obj);
}


GType rygel_basic_management_test_ping_get_type (void) {
	static volatile gsize rygel_basic_management_test_ping_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestPingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_ping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestPing), 0, (GInstanceInitFunc) rygel_basic_management_test_ping_instance_init, NULL };
		GType rygel_basic_management_test_ping_type_id;
		rygel_basic_management_test_ping_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestPing", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_test_ping_type_id__volatile, rygel_basic_management_test_ping_type_id);
	}
	return rygel_basic_management_test_ping_type_id__volatile;
}


static void _vala_rygel_basic_management_test_ping_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST:
		g_value_set_string (value, rygel_basic_management_test_ping_get_host (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_repeat_count (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_data_block_size (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_dscp (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_interval_time_out (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE:
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE:
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_basic_management_test_ping_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST:
		rygel_basic_management_test_ping_set_host (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT:
		rygel_basic_management_test_ping_set_repeat_count (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE:
		rygel_basic_management_test_ping_set_data_block_size (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP:
		rygel_basic_management_test_ping_set_dscp (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT:
		rygel_basic_management_test_ping_set_interval_time_out (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



