#include "config.h"

#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cassert>

#include "error.h"
#include "fs.h"
#include "vaulter.h"
#include "test-vaulter-setup.h"

#define ERR_OUT(e) std::cerr << e
// #define ERR_OUT(e)

void test_vaulter(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";
	argv[argc++] = "--timestamp";
	argv[argc++] = "2003-09-21";

	config.default_file("./test-vaulter.dir/file-1.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		assert(vaulter.vault() == "./test-vaulter.dir/group-1/vault-1");

		vaulter.delete_oldest_archive();
		assert(vaulter.deleted_archives().size() == 1);
		assert(vaulter.deleted_archives()[0] == "2003-09-15");

		vaulter.delete_oldest_archive();
		assert(vaulter.deleted_archives().size() == 2);
		assert(vaulter.deleted_archives()[0] == "2003-09-15");
		assert(vaulter.deleted_archives()[1] == "2003-09-18.incomplete");

	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);

	std::cerr << std::endl;
	std::cerr << "  You should see an error message here:" << std::endl;
	std::cerr << "-----------------------------------------" << std::endl;
	try {
		vaulter.delete_oldest_archive();
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	std::cerr << "-----------------------------------------" << std::endl;
	std::cerr << std::endl;
	assert(thrown);

	assert(vaulter.deleted_archives().size() == 2);
	assert(vaulter.deleted_archives()[0] == "2003-09-15");
	assert(vaulter.deleted_archives()[1] == "2003-09-18.incomplete");
	assert(vaulter.get_archive_list().size() == 1);
	assert(vaulter.get_archive_list()[0] == "2003-09-21");

	thrown = false;
	try {
		logger.clear();
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);

}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test_vaulter();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

