#include "config.h"

#include <iostream>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "asserts.h"
#include "error.h"
#include "timer.h"

// #define ERR_OUT(s) std::cerr << s
#define ERR_OUT(s)

template<class T>
T absolute(const T& num)
{
	if (num < 0) {
		return(-num);
	}
	return(num);
}

void test1(void)
{
	bool done = false;
	int retry = 0;

	while (!done && (retry++ < 3)) {
		timer t;

		t.start();
		sleep(5);
		t.stop();

		if (t.duration() != "00:05.0") {
			std::cout << "Once in a blue moon this test fails -- I don't know why."
				<< std::endl;
			std::cout << "t.duration() = " << t.duration() << std::endl;
			std::cout << "t.duration() should be 00:05.0" << std::endl;
		}
		if (t.duration() == "00:05.0") {
			done = true;
		}
	}
	assert(done);
}

void test2(void)
{
	timer t;
	timer::duration_type d1, d2, d;
	int retry = 0;

	d1 = 0.0;
	while ((d1 != 5.0) && (retry++ < 10)) {
		t.start();
		sleep(5);
		t.stop();

		d1 = t.duration_secs();
	}

	if (d1 != 5.0) {
		std::cout << "Once in a blue moon this test fails -- I don't know why."
			<< std::endl;
		std::cout << "d1 = " << d1 << std::endl;
		std::cout << "d1 should be 5.0" << std::endl;
	}
	d = absolute(d1-5.0);
	assert(d < 1.0);

	d1 = t.duration_mins();
	d2 = t.duration_secs()/60;
	d = absolute(d1-d2);
	assert(d < 1.0);

	d1 = t.duration_hours();
	d2 = t.duration_secs()/60/60;
	d = absolute(d1-d2);
	assert(d < 1.0);

	d1 = t.duration_days();
	d2 = t.duration_secs()/60/60/24;
	d = absolute(d1-d2);
	assert(d < 1.0);

	d1 = t.duration_years();
	d2 = t.duration_secs()/60/60/24/365;
	d = absolute(d1-d2);
	assert(d < 1.0);
}

void test3(void)
{
	timer::value_type base_value = 1067356170;
	timer::value_type start_value;
	timer::value_type stop_value;
	timer t(base_value, base_value+5);

	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+5);
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Oct 28 15:49:35");
	assert(t.duration() == "00:05.0");

	t.assign(base_value, base_value+(5*60));
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+(5*60));
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Oct 28 15:54:30");
	assert(t.duration() == "05:00.0");

	t.assign(base_value, base_value+(5*60*60));
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+(5*60*60));
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Oct 28 20:49:30");
	assert(t.duration() == "05:00:00.0");

	t.assign(base_value, base_value+(3*60*60*24));
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+(3*60*60*24));
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Oct 31 15:49:30");
	assert(t.duration() == "3d 00:00:00.0");

	t.assign(base_value, base_value+(5*60*60*24));
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+(5*60*60*24));
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Nov  2 15:49:30");
	assert(t.duration() == "5d 00:00:00.0");

	t.assign(base_value, base_value+(64*60*60*24));
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+(64*60*60*24));
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Dec 31 15:49:30");
	assert(t.duration() == "64d 00:00:00.0");

	t.assign(base_value, base_value+(65*60*60*24));
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	*/
	assert(t.start_value() == base_value);
	assert(t.stop_value() == base_value+(65*60*60*24));
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2004 Jan  1 15:49:30");
	assert(t.duration() == "65d 00:00:00.0");

	start_value = base_value;
	stop_value = base_value +5;
	t.assign(start_value, stop_value);
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	std::cout << "       t.eta(0) = " << t.eta(0) << std::endl;
	std::cout << "       t.eta(1) = " << t.eta(1) << std::endl;
	std::cout << "      t.eta(10) = " << t.eta(10) << std::endl;
	std::cout << "      t.eta(50) = " << t.eta(50) << std::endl;
	std::cout << "      t.eta(75) = " << t.eta(75) << std::endl;
	std::cout << "      t.eta(93) = " << t.eta(93) << std::endl;
	std::cout << "      t.eta(99) = " << t.eta(99) << std::endl;
	std::cout << "     t.eta(100) = " << t.eta(100) << std::endl;
	std::cout << "     t.eta(101) = " << t.eta(101) << std::endl;
	std::cout << "     t.eta(107) = " << t.eta(107) << std::endl;
	std::cout << "     t.eta(125) = " << t.eta(125) << std::endl;
	std::cout << "     t.eta(150) = " << t.eta(150) << std::endl;
	std::cout << "     t.eta(190) = " << t.eta(190) << std::endl;
	std::cout << "     t.eta(199) = " << t.eta(199) << std::endl;
	std::cout << "     t.eta(200) = " << t.eta(200) << std::endl;
	std::cout << "       t.eta(0,100) = " << t.eta(0,100) << std::endl;
	std::cout << "       t.eta(1,100) = " << t.eta(1,100) << std::endl;
	std::cout << "      t.eta(10,100) = " << t.eta(10,100) << std::endl;
	std::cout << "      t.eta(50,100) = " << t.eta(50,100) << std::endl;
	std::cout << "      t.eta(75,100) = " << t.eta(75,100) << std::endl;
	std::cout << "      t.eta(93,100) = " << t.eta(93,100) << std::endl;
	std::cout << "      t.eta(99,100) = " << t.eta(99,100) << std::endl;
	std::cout << "     t.eta(100,100) = " << t.eta(100,100) << std::endl;
	std::cout << "     t.eta(101,100) = " << t.eta(101,100) << std::endl;
	std::cout << "     t.eta(107,100) = " << t.eta(107,100) << std::endl;
	std::cout << "     t.eta(125,100) = " << t.eta(125,100) << std::endl;
	std::cout << "     t.eta(150,100) = " << t.eta(150,100) << std::endl;
	std::cout << "     t.eta(190,100) = " << t.eta(190,100) << std::endl;
	std::cout << "     t.eta(199,100) = " << t.eta(199,100) << std::endl;
	std::cout << "     t.eta(200,100) = " << t.eta(200,100) << std::endl;
	*/
	assert(t.start_value() == start_value);
	assert(t.stop_value() == stop_value);
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2003 Oct 28 15:49:35");
	assert(t.duration() == "00:05.0");
	assert(t.eta(0) == "??:??.?");
	assert(t.eta(1) == "08:15.0");
	assert(t.eta(10) == "00:45.0");
	assert(t.eta(50) == "00:05.0");
	assert(t.eta(75) == "00:01.6");
	assert(t.eta(93) == "00:00.3");
	assert(t.eta(99) == "00:00.0");
	assert(t.eta(100) == "00:00.0");
	assert(t.eta(101) == "-00:00.0");
	assert(t.eta(107) == "-00:00.3");
	assert(t.eta(125) == "-00:01.0");
	assert(t.eta(150) == "-00:01.6");
	assert(t.eta(190) == "-00:02.3");
	assert(t.eta(199) == "-00:02.4");
	assert(t.eta(200) == "-00:02.5");
	assert(t.eta(0,100) == "??:??.?");
	assert(t.eta(1,100) == "08:15.0");
	assert(t.eta(10,100) == "00:45.0");
	assert(t.eta(50,100) == "00:05.0");
	assert(t.eta(75,100) == "00:01.6");
	assert(t.eta(93,100) == "00:00.3");
	assert(t.eta(99,100) == "00:00.0");
	assert(t.eta(100,100) == "00:00.0");
	assert(t.eta(101,100) == "-00:00.0");
	assert(t.eta(107,100) == "-00:00.3");
	assert(t.eta(125,100) == "-00:01.0");
	assert(t.eta(150,100) == "-00:01.6");
	assert(t.eta(190,100) == "-00:02.3");
	assert(t.eta(199,100) == "-00:02.4");
	assert(t.eta(200,100) == "-00:02.5");

	start_value = base_value;
	stop_value = base_value +5*60*60*24*365 +6*60*60*24 +7*60*60 +8*60 +9;
	t.assign(start_value, stop_value);
	t.use_localtime(false);
	/*
	std::cout << "t.start_value() = " << t.start_value() << std::endl;
	std::cout << " t.stop_value() = " << t.stop_value() << std::endl;
	std::cout << " t.started_at() = " << t.started_at() << std::endl;
	std::cout << " t.stopped_at() = " << t.stopped_at() << std::endl;
	std::cout << "   t.duration() = " << t.duration() << std::endl;
	std::cout << "       t.eta(0) = " << t.eta(0) << std::endl;
	std::cout << "       t.eta(1) = " << t.eta(1) << std::endl;
	std::cout << "      t.eta(10) = " << t.eta(10) << std::endl;
	std::cout << "      t.eta(50) = " << t.eta(50) << std::endl;
	std::cout << "      t.eta(75) = " << t.eta(75) << std::endl;
	std::cout << "      t.eta(93) = " << t.eta(93) << std::endl;
	std::cout << "      t.eta(99) = " << t.eta(99) << std::endl;
	std::cout << "     t.eta(100) = " << t.eta(100) << std::endl;
	std::cout << "     t.eta(101) = " << t.eta(101) << std::endl;
	std::cout << "     t.eta(107) = " << t.eta(107) << std::endl;
	std::cout << "     t.eta(125) = " << t.eta(125) << std::endl;
	std::cout << "     t.eta(150) = " << t.eta(150) << std::endl;
	std::cout << "     t.eta(190) = " << t.eta(190) << std::endl;
	std::cout << "     t.eta(199) = " << t.eta(199) << std::endl;
	std::cout << "     t.eta(200) = " << t.eta(200) << std::endl;
	std::cout << "       t.eta(0,100) = " << t.eta(0,100) << std::endl;
	std::cout << "       t.eta(1,100) = " << t.eta(1,100) << std::endl;
	std::cout << "      t.eta(10,100) = " << t.eta(10,100) << std::endl;
	std::cout << "      t.eta(50,100) = " << t.eta(50,100) << std::endl;
	std::cout << "      t.eta(75,100) = " << t.eta(75,100) << std::endl;
	std::cout << "      t.eta(93,100) = " << t.eta(93,100) << std::endl;
	std::cout << "      t.eta(99,100) = " << t.eta(99,100) << std::endl;
	std::cout << "     t.eta(100,100) = " << t.eta(100,100) << std::endl;
	std::cout << "     t.eta(101,100) = " << t.eta(101,100) << std::endl;
	std::cout << "     t.eta(107,100) = " << t.eta(107,100) << std::endl;
	std::cout << "     t.eta(125,100) = " << t.eta(125,100) << std::endl;
	std::cout << "     t.eta(150,100) = " << t.eta(150,100) << std::endl;
	std::cout << "     t.eta(190,100) = " << t.eta(190,100) << std::endl;
	std::cout << "     t.eta(199,100) = " << t.eta(199,100) << std::endl;
	std::cout << "     t.eta(200,100) = " << t.eta(200,100) << std::endl;
	*/
	assert(t.start_value() == 1067356170);
	assert(t.stop_value() == 1225580259);
	assert(t.started_at() == "2003 Oct 28 15:49:30");
	assert(t.stopped_at() == "2008 Nov  1 22:57:39");
	assert(t.duration() == "5y 6d 07:08:09.0");
	assert(t.eta(0) == "??:??.?");
	assert(t.eta(1) == "496y 258d 10:26:51.0");
	assert(t.eta(10) == "45y 56d 16:13:21.0");
	assert(t.eta(50) == "5y 6d 07:08:09.0");
	assert(t.eta(75) == "1y 245d 10:22:43.0");
	assert(t.eta(93) == "137d 20:09:00.0");
	assert(t.eta(99) == "18d 11:57:03.1");
	assert(t.eta(100) == "00:00.0");
	assert(t.eta(101) == "-18d 03:09:35.1");
	assert(t.eta(107) == "-119d 19:18:28.6");
	assert(
		(t.eta(125) == "-1y 1d 06:13:37.8")
		|| (t.eta(125) == "-1y 1d 06:13:37.7")
		);
	assert(t.eta(150) == "-1y 245d 10:22:43.0");
	assert(t.eta(190) == "-2y 137d 10:57:32.6");
	assert(t.eta(199) == "-2y 181d 01:08:16.5");
	assert(t.eta(200) == "-2y 185d 15:34:04.5");
	assert(t.eta(0,100) == "??:??.?");
	assert(t.eta(1,100) == "496y 258d 10:26:51.0");
	assert(t.eta(10,100) == "45y 56d 16:13:21.0");
	assert(t.eta(50,100) == "5y 6d 07:08:09.0");
	assert(t.eta(75,100) == "1y 245d 10:22:43.0");
	assert(t.eta(93,100) == "137d 20:09:00.0");
	assert(t.eta(99,100) == "18d 11:57:03.1");
	assert(t.eta(100,100) == "00:00.0");
	assert(t.eta(101,100) == "-18d 03:09:35.1");
	assert(t.eta(107,100) == "-119d 19:18:28.6");
	assert(
		(t.eta(125,100) == "-1y 1d 06:13:37.8")
		|| (t.eta(125,100) == "-1y 1d 06:13:37.7")
		);
	assert(t.eta(150,100) == "-1y 245d 10:22:43.0");
	assert(t.eta(190,100) == "-2y 137d 10:57:32.6");
	assert(t.eta(199,100) == "-2y 181d 01:08:16.5");
	assert(t.eta(200,100) == "-2y 185d 15:34:04.5");
}

int main(int argc, char const * argv[])
{
	try {
		test1();
		test2();
		test3();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	return(0);
}

