#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"

// #define ERR_OUT(e) std::cerr << e;
#define ERR_OUT(e)

void test_cast(const rsync_behavior::value_type b_in)
{
	estring s;
	uint64 i;
	rsync_behavior::value_type b_out;

	s = estring(static_cast<uint64>(b_in));
	i = static_cast<uint64>(s);
	b_out = static_cast<rsync_behavior::value_type>(i);

	assert(b_in == b_out);
}

void test(void)
{
	test_cast(rsync_behavior::quit);
	test_cast(rsync_behavior::fail);
	test_cast(rsync_behavior::retry);
	test_cast(rsync_behavior::retry_without_hardlinks);
	test_cast(rsync_behavior::ok);
}

int main(int argc, char const * argv[])
{
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	return(0);
}
