#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"
#include "test-rconfig-setup.h"

// #define ERR_OUT(e) std::cerr << e;
#define ERR_OUT(e)

void test(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";

	config.default_file("./test-rconfig.dir/job.dir/file-12.conf");
	config.default_logdir("./test-rconfig.dir/log.dir");
	try {
		config.init(argc, argv);
	}
	catch(error e) {
		ERR_OUT(e);
		assert(e.num() == 0);
		assert(!e.internal());
		assert(e.size() == 5);
		assert(e[0].what() == "Overlapping archive-path values detected");
		// assert(e[1].what() == "Defined archive-path: \"var-spool/job-A\"");
		assert(e[1].what() == "Defined archive-path: \"var-spool/\"");
		assert(e[2].what() == "Is in a subdirectory of another job's previously defined archive-path");
		assert(e[3].what() == "At ./test-rconfig.dir/job.dir/file-12.conf[7]");
		assert(e[4].what() == "At ./test-rconfig.dir/job.dir/file-12.conf[13]");
		thrown = true;
	}
	catch(...) {
		assert(0);
	}
	assert(thrown);

}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

