#ifndef __tstamp_h__
#define __tstamp_h__

#ifdef HAVE_SYS_TIME_H
#include <sys/types.h>
#endif
#include <time.h>

#include "asserts.h"
#include "types.h"

/** Timestamp object */
class timestamp
{
public:
	enum resolution_type {
		resolution_year,
		resolution_month,
		resolution_day,
		resolution_hour,
		resolution_minute,
		resolution_second
	};

	timestamp();
	timestamp(const timestamp& a_t);
	timestamp(
		const int a_year, 
		const int a_month, 
		const int a_day, 
		const int a_hour, 
		const int a_minute, 
		const int a_second
		);
	timestamp(const std::string& a_s);

	void set(void);
	void assign(const timestamp& a_t);
	void assign(
		const int a_year, 
		const int a_month, 
		const int a_day, 
		const int a_hour, 
		const int a_minute, 
		const int a_second
		);
	void assign(const std::string& a_s);
	void clear(void);
	void resolution(resolution_type a_r);
	resolution_type resolution(void) const;

	const std::string str(void) const;
	const std::string str(const resolution_type a_resolution) const;
	int second(void) const;
	int minute(void) const;
	int hour(void) const;
	int day(void) const;
	int month(void) const;
	int year(void) const;

	timestamp& operator = (const timestamp& a_t);
	timestamp& operator = (const std::string& a_s);
	bool operator < (const timestamp& a_t) const;
	bool operator > (const timestamp& a_t) const;
	bool operator == (const timestamp& a_t) const;

private:
	int m_year;
	int m_month;
	int m_day;
	int m_hour;
	int m_minute;
	int m_second;
	resolution_type m_resolution;

	const std::string make_str_(const int a_resolution) const;
};

bool is_timestamp(const std::string& a_s);

/** A null timestamp */
const timestamp null_timestamp(0,1,1,0,0,0);

/** The minimum timestamp value */
const timestamp min_timestamp(null_timestamp);

/** The maximum timestamp value */
const timestamp max_timestamp(9999,12,31,23,59,59);

#endif
