#include "config.h"

#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cassert>

#include "error.h"
#include "fs.h"
#include "vaulter.h"
#include "test-vaulter-setup.h"

// #define ERR_OUT(e) std::cerr << e
#define ERR_OUT(e)

void test_vaulter(void)
{
	bool thrown = false;

	try {
		vaulter.init();
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test_vaulter();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

