#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"
#include "test-rconfig-setup.h"

#define ERR_OUT(e) std::cerr << e;
// #define ERR_OUT(e)

void test(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";

	config.default_file("./test-rconfig.dir/job.dir/file-13.conf");
	config.default_logdir("./test-rconfig.dir/log.dir");
	try {
		config.init(argc, argv);
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		assert(0);
	}
	assert(!thrown);
	assert(config.default_job().rsync_behavior.map_value().size() == 0);
	assert(config.default_job().rsync_behavior.default_value() 
		== rsync_behavior::retry);
	assert(config.default_job().paths.size() == 1);
	assert(config.default_job().paths[0] == "/var/spool");
	assert(config.jobs().size() == 2);
	assert(config.jobs()[0].rsync_behavior.map_value().size() == 0);
	assert(config.jobs()[0].paths.size() == 1);
	assert(config.jobs()[0].paths[0] == "/var/spool");
	assert(config.jobs()[1].rsync_behavior.map_value().size() == 0);
	assert(config.jobs()[1].paths.size() == 1);
	assert(config.jobs()[1].paths[0] == "/etc");
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

