#include "config.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <iostream>
#include <string>
#include <cassert>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"

void test1(void)
{
	estring s;
}

void test2(void)
{
	estring es;
	std::string s;

	es = static_cast<char>('c');
	s = es;
	assert(s == "c");
	assert(es == "c");

	es = "Hello World";
	s = es;
	assert(s == "Hello World");
	assert(es == "Hello World");

	s = "The quick brown fox";
	es = s;
	assert(es == "The quick brown fox");

	es = static_cast<unsigned int>(6);
	assert(es == "6");
	es = static_cast<int>(-5);
	assert(es == "-5");
	es = static_cast<int>(5);
	assert(es == "5");

	es = static_cast<unsigned short>(7);
	assert(es == "7");
	es = static_cast<short>(-7);
	assert(es == "-7");
	es = static_cast<short>(7);
	assert(es == "7");

	es = static_cast<unsigned long>(8);
	assert(es == "8");
	es = static_cast<long>(-8);
	assert(es == "-8");
	es = static_cast<long>(8);
	assert(es == "8");

	es = static_cast<unsigned long long>(9);
	assert(es == "9");
	es = static_cast<long long>(-9);
	assert(es == "-9");
	es = static_cast<long long>(9);
	assert(es == "9");

	es.precision(1);
	es = static_cast<float>(5.9);
	assert(es == "5.9");
	es = static_cast<float>(6.2);
	es.assign(static_cast<float>(6.2),1);
	assert(es == "6.2");
	es = static_cast<float>(-5.9);
	assert(es == "-5.9");
	es = static_cast<float>(-6.2);
	es.assign(static_cast<float>(-6.2),1);
	assert(es == "-6.2");


	es.assign(static_cast<float>(6.2),0);
	assert(es == "6");
	es.assign(static_cast<float>(6.2),1);
	assert(es == "6.2");
	es.assign(static_cast<float>(6.2),2);
	assert(es == "6.20");
	es.assign(static_cast<float>(-6.2),0);
	assert(es == "-6");
	es.assign(static_cast<float>(-6.2),1);
	assert(es == "-6.2");
	es.assign(static_cast<float>(-6.2),2);
	assert(es == "-6.20");


	es = "";

	assert(es.fmt_str(0,estring::left,'<','>') == "");
	assert(es.fmt_str(1,estring::left,'<','>') == ">");
	assert(es.fmt_str(2,estring::left,'<','>') == ">>");
	assert(es.fmt_str(3,estring::left,'<','>') == ">>>");

	assert(es.fmt_str(0,estring::right,'<','>') == "");
	assert(es.fmt_str(1,estring::right,'<','>') == "<");
	assert(es.fmt_str(2,estring::right,'<','>') == "<<");
	assert(es.fmt_str(3,estring::right,'<','>') == "<<<");

	assert(es.fmt_str(0,estring::center,'<','>') == "");
	assert(es.fmt_str(1,estring::center,'<','>') == ">");
	assert(es.fmt_str(2,estring::center,'<','>') == "<>");
	assert(es.fmt_str(3,estring::center,'<','>') == "<>>");

	es = "Hello World";

	assert(es.fmt_str(0,estring::left,'<','>') == "");
	assert(es.fmt_str(1,estring::left,'<','>') == ".");
	assert(es.fmt_str(2,estring::left,'<','>') == "..");
	assert(es.fmt_str(3,estring::left,'<','>') == "...");
	assert(es.fmt_str(4,estring::left,'<','>') == "H...");
	assert(es.fmt_str(5,estring::left,'<','>') == "He...");
	assert(es.fmt_str(6,estring::left,'<','>') == "Hel...");
	assert(es.fmt_str(7,estring::left,'<','>') == "Hell...");
	assert(es.fmt_str(8,estring::left,'<','>') == "Hello...");
	assert(es.fmt_str(9,estring::left,'<','>') == "Hello ...");
	assert(es.fmt_str(10,estring::left,'<','>') == "Hello W...");
	assert(es.fmt_str(11,estring::left,'<','>') == "Hello World");
	assert(es.fmt_str(12,estring::left,'<','>') == "Hello World>");
	assert(es.fmt_str(13,estring::left,'<','>') == "Hello World>>");
	
	assert(es.fmt_str(0,estring::right,'<','>') == "");
	assert(es.fmt_str(1,estring::right,'<','>') == ".");
	assert(es.fmt_str(2,estring::right,'<','>') == "..");
	assert(es.fmt_str(3,estring::right,'<','>') == "...");
	assert(es.fmt_str(4,estring::right,'<','>') == "...d");
	assert(es.fmt_str(5,estring::right,'<','>') == "...ld");
	assert(es.fmt_str(6,estring::right,'<','>') == "...rld");
	assert(es.fmt_str(7,estring::right,'<','>') == "...orld");
	assert(es.fmt_str(8,estring::right,'<','>') == "...World");
	assert(es.fmt_str(9,estring::right,'<','>') == "... World");
	assert(es.fmt_str(10,estring::right,'<','>') == "...o World");
	assert(es.fmt_str(11,estring::right,'<','>') == "Hello World");
	assert(es.fmt_str(12,estring::right,'<','>') == "<Hello World");
	assert(es.fmt_str(13,estring::right,'<','>') == "<<Hello World");
	
	assert(es.fmt_str(0,estring::center,'<','>') == "");
	assert(es.fmt_str(1,estring::center,'<','>') == ".");
	assert(es.fmt_str(2,estring::center,'<','>') == "..");
	assert(es.fmt_str(3,estring::center,'<','>') == "...");
	assert(es.fmt_str(4,estring::center,'<','>') == "H...");
	assert(es.fmt_str(5,estring::center,'<','>') == "H...d");
	assert(es.fmt_str(6,estring::center,'<','>') == "He...d");
	assert(es.fmt_str(7,estring::center,'<','>') == "He...ld");
	assert(es.fmt_str(8,estring::center,'<','>') == "Hel...ld");
	assert(es.fmt_str(9,estring::center,'<','>') == "Hel...rld");
	assert(es.fmt_str(10,estring::center,'<','>') == "Hell...rld");
	assert(es.fmt_str(11,estring::center,'<','>') == "Hello World");
	assert(es.fmt_str(12,estring::center,'<','>') == "Hello World>");
	assert(es.fmt_str(13,estring::center,'<','>') == "<Hello World>");
	assert(es.fmt_str(14,estring::center,'<','>') == "<Hello World>>");
	assert(es.fmt_str(15,estring::center,'<','>') == "<<Hello World>>");

	es.assign(static_cast<double>(6.25),2);
	assert(es == "6.25");

	assert(es.fmt_str(0,estring::left,'<','>') == "");
	assert(es.fmt_str(1,estring::left,'<','>') == ".");
	assert(es.fmt_str(2,estring::left,'<','>') == "..");
	assert(es.fmt_str(3,estring::left,'<','>') == "...");
	assert(es.fmt_str(4,estring::left,'<','>') == "6.25");
	assert(es.fmt_str(5,estring::left,'<','>') == "6.25>");
	assert(es.fmt_str(6,estring::left,'<','>') == "6.25>>");
	assert(es.fmt_str(7,estring::left,'<','>') == "6.25>>>");

	assert(es.fmt_str(0,estring::right,'<','>') == "");
	assert(es.fmt_str(1,estring::right,'<','>') == ".");
	assert(es.fmt_str(2,estring::right,'<','>') == "..");
	assert(es.fmt_str(3,estring::right,'<','>') == "...");
	assert(es.fmt_str(4,estring::right,'<','>') == "6.25");
	assert(es.fmt_str(5,estring::right,'<','>') == "<6.25");
	assert(es.fmt_str(6,estring::right,'<','>') == "<<6.25");
	assert(es.fmt_str(7,estring::right,'<','>') == "<<<6.25");

	assert(es.fmt_str(0,estring::center,'<','>') == "");
	assert(es.fmt_str(1,estring::center,'<','>') == ".");
	assert(es.fmt_str(2,estring::center,'<','>') == "..");
	assert(es.fmt_str(3,estring::center,'<','>') == "...");
	assert(es.fmt_str(4,estring::center,'<','>') == "6.25");
	assert(es.fmt_str(5,estring::center,'<','>') == "6.25>");
	assert(es.fmt_str(6,estring::center,'<','>') == "<6.25>");
	assert(es.fmt_str(7,estring::center,'<','>') == "<6.25>>");
}

void test3(void)
{
	estring es;
	unsigned int uint;
	int sint;
	float fl;
	double dbl;

	es = static_cast<unsigned int>(0);
	assert(es == "0");
	uint = es;
	assert(uint == 0);
	
	es = static_cast<unsigned int>(1);
	assert(es == "1");
	uint = es;
	assert(uint == 1);

	es = static_cast<unsigned int>(9);
	assert(es == "9");
	uint = es;
	assert(uint == 9);

	es = static_cast<unsigned int>(10);
	assert(es == "10");
	uint = es;
	assert(uint == 10);

	es = static_cast<unsigned int>(11);
	assert(es == "11");
	uint = es;
	assert(uint == 11);

	es = static_cast<unsigned int>(99);
	assert(es == "99");
	uint = es;
	assert(uint == 99);

	es = static_cast<unsigned int>(100);
	assert(es == "100");
	uint = es;
	assert(uint == 100);

	es.reset();
	es.base(16);

	es = static_cast<unsigned int>(0);
	assert(es == "0");
	uint = es;
	assert(uint == 0);

	es = static_cast<unsigned int>(9);
	assert(es == "9");
	uint = es;
	assert(uint == 9);

	es = static_cast<unsigned int>(10);
	assert(es == "a");
	uint = es;
	assert(uint == 10);

	es = static_cast<unsigned int>(15);
	assert(es == "f");
	uint = es;
	assert(uint == 15);

	es = static_cast<unsigned int>(16);
	assert(es == "10");
	uint = es;
	assert(uint == 16);

	es = static_cast<unsigned int>(17);
	assert(es == "11");
	uint = es;
	assert(uint == 17);

	es = static_cast<int>(0);
	assert(es == "0");
	sint = es;
	assert(sint == 0);

	es = static_cast<int>(-0);
	assert(es == "0");
	sint = es;
	assert(sint == 0);

	es = static_cast<int>(9);
	assert(es == "9");
	sint = es;
	assert(sint == 9);

	es = static_cast<int>(-9);
	assert(es == "-9");
	sint = es;
	assert(sint == -9);

	es = static_cast<int>(10);
	assert(es == "a");
	sint = es;
	assert(sint == 10);

	es = static_cast<int>(-10);
	assert(es == "-a");
	sint = es;
	assert(sint == -10);

	es = static_cast<int>(15);
	assert(es == "f");
	sint = es;
	assert(sint == 15);

	es = static_cast<int>(-15);
	assert(es == "-f");
	sint = es;
	assert(sint == -15);

	es = static_cast<int>(16);
	assert(es == "10");
	sint = es;
	assert(sint == 16);

	es = static_cast<int>(-16);
	assert(es == "-10");
	sint = es;
	assert(sint == -16);

	es = static_cast<int>(17);
	assert(es == "11");
	sint = es;
	assert(sint == 17);

	es = static_cast<int>(-17);
	assert(es == "-11");
	sint = es;
	assert(sint == -17);

	es.reset();

	es = static_cast<float>(6.2);
	assert(es == "6.2");
	fl = es;
	assert(estring(fl,1) == "6.2");

	es.precision(4);
	es = static_cast<double>(-5.9238);
	assert(es == "-5.9238");
	dbl = es;
	assert(estring(dbl,4) == "-5.9238");
}

void test4(void)
{
	estring es;
	estring es2;
	union generic_value {
		unsigned int ui;
		int i;
		unsigned short us;
		short s;
		unsigned long ul;
		long l;
		unsigned long long ull;
		long long ll;
		float f;
		double d;
	};
	generic_value v;

	es.base(16);
	es = static_cast<int>(16);
	assert(es == "10");
	v.i = es;
	assert(v.i == 16);
	es.base(10);
	assert(es == "16");
	v.i = es;
	assert(v.i == 16);

	assert(es2.get_from_type() == estring::type_unknown);
	es2 = es;
	assert(es2.get_from_type() == estring::type_int);
	assert(es2.base() == es.base());
	assert(es2.get_from_value().value.i == 16);
}

void test5(void)
{
	estring es;

	es = "Hello World";
	es.lower();
	assert(es == "hello world");
	es = "Hello World";
	es.upper();
	assert(es == "HELLO WORLD");
}

int main(int argc, char const * argv[])
{
	try {
		test1();
		test2();
		test3();
		test4();
		test5();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	return(0);
}

