#include "config.h"

#include <iostream>
#include <string>

#include "asserts.h"
#include "error.h"
#include "help.h"

void print_help(void)
{
	std::string text;
	std::string bumper;
	
	TRY_nomem(text = "Usage: ");
	TRY_nomem(text += PACKAGE);
	TRY_nomem(text += " ");

	while (bumper.length() < text.length()) {
		bumper += " ";
	}

	TRY_nomem(text += "[ --archive | --relink | --help | --version | ");
	TRY_nomem(text += "--check-config ]");
	TRY_nomem(text += "\n");

	TRY_nomem(text += bumper);
	TRY_nomem(text += "[ --timestamp <timestamp> ]");
	TRY_nomem(text += "\n");

	TRY_nomem(text += bumper);
	TRY_nomem(text += "[ --no-default-config ]");
	TRY_nomem(text += "\n");

	TRY_nomem(text += bumper);
	TRY_nomem(text += "[[ --config <config-file> ] ...]");
	TRY_nomem(text += "\n");

	TRY_nomem(text += bumper);
	TRY_nomem(text += "[[ --job <job-file> ] ...]");
	TRY_nomem(text += "\n");

	print_version();
	std::cout << text << std::endl;
}

void print_version(void)
{
	std::cout << PACKAGE << " version " << VERSION << std::endl;
}

