// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// expected-no-diagnostics
#ifndef HEADER
#define HEADER
// Test host codegen.
// RUN: %clang_cc1 -DCK1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK2
// RUN: %clang_cc1 -DCK1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK4

// RUN: %clang_cc1 -DCK1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK6
// RUN: %clang_cc1 -DCK1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK7
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK8
#ifdef CK1

int a[100];

int teams_argument_global(int n){
  int te = n / 128;
  int th = 128;
  // discard n_addr


  #pragma omp target
  #pragma omp teams distribute parallel for simd num_teams(te), thread_limit(th) simdlen(64)
  for(int i = 0; i < n; i++) {
    a[i] = 0;
  }

  int i;
  #pragma omp target
  {{{
  #pragma omp teams distribute parallel for simd safelen(4) aligned(a) linear(i)
  for(i = 0; i < n; i++) {
    a[i] = 0;
  }
  }}}
  // outlined target regions




  return a[0];
}


#endif // CK1

// Test host codegen.
// RUN: %clang_cc1 -DCK2 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK10
// RUN: %clang_cc1 -DCK2 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK11
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK12

// RUN: %clang_cc1 -DCK2 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK13
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK14
// RUN: %clang_cc1 -DCK2 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK15
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK16
#ifdef CK2

int teams_local_arg(void) {
  int n = 100;
  int a[n], i;

  #pragma omp target
  #pragma omp teams distribute parallel for simd safelen(4) aligned(a) linear(i)
  for(i = 0; i < n; i++) {
    a[i] = 0;
  }

  // outlined target region


  return a[0];
}


#endif // CK2

// Test host codegen.
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK17
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK18
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK19
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK20

// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK21
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK22
// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK23
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK24
#ifdef CK3


template <typename T, int X, long long Y>
struct SS{
  T a[X];
  float b;
  int foo(void) {
    int i;
    #pragma omp target
    #pragma omp teams distribute parallel for simd safelen(4) aligned(a) linear(i)
    for(i = 0; i < X; i++) {
      a[i] = (T)0;
    }

      // outlined target region


    return a[0];
  }
};

int teams_template_struct(void) {
  SS<int, 123, 456> V;
  return V.foo();

}

#endif // CK3

// Test host codegen.
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK25
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK26
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK27
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK28

// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK29
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK30
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK31
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK32

#ifdef CK4

template <typename T, int n>
int tmain(T argc) {
  T a[n];
  int te = n/128;
  int th = 128;
#pragma omp target
#pragma omp teams distribute parallel for simd num_teams(te) thread_limit(th) simdlen(64)
  for(int i = 0; i < n; i++) {
    a[i] = (T)0;
  }
  return 0;
}

int main (int argc, char **argv) {
  int n = 100;
  int a[n], i;
#pragma omp target
#pragma omp teams distribute parallel for simd safelen(4) aligned(a) linear(i)
  for(i = 0; i < n; i++) {
    a[i] = 0;
  }
  return tmain<int, 10>(argc);
}








#endif // CK4
#endif

// CHECK1-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK1-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_CASTED7:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK1-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK1-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK1-NEXT:    store i64 [[TMP4]], i64* [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK1-NEXT:    store i64 [[TMP4]], i64* [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP21]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TE]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP30]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP31]], 0
// CHECK1-NEXT:    [[DIV4:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV4]], 1
// CHECK1-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK1-NEXT:    [[TMP33:%.*]] = zext i32 [[ADD]] to i64
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 [[TMP33]])
// CHECK1-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP29]], i32 0)
// CHECK1-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK1-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29(i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], [100 x i32]* @a) #[[ATTR2:[0-9]+]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, i32* [[I]], align 4
// CHECK1-NEXT:    [[CONV6:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP36]], i32* [[CONV6]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CONV8:%.*]] = bitcast i64* [[N_CASTED7]] to i32*
// CHECK1-NEXT:    store i32 [[TMP38]], i32* [[CONV8]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i64, i64* [[N_CASTED7]], align 8
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP41]], align 8
// CHECK1-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP43:%.*]] = bitcast i8** [[TMP42]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP43]], align 8
// CHECK1-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP44]], align 8
// CHECK1-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i64*
// CHECK1-NEXT:    store i64 [[TMP37]], i64* [[TMP46]], align 8
// CHECK1-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i64*
// CHECK1-NEXT:    store i64 [[TMP37]], i64* [[TMP48]], align 8
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP49]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to i64*
// CHECK1-NEXT:    store i64 [[TMP39]], i64* [[TMP51]], align 8
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to i64*
// CHECK1-NEXT:    store i64 [[TMP39]], i64* [[TMP53]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP54]], align 8
// CHECK1-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK1-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK1-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK1-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK1-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK1-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK1-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK1-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD18]] to i64
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP60]])
// CHECK1-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 3, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK1-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK1-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED19:%.*]], label [[OMP_OFFLOAD_CONT20:%.*]]
// CHECK1:       omp_offload.failed19:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36([100 x i32]* @a, i64 [[TMP37]], i64 [[TMP39]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT20]]
// CHECK1:       omp_offload.cont20:
// CHECK1-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK1-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29
// CHECK1-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], i64 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB3]])
// CHECK1-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 8
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB3]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV2]], [100 x i32]* [[TMP1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP15]] to i64
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP16]], i64 [[TMP18]], i32* [[TMP0]], [100 x i32]* [[TMP1]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK1-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP25]], 0
// CHECK1-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD8]], i32* [[I3]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP6]] to i32
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP7]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP9]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP18]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i64 0, i64 [[IDXPROM]]
// CHECK1-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK1-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP24]], 0
// CHECK1-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK1-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK1-NEXT:    store i32 [[ADD11]], i32* [[I4]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK1-SAME: ([100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], [100 x i32]* [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = zext i32 [[TMP16]] to i64
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = zext i32 [[TMP18]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32*, [100 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP17]], i64 [[TMP19]], i32* [[I4]], i32* [[TMP1]], [100 x i32]* [[TMP2]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP22]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP23]])
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK1-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP26]], 0
// CHECK1-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB4:[0-9]+]], i32 [[TMP11]])
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP13]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP16]], [[COND_TRUE]] ], [ [[TMP17]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK1-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I5]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP22]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 [[IDXPROM]]
// CHECK1-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK1-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP25]])
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK1-NEXT:    br i1 [[TMP27]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK1-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK1-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[DIV11]], 1
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK1-NEXT:    store i32 [[ADD13]], i32* [[TMP0]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK1-NEXT:    br i1 [[TMP30]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK2-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_CASTED7:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [3 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [3 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [3 x i8*], align 8
// CHECK2-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK2-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK2-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP1]], i32* [[CONV]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[CONV1]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[CONV2]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK2-NEXT:    store i64 [[TMP2]], i64* [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK2-NEXT:    store i64 [[TMP2]], i64* [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK2-NEXT:    store i64 [[TMP4]], i64* [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK2-NEXT:    store i64 [[TMP4]], i64* [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP16]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i64*
// CHECK2-NEXT:    store i64 [[TMP6]], i64* [[TMP18]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK2-NEXT:    store i64 [[TMP6]], i64* [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK2-NEXT:    store i8* null, i8** [[TMP21]], align 8
// CHECK2-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP23]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP25]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK2-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK2-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TE]], align 4
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP30]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP31]], 0
// CHECK2-NEXT:    [[DIV4:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV4]], 1
// CHECK2-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK2-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK2-NEXT:    [[TMP33:%.*]] = zext i32 [[ADD]] to i64
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 [[TMP33]])
// CHECK2-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP29]], i32 0)
// CHECK2-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK2-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29(i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], [100 x i32]* @a) #[[ATTR2:[0-9]+]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, i32* [[I]], align 4
// CHECK2-NEXT:    [[CONV6:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP36]], i32* [[CONV6]], align 4
// CHECK2-NEXT:    [[TMP37:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[CONV8:%.*]] = bitcast i64* [[N_CASTED7]] to i32*
// CHECK2-NEXT:    store i32 [[TMP38]], i32* [[CONV8]], align 4
// CHECK2-NEXT:    [[TMP39:%.*]] = load i64, i64* [[N_CASTED7]], align 8
// CHECK2-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP41]], align 8
// CHECK2-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP43:%.*]] = bitcast i8** [[TMP42]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP43]], align 8
// CHECK2-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP44]], align 8
// CHECK2-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i64*
// CHECK2-NEXT:    store i64 [[TMP37]], i64* [[TMP46]], align 8
// CHECK2-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i64*
// CHECK2-NEXT:    store i64 [[TMP37]], i64* [[TMP48]], align 8
// CHECK2-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP49]], align 8
// CHECK2-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to i64*
// CHECK2-NEXT:    store i64 [[TMP39]], i64* [[TMP51]], align 8
// CHECK2-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to i64*
// CHECK2-NEXT:    store i64 [[TMP39]], i64* [[TMP53]], align 8
// CHECK2-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 2
// CHECK2-NEXT:    store i8* null, i8** [[TMP54]], align 8
// CHECK2-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK2-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK2-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK2-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK2-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK2-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK2-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK2-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK2-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD18]] to i64
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP60]])
// CHECK2-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 3, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK2-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK2-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED19:%.*]], label [[OMP_OFFLOAD_CONT20:%.*]]
// CHECK2:       omp_offload.failed19:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36([100 x i32]* @a, i64 [[TMP37]], i64 [[TMP39]]) #[[ATTR2]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT20]]
// CHECK2:       omp_offload.cont20:
// CHECK2-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK2-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29
// CHECK2-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], i64 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB3]])
// CHECK2-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK2-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 8
// CHECK2-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB3]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV2]], [100 x i32]* [[TMP1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK2-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP15]] to i64
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP16]], i64 [[TMP18]], i32* [[TMP0]], [100 x i32]* [[TMP1]])
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK2-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP25]], 0
// CHECK2-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK2-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD8]], i32* [[I3]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP6]] to i32
// CHECK2-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK2-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP7]] to i32
// CHECK2-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP9]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK2-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK2-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP18]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i64 0, i64 [[IDXPROM]]
// CHECK2-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK2-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK2-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP24]], 0
// CHECK2-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK2-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK2-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK2-NEXT:    store i32 [[ADD11]], i32* [[I4]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK2-SAME: ([100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], [100 x i32]* [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK2-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = zext i32 [[TMP16]] to i64
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP19:%.*]] = zext i32 [[TMP18]] to i64
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32*, [100 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP17]], i64 [[TMP19]], i32* [[I4]], i32* [[TMP1]], [100 x i32]* [[TMP2]])
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP22]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP23]])
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK2-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP26]], 0
// CHECK2-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK2-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK2-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK2-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB4:[0-9]+]], i32 [[TMP11]])
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP13]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP14]], [[TMP15]]
// CHECK2-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP16]], [[COND_TRUE]] ], [ [[TMP17]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK2-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I5]], align 4
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP22]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 [[IDXPROM]]
// CHECK2-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK2-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP25]])
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK2-NEXT:    br i1 [[TMP27]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK2-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK2-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[DIV11]], 1
// CHECK2-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK2-NEXT:    store i32 [[ADD13]], i32* [[TMP0]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK2-NEXT:    br i1 [[TMP30]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK2:       .omp.linear.pu:
// CHECK2-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK2:       .omp.linear.pu.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK2-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK2-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK3-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_CASTED4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[_TMP8:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK3-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK3-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TE_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TH_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32*
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TE]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP30]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP31]], 0
// CHECK3-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK3-NEXT:    [[TMP33:%.*]] = zext i32 [[ADD]] to i64
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 [[TMP33]])
// CHECK3-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP29]], i32 0)
// CHECK3-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK3-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29(i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], [100 x i32]* @a) #[[ATTR2:[0-9]+]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    [[TMP36:%.*]] = load i32, i32* [[I]], align 4
// CHECK3-NEXT:    store i32 [[TMP36]], i32* [[I_CASTED]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP38]], i32* [[N_CASTED4]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32, i32* [[N_CASTED4]], align 4
// CHECK3-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP41]], align 4
// CHECK3-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP43:%.*]] = bitcast i8** [[TMP42]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP43]], align 4
// CHECK3-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP44]], align 4
// CHECK3-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i32*
// CHECK3-NEXT:    store i32 [[TMP37]], i32* [[TMP46]], align 4
// CHECK3-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32*
// CHECK3-NEXT:    store i32 [[TMP37]], i32* [[TMP48]], align 4
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP49]], align 4
// CHECK3-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to i32*
// CHECK3-NEXT:    store i32 [[TMP39]], i32* [[TMP51]], align 4
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to i32*
// CHECK3-NEXT:    store i32 [[TMP39]], i32* [[TMP53]], align 4
// CHECK3-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP54]], align 4
// CHECK3-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK3-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK3-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK3-NEXT:    [[DIV12:%.*]] = sdiv i32 [[SUB11]], 1
// CHECK3-NEXT:    [[SUB13:%.*]] = sub nsw i32 [[DIV12]], 1
// CHECK3-NEXT:    store i32 [[SUB13]], i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK3-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK3-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK3-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD14]] to i64
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP60]])
// CHECK3-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 3, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK3-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK3-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK3:       omp_offload.failed15:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36([100 x i32]* @a, i32 [[TMP37]], i32 [[TMP39]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK3:       omp_offload.cont16:
// CHECK3-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK3-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29
// CHECK3-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], i32 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB3]])
// CHECK3-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB3]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], [100 x i32]* [[TMP1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP15]], i32 [[TMP16]], i32* [[TMP0]], [100 x i32]* [[TMP1]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK3-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK3-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[I3]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP9]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i32 0, i32 [[TMP18]]
// CHECK3-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK3-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP24]], 0
// CHECK3-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK3-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK3-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK3-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK3-SAME: ([100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], [100 x i32]* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 0
// CHECK3-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32*, [100 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP16]], i32 [[TMP17]], i32* [[I4]], i32* [[TMP1]], [100 x i32]* [[TMP2]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK3-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP24]], 0
// CHECK3-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 0
// CHECK3-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB4:[0-9]+]], i32 [[TMP11]])
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP13]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP16]], [[COND_TRUE]] ], [ [[TMP17]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I4]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 [[TMP22]]
// CHECK3-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP25]])
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK3-NEXT:    br i1 [[TMP27]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK3-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK3-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK3-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK3-NEXT:    store i32 [[ADD12]], i32* [[TMP0]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK3-NEXT:    br i1 [[TMP30]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK3:       .omp.linear.pu:
// CHECK3-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK3:       .omp.linear.pu.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK4-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_CASTED4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [3 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [3 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [3 x i8*], align 4
// CHECK4-NEXT:    [[_TMP8:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK4-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK4-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[TE_CASTED]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[TH_CASTED]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], i32* [[N_CASTED]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[TMP8]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK4-NEXT:    store i32 [[TMP4]], i32* [[TMP13]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK4-NEXT:    store i32 [[TMP4]], i32* [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP16]], align 4
// CHECK4-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32*
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[TMP18]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[TMP20]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK4-NEXT:    store i8* null, i8** [[TMP21]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP23]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP25]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK4-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TE]], align 4
// CHECK4-NEXT:    [[TMP30:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP30]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP31]], 0
// CHECK4-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK4-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK4-NEXT:    [[TMP33:%.*]] = zext i32 [[ADD]] to i64
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 [[TMP33]])
// CHECK4-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP29]], i32 0)
// CHECK4-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK4-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29(i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], [100 x i32]* @a) #[[ATTR2:[0-9]+]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    [[TMP36:%.*]] = load i32, i32* [[I]], align 4
// CHECK4-NEXT:    store i32 [[TMP36]], i32* [[I_CASTED]], align 4
// CHECK4-NEXT:    [[TMP37:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK4-NEXT:    [[TMP38:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP38]], i32* [[N_CASTED4]], align 4
// CHECK4-NEXT:    [[TMP39:%.*]] = load i32, i32* [[N_CASTED4]], align 4
// CHECK4-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP41]], align 4
// CHECK4-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP43:%.*]] = bitcast i8** [[TMP42]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP43]], align 4
// CHECK4-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP44]], align 4
// CHECK4-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i32*
// CHECK4-NEXT:    store i32 [[TMP37]], i32* [[TMP46]], align 4
// CHECK4-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32*
// CHECK4-NEXT:    store i32 [[TMP37]], i32* [[TMP48]], align 4
// CHECK4-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP49]], align 4
// CHECK4-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to i32*
// CHECK4-NEXT:    store i32 [[TMP39]], i32* [[TMP51]], align 4
// CHECK4-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to i32*
// CHECK4-NEXT:    store i32 [[TMP39]], i32* [[TMP53]], align 4
// CHECK4-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 2
// CHECK4-NEXT:    store i8* null, i8** [[TMP54]], align 4
// CHECK4-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK4-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK4-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK4-NEXT:    [[DIV12:%.*]] = sdiv i32 [[SUB11]], 1
// CHECK4-NEXT:    [[SUB13:%.*]] = sub nsw i32 [[DIV12]], 1
// CHECK4-NEXT:    store i32 [[SUB13]], i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK4-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK4-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK4-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD14]] to i64
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP60]])
// CHECK4-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 3, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK4-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK4-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK4:       omp_offload.failed15:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36([100 x i32]* @a, i32 [[TMP37]], i32 [[TMP39]]) #[[ATTR2]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK4:       omp_offload.cont16:
// CHECK4-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK4-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l29
// CHECK4-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], i32 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB3]])
// CHECK4-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK4-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB3]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], [100 x i32]* [[TMP1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK4-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK4-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP15]], i32 [[TMP16]], i32* [[TMP0]], [100 x i32]* [[TMP1]])
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK4-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK4-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK4-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD8]], i32* [[I3]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP9]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK4-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK4-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I3]], align 4
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i32 0, i32 [[TMP18]]
// CHECK4-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK4-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK4-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP24]], 0
// CHECK4-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK4-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK4-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK4-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK4-SAME: ([100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], [100 x i32]* [[TMP0]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK4-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 0
// CHECK4-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK4-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK4-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32*, [100 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP16]], i32 [[TMP17]], i32* [[I4]], i32* [[TMP1]], [100 x i32]* [[TMP2]])
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK4-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP24]], 0
// CHECK4-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK4-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK4-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 0
// CHECK4-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB4:[0-9]+]], i32 [[TMP11]])
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP13]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP14]], [[TMP15]]
// CHECK4-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP16]], [[COND_TRUE]] ], [ [[TMP17]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK4-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I4]], align 4
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 [[TMP22]]
// CHECK4-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK4-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP25]])
// CHECK4-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK4-NEXT:    br i1 [[TMP27]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK4-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK4-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK4-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK4-NEXT:    store i32 [[ADD12]], i32* [[TMP0]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK4-NEXT:    br i1 [[TMP30]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK4:       .omp.linear.pu:
// CHECK4-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK4:       .omp.linear.pu.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK4-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK4-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK5-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I11:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB18:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB19:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK5-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK5-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK5-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK5-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK5-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK5-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK5:       simd.if.then:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK5-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM]]
// CHECK5-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK5-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP11]], 0
// CHECK5-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK5-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK5-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK5-NEXT:    store i32 [[ADD10]], i32* [[I4]], align 4
// CHECK5-NEXT:    br label [[SIMD_IF_END]]
// CHECK5:       simd.if.end:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP12]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK5-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK5-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK5-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK5-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB18]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK5-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_UB19]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[I20]], align 4
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK5-NEXT:    [[CMP21:%.*]] = icmp slt i32 0, [[TMP15]]
// CHECK5-NEXT:    br i1 [[CMP21]], label [[SIMD_IF_THEN22:%.*]], label [[SIMD_IF_END41:%.*]]
// CHECK5:       simd.if.then22:
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB18]], align 4
// CHECK5-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV23]], align 4
// CHECK5-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), i64 16) ]
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I11]], align 4
// CHECK5-NEXT:    store i32 [[TMP17]], i32* [[DOTLINEAR_START]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK5:       omp.inner.for.cond26:
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB19]], align 4
// CHECK5-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK5-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END36:%.*]]
// CHECK5:       omp.inner.for.body28:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK5-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK5-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK5-NEXT:    store i32 [[ADD30]], i32* [[I24]], align 4
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I24]], align 4
// CHECK5-NEXT:    [[IDXPROM31:%.*]] = sext i32 [[TMP21]] to i64
// CHECK5-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM31]]
// CHECK5-NEXT:    store i32 0, i32* [[ARRAYIDX32]], align 4
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE33:%.*]]
// CHECK5:       omp.body.continue33:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC34:%.*]]
// CHECK5:       omp.inner.for.inc34:
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK5-NEXT:    [[ADD35:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK5-NEXT:    store i32 [[ADD35]], i32* [[DOTOMP_IV23]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK5:       omp.inner.for.end36:
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK5-NEXT:    [[SUB37:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK5-NEXT:    [[DIV38:%.*]] = sdiv i32 [[SUB37]], 1
// CHECK5-NEXT:    [[MUL39:%.*]] = mul nsw i32 [[DIV38]], 1
// CHECK5-NEXT:    [[ADD40:%.*]] = add nsw i32 0, [[MUL39]]
// CHECK5-NEXT:    store i32 [[ADD40]], i32* [[I11]], align 4
// CHECK5-NEXT:    br label [[SIMD_IF_END41]]
// CHECK5:       simd.if.end41:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK5-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK6-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I11:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB18:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB19:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK6-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK6-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK6-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK6-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK6-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK6-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK6-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK6:       simd.if.then:
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK6-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM]]
// CHECK6-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK6-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP11]], 0
// CHECK6-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK6-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK6-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK6-NEXT:    store i32 [[ADD10]], i32* [[I4]], align 4
// CHECK6-NEXT:    br label [[SIMD_IF_END]]
// CHECK6:       simd.if.end:
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP12]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK6-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK6-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK6-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK6-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB18]], align 4
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK6-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_UB19]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[I20]], align 4
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK6-NEXT:    [[CMP21:%.*]] = icmp slt i32 0, [[TMP15]]
// CHECK6-NEXT:    br i1 [[CMP21]], label [[SIMD_IF_THEN22:%.*]], label [[SIMD_IF_END41:%.*]]
// CHECK6:       simd.if.then22:
// CHECK6-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB18]], align 4
// CHECK6-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV23]], align 4
// CHECK6-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), i64 16) ]
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I11]], align 4
// CHECK6-NEXT:    store i32 [[TMP17]], i32* [[DOTLINEAR_START]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK6:       omp.inner.for.cond26:
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK6-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB19]], align 4
// CHECK6-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK6-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END36:%.*]]
// CHECK6:       omp.inner.for.body28:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK6-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK6-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK6-NEXT:    store i32 [[ADD30]], i32* [[I24]], align 4
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I24]], align 4
// CHECK6-NEXT:    [[IDXPROM31:%.*]] = sext i32 [[TMP21]] to i64
// CHECK6-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM31]]
// CHECK6-NEXT:    store i32 0, i32* [[ARRAYIDX32]], align 4
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE33:%.*]]
// CHECK6:       omp.body.continue33:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC34:%.*]]
// CHECK6:       omp.inner.for.inc34:
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK6-NEXT:    [[ADD35:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK6-NEXT:    store i32 [[ADD35]], i32* [[DOTOMP_IV23]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK6:       omp.inner.for.end36:
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK6-NEXT:    [[SUB37:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK6-NEXT:    [[DIV38:%.*]] = sdiv i32 [[SUB37]], 1
// CHECK6-NEXT:    [[MUL39:%.*]] = mul nsw i32 [[DIV38]], 1
// CHECK6-NEXT:    [[ADD40:%.*]] = add nsw i32 0, [[MUL39]]
// CHECK6-NEXT:    store i32 [[ADD40]], i32* [[I11]], align 4
// CHECK6-NEXT:    br label [[SIMD_IF_END41]]
// CHECK6:       simd.if.end41:
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK6-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK7-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I11:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB18:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB19:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK7-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK7-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK7-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK7-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK7-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK7-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK7:       simd.if.then:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK7-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP9]]
// CHECK7-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK7-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP11]], 0
// CHECK7-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK7-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK7-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK7-NEXT:    store i32 [[ADD10]], i32* [[I4]], align 4
// CHECK7-NEXT:    br label [[SIMD_IF_END]]
// CHECK7:       simd.if.end:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP12]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK7-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK7-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK7-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK7-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB18]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK7-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_UB19]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[I20]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK7-NEXT:    [[CMP21:%.*]] = icmp slt i32 0, [[TMP15]]
// CHECK7-NEXT:    br i1 [[CMP21]], label [[SIMD_IF_THEN22:%.*]], label [[SIMD_IF_END40:%.*]]
// CHECK7:       simd.if.then22:
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB18]], align 4
// CHECK7-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV23]], align 4
// CHECK7-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), i32 16) ]
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I11]], align 4
// CHECK7-NEXT:    store i32 [[TMP17]], i32* [[DOTLINEAR_START]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK7:       omp.inner.for.cond26:
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB19]], align 4
// CHECK7-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK7-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK7:       omp.inner.for.body28:
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK7-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK7-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK7-NEXT:    store i32 [[ADD30]], i32* [[I24]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I24]], align 4
// CHECK7-NEXT:    [[ARRAYIDX31:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP21]]
// CHECK7-NEXT:    store i32 0, i32* [[ARRAYIDX31]], align 4
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK7:       omp.body.continue32:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK7:       omp.inner.for.inc33:
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK7-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK7-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV23]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK7:       omp.inner.for.end35:
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK7-NEXT:    [[SUB36:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK7-NEXT:    [[DIV37:%.*]] = sdiv i32 [[SUB36]], 1
// CHECK7-NEXT:    [[MUL38:%.*]] = mul nsw i32 [[DIV37]], 1
// CHECK7-NEXT:    [[ADD39:%.*]] = add nsw i32 0, [[MUL38]]
// CHECK7-NEXT:    store i32 [[ADD39]], i32* [[I11]], align 4
// CHECK7-NEXT:    br label [[SIMD_IF_END40]]
// CHECK7:       simd.if.end40:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK7-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK8-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I11:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB18:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB19:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK8-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK8-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK8-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK8-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK8-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK8-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK8:       simd.if.then:
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK8-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP9]]
// CHECK8-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK8-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP11]], 0
// CHECK8-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK8-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK8-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK8-NEXT:    store i32 [[ADD10]], i32* [[I4]], align 4
// CHECK8-NEXT:    br label [[SIMD_IF_END]]
// CHECK8:       simd.if.end:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP12]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK8-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK8-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK8-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK8-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB18]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK8-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_UB19]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[I20]], align 4
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK8-NEXT:    [[CMP21:%.*]] = icmp slt i32 0, [[TMP15]]
// CHECK8-NEXT:    br i1 [[CMP21]], label [[SIMD_IF_THEN22:%.*]], label [[SIMD_IF_END40:%.*]]
// CHECK8:       simd.if.then22:
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB18]], align 4
// CHECK8-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV23]], align 4
// CHECK8-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), i32 16) ]
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I11]], align 4
// CHECK8-NEXT:    store i32 [[TMP17]], i32* [[DOTLINEAR_START]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK8:       omp.inner.for.cond26:
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB19]], align 4
// CHECK8-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK8-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK8:       omp.inner.for.body28:
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK8-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK8-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK8-NEXT:    store i32 [[ADD30]], i32* [[I24]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I24]], align 4
// CHECK8-NEXT:    [[ARRAYIDX31:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP21]]
// CHECK8-NEXT:    store i32 0, i32* [[ARRAYIDX31]], align 4
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK8:       omp.body.continue32:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK8:       omp.inner.for.inc33:
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4
// CHECK8-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK8-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV23]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK8:       omp.inner.for.end35:
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK8-NEXT:    [[SUB36:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK8-NEXT:    [[DIV37:%.*]] = sdiv i32 [[SUB36]], 1
// CHECK8-NEXT:    [[MUL38:%.*]] = mul nsw i32 [[DIV37]], 1
// CHECK8-NEXT:    [[ADD39:%.*]] = add nsw i32 0, [[MUL38]]
// CHECK8-NEXT:    store i32 [[ADD39]], i32* [[I11]], align 4
// CHECK8-NEXT:    br label [[SIMD_IF_END40]]
// CHECK8:       simd.if.end40:
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK8-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK9-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK9-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK9-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK9-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK9-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP9]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP11]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK9-NEXT:    store i64 8, i64* [[TMP12]], align 8
// CHECK9-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK9-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 8
// CHECK9-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK9-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 8
// CHECK9-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK9-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 8
// CHECK9-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK9-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK9-NEXT:    store i64 [[TMP4]], i64* [[TMP21]], align 8
// CHECK9-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK9-NEXT:    store i64 [[TMP4]], i64* [[TMP23]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK9-NEXT:    store i64 4, i64* [[TMP24]], align 8
// CHECK9-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK9-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK9-NEXT:    store i64 [[TMP6]], i64* [[TMP27]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK9-NEXT:    store i64 [[TMP6]], i64* [[TMP29]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK9-NEXT:    store i64 4, i64* [[TMP30]], align 8
// CHECK9-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK9-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK9-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK9-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK9-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK9:       omp_offload.failed:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74(i64 [[TMP1]], i32* [[VLA]], i64 [[TMP4]], i64 [[TMP6]]) #[[ATTR5:[0-9]+]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK9:       omp_offload.cont:
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK9-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK9-NEXT:    ret i32 [[TMP41]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74
// CHECK9-SAME: (i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK9-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32*, i64, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[I4]], i32* [[TMP1]], i64 [[TMP2]], i32* [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK9-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK9:       .omp.final.then:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP27]], 0
// CHECK9-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK9-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK9:       .omp.final.done:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK9-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP10]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK9-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK9-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I5]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i64 [[IDXPROM]]
// CHECK9-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK9-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK9:       .omp.final.then:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK9-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK9-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[DIV11]], 1
// CHECK9-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK9-NEXT:    store i32 [[ADD13]], i32* [[TMP0]], align 4
// CHECK9-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK9:       .omp.final.done:
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK9-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK9:       .omp.linear.pu:
// CHECK9-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK9:       .omp.linear.pu.done:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK9-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK9-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK10-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK10-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 8
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK10-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK10-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK10-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK10-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I]], align 4
// CHECK10-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK10-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N]], align 4
// CHECK10-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK10-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK10-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK10-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK10-NEXT:    store i64 [[TMP1]], i64* [[TMP9]], align 8
// CHECK10-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK10-NEXT:    store i64 [[TMP1]], i64* [[TMP11]], align 8
// CHECK10-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK10-NEXT:    store i64 8, i64* [[TMP12]], align 8
// CHECK10-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK10-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK10-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK10-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK10-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 8
// CHECK10-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK10-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK10-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 8
// CHECK10-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK10-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 8
// CHECK10-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK10-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK10-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK10-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK10-NEXT:    store i64 [[TMP4]], i64* [[TMP21]], align 8
// CHECK10-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK10-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK10-NEXT:    store i64 [[TMP4]], i64* [[TMP23]], align 8
// CHECK10-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK10-NEXT:    store i64 4, i64* [[TMP24]], align 8
// CHECK10-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK10-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK10-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK10-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK10-NEXT:    store i64 [[TMP6]], i64* [[TMP27]], align 8
// CHECK10-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK10-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK10-NEXT:    store i64 [[TMP6]], i64* [[TMP29]], align 8
// CHECK10-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK10-NEXT:    store i64 4, i64* [[TMP30]], align 8
// CHECK10-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK10-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK10-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK10-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK10-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK10-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK10-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK10-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK10-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK10-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK10-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK10-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK10-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK10:       omp_offload.failed:
// CHECK10-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74(i64 [[TMP1]], i32* [[VLA]], i64 [[TMP4]], i64 [[TMP6]]) #[[ATTR5:[0-9]+]]
// CHECK10-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK10:       omp_offload.cont:
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK10-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK10-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK10-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK10-NEXT:    ret i32 [[TMP41]]
//
//
// CHECK10-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74
// CHECK10-SAME: (i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK10-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK10-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK10-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK10-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK10-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK10-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK10-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK10-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK10-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK10-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK10-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK10-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK10:       omp.precond.then:
// CHECK10-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK10-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK10-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK10-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK10-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32*, i64, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[I4]], i32* [[TMP1]], i64 [[TMP2]], i32* [[TMP3]])
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK10-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK10-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP27]], 0
// CHECK10-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK10-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK10:       omp.precond.end:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK10-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK10-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK10-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK10-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK10-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK10-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK10-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK10-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK10-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK10-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK10:       omp.precond.then:
// CHECK10-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK10-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK10-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK10-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK10-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK10-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP10]] to i32
// CHECK10-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK10-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK10-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK10-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4
// CHECK10-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I5]], align 4
// CHECK10-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i64 [[IDXPROM]]
// CHECK10-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK10-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK10-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK10-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK10-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK10-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[DIV11]], 1
// CHECK10-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK10-NEXT:    store i32 [[ADD13]], i32* [[TMP0]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK10-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK10:       .omp.linear.pu:
// CHECK10-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK10:       .omp.linear.pu.done:
// CHECK10-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK10:       omp.precond.end:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK10-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK10-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK11-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK11-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK11-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[I]], align 4
// CHECK11-NEXT:    store i32 [[TMP2]], i32* [[I_CASTED]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK11-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
// CHECK11-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[TMP9]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[TMP11]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK11-NEXT:    store i64 4, i64* [[TMP12]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK11-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK11-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK11-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK11-NEXT:    store i32 [[TMP3]], i32* [[TMP21]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK11-NEXT:    store i32 [[TMP3]], i32* [[TMP23]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK11-NEXT:    store i64 4, i64* [[TMP24]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[TMP27]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[TMP29]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK11-NEXT:    store i64 4, i64* [[TMP30]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK11-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK11-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK11-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK11-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK11:       omp_offload.failed:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74(i32 [[TMP0]], i32* [[VLA]], i32 [[TMP3]], i32 [[TMP5]]) #[[ATTR5:[0-9]+]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK11:       omp_offload.cont:
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK11-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK11-NEXT:    ret i32 [[TMP41]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74
// CHECK11-SAME: (i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK11-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32*, i32, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[I4]], i32* [[TMP1]], i32 [[TMP2]], i32* [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK11-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK11:       .omp.final.then:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP25]], 0
// CHECK11-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK11-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK11:       .omp.final.done:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK11-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK11-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK11-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i32 [[TMP23]]
// CHECK11-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK11-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK11-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK11:       .omp.final.then:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK11-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK11-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK11-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK11-NEXT:    store i32 [[ADD12]], i32* [[TMP0]], align 4
// CHECK11-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK11:       .omp.final.done:
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK11-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK11:       .omp.linear.pu:
// CHECK11-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK11:       .omp.linear.pu.done:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK11-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK11-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK12-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK12-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK12-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK12-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[I]], align 4
// CHECK12-NEXT:    store i32 [[TMP2]], i32* [[I_CASTED]], align 4
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK12-NEXT:    store i32 [[TMP4]], i32* [[N_CASTED]], align 4
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK12-NEXT:    [[TMP6:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK12-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
// CHECK12-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[TMP9]], align 4
// CHECK12-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[TMP11]], align 4
// CHECK12-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK12-NEXT:    store i64 4, i64* [[TMP12]], align 4
// CHECK12-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK12-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK12-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK12-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK12-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 4
// CHECK12-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK12-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK12-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 4
// CHECK12-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK12-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 4
// CHECK12-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK12-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK12-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK12-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK12-NEXT:    store i32 [[TMP3]], i32* [[TMP21]], align 4
// CHECK12-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK12-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK12-NEXT:    store i32 [[TMP3]], i32* [[TMP23]], align 4
// CHECK12-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK12-NEXT:    store i64 4, i64* [[TMP24]], align 4
// CHECK12-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK12-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK12-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK12-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK12-NEXT:    store i32 [[TMP5]], i32* [[TMP27]], align 4
// CHECK12-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK12-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK12-NEXT:    store i32 [[TMP5]], i32* [[TMP29]], align 4
// CHECK12-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK12-NEXT:    store i64 4, i64* [[TMP30]], align 4
// CHECK12-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK12-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK12-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK12-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK12-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK12-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK12-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK12-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK12-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK12-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK12-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK12-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK12:       omp_offload.failed:
// CHECK12-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74(i32 [[TMP0]], i32* [[VLA]], i32 [[TMP3]], i32 [[TMP5]]) #[[ATTR5:[0-9]+]]
// CHECK12-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK12:       omp_offload.cont:
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK12-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK12-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK12-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK12-NEXT:    ret i32 [[TMP41]]
//
//
// CHECK12-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l74
// CHECK12-SAME: (i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK12-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK12-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK12-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK12-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK12-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK12-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK12-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK12:       omp.precond.then:
// CHECK12-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK12-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK12-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK12-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK12-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK12-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK12:       cond.true:
// CHECK12-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    br label [[COND_END:%.*]]
// CHECK12:       cond.false:
// CHECK12-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK12-NEXT:    br label [[COND_END]]
// CHECK12:       cond.end:
// CHECK12-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK12-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK12-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK12-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK12-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK12-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32*, i32, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[I4]], i32* [[TMP1]], i32 [[TMP2]], i32* [[TMP3]])
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK12:       omp.loop.exit:
// CHECK12-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK12-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK12-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK12-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK12:       .omp.final.then:
// CHECK12-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP25]], 0
// CHECK12-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK12-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK12-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK12:       .omp.final.done:
// CHECK12-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK12:       omp.precond.end:
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK12-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK12-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK12-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK12-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK12-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK12-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK12-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK12-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK12-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK12:       omp.precond.then:
// CHECK12-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK12-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK12-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK12-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK12-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK12-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK12-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK12-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK12-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK12-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK12:       cond.true:
// CHECK12-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    br label [[COND_END:%.*]]
// CHECK12:       cond.false:
// CHECK12-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    br label [[COND_END]]
// CHECK12:       cond.end:
// CHECK12-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK12-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK12-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK12-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i32 [[TMP23]]
// CHECK12-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK12-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK12:       omp.loop.exit:
// CHECK12-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK12-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK12-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK12-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK12:       .omp.final.then:
// CHECK12-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK12-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK12-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK12-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK12-NEXT:    store i32 [[ADD12]], i32* [[TMP0]], align 4
// CHECK12-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK12:       .omp.final.done:
// CHECK12-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK12-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK12:       .omp.linear.pu:
// CHECK12-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK12:       .omp.linear.pu.done:
// CHECK12-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK12:       omp.precond.end:
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK12-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK12-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK13-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK13-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK13-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK13-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK13-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK13-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK13-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK13-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK13-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK13-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK13:       simd.if.then:
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i64 16) ]
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK13-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK13-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK13-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I4]], align 4
// CHECK13-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP12]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK13-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK13-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK13-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK13-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK13-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK13-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK13-NEXT:    br label [[SIMD_IF_END]]
// CHECK13:       simd.if.end:
// CHECK13-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK13-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX12]], align 4
// CHECK13-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    call void @llvm.stackrestore(i8* [[TMP16]])
// CHECK13-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK14-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK14-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK14-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK14-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK14-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK14-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK14-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK14-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK14-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK14-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK14-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK14-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK14-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK14-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK14:       simd.if.then:
// CHECK14-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i64 16) ]
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK14-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK14-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK14-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I4]], align 4
// CHECK14-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP12]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK14-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK14-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK14-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK14-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK14-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK14-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK14-NEXT:    br label [[SIMD_IF_END]]
// CHECK14:       simd.if.end:
// CHECK14-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK14-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX12]], align 4
// CHECK14-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK14-NEXT:    call void @llvm.stackrestore(i8* [[TMP16]])
// CHECK14-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK15-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK15-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK15-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK15-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK15-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK15-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK15-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK15:       simd.if.then:
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i32 16) ]
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4
// CHECK15-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK15-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I4]], align 4
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP11]]
// CHECK15-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK15-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK15-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK15-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK15-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK15-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK15-NEXT:    br label [[SIMD_IF_END]]
// CHECK15:       simd.if.end:
// CHECK15-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK15-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARRAYIDX12]], align 4
// CHECK15-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK15-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK16-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK16-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK16-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK16-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK16-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK16-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK16-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK16-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK16-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK16-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK16:       simd.if.then:
// CHECK16-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i32 16) ]
// CHECK16-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4
// CHECK16-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK16-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I4]], align 4
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP11]]
// CHECK16-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK16-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK16-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK16-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK16-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK16-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK16-NEXT:    br label [[SIMD_IF_END]]
// CHECK16:       simd.if.end:
// CHECK16-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK16-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARRAYIDX12]], align 4
// CHECK16-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK16-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK16-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK17-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK17-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK17-NEXT:    ret i32 [[CALL]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK17-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 8
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[I]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to %struct.SS**
// CHECK17-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP3]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to [123 x i32]**
// CHECK17-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP5]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP6]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK17-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK17-NEXT:    store i64 [[TMP1]], i64* [[TMP10]], align 8
// CHECK17-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 123)
// CHECK17-NEXT:    [[TMP14:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112.region_id, i32 2, i8** [[TMP12]], i8** [[TMP13]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK17-NEXT:    [[TMP15:%.*]] = icmp ne i32 [[TMP14]], 0
// CHECK17-NEXT:    br i1 [[TMP15]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112(%struct.SS* [[THIS1]], i64 [[TMP1]]) #[[ATTR4:[0-9]+]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i64 0, i64 0
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112
// CHECK17-SAME: (%struct.SS* [[THIS:%.*]], i64 [[I:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], %struct.SS* [[TMP0]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I1:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK17-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 0
// CHECK17-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK17-NEXT:    store i32 122, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP3]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 122
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = zext i32 [[TMP9]] to i64
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK17-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP11]] to i64
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, %struct.SS*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP10]], i64 [[TMP12]], i32* [[I1]], %struct.SS* [[TMP1]])
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP16:%.*]] = icmp ne i32 [[TMP15]], 0
// CHECK17-NEXT:    br i1 [[TMP16]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK17-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 0
// CHECK17-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK17-NEXT:    store i32 [[TMP2]], i32* [[DOTLINEAR_START]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK17-NEXT:    [[CONV1:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK17-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[CONV1]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK17-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP6]])
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP6]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 122
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK17-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I2]], align 4
// CHECK17-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I2]], align 4
// CHECK17-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A5]], i64 0, i64 [[IDXPROM]]
// CHECK17-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK17-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP16:%.*]] = icmp ne i32 [[TMP15]], 0
// CHECK17-NEXT:    br i1 [[TMP16]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK17-NEXT:    br i1 [[TMP18]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK17:       .omp.linear.pu:
// CHECK17-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK17:       .omp.linear.pu.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK17-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK17-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK18-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK18-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK18-NEXT:    ret i32 [[CALL]]
//
//
// CHECK18-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK18-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 8
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load i32, i32* [[I]], align 4
// CHECK18-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK18-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK18-NEXT:    [[TMP1:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK18-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to %struct.SS**
// CHECK18-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP3]], align 8
// CHECK18-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to [123 x i32]**
// CHECK18-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP5]], align 8
// CHECK18-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK18-NEXT:    store i8* null, i8** [[TMP6]], align 8
// CHECK18-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK18-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK18-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK18-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK18-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK18-NEXT:    store i64 [[TMP1]], i64* [[TMP10]], align 8
// CHECK18-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK18-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK18-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK18-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 123)
// CHECK18-NEXT:    [[TMP14:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112.region_id, i32 2, i8** [[TMP12]], i8** [[TMP13]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK18-NEXT:    [[TMP15:%.*]] = icmp ne i32 [[TMP14]], 0
// CHECK18-NEXT:    br i1 [[TMP15]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK18:       omp_offload.failed:
// CHECK18-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112(%struct.SS* [[THIS1]], i64 [[TMP1]]) #[[ATTR4:[0-9]+]]
// CHECK18-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK18:       omp_offload.cont:
// CHECK18-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i64 0, i64 0
// CHECK18-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK18-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112
// CHECK18-SAME: (%struct.SS* [[THIS:%.*]], i64 [[I:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], %struct.SS* [[TMP0]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I1:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK18-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK18-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 0
// CHECK18-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK18-NEXT:    store i32 122, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP3]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK18-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 122
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK18-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK18-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK18-NEXT:    [[TMP10:%.*]] = zext i32 [[TMP9]] to i64
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK18-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP11]] to i64
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, %struct.SS*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP10]], i64 [[TMP12]], i32* [[I1]], %struct.SS* [[TMP1]])
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK18:       omp.loop.exit:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK18-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP16:%.*]] = icmp ne i32 [[TMP15]], 0
// CHECK18-NEXT:    br i1 [[TMP16]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK18-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK18-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK18-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 0
// CHECK18-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK18-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK18-NEXT:    store i32 [[TMP2]], i32* [[DOTLINEAR_START]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK18-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK18-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK18-NEXT:    [[CONV1:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK18-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[CONV1]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK18-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP6]])
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP6]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 122
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK18-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK18-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[I2]], align 4
// CHECK18-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I2]], align 4
// CHECK18-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A5]], i64 0, i64 [[IDXPROM]]
// CHECK18-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK18-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK18:       omp.loop.exit:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK18-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP16:%.*]] = icmp ne i32 [[TMP15]], 0
// CHECK18-NEXT:    br i1 [[TMP16]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK18-NEXT:    br i1 [[TMP18]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK18:       .omp.linear.pu:
// CHECK18-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK18:       .omp.linear.pu.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK18-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK18-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK19-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK19-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK19-NEXT:    ret i32 [[CALL]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK19-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[I]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[I_CASTED]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to %struct.SS**
// CHECK19-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP3]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to [123 x i32]**
// CHECK19-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP5]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP6]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP10]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 123)
// CHECK19-NEXT:    [[TMP14:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112.region_id, i32 2, i8** [[TMP12]], i8** [[TMP13]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK19-NEXT:    [[TMP15:%.*]] = icmp ne i32 [[TMP14]], 0
// CHECK19-NEXT:    br i1 [[TMP15]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112(%struct.SS* [[THIS1]], i32 [[TMP1]]) #[[ATTR4:[0-9]+]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112
// CHECK19-SAME: (%struct.SS* [[THIS:%.*]], i32 [[I:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], %struct.SS* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I1:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK19-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 0
// CHECK19-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK19-NEXT:    store i32 122, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP3]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 122
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK19-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK19-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, %struct.SS*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP9]], i32 [[TMP10]], i32* [[I1]], %struct.SS* [[TMP1]])
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP11]], [[TMP12]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK19-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I1:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK19-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 0
// CHECK19-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK19-NEXT:    store i32 [[TMP2]], i32* [[DOTLINEAR_START]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK19-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP6]])
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP6]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 122
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK19-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I1]], align 4
// CHECK19-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I1]], align 4
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A4]], i32 0, i32 [[TMP13]]
// CHECK19-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK19-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = icmp ne i32 [[TMP15]], 0
// CHECK19-NEXT:    br i1 [[TMP16]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK19-NEXT:    br i1 [[TMP18]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK19:       .omp.linear.pu:
// CHECK19-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK19:       .omp.linear.pu.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK19-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK19-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK20-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK20-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK20-NEXT:    ret i32 [[CALL]]
//
//
// CHECK20-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK20-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load i32, i32* [[I]], align 4
// CHECK20-NEXT:    store i32 [[TMP0]], i32* [[I_CASTED]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK20-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to %struct.SS**
// CHECK20-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP3]], align 4
// CHECK20-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to [123 x i32]**
// CHECK20-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP5]], align 4
// CHECK20-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK20-NEXT:    store i8* null, i8** [[TMP6]], align 4
// CHECK20-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK20-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK20-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK20-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK20-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK20-NEXT:    store i32 [[TMP1]], i32* [[TMP10]], align 4
// CHECK20-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK20-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK20-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK20-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 123)
// CHECK20-NEXT:    [[TMP14:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112.region_id, i32 2, i8** [[TMP12]], i8** [[TMP13]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK20-NEXT:    [[TMP15:%.*]] = icmp ne i32 [[TMP14]], 0
// CHECK20-NEXT:    br i1 [[TMP15]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK20:       omp_offload.failed:
// CHECK20-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112(%struct.SS* [[THIS1]], i32 [[TMP1]]) #[[ATTR4:[0-9]+]]
// CHECK20-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK20:       omp_offload.cont:
// CHECK20-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK20-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l112
// CHECK20-SAME: (%struct.SS* [[THIS:%.*]], i32 [[I:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], %struct.SS* [[TMP0]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I1:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK20-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 0
// CHECK20-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK20-NEXT:    store i32 122, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP3]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK20-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 122
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK20-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK20-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, %struct.SS*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP9]], i32 [[TMP10]], i32* [[I1]], %struct.SS* [[TMP1]])
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP11]], [[TMP12]]
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK20:       omp.loop.exit:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK20-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK20-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I1:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK20-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK20-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 0
// CHECK20-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK20-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK20-NEXT:    store i32 [[TMP2]], i32* [[DOTLINEAR_START]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK20-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK20-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK20-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP6]])
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP6]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 122
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK20-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK20-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[I1]], align 4
// CHECK20-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP1]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I1]], align 4
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A4]], i32 0, i32 [[TMP13]]
// CHECK20-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK20-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK20:       omp.loop.exit:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK20-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP16:%.*]] = icmp ne i32 [[TMP15]], 0
// CHECK20-NEXT:    br i1 [[TMP16]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 123, i32* [[TMP0]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK20-NEXT:    br i1 [[TMP18]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK20:       .omp.linear.pu:
// CHECK20-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK20:       .omp.linear.pu.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK20-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK20-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK21-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK21-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK21-NEXT:    ret i32 [[CALL]]
//
//
// CHECK21-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK21-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK21-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 0
// CHECK21-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I]], align 4
// CHECK21-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK21-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I2]], align 4
// CHECK21-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I2]], align 4
// CHECK21-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A4]], i64 0, i64 [[IDXPROM]]
// CHECK21-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK21-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK21-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK21-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A6]], i64 0, i64 0
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX7]], align 4
// CHECK21-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK22-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK22-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK22-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK22-NEXT:    ret i32 [[CALL]]
//
//
// CHECK22-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK22-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK22-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK22-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 0
// CHECK22-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK22-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I]], align 4
// CHECK22-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK22-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK22-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK22-NEXT:    store i32 [[ADD]], i32* [[I2]], align 4
// CHECK22-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I2]], align 4
// CHECK22-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK22-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A4]], i64 0, i64 [[IDXPROM]]
// CHECK22-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK22-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK22-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK22-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A6]], i64 0, i64 0
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX7]], align 4
// CHECK22-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK23-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK23-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK23-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK23-NEXT:    ret i32 [[CALL]]
//
//
// CHECK23-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK23-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK23-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 0
// CHECK23-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I]], align 4
// CHECK23-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK23-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I2]], align 4
// CHECK23-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I2]], align 4
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A4]], i32 0, i32 [[TMP5]]
// CHECK23-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK23-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK23-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK23-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A6]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX7]], align 4
// CHECK23-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK24-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK24-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK24-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK24-NEXT:    ret i32 [[CALL]]
//
//
// CHECK24-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK24-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK24-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[I2:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK24-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK24-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK24-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 0
// CHECK24-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK24-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I]], align 4
// CHECK24-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START]], align 4
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK24:       omp.inner.for.cond:
// CHECK24-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK24-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK24:       omp.inner.for.body:
// CHECK24-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK24-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK24-NEXT:    store i32 [[ADD]], i32* [[I2]], align 4
// CHECK24-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I2]], align 4
// CHECK24-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A4]], i32 0, i32 [[TMP5]]
// CHECK24-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK24-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK24:       omp.body.continue:
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK24:       omp.inner.for.inc:
// CHECK24-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK24-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK24:       omp.inner.for.end:
// CHECK24-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK24-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK24-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A6]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX7]], align 4
// CHECK24-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK25-LABEL: define {{[^@]+}}@main
// CHECK25-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK25-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK25-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 8
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK25-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK25-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK25-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK25-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK25-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK25-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK25-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK25-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK25-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I]], align 4
// CHECK25-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK25-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK25-NEXT:    [[TMP4:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK25-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N]], align 4
// CHECK25-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK25-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK25-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK25-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK25-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK25-NEXT:    store i64 [[TMP1]], i64* [[TMP9]], align 8
// CHECK25-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK25-NEXT:    store i64 [[TMP1]], i64* [[TMP11]], align 8
// CHECK25-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK25-NEXT:    store i64 8, i64* [[TMP12]], align 8
// CHECK25-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK25-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK25-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK25-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK25-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 8
// CHECK25-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK25-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK25-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 8
// CHECK25-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK25-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 8
// CHECK25-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK25-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK25-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK25-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK25-NEXT:    store i64 [[TMP4]], i64* [[TMP21]], align 8
// CHECK25-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK25-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK25-NEXT:    store i64 [[TMP4]], i64* [[TMP23]], align 8
// CHECK25-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK25-NEXT:    store i64 4, i64* [[TMP24]], align 8
// CHECK25-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK25-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK25-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK25-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK25-NEXT:    store i64 [[TMP6]], i64* [[TMP27]], align 8
// CHECK25-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK25-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK25-NEXT:    store i64 [[TMP6]], i64* [[TMP29]], align 8
// CHECK25-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK25-NEXT:    store i64 4, i64* [[TMP30]], align 8
// CHECK25-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK25-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK25-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK25-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK25-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK25-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK25-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK25-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK25-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK25-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK25-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK25-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK25-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK25-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK25:       omp_offload.failed:
// CHECK25-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166(i64 [[TMP1]], i32* [[VLA]], i64 [[TMP4]], i64 [[TMP6]]) #[[ATTR5:[0-9]+]]
// CHECK25-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK25:       omp_offload.cont:
// CHECK25-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK25-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP41]])
// CHECK25-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK25-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK25-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK25-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK25-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK25-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166
// CHECK25-SAME: (i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK25-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK25-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK25-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK25-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK25-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK25-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK25-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK25-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK25-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK25-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK25-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK25-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK25-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK25-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK25-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK25-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK25-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK25-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK25-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK25:       omp.precond.then:
// CHECK25-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK25-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK25-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK25-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK25-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK25:       cond.true:
// CHECK25-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    br label [[COND_END:%.*]]
// CHECK25:       cond.false:
// CHECK25-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    br label [[COND_END]]
// CHECK25:       cond.end:
// CHECK25-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK25-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK25-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK25:       omp.inner.for.cond:
// CHECK25-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK25-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK25:       omp.inner.for.body:
// CHECK25-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK25-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK25-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK25-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32*, i64, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[I4]], i32* [[TMP1]], i64 [[TMP2]], i32* [[TMP3]])
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK25:       omp.inner.for.inc:
// CHECK25-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK25-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK25-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK25:       omp.inner.for.end:
// CHECK25-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK25:       omp.loop.exit:
// CHECK25-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK25-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK25-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK25-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK25:       .omp.final.then:
// CHECK25-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP27]], 0
// CHECK25-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK25-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK25-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK25-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK25-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK25:       .omp.final.done:
// CHECK25-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK25:       omp.precond.end:
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK25-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK25-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK25-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK25-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK25-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK25-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK25-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK25-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK25-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK25-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK25-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK25-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK25-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK25-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK25-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK25:       omp.precond.then:
// CHECK25-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK25-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK25-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK25-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK25-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK25-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP10]] to i32
// CHECK25-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK25-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK25-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK25-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK25-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK25-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK25:       cond.true:
// CHECK25-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK25-NEXT:    br label [[COND_END:%.*]]
// CHECK25:       cond.false:
// CHECK25-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    br label [[COND_END]]
// CHECK25:       cond.end:
// CHECK25-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK25-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK25:       omp.inner.for.cond:
// CHECK25-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK25-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK25:       omp.inner.for.body:
// CHECK25-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK25-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK25-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4
// CHECK25-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I5]], align 4
// CHECK25-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK25-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i64 [[IDXPROM]]
// CHECK25-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK25-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK25:       omp.body.continue:
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK25:       omp.inner.for.inc:
// CHECK25-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK25-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK25:       omp.inner.for.end:
// CHECK25-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK25:       omp.loop.exit:
// CHECK25-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK25-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK25-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK25-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK25:       .omp.final.then:
// CHECK25-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK25-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK25-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK25-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[DIV11]], 1
// CHECK25-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK25-NEXT:    store i32 [[ADD13]], i32* [[TMP0]], align 4
// CHECK25-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK25:       .omp.final.done:
// CHECK25-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK25-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK25:       .omp.linear.pu:
// CHECK25-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK25:       .omp.linear.pu.done:
// CHECK25-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK25:       omp.precond.end:
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK25-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR6:[0-9]+]] comdat {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK25-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK25-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK25-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK25-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK25-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK25-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK25-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK25-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK25-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK25-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK25-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK25-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK25-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK25-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK25-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK25-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK25-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK25-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK25-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK25-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK25-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK25-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK25-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK25-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK25-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK25-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK25-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK25-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 8
// CHECK25-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK25-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK25-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 8
// CHECK25-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK25-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK25-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK25-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i64 10)
// CHECK25-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 0)
// CHECK25-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK25-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK25:       omp_offload.failed:
// CHECK25-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR5]]
// CHECK25-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK25:       omp_offload.cont:
// CHECK25-NEXT:    ret i32 0
//
//
// CHECK25-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155
// CHECK25-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB4]])
// CHECK25-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK25-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK25-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK25-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK25-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 8
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 8
// CHECK25-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB4]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK25-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK25-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK25-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK25-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK25-NEXT:    store i32 9, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK25-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK25-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK25:       cond.true:
// CHECK25-NEXT:    br label [[COND_END:%.*]]
// CHECK25:       cond.false:
// CHECK25-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    br label [[COND_END]]
// CHECK25:       cond.end:
// CHECK25-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK25-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK25-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK25:       omp.inner.for.cond:
// CHECK25-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK25-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK25:       omp.inner.for.body:
// CHECK25-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK25-NEXT:    [[TMP9:%.*]] = zext i32 [[TMP8]] to i64
// CHECK25-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK25-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i64
// CHECK25-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP9]], i64 [[TMP11]], [10 x i32]* [[TMP0]])
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK25:       omp.inner.for.inc:
// CHECK25-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK25-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP12]], [[TMP13]]
// CHECK25-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK25:       omp.inner.for.end:
// CHECK25-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK25:       omp.loop.exit:
// CHECK25-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK25-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP15:%.*]] = icmp ne i32 [[TMP14]], 0
// CHECK25-NEXT:    br i1 [[TMP15]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK25:       .omp.final.then:
// CHECK25-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK25-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK25:       .omp.final.done:
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK25-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK25-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK25-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK25-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK25-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK25-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[TMP1:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK25-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK25-NEXT:    [[TMP2:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK25-NEXT:    [[CONV1:%.*]] = trunc i64 [[TMP2]] to i32
// CHECK25-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 [[CONV1]], i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK25-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK25-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 9
// CHECK25-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK25:       cond.true:
// CHECK25-NEXT:    br label [[COND_END:%.*]]
// CHECK25:       cond.false:
// CHECK25-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    br label [[COND_END]]
// CHECK25:       cond.end:
// CHECK25-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK25-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK25:       omp.inner.for.cond:
// CHECK25-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK25-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK25:       omp.inner.for.body:
// CHECK25-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK25-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK25-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK25-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK25-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK25-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK25-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK25-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK25:       omp.body.continue:
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK25:       omp.inner.for.inc:
// CHECK25-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK25-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK25:       omp.inner.for.end:
// CHECK25-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK25:       omp.loop.exit:
// CHECK25-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK25-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK25-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK25-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK25:       .omp.final.then:
// CHECK25-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK25-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK25:       .omp.final.done:
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK25-SAME: () #[[ATTR7:[0-9]+]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK25-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@main
// CHECK26-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK26-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK26-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 8
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK26-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK26-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK26-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK26-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK26-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK26-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK26-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK26-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK26-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I]], align 4
// CHECK26-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK26-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK26-NEXT:    [[TMP4:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK26-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N]], align 4
// CHECK26-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK26-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK26-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK26-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK26-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK26-NEXT:    store i64 [[TMP1]], i64* [[TMP9]], align 8
// CHECK26-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK26-NEXT:    store i64 [[TMP1]], i64* [[TMP11]], align 8
// CHECK26-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK26-NEXT:    store i64 8, i64* [[TMP12]], align 8
// CHECK26-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK26-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK26-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK26-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK26-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 8
// CHECK26-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK26-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK26-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 8
// CHECK26-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK26-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 8
// CHECK26-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK26-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK26-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK26-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK26-NEXT:    store i64 [[TMP4]], i64* [[TMP21]], align 8
// CHECK26-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK26-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK26-NEXT:    store i64 [[TMP4]], i64* [[TMP23]], align 8
// CHECK26-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK26-NEXT:    store i64 4, i64* [[TMP24]], align 8
// CHECK26-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK26-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK26-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK26-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK26-NEXT:    store i64 [[TMP6]], i64* [[TMP27]], align 8
// CHECK26-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK26-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK26-NEXT:    store i64 [[TMP6]], i64* [[TMP29]], align 8
// CHECK26-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK26-NEXT:    store i64 4, i64* [[TMP30]], align 8
// CHECK26-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK26-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK26-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK26-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK26-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK26-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK26-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK26-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK26-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK26-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK26-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK26-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK26-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK26-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK26:       omp_offload.failed:
// CHECK26-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166(i64 [[TMP1]], i32* [[VLA]], i64 [[TMP4]], i64 [[TMP6]]) #[[ATTR5:[0-9]+]]
// CHECK26-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK26:       omp_offload.cont:
// CHECK26-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK26-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP41]])
// CHECK26-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK26-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK26-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK26-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK26-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK26-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166
// CHECK26-SAME: (i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK26-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK26-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK26-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK26-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK26-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK26-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK26-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK26-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK26-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK26-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK26-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK26-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK26-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK26-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK26-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK26-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK26-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK26-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK26-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK26-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK26-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK26:       omp.precond.then:
// CHECK26-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK26-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK26-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK26-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK26-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK26:       cond.true:
// CHECK26-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    br label [[COND_END:%.*]]
// CHECK26:       cond.false:
// CHECK26-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    br label [[COND_END]]
// CHECK26:       cond.end:
// CHECK26-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK26-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK26-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK26:       omp.inner.for.cond:
// CHECK26-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK26-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK26:       omp.inner.for.body:
// CHECK26-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK26-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK26-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK26-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32*, i64, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[I4]], i32* [[TMP1]], i64 [[TMP2]], i32* [[TMP3]])
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK26:       omp.inner.for.inc:
// CHECK26-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK26-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK26-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK26:       omp.inner.for.end:
// CHECK26-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK26:       omp.loop.exit:
// CHECK26-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK26-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK26-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK26-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK26:       .omp.final.then:
// CHECK26-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP27]], 0
// CHECK26-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK26-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK26-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK26-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK26-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK26:       .omp.final.done:
// CHECK26-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK26:       omp.precond.end:
// CHECK26-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK26-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK26-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK26-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK26-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK26-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK26-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK26-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK26-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK26-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK26-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK26-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK26-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK26-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK26-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK26-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK26:       omp.precond.then:
// CHECK26-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i64 16) ]
// CHECK26-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK26-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK26-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK26-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK26-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP10]] to i32
// CHECK26-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK26-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK26-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK26-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK26-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK26-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK26:       cond.true:
// CHECK26-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK26-NEXT:    br label [[COND_END:%.*]]
// CHECK26:       cond.false:
// CHECK26-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    br label [[COND_END]]
// CHECK26:       cond.end:
// CHECK26-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK26-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK26:       omp.inner.for.cond:
// CHECK26-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK26-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK26:       omp.inner.for.body:
// CHECK26-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK26-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK26-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4
// CHECK26-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I5]], align 4
// CHECK26-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK26-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i64 [[IDXPROM]]
// CHECK26-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK26-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK26:       omp.body.continue:
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK26:       omp.inner.for.inc:
// CHECK26-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK26-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK26:       omp.inner.for.end:
// CHECK26-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK26:       omp.loop.exit:
// CHECK26-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK26-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK26-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK26-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK26:       .omp.final.then:
// CHECK26-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK26-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK26-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK26-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[DIV11]], 1
// CHECK26-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK26-NEXT:    store i32 [[ADD13]], i32* [[TMP0]], align 4
// CHECK26-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK26:       .omp.final.done:
// CHECK26-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK26-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK26:       .omp.linear.pu:
// CHECK26-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK26:       .omp.linear.pu.done:
// CHECK26-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK26:       omp.precond.end:
// CHECK26-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK26-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR6:[0-9]+]] comdat {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK26-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK26-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK26-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK26-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK26-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK26-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK26-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK26-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK26-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK26-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK26-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK26-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK26-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK26-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK26-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK26-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK26-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK26-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK26-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK26-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK26-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK26-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK26-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK26-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK26-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK26-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK26-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK26-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 8
// CHECK26-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK26-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK26-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 8
// CHECK26-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK26-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK26-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK26-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i64 10)
// CHECK26-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 0)
// CHECK26-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK26-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK26:       omp_offload.failed:
// CHECK26-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR5]]
// CHECK26-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK26:       omp_offload.cont:
// CHECK26-NEXT:    ret i32 0
//
//
// CHECK26-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155
// CHECK26-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK26-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB4]])
// CHECK26-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK26-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK26-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK26-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK26-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 8
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 8
// CHECK26-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB4]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK26-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK26-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK26-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK26-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK26-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK26-NEXT:    store i32 9, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK26-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK26-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK26:       cond.true:
// CHECK26-NEXT:    br label [[COND_END:%.*]]
// CHECK26:       cond.false:
// CHECK26-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    br label [[COND_END]]
// CHECK26:       cond.end:
// CHECK26-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK26-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK26-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK26:       omp.inner.for.cond:
// CHECK26-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK26-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK26:       omp.inner.for.body:
// CHECK26-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK26-NEXT:    [[TMP9:%.*]] = zext i32 [[TMP8]] to i64
// CHECK26-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK26-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i64
// CHECK26-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP9]], i64 [[TMP11]], [10 x i32]* [[TMP0]])
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK26:       omp.inner.for.inc:
// CHECK26-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK26-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP12]], [[TMP13]]
// CHECK26-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK26:       omp.inner.for.end:
// CHECK26-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK26:       omp.loop.exit:
// CHECK26-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK26-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP15:%.*]] = icmp ne i32 [[TMP14]], 0
// CHECK26-NEXT:    br i1 [[TMP15]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK26:       .omp.final.then:
// CHECK26-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK26-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK26:       .omp.final.done:
// CHECK26-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK26-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i64 [[DOTPREVIOUS_LB_:%.*]], i64 [[DOTPREVIOUS_UB_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK26-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK26-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK26-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK26-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK26-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK26-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK26-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[TMP1:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK26-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK26-NEXT:    [[TMP2:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK26-NEXT:    [[CONV1:%.*]] = trunc i64 [[TMP2]] to i32
// CHECK26-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 [[CONV1]], i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK26-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK26-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK26-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 9
// CHECK26-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK26:       cond.true:
// CHECK26-NEXT:    br label [[COND_END:%.*]]
// CHECK26:       cond.false:
// CHECK26-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    br label [[COND_END]]
// CHECK26:       cond.end:
// CHECK26-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK26-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK26:       omp.inner.for.cond:
// CHECK26-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK26-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK26:       omp.inner.for.body:
// CHECK26-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK26-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK26-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK26-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK26-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK26-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK26-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK26-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK26:       omp.body.continue:
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK26:       omp.inner.for.inc:
// CHECK26-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK26-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK26:       omp.inner.for.end:
// CHECK26-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK26:       omp.loop.exit:
// CHECK26-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK26-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK26-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK26-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK26:       .omp.final.then:
// CHECK26-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK26-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK26:       .omp.final.done:
// CHECK26-NEXT:    ret void
//
//
// CHECK26-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK26-SAME: () #[[ATTR7:[0-9]+]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK26-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@main
// CHECK27-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK27-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK27-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK27-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK27-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK27-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK27-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK27-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[I]], align 4
// CHECK27-NEXT:    store i32 [[TMP2]], i32* [[I_CASTED]], align 4
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK27-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK27-NEXT:    store i32 [[TMP4]], i32* [[N_CASTED]], align 4
// CHECK27-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK27-NEXT:    [[TMP6:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK27-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
// CHECK27-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK27-NEXT:    store i32 [[TMP0]], i32* [[TMP9]], align 4
// CHECK27-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK27-NEXT:    store i32 [[TMP0]], i32* [[TMP11]], align 4
// CHECK27-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK27-NEXT:    store i64 4, i64* [[TMP12]], align 4
// CHECK27-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK27-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK27-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK27-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK27-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 4
// CHECK27-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK27-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK27-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 4
// CHECK27-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK27-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 4
// CHECK27-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK27-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK27-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK27-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK27-NEXT:    store i32 [[TMP3]], i32* [[TMP21]], align 4
// CHECK27-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK27-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK27-NEXT:    store i32 [[TMP3]], i32* [[TMP23]], align 4
// CHECK27-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK27-NEXT:    store i64 4, i64* [[TMP24]], align 4
// CHECK27-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK27-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK27-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK27-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK27-NEXT:    store i32 [[TMP5]], i32* [[TMP27]], align 4
// CHECK27-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK27-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK27-NEXT:    store i32 [[TMP5]], i32* [[TMP29]], align 4
// CHECK27-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK27-NEXT:    store i64 4, i64* [[TMP30]], align 4
// CHECK27-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK27-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK27-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK27-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK27-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK27-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK27-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK27-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK27-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK27-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK27-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK27-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK27:       omp_offload.failed:
// CHECK27-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166(i32 [[TMP0]], i32* [[VLA]], i32 [[TMP3]], i32 [[TMP5]]) #[[ATTR5:[0-9]+]]
// CHECK27-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK27:       omp_offload.cont:
// CHECK27-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP41]])
// CHECK27-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK27-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK27-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK27-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK27-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK27-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166
// CHECK27-SAME: (i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK27-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK27-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK27-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK27-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK27-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK27-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK27-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK27-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK27-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK27-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK27-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK27-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK27-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK27-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK27:       omp.precond.then:
// CHECK27-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK27-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK27-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK27-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK27-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK27:       cond.true:
// CHECK27-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    br label [[COND_END:%.*]]
// CHECK27:       cond.false:
// CHECK27-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    br label [[COND_END]]
// CHECK27:       cond.end:
// CHECK27-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK27-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK27:       omp.inner.for.cond:
// CHECK27-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK27-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK27:       omp.inner.for.body:
// CHECK27-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK27-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32*, i32, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[I4]], i32* [[TMP1]], i32 [[TMP2]], i32* [[TMP3]])
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK27:       omp.inner.for.inc:
// CHECK27-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK27-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK27-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK27:       omp.inner.for.end:
// CHECK27-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK27:       omp.loop.exit:
// CHECK27-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK27-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK27-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK27-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK27:       .omp.final.then:
// CHECK27-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP25]], 0
// CHECK27-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK27-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK27-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK27-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK27-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK27:       .omp.final.done:
// CHECK27-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK27:       omp.precond.end:
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK27-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK27-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK27-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK27-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK27-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK27-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK27-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK27-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK27-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK27-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK27-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK27-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK27:       omp.precond.then:
// CHECK27-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK27-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK27-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK27-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK27-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK27-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK27-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK27-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK27-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK27-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK27:       cond.true:
// CHECK27-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK27-NEXT:    br label [[COND_END:%.*]]
// CHECK27:       cond.false:
// CHECK27-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    br label [[COND_END]]
// CHECK27:       cond.end:
// CHECK27-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK27-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK27:       omp.inner.for.cond:
// CHECK27-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK27-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK27:       omp.inner.for.body:
// CHECK27-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK27-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK27-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK27-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK27-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i32 [[TMP23]]
// CHECK27-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK27-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK27:       omp.body.continue:
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK27:       omp.inner.for.inc:
// CHECK27-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK27-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK27:       omp.inner.for.end:
// CHECK27-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK27:       omp.loop.exit:
// CHECK27-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK27-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK27-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK27-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK27:       .omp.final.then:
// CHECK27-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK27-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK27-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK27-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK27-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK27-NEXT:    store i32 [[ADD12]], i32* [[TMP0]], align 4
// CHECK27-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK27:       .omp.final.done:
// CHECK27-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK27-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK27:       .omp.linear.pu:
// CHECK27-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK27:       .omp.linear.pu.done:
// CHECK27-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK27:       omp.precond.end:
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK27-SAME: (i32 [[ARGC:%.*]]) #[[ATTR6:[0-9]+]] comdat {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK27-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK27-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK27-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK27-NEXT:    store i32 [[TMP0]], i32* [[TE_CASTED]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK27-NEXT:    store i32 [[TMP2]], i32* [[TH_CASTED]], align 4
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK27-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK27-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK27-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK27-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK27-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK27-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK27-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK27-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK27-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK27-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK27-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK27-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK27-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK27-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK27-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK27-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK27-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 4
// CHECK27-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK27-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK27-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 4
// CHECK27-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK27-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK27-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK27-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i64 10)
// CHECK27-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 0)
// CHECK27-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK27-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK27:       omp_offload.failed:
// CHECK27-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR5]]
// CHECK27-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK27:       omp_offload.cont:
// CHECK27-NEXT:    ret i32 0
//
//
// CHECK27-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155
// CHECK27-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB4]])
// CHECK27-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK27-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK27-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK27-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB4]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK27-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK27-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK27-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK27-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK27-NEXT:    store i32 9, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK27-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK27-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK27:       cond.true:
// CHECK27-NEXT:    br label [[COND_END:%.*]]
// CHECK27:       cond.false:
// CHECK27-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    br label [[COND_END]]
// CHECK27:       cond.end:
// CHECK27-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK27-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK27:       omp.inner.for.cond:
// CHECK27-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK27-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK27:       omp.inner.for.body:
// CHECK27-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK27-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK27-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP8]], i32 [[TMP9]], [10 x i32]* [[TMP0]])
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK27:       omp.inner.for.inc:
// CHECK27-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK27-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP10]], [[TMP11]]
// CHECK27-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK27:       omp.inner.for.end:
// CHECK27-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK27:       omp.loop.exit:
// CHECK27-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK27-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK27-NEXT:    br i1 [[TMP13]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK27:       .omp.final.then:
// CHECK27-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK27-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK27:       .omp.final.done:
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK27-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK27-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK27-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK27-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK27-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK27-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK27-NEXT:    store i32 [[TMP1]], i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK27-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK27-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 9
// CHECK27-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK27:       cond.true:
// CHECK27-NEXT:    br label [[COND_END:%.*]]
// CHECK27:       cond.false:
// CHECK27-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    br label [[COND_END]]
// CHECK27:       cond.end:
// CHECK27-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK27-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK27:       omp.inner.for.cond:
// CHECK27-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK27-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK27:       omp.inner.for.body:
// CHECK27-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK27-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK27-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK27-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK27-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 [[TMP11]]
// CHECK27-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK27-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK27:       omp.body.continue:
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK27:       omp.inner.for.inc:
// CHECK27-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK27-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK27:       omp.inner.for.end:
// CHECK27-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK27:       omp.loop.exit:
// CHECK27-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK27-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK27-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK27-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK27:       .omp.final.then:
// CHECK27-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK27-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK27:       .omp.final.done:
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK27-SAME: () #[[ATTR7:[0-9]+]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK27-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@main
// CHECK28-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK28-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK28-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK28-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK28-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK28-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK28-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK28-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK28-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[I]], align 4
// CHECK28-NEXT:    store i32 [[TMP2]], i32* [[I_CASTED]], align 4
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK28-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK28-NEXT:    store i32 [[TMP4]], i32* [[N_CASTED]], align 4
// CHECK28-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK28-NEXT:    [[TMP6:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK28-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
// CHECK28-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK28-NEXT:    store i32 [[TMP0]], i32* [[TMP9]], align 4
// CHECK28-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK28-NEXT:    store i32 [[TMP0]], i32* [[TMP11]], align 4
// CHECK28-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK28-NEXT:    store i64 4, i64* [[TMP12]], align 4
// CHECK28-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK28-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK28-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK28-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32**
// CHECK28-NEXT:    store i32* [[VLA]], i32** [[TMP15]], align 4
// CHECK28-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK28-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32**
// CHECK28-NEXT:    store i32* [[VLA]], i32** [[TMP17]], align 4
// CHECK28-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK28-NEXT:    store i64 [[TMP7]], i64* [[TMP18]], align 4
// CHECK28-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK28-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK28-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK28-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK28-NEXT:    store i32 [[TMP3]], i32* [[TMP21]], align 4
// CHECK28-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK28-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK28-NEXT:    store i32 [[TMP3]], i32* [[TMP23]], align 4
// CHECK28-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK28-NEXT:    store i64 4, i64* [[TMP24]], align 4
// CHECK28-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK28-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK28-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK28-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK28-NEXT:    store i32 [[TMP5]], i32* [[TMP27]], align 4
// CHECK28-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK28-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK28-NEXT:    store i32 [[TMP5]], i32* [[TMP29]], align 4
// CHECK28-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK28-NEXT:    store i64 4, i64* [[TMP30]], align 4
// CHECK28-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK28-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK28-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK28-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK28-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK28-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK28-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK28-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK28-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK28-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK28-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK28-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK28:       omp_offload.failed:
// CHECK28-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166(i32 [[TMP0]], i32* [[VLA]], i32 [[TMP3]], i32 [[TMP5]]) #[[ATTR5:[0-9]+]]
// CHECK28-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK28:       omp_offload.cont:
// CHECK28-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK28-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP41]])
// CHECK28-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK28-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK28-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK28-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK28-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK28-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l166
// CHECK28-SAME: (i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK28-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK28-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK28-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK28-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK28-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK28-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK28-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK28-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK28-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK28-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK28-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK28-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK28-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK28-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK28-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK28:       omp.precond.then:
// CHECK28-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK28-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK28-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK28-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK28-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK28:       cond.true:
// CHECK28-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    br label [[COND_END:%.*]]
// CHECK28:       cond.false:
// CHECK28-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    br label [[COND_END]]
// CHECK28:       cond.end:
// CHECK28-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK28-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK28:       omp.inner.for.cond:
// CHECK28-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK28-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK28:       omp.inner.for.body:
// CHECK28-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK28-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32*, i32, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[I4]], i32* [[TMP1]], i32 [[TMP2]], i32* [[TMP3]])
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK28:       omp.inner.for.inc:
// CHECK28-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK28-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK28-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK28:       omp.inner.for.end:
// CHECK28-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK28:       omp.loop.exit:
// CHECK28-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK28-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK28-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK28-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK28:       .omp.final.then:
// CHECK28-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP25]], 0
// CHECK28-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK28-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK28-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL]]
// CHECK28-NEXT:    store i32 [[ADD9]], i32* [[TMP0]], align 4
// CHECK28-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK28:       .omp.final.done:
// CHECK28-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK28:       omp.precond.end:
// CHECK28-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK28-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK28-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK28-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK28-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK28-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK28-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK28-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK28-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK28-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK28-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK28-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK28-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK28:       omp.precond.then:
// CHECK28-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[TMP3]], i32 16) ]
// CHECK28-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK28-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK28-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK28-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK28-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP12]])
// CHECK28-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK28-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP14]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK28-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP15]], [[TMP16]]
// CHECK28-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK28:       cond.true:
// CHECK28-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK28-NEXT:    br label [[COND_END:%.*]]
// CHECK28:       cond.false:
// CHECK28-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    br label [[COND_END]]
// CHECK28:       cond.end:
// CHECK28-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// CHECK28-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP19]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK28:       omp.inner.for.cond:
// CHECK28-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK28-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK28:       omp.inner.for.body:
// CHECK28-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK28-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK28-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK28-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK28-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP3]], i32 [[TMP23]]
// CHECK28-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK28-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK28:       omp.body.continue:
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK28:       omp.inner.for.inc:
// CHECK28-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK28-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK28:       omp.inner.for.end:
// CHECK28-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK28:       omp.loop.exit:
// CHECK28-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK28-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK28-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK28-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK28:       .omp.final.then:
// CHECK28-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK28-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK28-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK28-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK28-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK28-NEXT:    store i32 [[ADD12]], i32* [[TMP0]], align 4
// CHECK28-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK28:       .omp.final.done:
// CHECK28-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK28-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK28:       .omp.linear.pu:
// CHECK28-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK28:       .omp.linear.pu.done:
// CHECK28-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK28:       omp.precond.end:
// CHECK28-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK28-SAME: (i32 [[ARGC:%.*]]) #[[ATTR6:[0-9]+]] comdat {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK28-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK28-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK28-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK28-NEXT:    store i32 [[TMP0]], i32* [[TE_CASTED]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK28-NEXT:    store i32 [[TMP2]], i32* [[TH_CASTED]], align 4
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK28-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK28-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK28-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK28-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK28-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK28-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK28-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK28-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK28-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK28-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK28-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK28-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK28-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK28-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK28-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK28-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK28-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 4
// CHECK28-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK28-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK28-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 4
// CHECK28-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK28-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK28-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK28-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i64 10)
// CHECK28-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB4]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 0)
// CHECK28-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK28-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK28:       omp_offload.failed:
// CHECK28-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR5]]
// CHECK28-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK28:       omp_offload.cont:
// CHECK28-NEXT:    ret i32 0
//
//
// CHECK28-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l155
// CHECK28-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB4]])
// CHECK28-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK28-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK28-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK28-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB4]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK28-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB4]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK28-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK28-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK28-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK28-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK28-NEXT:    store i32 9, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK28-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK28-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK28:       cond.true:
// CHECK28-NEXT:    br label [[COND_END:%.*]]
// CHECK28:       cond.false:
// CHECK28-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    br label [[COND_END]]
// CHECK28:       cond.end:
// CHECK28-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK28-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK28:       omp.inner.for.cond:
// CHECK28-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK28-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK28:       omp.inner.for.body:
// CHECK28-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK28-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK28-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB4]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP8]], i32 [[TMP9]], [10 x i32]* [[TMP0]])
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK28:       omp.inner.for.inc:
// CHECK28-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK28-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP10]], [[TMP11]]
// CHECK28-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK28:       omp.inner.for.end:
// CHECK28-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK28:       omp.loop.exit:
// CHECK28-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK28-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK28-NEXT:    br i1 [[TMP13]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK28:       .omp.final.then:
// CHECK28-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK28-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK28:       .omp.final.done:
// CHECK28-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK28-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32 [[DOTPREVIOUS_LB_:%.*]], i32 [[DOTPREVIOUS_UB_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK28-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK28-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK28-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK28-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK28-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK28-NEXT:    store i32 [[TMP1]], i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK28-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK28-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK28-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 9
// CHECK28-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK28:       cond.true:
// CHECK28-NEXT:    br label [[COND_END:%.*]]
// CHECK28:       cond.false:
// CHECK28-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    br label [[COND_END]]
// CHECK28:       cond.end:
// CHECK28-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK28-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK28:       omp.inner.for.cond:
// CHECK28-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK28-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK28:       omp.inner.for.body:
// CHECK28-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK28-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK28-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK28-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK28-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 [[TMP11]]
// CHECK28-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK28-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK28:       omp.body.continue:
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK28:       omp.inner.for.inc:
// CHECK28-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK28-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK28:       omp.inner.for.end:
// CHECK28-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK28:       omp.loop.exit:
// CHECK28-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK28-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK28-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK28-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK28:       .omp.final.then:
// CHECK28-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK28-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK28:       .omp.final.done:
// CHECK28-NEXT:    ret void
//
//
// CHECK28-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK28-SAME: () #[[ATTR7:[0-9]+]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK28-NEXT:    ret void
//
//
// CHECK29-LABEL: define {{[^@]+}}@main
// CHECK29-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK29-NEXT:  entry:
// CHECK29-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK29-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK29-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK29-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK29-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK29-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK29-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK29-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK29-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK29-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK29-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK29-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK29-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK29-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK29-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK29-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK29-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK29-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK29-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK29-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK29-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK29-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK29-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK29-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK29-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK29-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK29-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK29:       simd.if.then:
// CHECK29-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK29-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i64 16) ]
// CHECK29-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK29-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START]], align 4
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK29:       omp.inner.for.cond:
// CHECK29-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK29-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK29-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK29:       omp.inner.for.body:
// CHECK29-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK29-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK29-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK29-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I4]], align 4
// CHECK29-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP12]] to i64
// CHECK29-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK29-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK29-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK29:       omp.body.continue:
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK29:       omp.inner.for.inc:
// CHECK29-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK29-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK29:       omp.inner.for.end:
// CHECK29-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK29-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK29-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK29-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK29-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK29-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK29-NEXT:    br label [[SIMD_IF_END]]
// CHECK29:       simd.if.end:
// CHECK29-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK29-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP15]])
// CHECK29-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK29-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK29-NEXT:    call void @llvm.stackrestore(i8* [[TMP16]])
// CHECK29-NEXT:    [[TMP17:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK29-NEXT:    ret i32 [[TMP17]]
//
//
// CHECK29-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK29-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR3:[0-9]+]] comdat {
// CHECK29-NEXT:  entry:
// CHECK29-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK29-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK29-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK29-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK29-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK29-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK29-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK29-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK29:       omp.inner.for.cond:
// CHECK29-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK29-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK29:       omp.inner.for.body:
// CHECK29-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK29-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK29-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP4]] to i64
// CHECK29-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK29-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK29:       omp.body.continue:
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK29:       omp.inner.for.inc:
// CHECK29-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK29-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK29:       omp.inner.for.end:
// CHECK29-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK29-NEXT:    ret i32 0
//
//
// CHECK30-LABEL: define {{[^@]+}}@main
// CHECK30-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK30-NEXT:  entry:
// CHECK30-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK30-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK30-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK30-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK30-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK30-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK30-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK30-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK30-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK30-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK30-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK30-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK30-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK30-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK30-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK30-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK30-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK30-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK30-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK30-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK30-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK30-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK30-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK30-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK30-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK30-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK30-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK30:       simd.if.then:
// CHECK30-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK30-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i64 16) ]
// CHECK30-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK30-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START]], align 4
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK30:       omp.inner.for.cond:
// CHECK30-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK30-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK30-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK30:       omp.inner.for.body:
// CHECK30-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK30-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK30-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK30-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I4]], align 4
// CHECK30-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP12]] to i64
// CHECK30-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK30-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK30-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK30:       omp.body.continue:
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK30:       omp.inner.for.inc:
// CHECK30-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK30-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK30:       omp.inner.for.end:
// CHECK30-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK30-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK30-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK30-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK30-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK30-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK30-NEXT:    br label [[SIMD_IF_END]]
// CHECK30:       simd.if.end:
// CHECK30-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK30-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP15]])
// CHECK30-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK30-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK30-NEXT:    call void @llvm.stackrestore(i8* [[TMP16]])
// CHECK30-NEXT:    [[TMP17:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK30-NEXT:    ret i32 [[TMP17]]
//
//
// CHECK30-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK30-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR3:[0-9]+]] comdat {
// CHECK30-NEXT:  entry:
// CHECK30-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK30-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK30-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK30-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK30-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK30-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK30-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK30-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK30:       omp.inner.for.cond:
// CHECK30-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK30-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK30:       omp.inner.for.body:
// CHECK30-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK30-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK30-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP4]] to i64
// CHECK30-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK30-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK30:       omp.body.continue:
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK30:       omp.inner.for.inc:
// CHECK30-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK30-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK30:       omp.inner.for.end:
// CHECK30-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK30-NEXT:    ret i32 0
//
//
// CHECK31-LABEL: define {{[^@]+}}@main
// CHECK31-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK31-NEXT:  entry:
// CHECK31-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK31-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK31-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK31-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK31-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK31-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK31-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK31-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK31-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK31-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK31-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK31-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK31-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK31-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK31-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK31-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK31-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK31-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK31-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK31-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK31-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK31-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK31-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK31-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK31-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK31:       simd.if.then:
// CHECK31-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK31-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i32 16) ]
// CHECK31-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4
// CHECK31-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK31:       omp.inner.for.cond:
// CHECK31-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK31-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK31-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK31:       omp.inner.for.body:
// CHECK31-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK31-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK31-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK31-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I4]], align 4
// CHECK31-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP11]]
// CHECK31-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK31-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK31:       omp.body.continue:
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK31:       omp.inner.for.inc:
// CHECK31-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK31-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK31:       omp.inner.for.end:
// CHECK31-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK31-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK31-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK31-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK31-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK31-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK31-NEXT:    br label [[SIMD_IF_END]]
// CHECK31:       simd.if.end:
// CHECK31-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK31-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP14]])
// CHECK31-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK31-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK31-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK31-NEXT:    [[TMP16:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK31-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK31-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK31-SAME: (i32 [[ARGC:%.*]]) #[[ATTR3:[0-9]+]] comdat {
// CHECK31-NEXT:  entry:
// CHECK31-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK31-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK31-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK31-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK31-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK31-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK31-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK31-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK31:       omp.inner.for.cond:
// CHECK31-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK31-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK31:       omp.inner.for.body:
// CHECK31-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK31-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK31-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i32 0, i32 [[TMP4]]
// CHECK31-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK31:       omp.body.continue:
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK31:       omp.inner.for.inc:
// CHECK31-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK31-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK31:       omp.inner.for.end:
// CHECK31-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK31-NEXT:    ret i32 0
//
//
// CHECK32-LABEL: define {{[^@]+}}@main
// CHECK32-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK32-NEXT:  entry:
// CHECK32-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK32-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK32-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK32-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK32-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK32-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK32-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK32-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK32-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK32-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK32-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK32-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK32-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK32-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK32-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK32-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK32-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK32-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK32-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK32-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK32-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK32-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK32-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK32-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK32-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK32:       simd.if.then:
// CHECK32-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK32-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[VLA]], i32 16) ]
// CHECK32-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4
// CHECK32-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK32:       omp.inner.for.cond:
// CHECK32-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK32-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK32-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK32:       omp.inner.for.body:
// CHECK32-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK32-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK32-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK32-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I4]], align 4
// CHECK32-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP11]]
// CHECK32-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK32-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK32:       omp.body.continue:
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK32:       omp.inner.for.inc:
// CHECK32-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK32-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK32:       omp.inner.for.end:
// CHECK32-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK32-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK32-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK32-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK32-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK32-NEXT:    store i32 [[ADD11]], i32* [[I]], align 4
// CHECK32-NEXT:    br label [[SIMD_IF_END]]
// CHECK32:       simd.if.end:
// CHECK32-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK32-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP14]])
// CHECK32-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK32-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK32-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK32-NEXT:    [[TMP16:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK32-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK32-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK32-SAME: (i32 [[ARGC:%.*]]) #[[ATTR3:[0-9]+]] comdat {
// CHECK32-NEXT:  entry:
// CHECK32-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK32-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK32-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK32-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK32-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK32-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK32-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK32-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK32:       omp.inner.for.cond:
// CHECK32-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK32-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK32:       omp.inner.for.body:
// CHECK32-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK32-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK32-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i32 0, i32 [[TMP4]]
// CHECK32-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK32:       omp.body.continue:
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK32:       omp.inner.for.inc:
// CHECK32-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK32-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK32:       omp.inner.for.end:
// CHECK32-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK32-NEXT:    ret i32 0
//
