// This test checks that jumps generated by logical operators can be optimized away

// compile-flags: -Copt-level=3
// only-64bit

#![crate_type="lib"]

pub struct Blueprint {
    pub fuel_tank_size: u32,
    pub payload: u32,
    pub wheel_diameter: u32,
    pub wheel_width: u32,
    pub storage: u32,
}

// && chains should not prevent SIMD optimizations for primitives
impl PartialEq for Blueprint{
    fn eq(&self, other: &Self)->bool{
       // CHECK-NOT: call{{.*}}bcmp
       // CHECK-NOT: call{{.*}}memcmp
       // CHECK-NOT: br {{.*}}
       self.fuel_tank_size == other.fuel_tank_size
            && self.payload == other.payload
            && self.wheel_diameter == other.wheel_diameter
            && self.wheel_width == other.wheel_width
            && self.storage == other.storage
    }
}

#[derive(PartialEq)]
pub struct Blueprint2 {
    pub fuel_tank_size: u32,
    pub payload: u32,
    pub wheel_diameter: u32,
    pub wheel_width: u32,
    pub storage: u32,
}

// Derived PartialEq should not generate jumps and should use SIMD
#[no_mangle]
pub fn partial_eq_should_not_jump(a: &Blueprint2, b:&Blueprint2)->bool{
    // CHECK-NOT: call{{.*}}bcmp
    // CHECK-NOT: call{{.*}}memcmp
    // CHECK-NOT: br {{.*}}
    a==b
}
