The `issue` value is incorrect in a stability attribute.

Erroneous code example:

```compile_fail,E0545
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[unstable(feature = "_unstable_fn", issue = "0")] // invalid
fn _unstable_fn() {}

#[rustc_const_unstable(feature = "_unstable_const_fn", issue = "0")] // invalid
fn _unstable_const_fn() {}
```

To fix this issue, you need to provide a correct value in the `issue` field.
Example:

```
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[unstable(feature = "_unstable_fn", issue = "none")] // ok!
fn _unstable_fn() {}

#[rustc_const_unstable(feature = "_unstable_const_fn", issue = "1")] // ok!
fn _unstable_const_fn() {}
```

See the [How Rust is Made and “Nightly Rust”][how-rust-made-nightly] appendix
of the Book and the [Stability attributes][stability-attributes] section of the
Rustc Dev Guide for more details.

[how-rust-made-nightly]: https://doc.rust-lang.org/book/appendix-07-nightly-rust.html
[stability-attributes]: https://rustc-dev-guide.rust-lang.org/stability.html
