# Object Oriented Programming Features of Rust

Object-oriented programming (OOP) is a way of modeling programs. Objects came
from Simula in the 1960s. Those objects influenced Alan Kay’s programming
architecture in which objects pass messages to each other. He coined the term
*object-oriented programming* in 1967 to describe this architecture. Many
competing definitions describe what OOP is; some definitions would classify
Rust as object oriented, but other definitions would not. In this chapter,
we’ll explore certain characteristics that are commonly considered object
oriented and how those characteristics translate to idiomatic Rust. We’ll then
show you how to implement an object-oriented design pattern in Rust and discuss
the trade-offs of doing so versus implementing a solution using some of Rust’s
strengths instead.
