// run-rustfix
#![allow(unused_assignments, unused_mut, clippy::assign_op_pattern)]
#![warn(clippy::implicit_saturating_sub)]

fn main() {
    // Tests for unsigned integers

    let end_8: u8 = 10;
    let start_8: u8 = 5;
    let mut u_8: u8 = end_8 - start_8;

    // Lint
    if u_8 > 0 {
        u_8 = u_8 - 1;
    }

    match end_8 {
        10 => {
            // Lint
            if u_8 > 0 {
                u_8 -= 1;
            }
        },
        11 => u_8 += 1,
        _ => u_8 = 0,
    }

    let end_16: u16 = 40;
    let start_16: u16 = 35;

    let mut u_16: u16 = end_16 - start_16;

    // Lint
    if u_16 > 0 {
        u_16 -= 1;
    }

    let mut end_32: u32 = 7010;
    let mut start_32: u32 = 7000;

    let mut u_32: u32 = end_32 - start_32;

    // Lint
    if u_32 != 0 {
        u_32 -= 1;
    }

    // No Lint
    if u_32 > 0 {
        u_16 += 1;
    }

    // No Lint
    if u_32 != 0 {
        end_32 -= 1;
        start_32 += 1;
    }

    let mut end_64: u64 = 75001;
    let mut start_64: u64 = 75000;

    let mut u_64: u64 = end_64 - start_64;

    // Lint
    if u_64 > 0 {
        u_64 -= 1;
    }

    // Lint
    if 0 < u_64 {
        u_64 -= 1;
    }

    // Lint
    if 0 != u_64 {
        u_64 -= 1;
    }

    // No Lint
    if u_64 >= 1 {
        u_64 -= 1;
    }

    // No Lint
    if u_64 > 0 {
        end_64 -= 1;
    }

    // Tests for usize
    let end_usize: usize = 8054;
    let start_usize: usize = 8050;

    let mut u_usize: usize = end_usize - start_usize;

    // Lint
    if u_usize > 0 {
        u_usize -= 1;
    }

    // Tests for signed integers

    let endi_8: i8 = 10;
    let starti_8: i8 = 50;

    let mut i_8: i8 = endi_8 - starti_8;

    // Lint
    if i_8 > i8::MIN {
        i_8 -= 1;
    }

    // Lint
    if i_8 > i8::min_value() {
        i_8 -= 1;
    }

    // Lint
    if i_8 != i8::MIN {
        i_8 -= 1;
    }

    // Lint
    if i_8 != i8::min_value() {
        i_8 -= 1;
    }

    let endi_16: i16 = 45;
    let starti_16: i16 = 44;

    let mut i_16: i16 = endi_16 - starti_16;

    // Lint
    if i_16 > i16::MIN {
        i_16 -= 1;
    }

    // Lint
    if i_16 > i16::min_value() {
        i_16 -= 1;
    }

    // Lint
    if i_16 != i16::MIN {
        i_16 -= 1;
    }

    // Lint
    if i_16 != i16::min_value() {
        i_16 -= 1;
    }

    let endi_32: i32 = 45;
    let starti_32: i32 = 44;

    let mut i_32: i32 = endi_32 - starti_32;

    // Lint
    if i_32 > i32::MIN {
        i_32 -= 1;
    }

    // Lint
    if i_32 > i32::min_value() {
        i_32 -= 1;
    }

    // Lint
    if i_32 != i32::MIN {
        i_32 -= 1;
    }

    // Lint
    if i_32 != i32::min_value() {
        i_32 -= 1;
    }

    let endi_64: i64 = 45;
    let starti_64: i64 = 44;

    let mut i_64: i64 = endi_64 - starti_64;

    // Lint
    if i64::min_value() < i_64 {
        i_64 -= 1;
    }

    // Lint
    if i64::MIN != i_64 {
        i_64 -= 1;
    }

    // Lint
    if i64::MIN < i_64 {
        i_64 -= 1;
    }

    // No Lint
    if i_64 > 0 {
        i_64 -= 1;
    }

    // No Lint
    if i_64 != 0 {
        i_64 -= 1;
    }
}
