// Copyright 2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// OIBIT-based version of #29859, supertrait version. Test that using
// a simple OIBIT `..` impl alone still doesn't allow arbitrary bounds
// to be synthesized.

#![feature(optin_builtin_traits)]

auto trait Magic: Copy {} //~ ERROR E0568

fn copy<T: Magic>(x: T) -> (T, T) { (x, x) }

#[derive(Debug)]
struct NoClone;

fn main() {
    let (a, b) = copy(NoClone); //~ ERROR
    println!("{:?} {:?}", a, b);
}
