=begin
= test for WebUnit::Table
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_table.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestTable < WebUnit::TestCase

    def test_accessor
    end

    def test_Table

      url = @urlbase + "webunit/table.html"
      response = Response::get( url )

      table = response.tables[0]

      assert_instance_of( Array, table.rows )
      assert_equals( 4, table.rows.size )

      assert_exception( ArgumentError ){ table.at(0) }
      assert_instance_of( TableRow, table.at(1) )
      assert_instance_of( TableRow, table.at(4) )
      assert_exception( RuntimeError ){ table.at(5) }

      assert_exception( ArgumentError ){ table.at(0,1) }
      assert_exception( ArgumentError ){ table.at(1,0) }
      assert_instance_of( TableCell, table.at(1,1) )
      assert_instance_of( TableCell, table.at(4,3) )
      assert_instance_of( NilTableCell, table.at(5,1) )
      assert_instance_of( NilTableCell, table.at(1,4) )

      assert_equals( "this 11", table.at(1,1).data )
      assert_equals( "test 23", table.at(2,3).data )
      assert_equals( "this 21", table.at(3,1).data )
      assert_equals( "test 32", table.at(3,2).data )
      assert_equals( "test 32", table.at(3,3).data )
      assert_equals( "this 21", table.at(4,1).data )

      table = response.tables[1]

      assert_equals( "green", table.at(1).attrs['bgcolor'] )
      assert_equals( "blue",  table.at(2).attrs['bgcolor'] )
      assert_equals( "red",   table.at(3).attrs['bgcolor'] )

      table = response.tables[2]

      assert_equals( "", table.at(3,1).data )
      assert_equals( "ggg", table.at(3,1).find("a")[0].data )

      assert_include( "ggg", table.at(3,1) )
      assert( table.at(3,1).has?( response.link ) )

      assert_equals( 3, table.row_index( "ggg" ) )
      assert_equals( 4, table.row_index( "kkk", 2 ) )

      assert_equals( 2, table.col_index( "bbb" ) )
      assert_equals( 1, table.col_index( "ggg", 3 ) )

    end

  end

end
