=begin
= test for WebUnit::Params
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_params.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestParams < WebUnit::TestCase

    def test_accessor
    end

    def test_InputImage

      url = @urlbase + "webunit/form.html"
      response = Response::get( url )

      form = response.forms[4]
      response = form.submit( 'AAA', 10, 5 )

      qs = 'AAA.x=10&AAA.y=5'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

    end

    def test_Form

      url = @urlbase + "webunit/form.html"
      #Parser::ignore %w( br hr )
      test_form = Response::get( url )

      assert_equals( 'WebUnit Test 1', test_form.title )
      assert_equals( 5, test_form.forms.size )

    # hidden
      form = test_form.forms[0]
      assert_equals( 3, form.parameters.size )

      assert_input( 'nhidden', 'hidden', 'HIDDEN', form.parameters[0] )

      spec = { 'name'=>'nhidden', 'type'=>'hidden', 'value'=>'HIDDEN' }
      assert_attrs( spec, form.parameters[0] )

      assert_equals( 'nhidden', form.parameters[0].name )
      assert_equals( 'hidden',  form.parameters[0].type )
      assert_equals( 'HIDDEN',  form.parameters[0].value )
      #response = form.submit
      response = test_form.submit
      qs = 'nhidden=HIDDEN'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

    # textfields
      form = test_form.forms[1]
      assert_equals( 5, form.parameters.size )

      assert_equals( 'ntext',     form.parameters[0].name )
      assert_equals( 'npassword', form.parameters[1].name )
      assert_equals( 'ntextarea', form.parameters[2].name )

      assert_equals( 'text',     form.parameters[0].type )
      assert_equals( 'password', form.parameters[1].type )
      assert_equals( 'textarea', form.parameters[2].type )

      assert_equals( 'TEXT',     form.parameters[0].value )
      assert_equals( 'PASSWORD', form.parameters[1].value )
      assert_equals( "TEXTAREA\nTEXTAREA", form.parameters[2].value )

      assert_exception( TypeError ){ form.parameters[0] = "this is test" }
      form.parameters[0].value = "this is test"
      form.parameters[1].value = '!@#$%'
      form.parameters[2].value = "aaaa\r\nbbbb"
      response = form.submit( 'nsubmit' )

      qs = 'ntext=this+is+test&'
      qs << 'npassword=%21%40%23%24%25&'
      qs << 'ntextarea=aaaa%0D%0Abbbb&'
      qs << 'nsubmit=Submit+Query'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

    # buttons
      form = test_form.forms[2]

      assert_equals( 6, form.params.size )
      assert_equals( 10, form.parameters.size )

      assert_equals( 'ncheckbox',  form.parameters[0].name )
      assert_equals( 'ncheckbox1', form.parameters[1].name )
      assert_equals( 'nradio',     form.parameters[2].name )
      assert_equals( 'nradio',     form.parameters[3].name )
      assert_equals( 'nradio',     form.parameters[4].name )
      assert_equals( 'nradio1',    form.parameters[5].name )
      assert_equals( 'nradio1',    form.parameters[6].name )
      assert_equals( 'nradio1',    form.parameters[7].name )
      assert_equals( 'nsubmit',    form.parameters[8].name )
      assert_equals( 'nreset',     form.parameters[9].name )

      form.params['ncheckbox'].on
      form.params['ncheckbox1'].off
      response = form.submit( 'nsubmit' )
      qs = 'ncheckbox=on&'
      qs << 'nradio1=c&'
      qs << 'nsubmit=SUBMIT'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

      form.params['ncheckbox'].off
      form.params['nradio1'].on
      response = form.submit( 'nsubmit' )
      qs = 'nradio1=a&'
      qs << 'nsubmit=SUBMIT'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

      form.params['ncheckbox'].off
      form.params['nradio1'].value='a'
      form.params['nradio1'].value='b'
      response = form.submit( 'nsubmit' )
      qs = 'nradio1=b&'
      qs << 'nsubmit=SUBMIT'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

    # select
      form = test_form.forms[3]
      table = test_form.tables[3]
      assert( table.at(1,2).has?( form.parameters[0] ) )
      #p table.find( 'td' )[1].array

      assert_equals( 5, form.parameters.size )
      assert_equals( 'nselect',  form.parameters[0].name )
      assert_equals( 'select',   form.parameters[0].type )
      assert_input( 'nselect', 'select', 'aaa',  form.parameters[0] )
      assert_equals( 'nselect1', form.parameters[1].name )
      assert_equals( 'nselect2', form.parameters[2].name )

      response = form.submit

      qs = 'nselect=aaa&nselect2=b&nselect2=d'
      #p response.tree.find( 'b' )[0].array
      assert_equals( qs, response.find( 'b' )[0].data )

      form.params['nselect1'].value = 'c'
      response = form.submit
      qs = 'nselect=aaa&nselect1=c&nselect2=b&nselect2=d'
      assert_equals( qs, response.find( 'b' )[0].data )

      form.params['nselect1'].select( [ 0, 2 ] )
      response = form.submit
      qs = 'nselect=aaa&nselect1=aaa&nselect1=c&nselect2=b&nselect2=d'
      assert_equals( qs, response.find( 'b' )[0].data )

      form.params['nselect1'].select( [ 'aaa', 'c' ] )
      response = form.submit
      qs = 'nselect=aaa&nselect1=aaa&nselect1=c&nselect2=b&nselect2=d'
      assert_equals( qs, response.find( 'b' )[0].data )

      form.params['nselect1'].select( [ 'b', 'c' ] )
      response = form.submit
      qs = 'nselect=aaa&nselect1=b&nselect1=c&nselect2=b&nselect2=d'
      assert_equals( qs, response.find( 'b' )[0].data )

      assert_equals( %w( b d ), form.params['nselect2'].value )
      form.params['nselect2'].select( [ 'c' ] )
      assert_equals( 'c', form.params['nselect2'].value )

    end

    def test_params

      url = @urlbase + "webunit/params.html"
      #Parser::ignore %w( br hr )
      response = Response::get( url )
      assert_equals( 'WebUnit Test Params', response.title )
      assert_equals( 1, response.forms.size )
      form = response.forms[0]
      assert_equals( 10, form.params.size )
      assert_equals( 13, form.parameters.size )

      hash = {
        "nhidden" => "aaaaa",
        "ntext" => "bbbbb",
        "npassword" => "ccccc",
        "ntextarea" => "ddddd",
      }

      form.set_params( hash )
      response = form.submit

      qs = 'nhidden=aaaaa&ntext=bbbbb&npassword=ccccc&ntextarea=ddddd&ncheckbox1=1&nselect=aaa'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

      array = [
        "wwwww",
        "xxxxx",
        "yyyyy",
        "zzzzz",
      ]

      form.set_parameters( array )
      response = form.submit

      qs = 'nhidden=wwwww&ntext=xxxxx&npassword=yyyyy&ntextarea=zzzzz&ncheckbox1=1&nselect=aaa'
      assert_equals( qs, response.tree.find( 'b' )[0].data )

    end

  end

end
