=begin
= test for data transfer by post multipart.
  Copyright(C), Narushima Hironori
  $Id: test_multipart.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestMultipart < WebUnit::TestCase

    def test_multipart
      url = @urlbase + "webunit/multipart.html"
      response = Response::get( url )
      assert_title( 'test for multipart/formdata', response )
      
      res = response.form.set_params( {
        'file1' => 'test_resources/uploadfile1.txt',
        'file2' => 'test_resources/uploadfile2.txt',
      } ).submit
      
      table = res.tables[0]
      assert_equals( 'uploadfile1.txt', table.at(1, 2).data)
      assert_equals( '### Upload File 1', table.at(3, 2).data)
      assert_equals( 'text/plain', table.at(4, 2).data)
      
      table = res.tables[1]
      assert_equals( 'uploadfile2.txt', table.at(1, 2).data)
      assert_equals( '### Upload File 2', table.at(3, 2).data)
      
      list = {}
      res.tables[2].rows.each { |r|
        list[r.at(1).data] = r.at(2).data
      }
      
      assert_equals( 'Text 1', list['text1'])
      assert_equals( 'Text 2', list['text2'])
      assert_equals( 'Checkbox 3', list['checkbox1'])
      assert_equals( 'Radio 1-2', list['radio1'])
      assert_equals( 'Radio 2-3', list['radio2'])
      assert_equals( 'Text Area 1', list['textarea1'])
      assert_equals( 'Text Area 2', list['textarea2'])
      assert_equals( 'a', list['select1'])
      assert_equals( 'BB', list['select2'])
    end

  end

end
