=begin
= test for WebUnit::Link
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_link.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestLink < WebUnit::TestCase

    def test_Link

      url = @urlbase + "webunit/link.html"
      response = Response::get( url )
      assert_title( 'WebUnit::link', response )

      links = response.links
      i = -1

      link_self = links[i+=1]
      assert_equals( 'self', link_self.data )
      assert_urls( 'webunit/link.html', link_self.href )
      assert_equals( nil, link_self.target )

      link_other = links[i+=1]
      assert_equals( 'other', link_other.data )
      assert_urls( 'webunit/link-0.html', link_other.href ) # not exist
      assert_equals( 'top', link_other.target )

      link_x = links[i+=1]
      assert_equals( 'x', link_x.data )
      assert_urls( 'webunit/x.cgi?aaa=AAA&bbb=BBB', link_x.href )
      assert_equals( nil, link_x.target )

      link_y = links[i+=1]
      assert_equals( 'y', link_y.data )
      assert_equals( '#', link_y.href )
      assert_equals( nil, link_y.target )
      assert_equals( 'test', link_y.onClick )

      assert_title( 'WebUnit::link', link_self.read )

      response = response.click( 'self' )
      assert_title( 'WebUnit::link', response )
      assert_exception( WebUnit::ElemNotFound ){
        response = response.click( 'xxxxx' )
      }
      assert_exception( WebUnit::HttpNotFound ){
        response = response.click( 'other' )
      }

      response = response.readlink( 'self' )
      assert_title( 'WebUnit::link', response )
      assert_exception( WebUnit::ElemNotFound ){
        response = response.readlink( 'xxxxx' )
      }
      assert_exception( WebUnit::HttpNotFound ){
        response = response.readlink( 'other' )
      }

    end

    def test_accessor

      link = Link::new( 'href'=>@urlbase+'xxx.html', 'target'=>'top' )
      assert_urls( 'xxx.html', link.href )
      assert_equals( 'top', link.target )

      link = Link::new( 'href'=>@urlbase+'xxx.html' )
      assert_equals( nil, link.target )

    end

    def test_read
      url = @urlbase + 'webunit/link.html'
      link = Link::new( 'href'=>url, 'target'=>'fx' )
      assert_title( 'WebUnit::link', link.read )
    end

  end

end
