=begin
= test for WebUnit::Image
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_image.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestImage < WebUnit::TestCase

    def test_Image

      url = @urlbase + "webunit/image.html"
      response = Response::get( url )
      assert_title( 'WebUnit::image', response )

      images = response.images
      assert_equals( 2, images.size )

      i = -1

      image_edit = images[i+=1]
      assert_equals( image_edit, response.image )

      assert_equals( 'images/x.gif', image_edit.src )
      assert_equals( nil, image_edit.alt )
      assert_equals( nil, image_edit.width )
      assert_equals( nil, image_edit.height )
      assert_equals( nil, image_edit.border )

      image_up = images[i+=1]
      assert_equals( 'images/y.gif', image_up.src )
      assert_equals( 'up', image_up.alt )
      assert_equals( '64', image_up.width )
      assert_equals( '64', image_up.height )
      assert_equals( '0', image_up.border )

    end

  end

end
