=begin
= test for WebUnit::Form
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_form.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestForm < WebUnit::TestCase

    def test_accessor
    end

    def test_Form__store_test_data

      url = 'webunit/stock.cgi'
      url_clear = url + '?clear'

      form = Response::get( url_clear ).form
      assert_urls( url, form.action )

      form = Response::get( url ).form
      form.store_test_data( %w( name title ), <<-EOF )
        yuichi,leader
        tadaya,member
      EOF

      parameters = Response::get( url ).form.parameters
      assert_equals( 'yuichi', parameters[3].value )
      assert_equals( 'leader', parameters[4].value )
      assert_equals( 'tadaya', parameters[5].value )
      assert_equals( 'member', parameters[6].value )

      Response::get( url_clear )

    end

  end

end
