=begin
= test for WebUnit::
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_domwalker.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestXml < WebUnit::TestCase

    def test_doc
    
      xml = <<-'EOF'
      <?xml version="1.0"?>
      <top>
        <array>
          <name id="1">name1</name>
          <name id="2">name2</name>
	</array>
        <array>
          <name id="1" append="x">name1x</name>
          <name id="1" append="y">name1y</name>
          <name id="2" append="x">name2x</name>
          <name id="2" append="y" more="q">name2y</name>
	</array>
	<x></x>
      </top>
      EOF
      
      doc = DomWalker::new( xml )
      assert_equals( '/', doc.cur_path )
      assert_equals( 'top', doc.cur_name )      
      assert_equals( 3, doc.size() )            
      assert_equals( 2, doc.size( "array" ) )                  
      
      doc.change_node( 'array/name' )
      assert_equals( '/array/name', doc.cur_path )
      assert_equals( "name1", doc.cur_value )
      assert_equals( "1", doc.cur_attrs['id'] )
      
      doc.change_node( '/array/name[0]' )
      assert_equals( '/array/name[0]', doc.cur_path )
      assert_equals( "name1", doc.cur_value )
      
      doc.change_node( '/array/name[1]' )
      assert_equals( '/array/name[1]', doc.cur_path )
      assert_equals( "name2", doc.cur_value )
      assert_equals( "2", doc.cur_attrs['id'] )
      
      assert_exception( DomWalkerError ){
        doc.change_node( '/array/name[2]' )
      }
      
      doc.change_node( '/array/name[id="1"]' )
      assert_equals( '/array/name[id="1"]', doc.cur_path )
      assert_equals( "name1", doc.cur_value )
      
      doc.change_node( '/array/name[id="2"]' )
      assert_equals( '/array/name[id="2"]', doc.cur_path )
      assert_equals( "name2", doc.cur_value )

      assert_exception( DomWalkerError ){
        doc.change_node( '/array/name[id="3"]' )
      }
      
      path = '/array[1]/name[id="1",append="y"]'
      doc.change_node( path )
      assert_equals( path, doc.cur_path )
      assert_equals( "name1y", doc.cur_value )

      path = '/array[1]/name[id="2",append="y"]'
      doc.change_node( path )
      assert_equals( path, doc.cur_path )
      assert_equals( "name2y", doc.cur_value )

    end

  end

end
