class CustomAttribute
	attr_accessor :value

	def self.custom_value( object )
		CustomAttribute.new object
	end

	def initialize( value )
		@value = value
	end

	def ==( other )
		if String === other then
			@value == other
		elsif @value == other.value then
			true
		else
			false
		end
	end

	def string
		@value.to_s
	end
end

class TestCustomAttribute < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new ALL_MODELS
		@ec  = @app.create_editing_context
		@entity = @app.entity('Company')
		@attr = @entity.attribute('name')
		@attr.class_name = 'CustomAttribute'
		@attr.factory_method = 'custom_value' # class method
		@attr.conversion_method = 'string' # instance method
		# @app.log_options[:sql] = true
	end

	def test_factory_method
		str = 'custom value'
		expected = CustomAttribute.new str
		assert_equal(expected, @attr.new_value(str))
	end

	def test_conversion_method
		str = 'custom value'
		value = CustomAttribute.new str
		expected = str
		assert_equal(expected, @attr.adapter_value(value))
	end

	def test_boolean_conversion
		attr_int = @entity.attribute 'company_id'
		attr_int.class_name = 'Boolean'
		assert_equal(1, attr_int.adapter_value(true))
		assert_equal(0, attr_int.adapter_value(false))
	end

	def test_saving1_insert
		str = "test_saving1_insert"
		value = CustomAttribute.new str
		obj = @ec.create 'Company'
		obj['name'] = value
		assert_nothing_thrown { @ec.save }
	end

	def test_saving2_fetch
		str = "test_saving1_insert"
		q = Qualifier.format("name == %@", [str])
		fs = FetchSpec.new('Company', q)
		obj = @ec.fetch(fs).first
		expected = CustomAttribute.new str
		assert_equal(expected, obj['name'])
		@ec.delete obj
		@ec.save
	end
end
