################################################################
# test.rb
#
# Generic test script used if TestUnit is not installed, or for
# futzing in general.
################################################################
if File.basename(Dir.pwd) == "examples"
   require "ftools"
   Dir.chdir ".."
   Dir.mkdir("sys") unless File.exists?("sys")
   extension = ".so"
   extension = ".sl" if RUBY_PLATFORM =~ /hpux/i
   extension = ".bundle" if RUBY_PLATFORM =~ /powerpc|darwin/i
   file = "uname" + extension
   if File::ALT_SEPARATOR
      File.copy("lib/os/windows.rb","sys/uname.rb")
   else
      File.copy(file,"sys")
   end
   $LOAD_PATH.unshift Dir.pwd
end

require 'sys/uname'
include Sys

puts "VERSION: " + Uname::VERSION
puts 'Nodename: ' + Uname.nodename
puts 'Sysname: ' + Uname.sysname
puts 'Version: ' + Uname.version
puts 'Release: ' + Uname.release
puts 'Machine: ' + Uname.machine # May be "unknown" on Win32

if RUBY_PLATFORM =~ /sun|solaris/i
   print "\nSolaris specific tests\n" 
   puts "==========================="
   puts 'Architecture: ' + Uname.architecture
   puts 'Platform: ' + Uname.platform
   puts 'Instruction Set List: ' + Uname.isa_list.split.join(", ")
   puts 'Hardware Provider: ' + Uname.hw_provider
   puts 'Serial Number: ' + Uname.hw_serial_number.to_s
   puts 'SRPC Domain: ' + Uname.srpc_domain # might be empty
   puts 'DHCP Cache: ' + Uname.dhcp_cache # might be empty
end

if RUBY_PLATFORM =~ /powerpc|darwin/i
   print "\nOS X specific tests\n" 
   puts "======================="
   puts 'Model: ' + Uname.model
end

if RUBY_PLATFORM =~ /hpux/i
   print "\nHP-UX specific tests\n"
   puts "========================"
   puts "ID: " + Uname.id
end

print "\nTest finished successfully\n"
