#!/usr/local/bin/ruby -w

require "test/unit"
require "rss/parser"

test_file = "test/test_*"
case ARGV.first
when /\A--\z/
  ARGV.shift
when /\A-/, nil;
else
  test_file = ARGV.shift
end

$:.unshift(File.join(File.expand_path("."), "lib"))
$:.unshift(File.join(File.expand_path("."), "test"))
Dir.glob(test_file) do |file|
  require file
end

argv = ARGV.dup
unless argv.find {|opt| /\A(?:-v|--verbose=)/ =~ opt}
  argv << "--verbose=n"
end

RSS::AVAILABLE_PARSERS.each do |parser|
  puts "------------------------------------"
  puts "Using #{parser}"
  puts "------------------------------------"
  RSS::Parser.default_parser = parser
  break unless defined?(Test::Unit::AutoRunner)
  GC.start
  Test::Unit::AutoRunner.run($0, File.dirname($0), argv.dup)
  puts
end
