module Jabber

module XMLListener
  
  def tag_start(name, attr)
    if :debug then debug("Tag_start: start tag is: #{name}, depth is #{@depth}") end
    #puts "TAG_START: #{name}"
    #attr.each { |k,v| puts "  K/V: #{k} / #{v}" }

    # convert attributes array into hash for name-based lookup
    h_attr = Hash[ *attr.flatten ] 

    if name == 'stream:stream'
      @currnode = Node.new(name)
      @confirmedhost = h_attr['from']
      @streamid = h_attr['id']
    else
      @depth += 1
      if @depth == 1
	if name == 'stream:error'
	  @streamerror = true
	else
	  @node = Node.new(name)
	  attr.each { |k,v| @node.root.attributes[k] = v }
	  @currnode = @node
	end
      else
	kid = @currnode.root.add_element(name)
	attr.each { |k,v| kid.root.attributes[k] = v }
	@currnode = kid
      end
    end
  end
  
  def tag_end(name)
    #puts "TAG_END: #{name}"
    #puts "-----"

    return if @streamerror == true

    if @depth == 1
      dispatch(@currnode)
    else
      @currnode = @currnode.root
    end
    @depth -= 1

    if :debug then debug("Tag_end: end tag is #{name}, depth is #{@depth}") end

  end

  def text(text)
    #puts "  TEXT: #{text}"
    if :debug then debug("Text: #{text}") end
    
    if @streamerror == true
      @errortext = text
      raise "Stream error: #{text}"
    else
      @currnode.text = text
    end
  end

  def method_missing(*args); end
  
end # Module: XMLListener

end # Module: Jabber
